/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.data.Actor;
import gurpsinittool.ui.DefenseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class InitTable
extends JTable
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private JPopupMenu popupMenu;
    private Map<Actor.ActorStatus, JMenuItem> coordinatedStatusMenuItems;
    private InitTableModel tableModel;
    private boolean isInitTable;
    private Properties propertyBag;

    public InitTable(Properties propertyBag, boolean isInitTable) {
        super(new InitTableModel());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyBag = propertyBag;
        this.isInitTable = isInitTable;
        this.tableModel = (InitTableModel)this.dataModel;
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            block19: {
                if (!"Delete".equals(e.getActionCommand())) break block19;
                this.stopCellEditing();
                int[] rows = this.getSelectedRows();
                int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete these rows?", "Confirm Row Delete", 2);
                if (result != 0) break block20;
                int i = rows.length - 1;
                while (i >= 0) {
                    this.tableModel.removeActor(rows[i]);
                    --i;
                }
                break block20;
            }
            if ("Reset".equals(e.getActionCommand())) {
                this.stopCellEditing();
                int[] rows = this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    Actor actor = this.tableModel.getActor(rows[i]);
                    actor.Reset();
                    ++i;
                }
            } else if ("Set Active".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                this.tableModel.setActiveRow(rows[0]);
            } else if ("Tag".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.tableModel.tagActor(this.tableModel.getActor(rows[i]));
                    ++i;
                }
            } else if ("Remove Tag".equals(e.getActionCommand())) {
                int[] rows = this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    this.tableModel.removeTag(this.tableModel.getActor(rows[i]));
                    ++i;
                }
            } else if ("Attack".equals(e.getActionCommand())) {
                this.selectedActorsAttack();
            } else if ("Defend".equals(e.getActionCommand())) {
                this.selectedActorDefend();
            } else {
                Actor.ActorType[] actorTypeArray = Actor.ActorType.values();
                int n = actorTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor.ActorType t = actorTypeArray[n2];
                    if (t.toString().equals(e.getActionCommand())) {
                        this.stopCellEditing();
                        int[] rows = this.getSelectedRows();
                        int i = 0;
                        while (i < rows.length) {
                            this.tableModel.setValueAt(t.toString(), rows[i], InitTableModel.columns.Type.ordinal());
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void autoSizeColumns() {
        TableColumn column = null;
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int j = 0;
            while (j < this.getRowCount()) {
                renderer = this.getCellRenderer(j, i);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(j, i), false, false, j, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++j;
            }
            column.setPreferredWidth(width);
            if (this.isInitTable && i == 0) {
                column.setMaxWidth(width);
                column.setMinWidth(width);
            }
            ++i;
        }
    }

    private JMenuItem createMenuItem(String text, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.addActionListener(this);
        return menuItem;
    }

    private JMenuItem createCoordinatedStatusMenuItem(final Actor.ActorStatus status, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(status.toString(), mnemonic);
        menuItem.setAction(new AbstractAction(status.toString()){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InitTable.this.coordinatedChangeStatusOfSelectedActors(status);
            }
        });
        this.coordinatedStatusMenuItems.put(status, menuItem);
        return menuItem;
    }

    private void updateCoordinatedStatusMenuItems() {
        for (Map.Entry<Actor.ActorStatus, JMenuItem> entry : this.coordinatedStatusMenuItems.entrySet()) {
            Actor.ActorStatus status = entry.getKey();
            JMenuItem menuItem = entry.getValue();
            boolean all_set = true;
            boolean all_unset = true;
            int[] nArray = this.getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                Actor actor = this.tableModel.getActor(row);
                if (actor.hasStatus(status)) {
                    all_unset = false;
                } else {
                    all_set = false;
                }
                ++n2;
            }
            if (all_set) {
                menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/tick.png"), "Tick"));
                continue;
            }
            if (all_unset) {
                menuItem.setIcon(null);
                continue;
            }
            menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/shape_square.png"), "Square"));
        }
    }

    public void initialize() {
        this.setDefaultRenderer(Object.class, new InitTableCellRenderer());
        this.setDefaultRenderer(new Integer(0).getClass(), new InitTableCellRenderer());
        this.setDefaultEditor(String.class, new InitTableTextCellEditor());
        this.setDefaultEditor(new Integer(0).getClass(), new InitTableIntegerCellEditor());
        this.setTransferHandler(new InitTableTransferHandler("name"));
        this.setPreferredScrollableViewportSize(new Dimension(800, 270));
        this.setFillsViewportHeight(true);
        this.setSelectionMode(2);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setSurrendersFocusOnKeystroke(false);
        this.getColumnModel().getColumn(InitTableModel.columns.Act.ordinal()).setResizable(false);
        JComboBox<Actor.ActorStatus> initTableStateEditor = new JComboBox<Actor.ActorStatus>();
        Actor.ActorStatus[] actorStatusArray = Actor.ActorStatus.values();
        int n = actorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor.ActorStatus a = actorStatusArray[n2];
            initTableStateEditor.addItem(a);
            ++n2;
        }
        this.getColumnModel().getColumn(InitTableModel.columns.Status.ordinal()).setCellEditor(new InitTableStatusListCellEditor());
        this.getColumnModel().getColumn(InitTableModel.columns.Type.ordinal()).setCellEditor(new InitTableTypeListCellEditor());
        this.getColumnModel().getColumn(InitTableModel.columns.Damage.ordinal()).setCellEditor(new InitTableDamageCellEditor());
        this.getColumnModel().getColumn(InitTableModel.columns.Fatigue.ordinal()).setCellEditor(new InitTableDamageCellEditor());
        this.popupMenu = new JPopupMenu();
        this.coordinatedStatusMenuItems = new HashMap<Actor.ActorStatus, JMenuItem>();
        JMenu menuFile = new JMenu("Status");
        menuFile.setMnemonic(83);
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Attacking, 65));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Waiting, 87));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.StunPhys, 80));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.StunMental, 77));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.StunRecovr, 83));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Disarmed, 82));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Kneeling, 75));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Prone, 80));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Disabled, 68));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Unconscious, 85));
        menuFile.add(this.createCoordinatedStatusMenuItem(Actor.ActorStatus.Dead, 69));
        this.popupMenu.add(menuFile);
        menuFile = new JMenu("Type");
        menuFile.setMnemonic(84);
        menuFile.add(this.createMenuItem("PC", 67));
        menuFile.add(this.createMenuItem("Ally", 65));
        menuFile.add(this.createMenuItem("Enemy", 69));
        menuFile.add(this.createMenuItem("Neutral", 78));
        menuFile.add(this.createMenuItem("Special", 83));
        this.popupMenu.add(menuFile);
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Set Active", 65));
        }
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Attack", 75));
        }
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Defend", 68));
        }
        this.popupMenu.add(this.createMenuItem("Reset", 82));
        this.popupMenu.add(this.createMenuItem("Delete", 127));
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Tag", 84));
        }
        if (this.isInitTable) {
            this.popupMenu.add(this.createMenuItem("Remove Tag", 86));
        }
        MousePopupListener popupListener = new MousePopupListener();
        this.addMouseListener(popupListener);
        this.getTableHeader().addMouseListener(popupListener);
        if (!this.isInitTable) {
            this.getColumnModel().removeColumn(this.getColumnModel().getColumn(InitTableModel.columns.Act.ordinal()));
        }
        this.autoSizeColumns();
    }

    public boolean isInitTable() {
        return this.isInitTable;
    }

    public boolean nextActor() {
        return this.tableModel.nextActor();
    }

    public InitTableModel getActorTableModel() {
        return this.tableModel;
    }

    public Actor getActiveActor() {
        return this.tableModel.getActiveActor();
    }

    public Actor getSelectedActor() {
        int index = this.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.tableModel.getActor(index);
    }

    @Override
    public int[] getSelectedRows() {
        int[] rows = super.getSelectedRows();
        if (rows.length > 0 && rows[rows.length - 1] == this.getRowCount() - 1) {
            if (rows.length == 1) {
                return new int[0];
            }
            int[] newrows = new int[rows.length - 1];
            System.arraycopy(rows, 0, newrows, 0, newrows.length);
            return newrows;
        }
        return rows;
    }

    public void setActorValue(Actor actor, InitTableModel.columns field, Object newValue) {
        this.tableModel.setValueAt(newValue, this.tableModel.getActorRows(actor)[0], field.ordinal());
    }

    public void modifyStatusOfSelectedActors(Actor.ActorStatus status, boolean add) {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Actor actor = this.tableModel.getActor(row);
            if (add) {
                actor.addStatus(status);
            } else {
                actor.removeStatus(status);
            }
            ++n2;
        }
    }

    public void toggleStatusOfSelectedActors(Actor.ActorStatus status) {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Actor actor = this.tableModel.getActor(row);
            if (actor.hasStatus(status)) {
                actor.removeStatus(status);
            } else {
                actor.addStatus(status);
            }
            ++n2;
        }
    }

    public void coordinatedChangeStatusOfSelectedActors(Actor.ActorStatus status) {
        Actor actor;
        int row;
        boolean all_set = true;
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            row = nArray[n2];
            actor = this.tableModel.getActor(row);
            if (!actor.hasStatus(status)) {
                all_set = false;
                break;
            }
            ++n2;
        }
        nArray = this.getSelectedRows();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            row = nArray[n2];
            actor = this.tableModel.getActor(row);
            if (all_set) {
                actor.removeStatus(status);
            } else {
                actor.addStatus(status);
            }
            ++n2;
        }
    }

    public void resetEncounter() {
        this.tableModel.resetEncounter();
    }

    public void activeActorAttack() {
        Actor actor = this.getActiveActor();
        if (actor == null) {
            return;
        }
        actor.Attack();
    }

    public void selectedActorsAttack() {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Actor actor = this.tableModel.getActor(row);
            actor.Attack();
            ++n2;
        }
    }

    public void selectedActorDefend() {
        System.out.println("InitTable: selectedActorDefend: start");
        Actor actor = this.getSelectedActor();
        if (actor == null) {
            return;
        }
        this.stopCellEditing();
        DefenseDialog defenseDialog = new DefenseDialog(actor, SwingUtilities.getWindowAncestor(this));
        defenseDialog.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.y")));
        GITApp.validateOnScreen(defenseDialog);
        defenseDialog.setVisible(true);
        if (defenseDialog.valid) {
            actor.Defend(defenseDialog.defense);
        }
        this.propertyBag.setProperty("GITApp.defense.location.x", String.valueOf(defenseDialog.getLocation().x));
        this.propertyBag.setProperty("GITApp.defense.location.y", String.valueOf(defenseDialog.getLocation().y));
    }

    public void stopCellEditing() {
        if (this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    public static void formatComponentAlignment(JLabel c, Actor a, InitTableModel.columns col) {
        c.setHorizontalAlignment(2);
        c.setHorizontalTextPosition(10);
        if (a.hasStatus(Actor.ActorStatus.Waiting)) {
            c.setHorizontalAlignment(4);
        }
        if (col == InitTableModel.columns.Act) {
            c.setHorizontalAlignment(4);
        }
    }

    public static void formatComponentAlignment(JTextField c, Actor a) {
        c.setHorizontalAlignment(2);
        if (a.hasStatus(Actor.ActorStatus.Waiting)) {
            c.setHorizontalAlignment(4);
        }
    }

    public static void formatComponentColor(JComponent c, Actor a, boolean isSelected, InitTableModel.columns col) {
        if (col == InitTableModel.columns.Damage || col == InitTableModel.columns.Fatigue) {
            c.setForeground(new Color(220, 0, 0));
        } else {
            c.setForeground(new Color(0, 0, 0));
        }
        if (isSelected) {
            switch (a.getType()) {
                case PC: {
                    c.setBackground(new Color(128, 255, 128));
                    break;
                }
                case Ally: {
                    c.setBackground(new Color(128, 128, 255));
                    break;
                }
                case Enemy: {
                    c.setBackground(new Color(255, 128, 128));
                    break;
                }
                case Neutral: {
                    c.setBackground(new Color(128, 128, 128));
                    break;
                }
                case Special: {
                    c.setBackground(new Color(255, 128, 255));
                }
            }
        } else {
            switch (a.getType()) {
                case PC: {
                    c.setBackground(new Color(200, 255, 200));
                    break;
                }
                case Ally: {
                    c.setBackground(new Color(200, 200, 255));
                    break;
                }
                case Enemy: {
                    c.setBackground(new Color(255, 200, 200));
                    break;
                }
                case Neutral: {
                    c.setBackground(new Color(200, 200, 200));
                    break;
                }
                case Special: {
                    c.setBackground(new Color(255, 200, 255));
                }
            }
        }
        if (a.hasStatus(Actor.ActorStatus.Unconscious) || a.hasStatus(Actor.ActorStatus.Disabled) || a.hasStatus(Actor.ActorStatus.Dead)) {
            c.setForeground(new Color(128, 128, 128));
        }
    }

    class InitTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        InitTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                c.setIcon(new ImageIcon());
                if (col == InitTableModel.columns.Name) {
                    c.setText("new...");
                } else if (col == InitTableModel.columns.Status) {
                    c.setText("");
                }
                return c;
            }
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            int Injury = a.getTraitValueInt(Actor.BasicTrait.Injury);
            int Fatigue = a.getTraitValueInt(Actor.BasicTrait.Fatigue);
            int HP = a.getTraitValueInt(Actor.BasicTrait.HP);
            int FP = a.getTraitValueInt(Actor.BasicTrait.FP);
            if (col == InitTableModel.columns.Act && InitTable.this.tableModel.getActiveActorIndex() == row) {
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/go.png"), "Current Actor"));
            } else if ((col == InitTableModel.columns.Move || col == InitTableModel.columns.Dodge) && Injury > 2 * HP / 3 && Fatigue > 2 * FP / 3) {
                int currentValue = Integer.parseInt(c.getText());
                int newValue = (int)Math.ceil((double)currentValue / 4.0);
                c.setText("<html>" + c.getText() + " <strong>(" + newValue + ")</strong></html>");
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/exclamation.png"), "Greatly reduced state"));
            } else if (!(col != InitTableModel.columns.Move && col != InitTableModel.columns.Dodge || Injury <= 2 * HP / 3 && Fatigue <= 2 * FP / 3)) {
                int currentValue = Integer.parseInt(c.getText());
                int newValue = (int)Math.ceil((double)currentValue / 2.0);
                c.setText("<html>" + c.getText() + " <strong>(" + newValue + ")</strong></html>");
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Reduced state"));
            } else if (col == InitTableModel.columns.HT && Injury >= HP) {
                int penalty = (int)(-1.0 * (Math.floor((double)Injury / (double)HP) - 1.0));
                if (penalty < 0) {
                    c.setText("<html>" + c.getText() + " <strong>(" + penalty + ")</strong></html>");
                }
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Must check to stay conscious"));
            } else if (col == InitTableModel.columns.Status) {
                c.setText(a.getStatusesString());
                c.setIcon(new ImageIcon());
            } else {
                c.setIcon(new ImageIcon());
            }
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a, col);
            return c;
        }
    }

    class InitTableDamageCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private static final boolean DEBUG = true;

        public InitTableDamageCellEditor() {
            super(new JTextField());
            DamageDocumentFilter df = new DamageDocumentFilter();
            JTextField tf = (JTextField)this.getComponent();
            tf.addFocusListener(df);
            ((AbstractDocument)tf.getDocument()).setDocumentFilter(df);
        }

        @Override
        public Object getCellEditorValue() {
            JTextField tf = (JTextField)this.getComponent();
            try {
                Integer value = new Integer(tf.getText());
                return value;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String text = tf.getText();
            Pattern pattern = Pattern.compile("^(-?\\d+)([\\+-])(\\d+)(.*)$");
            Matcher matcher = pattern.matcher(text);
            while (matcher.matches()) {
                Integer first = new Integer(matcher.group(1));
                String operator = matcher.group(2);
                Integer second = new Integer(matcher.group(3));
                Integer result = operator.equals("+") ? Integer.valueOf(first + second) : Integer.valueOf(first - second);
                text = matcher.group(4);
                System.out.println("InitTableDamageCellEditor: Calculating damage: " + first + " : " + operator + " : " + second + " = " + result + " (" + text + ").");
                text = result + text;
                matcher = pattern.matcher(text);
            }
            try {
                new Integer(text);
                tf.setText(text);
                return super.stopCellEditing();
            }
            catch (NumberFormatException e) {
                tf.setBorder(new LineBorder(new Color(220, 0, 0)));
                return false;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            c.setBorder(new LineBorder(new Color(255, 255, 255)));
            return c;
        }

        private class DamageDocumentFilter
        extends DocumentFilter
        implements FocusListener {
            boolean startingNew = true;
            boolean firstEdit = true;
            boolean hasFocus = false;

            private DamageDocumentFilter() {
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offs, int length) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Remove: offs: " + offs + ", len:" + length + ".");
                this.startingNew = false;
                super.remove(fb, offs, length);
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Insert:" + str + ".");
                if (str.matches("[\\d\\+-]+")) {
                    super.insertString(fb, offs, str, a);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: Replace: '" + str + "', Offs=" + offs + ", Length=" + length + ".");
                if (str.matches("[\\d\\+-]+")) {
                    if (this.hasFocus || this.firstEdit || length > 0) {
                        this.firstEdit = false;
                        this.startingNew = true;
                        super.replace(fb, offs, length, str, a);
                    } else if (this.startingNew && str.matches("\\d")) {
                        this.startingNew = false;
                        super.replace(fb, offs, 0, "+", null);
                        super.replace(fb, offs + 1, 0, str, a);
                    } else {
                        this.startingNew = false;
                        super.replace(fb, offs, 0, str, a);
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                this.hasFocus = true;
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: TextField focus gained.");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                this.hasFocus = false;
                System.out.println("InitTableDamageCellEditor: DamageDocumentFilter: TextField focus lost.");
            }
        }
    }

    class InitTableIntegerCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public InitTableIntegerCellEditor() {
            super(new JTextField());
        }

        @Override
        public Object getCellEditorValue() {
            JTextField tf = (JTextField)this.getComponent();
            try {
                Integer value = new Integer(tf.getText());
                return value;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String text = tf.getText();
            try {
                new Integer(text);
                tf.setText(text);
                return super.stopCellEditing();
            }
            catch (NumberFormatException e) {
                tf.setBorder(new LineBorder(new Color(220, 0, 0)));
                return false;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (isSelected) {
                c.selectAll();
            }
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            c.setBorder(new LineBorder(new Color(255, 255, 255)));
            return c;
        }
    }

    class InitTableStatusListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    FocusListener,
    ComponentListener {
        private static final long serialVersionUID = 1L;
        JList<Actor.ActorStatus> list;
        JScrollPane pane;
        JButton button = new JButton();
        JDialog dialog = null;
        boolean isEditing = false;

        public InitTableStatusListCellEditor() {
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setActionCommand("EDIT");
            this.button.addActionListener(this);
            this.button.addFocusListener(this);
            this.list = new JList<Actor.ActorStatus>(Actor.ActorStatus.values());
            this.list.setVisibleRowCount(Actor.ActorStatus.values().length);
            this.list.setSelectionMode(2);
            this.list.setSelectionModel(new DefaultListSelectionModel(){
                boolean gestureStarted = false;
                boolean adding = true;

                @Override
                public void setSelectionInterval(int index0, int index1) {
                    if (this.getValueIsAdjusting() && !this.gestureStarted && index0 != -1 && index1 != -1) {
                        this.adding = !super.isSelectedIndex(index0);
                        this.gestureStarted = true;
                    }
                    if (!this.getValueIsAdjusting() || this.adding) {
                        super.addSelectionInterval(index0, index1);
                    } else {
                        super.removeSelectionInterval(index0, index1);
                    }
                }

                @Override
                public void setValueIsAdjusting(boolean isAdjusting) {
                    if (!isAdjusting) {
                        this.gestureStarted = false;
                    }
                    super.setValueIsAdjusting(isAdjusting);
                }
            });
            this.pane = new JScrollPane(this.list);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.dialog == null) {
                this.dialog = new JDialog((Frame)InitTable.this.getTopLevelAncestor(), false);
                this.dialog.add(this.pane);
                this.dialog.setUndecorated(true);
                this.dialog.setBounds(0, 0, 10, 10);
                this.dialog.setModal(false);
                this.dialog.setFocusableWindowState(false);
                InitTable.this.getTopLevelAncestor().addComponentListener(this);
            }
            this.list.clearSelection();
            for (Actor.ActorStatus status : (HashSet)value) {
                this.list.setSelectedValue((Object)status, true);
            }
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            HashSet<Actor.ActorStatus> statuses = new HashSet<Actor.ActorStatus>(this.list.getSelectedValuesList());
            return statuses;
        }

        @Override
        public boolean stopCellEditing() {
            boolean retval = super.stopCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
            return retval;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("EDIT")) {
                this.dialog.setLocation(this.button.getLocationOnScreen());
                this.dialog.setSize(this.button.getWidth(), this.dialog.getPreferredSize().height);
                this.dialog.setVisible(true);
                this.isEditing = true;
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class InitTableTextCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        private String actorName;

        public InitTableTextCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.editorComponent.addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (row == table.getRowCount() - 1) {
                c.setBackground(new Color(255, 255, 255));
                c.setForeground(new Color(128, 128, 128));
                c.setHorizontalAlignment(2);
                return c;
            }
            InitTableModel.columns col = InitTableModel.columns.valueOf(table.getColumnName(column));
            Actor a = ((InitTableModel)table.getModel()).getActor(row);
            this.actorName = a.getTraitValue(Actor.BasicTrait.Name);
            InitTable.formatComponentColor(c, a, isSelected, col);
            InitTable.formatComponentAlignment(c, a);
            return c;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            String selctedActorName = InitTable.this.getSelectedActor().getTraitValue(Actor.BasicTrait.Name);
            if (!selctedActorName.equals(this.actorName)) {
                JTextField t = (JTextField)evt.getComponent();
                this.actorName = selctedActorName;
                t.setText(this.actorName);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            this.stopCellEditing();
        }
    }

    class InitTableTypeListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    MouseListener,
    FocusListener,
    ComponentListener {
        private static final long serialVersionUID = 1L;
        JList<Actor.ActorType> list;
        JScrollPane pane;
        JButton button = new JButton();
        JDialog dialog = null;
        boolean isEditing = false;

        public InitTableTypeListCellEditor() {
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setActionCommand("EDIT");
            this.button.addActionListener(this);
            this.button.addFocusListener(this);
            this.list = new JList<Actor.ActorType>(Actor.ActorType.values());
            this.list.setVisibleRowCount(Actor.ActorType.values().length);
            this.list.setSelectionMode(0);
            this.list.addMouseListener(this);
            this.pane = new JScrollPane(this.list);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.dialog == null) {
                this.dialog = new JDialog((Frame)InitTable.this.getTopLevelAncestor(), false);
                this.dialog.add(this.pane);
                this.dialog.setUndecorated(true);
                this.dialog.setBounds(0, 0, 10, 10);
                this.dialog.setModal(false);
                this.dialog.setFocusableWindowState(false);
                InitTable.this.getTopLevelAncestor().addComponentListener(this);
            }
            this.list.setSelectedValue(value, true);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.list.getSelectedValue();
        }

        @Override
        public boolean stopCellEditing() {
            boolean retval = super.stopCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
            return retval;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("EDIT")) {
                this.dialog.setLocation(this.button.getLocationOnScreen());
                this.dialog.setSize(this.button.getWidth(), this.dialog.getPreferredSize().height);
                this.dialog.setVisible(true);
                this.isEditing = true;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.isEditing) {
                this.cancelCellEditing();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.isEditing) {
                this.cancelCellEditing();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
            this.checkResize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger() & InitTable.this.getSelectedRows().length > 0) {
                InitTable.this.updateCoordinatedStatusMenuItems();
                InitTable.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void checkResize(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Cursor currentCursor = InitTable.this.getTableHeader().getCursor();
                System.out.println("MouseClickListener: checkResize: double-click detected. Type is " + currentCursor.getType() + " (" + currentCursor.toString() + ")");
                if (currentCursor.getType() == 11) {
                    InitTable.this.autoSizeColumns();
                    System.out.println("MouseClickListener: checkResize: auto-sizing columns.");
                }
            }
        }
    }
}

