/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class TraitTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private String[] columnNames = new String[]{"Name", "Value"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class};
    private static int numColumns = 2;
    private boolean isTemp;
    private Actor currentActor = null;
    private ArrayList<String> displayedTraitKeys = new ArrayList();

    public TraitTableModel(boolean isTemp) {
        this.isTemp = isTemp;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.currentActor == null) {
            return 0;
        }
        return this.displayedTraitKeys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentActor == null) {
            return null;
        }
        String traitName = this.displayedTraitKeys.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return traitName;
            }
            case Value: {
                if (this.isTemp) {
                    return this.currentActor.getTempValue(traitName);
                }
                return this.currentActor.getTraitValue(traitName);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.isTemp) {
            return;
        }
        if (this.getValueAt(row, col).equals(value)) {
            return;
        }
        String traitName = this.displayedTraitKeys.get(row);
        switch (columns.values()[col]) {
            case Name: {
                String newName = (String)value;
                if (!this.currentActor.renameTrait(traitName, newName)) {
                    System.out.println("TraitTableModel: setValueAt: rename failed!");
                    break;
                }
                this.displayedTraitKeys.set(row, newName);
                break;
            }
            case Value: {
                this.currentActor.setTrait(traitName, (String)value);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return !this.isTemp && this.currentActor != null;
    }

    public void setActor(Actor actor) {
        this.currentActor = actor;
        this.displayedTraitKeys.clear();
        if (this.isTemp) {
            this.displayedTraitKeys.addAll(actor.getAllTempNames());
        } else {
            for (String traitName : actor.getAllTraitNames()) {
                if (Actor.isBasicTrait(traitName)) continue;
                this.displayedTraitKeys.add(traitName);
            }
        }
        this.fireTableDataChanged();
    }

    public void addTrait() {
        if (!this.isTemp && this.currentActor != null) {
            int num = 1;
            while (this.currentActor.hasTrait("newTrait" + String.valueOf(num))) {
                ++num;
            }
            String name = "newTrait" + String.valueOf(num);
            if (this.currentActor.addTrait(name, "")) {
                this.displayedTraitKeys.add(name);
                this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            }
        }
    }

    public void removeTraits(int[] rows) {
        if (!this.isTemp && this.currentActor != null && rows.length > 0) {
            int i = rows.length - 1;
            while (i >= 0) {
                String traitName = this.displayedTraitKeys.get(rows[i]);
                if (this.currentActor.removeTrait(traitName)) {
                    this.displayedTraitKeys.remove(rows[i]);
                } else {
                    System.out.println("-W- TraitTableModel: skipping trait removal due to failure in base actor");
                }
                --i;
            }
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }
    }

    public static enum columns {
        Name,
        Value;

    }
}

