/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Attack;
import gurpsinittool.data.CriticalTables;
import gurpsinittool.data.Damage;
import gurpsinittool.data.Defense;
import gurpsinittool.data.GameSettings;
import gurpsinittool.util.DieRoller;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogEventSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Actor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static EncounterLogEventSource LogEventSource;
    public static GameSettings settings;
    private transient PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    private HashSet<ActorStatus> statuses;
    private ActorType type;
    protected HashMap<String, Trait> traits = new HashMap();
    private int defaultAttack = 0;
    private ArrayList<Attack> attacks;
    protected HashMap<String, Trait> temps = new HashMap();

    public Actor(String name, ActorType type) {
        this.statuses = new HashSet();
        this.type = type;
        this.InitializeBasicTraits();
        this.setTrait(BasicTrait.Name, name);
        this.attacks = new ArrayList();
    }

    public Actor(Actor anActor) {
        this(anActor.getTrait((BasicTrait)BasicTrait.Name).value, anActor.type);
        this.statuses.addAll(anActor.statuses);
        Iterator<Trait> iterator = anActor.traits.values().iterator();
        while (iterator.hasNext()) {
            Trait value;
            Trait trait = value = iterator.next();
            this.setTrait(trait.name, trait.value);
        }
        int i = 0;
        while (i < anActor.attacks.size()) {
            this.attacks.add(anActor.attacks.get(i));
            ++i;
        }
    }

    private void InitializeBasicTraits() {
        String[] defaultBasicTraitValues = new String[]{"unnamed", "10", "10", "5", "10", "10", "5", "10", "10", "10", "10", "0", "0", "0", "8", "9", "9", "0", "2", "4", "20", ""};
        BasicTrait[] traitNames = BasicTrait.values();
        int i = 0;
        while (i < traitNames.length) {
            String traitValue = defaultBasicTraitValues[i];
            String traitName = traitNames[i].toString();
            this.addTrait(traitName, traitValue);
            ++i;
        }
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mPcs = new PropertyChangeSupport(this);
    }

    public boolean hasStatus(ActorStatus status) {
        return this.statuses.contains((Object)status);
    }

    public void addStatus(ActorStatus status) {
        if (!this.statuses.contains((Object)status)) {
            this.statuses.add(status);
            if (Actor.settings.LOG_STATUSCHANGES) {
                this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> added status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
            }
            this.mPcs.firePropertyChange("Status", null, (Object)status);
        }
    }

    public HashSet<ActorStatus> getAllStatuses() {
        return new HashSet<ActorStatus>(this.statuses);
    }

    public void setAllStatuses(HashSet<ActorStatus> newStatuses) {
        if (!this.statuses.containsAll(newStatuses) || !newStatuses.containsAll(this.statuses)) {
            String oldStatuses = this.getStatusesString();
            this.statuses.clear();
            this.statuses.addAll(newStatuses);
            if (Actor.settings.LOG_STATUSCHANGES) {
                this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> status set to <b>[" + this.getStatusesString() + "]</b>");
            }
            this.mPcs.firePropertyChange("Statuses", oldStatuses, this.getStatusesString());
        }
    }

    public void removeStatus(ActorStatus status) {
        if (this.statuses.contains((Object)status)) {
            this.statuses.remove((Object)status);
            if (Actor.settings.LOG_STATUSCHANGES) {
                this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> removed status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
            }
            this.mPcs.firePropertyChange("Status", (Object)status, null);
        }
    }

    public void clearStatuses() {
        if (this.statuses.size() > 0) {
            int size = this.statuses.size();
            this.statuses.clear();
            this.mPcs.firePropertyChange("Status", (Object)size, null);
        }
    }

    public String getStatusesString() {
        int[] scodes = new int[this.statuses.size()];
        int i = 0;
        for (ActorStatus as : this.statuses) {
            scodes[i++] = as.ordinal();
        }
        Arrays.sort(scodes);
        String text = "";
        int j = 0;
        while (j < scodes.length) {
            if (j != 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ActorStatus.values()[scodes[j]].toString();
            ++j;
        }
        return text;
    }

    public ActorType getType() {
        return this.type;
    }

    public void setType(ActorType type) {
        if (this.type != type) {
            ActorType oldType = this.type;
            this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> type changed to <b>" + (Object)((Object)type) + "</b>");
            this.type = type;
            this.mPcs.firePropertyChange("Type", (Object)oldType, (Object)type);
        }
    }

    public int getDefaultAttack() {
        return this.defaultAttack;
    }

    public void setDefaultAttack(int index) {
        if (this.defaultAttack != index && index < this.attacks.size()) {
            int oldDefault = this.defaultAttack;
            this.defaultAttack = index;
            this.mPcs.firePropertyChange("DefaultAttack", oldDefault, this.defaultAttack);
        }
    }

    public int getNumAttacks() {
        return this.attacks.size();
    }

    public Attack getAttack(int index) {
        return this.attacks.get(index);
    }

    public void addAttack(Attack attack) {
        this.attacks.add(attack);
        this.mPcs.firePropertyChange("Attacks", this.attacks.size() - 1, this.attacks.size());
    }

    public void removeAttack(int index) {
        if (index < this.attacks.size()) {
            if (index < this.defaultAttack) {
                --this.defaultAttack;
            }
            if (index == this.defaultAttack) {
                this.defaultAttack = 0;
            }
            this.attacks.remove(index);
            this.mPcs.firePropertyChange("Attacks", this.attacks.size() + 1, this.attacks.size());
        }
    }

    public boolean hasTrait(String name) {
        return this.traits.containsKey(name);
    }

    public static boolean isBasicTrait(String name) {
        BasicTrait[] basicTraitArray = BasicTrait.values();
        int n = basicTraitArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicTrait b = basicTraitArray[n2];
            if (b.name().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Trait getTrait(String name) {
        if (!this.traits.containsKey(name)) {
            System.out.println("-E- Actor:GetTrait: requested trait that does not exist: " + name);
            return null;
        }
        return this.traits.get(name);
    }

    private Trait getTrait(BasicTrait trait) {
        return this.traits.get(trait.toString());
    }

    public String getTraitValue(String name) {
        return this.getTrait((String)name).value;
    }

    public String getTraitValue(BasicTrait trait) {
        return this.getTrait((BasicTrait)trait).value;
    }

    public int getTraitValueInt(BasicTrait trait) {
        try {
            return Integer.parseInt(this.getTrait((BasicTrait)trait).value);
        }
        catch (NumberFormatException e) {
            System.err.println("Actor: getValueInt: Error parsing value: " + this.getTrait((BasicTrait)trait).value);
            return 0;
        }
    }

    public Collection<String> getAllTraitNames() {
        return this.traits.keySet();
    }

    public void setTrait(String name, String value) {
        if (!this.hasTrait(name)) {
            System.err.println("Actor.setTrait: trait does not exist: " + name);
            return;
        }
        Trait trait = this.getTrait(name);
        if (!trait.value.equals(value)) {
            String oldValue = trait.value;
            if (name == "Injury") {
                int newValue = Integer.valueOf(value);
                int HP = this.getTraitValueInt(BasicTrait.HP);
                int diff = this.getTraitValueInt(BasicTrait.Injury) - newValue;
                if (diff < 0) {
                    this.setTemp("shock.next", this.getTempInt("shock.next") - diff);
                    this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> took <b><font color=red>" + -1 * diff + "</font></b> damage (now " + (HP - newValue) + " HP).");
                } else {
                    this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> healed <b><font color=blue>" + diff + "</font></b> (now " + (HP - newValue) + " HP).");
                }
            } else if (name == "Fatigue") {
                int newValue = Integer.valueOf(value);
                int FP = this.getTraitValueInt(BasicTrait.FP);
                int diff = this.getTraitValueInt(BasicTrait.Fatigue) - newValue;
                if (diff < 0) {
                    this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> lost <b>" + -1 * diff + "</b> fatigue (now " + (FP - newValue) + " FP).");
                } else {
                    this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> recoverd <b>" + diff + "</b> fatigue (now " + (FP - newValue) + " FP).");
                }
            }
            trait.value = value;
            this.mPcs.firePropertyChange("trait." + name, oldValue, value);
        }
    }

    public void setTrait(BasicTrait trait, String value) {
        this.setTrait(trait.toString(), value);
    }

    public void setTrait(BasicTrait trait, int value) {
        this.setTrait(trait, String.valueOf(value));
    }

    public void setTrait(String name, int value) {
        this.setTrait(name, String.valueOf(value));
    }

    public boolean addTrait(String name, String value) {
        if (this.hasTrait(name)) {
            System.err.println("Actor.addTrait: trait already exists! " + name);
            return false;
        }
        Trait newTrait = new Trait(name, value);
        this.traits.put(name, newTrait);
        this.mPcs.firePropertyChange("trait." + name, null, value);
        return true;
    }

    public boolean removeTrait(String name) {
        if (Actor.isBasicTrait(name)) {
            System.out.println("-E- removeTrait: cannot remove basic traits! => " + name);
            return false;
        }
        if (!this.hasTrait(name)) {
            System.out.println("-E- removeTrait: cannot remove non-existant trait! => " + name);
            return false;
        }
        String oldValue = this.getTraitValue(name);
        this.traits.remove(name);
        this.mPcs.firePropertyChange("trait." + name, oldValue, null);
        return true;
    }

    public boolean renameTrait(String oldName, String newName) {
        if (Actor.isBasicTrait(oldName)) {
            System.out.println("-E- renameTrait: Cannot rename BasicTrait! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        if (this.hasTrait(newName)) {
            System.out.println("-E- renameTrait: New trait name already exists! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        if (!this.hasTrait(oldName)) {
            System.out.println("-E- renameTrait: Old name does not exist! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        Trait trait = this.getTrait(oldName);
        String value = trait.value;
        trait.name = newName;
        this.traits.remove(oldName);
        this.mPcs.firePropertyChange("trait." + oldName, value, null);
        this.traits.put(newName, trait);
        this.mPcs.firePropertyChange("trait." + newName, null, value);
        return true;
    }

    public boolean hasTemp(String name) {
        return this.temps.containsKey(name);
    }

    private Trait getTemp(String name) {
        return this.temps.get(name);
    }

    public String getTempValue(String name) {
        return this.temps.get((Object)name).value;
    }

    public int getTempInt(String name) {
        return Integer.parseInt(this.getTemp((String)name).value);
    }

    public void setTemp(String name, String value) {
        if (this.hasTemp(name)) {
            this.getTemp((String)name).value = value;
        } else {
            Trait newTrait = new Trait(name, value);
            this.temps.put(name, newTrait);
        }
    }

    public void setTemp(String name, int value) {
        this.setTemp(name, String.valueOf(value));
    }

    public Collection<String> getAllTempNames() {
        return this.temps.keySet();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    public void NextTurn() {
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        if (Actor.settings.AUTO_SHOCK) {
            int injury = this.getTempInt("shock.next");
            int injury_per_shock = this.getTraitValueInt(BasicTrait.HP) / 10;
            int LHPT = this.hasTrait("HPT") ? 0 : (this.hasTrait("LPT") ? 2 : 1);
            this.setTemp("shock", LHPT * Math.min(injury / injury_per_shock, 4));
        }
        this.setTemp("shock.next", 0);
        String Name = this.getTraitValue(BasicTrait.Name);
        int Injury = this.getTraitValueInt(BasicTrait.Injury);
        int HP = this.getTraitValueInt(BasicTrait.HP);
        int HT = this.getTraitValueInt(BasicTrait.HT);
        if (this.type == ActorType.Enemy) {
            if (!(!Actor.settings.AUTO_UNCONSCIOUS || Injury < HP || this.hasStatus(ActorStatus.Unconscious) || this.hasStatus(ActorStatus.Disabled) || this.hasStatus(ActorStatus.Dead) || this.hasStatus(ActorStatus.Waiting))) {
                int penalty = (int)(-1.0 * (Math.floor((double)Injury / (double)HP) - 1.0));
                int result = DieRoller.roll3d6();
                String details = "(HT: " + HT + ", penalty: " + penalty + ", roll: " + result + ")";
                if (DieRoller.isFailure(result, HT + penalty)) {
                    this.logEvent("<b>" + Name + "</b> <b><font color=red>failed</font></b> consciousness roll " + details);
                    this.clearStatuses();
                    this.addStatus(ActorStatus.Unconscious);
                    this.addStatus(ActorStatus.Prone);
                    this.addStatus(ActorStatus.Disarmed);
                } else {
                    this.logEvent("<b>" + Name + "</b> passed consciousness roll " + details);
                }
            }
            if (Actor.settings.AUTO_STUNRECOVERY) {
                int roll;
                int recoverTarget;
                this.removeStatus(ActorStatus.StunRecovr);
                if (this.hasStatus(ActorStatus.StunMental)) {
                    recoverTarget = this.getTraitValueInt(BasicTrait.IQ);
                    if (this.hasTrait("CR")) {
                        recoverTarget += 6;
                    }
                    if (DieRoller.isSuccess(roll = DieRoller.roll3d6(), recoverTarget)) {
                        this.logEvent("<b>" + Name + "</b> is now recovering from Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorStatus.StunMental);
                        this.addStatus(ActorStatus.StunRecovr);
                    } else {
                        this.logEvent("<b>" + Name + "</b> <b>failed</b> recovery roll for Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                } else if (this.hasStatus(ActorStatus.StunPhys)) {
                    recoverTarget = this.getTraitValueInt(BasicTrait.HT);
                    roll = DieRoller.roll3d6();
                    if (DieRoller.isSuccess(roll, recoverTarget)) {
                        this.logEvent("<b>" + Name + "</b> is now recovering from Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorStatus.StunPhys);
                        this.addStatus(ActorStatus.StunRecovr);
                    } else {
                        this.logEvent("<b>" + Name + "</b> <b>failed</b> recovery roll for Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                }
            }
            if (Actor.settings.AUTO_ATTACK && this.hasStatus(ActorStatus.Attacking) && !this.isStunned()) {
                this.Attack();
            }
        }
    }

    public void Reset() {
        this.clearStatuses();
        this.setTrait(BasicTrait.Injury, "0");
        this.setTrait(BasicTrait.Fatigue, "0");
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    private void logEvent(String text) {
        if (LogEventSource != null) {
            LogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, text));
        }
    }

    public boolean isStunned() {
        return this.hasStatus(ActorStatus.StunPhys) || this.hasStatus(ActorStatus.StunMental) || this.hasStatus(ActorStatus.StunRecovr);
    }

    public void Attack() {
        CriticalTables.Entry crit_result;
        String hit_miss;
        String Name = this.getTraitValue(BasicTrait.Name);
        if (this.attacks.size() < 1) {
            this.logEvent("<i><font color=gray>" + Name + " has no attacks defined!</font></i>");
            return;
        }
        if (this.defaultAttack < 0 || this.defaultAttack >= this.attacks.size()) {
            this.logEvent("<i><font color=gray>" + Name + " has invalid default attack: " + this.defaultAttack + "</font></i>");
            return;
        }
        Attack attack = this.attacks.get(this.defaultAttack);
        int eff_skill = attack.Skill;
        if (Actor.settings.AUTO_SHOCK) {
            eff_skill -= this.getTempInt("shock");
        }
        int roll = DieRoller.roll3d6();
        int margin = eff_skill - roll;
        String crit_string = "";
        if (DieRoller.isCritFailure(roll, eff_skill)) {
            hit_miss = "<b><font color=red>Critical miss</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_miss);
            crit_string = "<br/> <i><font color=gray><b>Critical Miss Table Result:</b>" + crit_result.notes + "</font></i>";
        } else if (DieRoller.isCritSuccess(roll, eff_skill)) {
            hit_miss = "<b><font color=blue>Critical hit</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_hit);
            crit_string = "<br/> <i><font color=gray><b>Critical Hit Table Result:</b>" + crit_result.notes + "</font></i>";
        } else {
            hit_miss = DieRoller.isSuccess(roll, eff_skill) ? "<b>hit</b>" : "miss";
        }
        boolean isHit = DieRoller.isSuccess(roll, eff_skill);
        Damage damage = Damage.ParseDamage(attack.Damage);
        if (attack.Unbalanced) {
            this.setTemp("numParry", this.getTempInt("numParry") + 1);
        }
        String armorDivStr = "";
        if (damage.ArmorDivisor != 1.0) {
            armorDivStr = damage.ArmorDivisor == (double)((int)damage.ArmorDivisor) ? "(" + String.format("%d", (int)damage.ArmorDivisor) + ")" : "(" + String.format("%s", damage.ArmorDivisor) + ")";
        }
        this.logEvent("<b> " + Name + "</b> attacks with " + attack.Name + ": " + hit_miss + " (" + roll + "/" + eff_skill + "=" + margin + ") for damage " + (isHit ? "<font color=red><b>" : "") + damage.BasicDamage + armorDivStr + " " + (Object)((Object)damage.Type) + (isHit ? "</b></font>" : "") + " (" + attack.Damage + ")" + crit_string);
    }

    public String Defend(Defense defense) {
        this.ProcessDefense(defense);
        this.GenerateDefenseLog(defense);
        this.KnockdownStunningCheck(defense);
        return "";
    }

    private void ProcessDefense(Defense defense) {
        int Fatigue = this.getTraitValueInt(BasicTrait.Fatigue);
        int Injury = this.getTraitValueInt(BasicTrait.Injury);
        this.setTemp("shieldDamage", this.getTempInt("shieldDamage") + defense.shieldDamage);
        this.setTrait(BasicTrait.Injury, String.valueOf(Injury + defense.injury));
        this.setTrait(BasicTrait.Fatigue, String.valueOf(Fatigue + defense.fatigue));
        switch (defense.type) {
            case Parry: {
                this.setTemp("numParry", this.getTempInt("numParry") + 1);
                break;
            }
            case Block: {
                this.setTemp("numBlock", this.getTempInt("numBlock") + 1);
            }
        }
    }

    private void KnockdownStunningCheck(Defense defense) {
        String Name = this.getTraitValue(BasicTrait.Name);
        int HT = this.getTraitValueInt(BasicTrait.HT);
        if (defense.cripplingInjury || defense.majorWound) {
            int effHT = HT + defense.location.knockdownPenalty;
            if (this.hasTrait("HPT")) {
                effHT += 3;
            }
            if (this.hasTrait("LPT")) {
                effHT -= 4;
            }
            int roll = DieRoller.roll3d6();
            boolean success = DieRoller.isSuccess(roll, effHT);
            this.logEvent("<b>" + Name + "</b> Knockdown/Stunning check: rolled " + roll + " against " + effHT + " => " + (!success ? "<b>failed</b>" : "succeeded") + (Actor.settings.AUTO_KNOCKDOWNSTUN ? "" : " (not applied)"));
            if (Actor.settings.AUTO_KNOCKDOWNSTUN && !success) {
                this.addStatus(ActorStatus.StunPhys);
                this.removeStatus(ActorStatus.StunRecovr);
                this.addStatus(ActorStatus.Prone);
                this.removeStatus(ActorStatus.Kneeling);
                this.addStatus(ActorStatus.Disarmed);
            }
        }
    }

    private void GenerateDefenseLog(Defense defense) {
        String Name = this.getTraitValue(BasicTrait.Name);
        String resultType = defense.result == Defense.DefenseResult.CritSuccess ? "<b><font color=blue>critically</font></b>" : (defense.result == Defense.DefenseResult.Success ? "successfully" : (defense.result == Defense.DefenseResult.ShieldHit ? "partially" : "unsuccessfully"));
        String defenseDescription = "";
        switch (defense.type) {
            case Parry: {
                defenseDescription = String.valueOf(resultType) + " parried blow.";
                break;
            }
            case Block: {
                defenseDescription = String.valueOf(resultType) + " blocked blow.";
                break;
            }
            case Dodge: {
                defenseDescription = String.valueOf(resultType) + " dodged blow.";
                break;
            }
            case None: {
                defenseDescription = "made no defense against blow.";
            }
        }
        String damageDescription = "";
        if (defense.injury != 0) {
            String knockdownstunningPenalty;
            damageDescription = " Sustained <b><font color=red>" + defense.injury + "</font></b> injury to the " + defense.location.description;
            String string = knockdownstunningPenalty = defense.location.knockdownPenalty != 0 ? " @ " + defense.location.knockdownPenalty : "";
            if (defense.cripplingInjury) {
                damageDescription = String.valueOf(damageDescription) + " <b>(crippling" + knockdownstunningPenalty + ")</br>";
            } else if (defense.majorWound) {
                damageDescription = String.valueOf(damageDescription) + " <b>(major" + knockdownstunningPenalty + ")</br>";
            }
            damageDescription = String.valueOf(damageDescription) + ".";
        } else if (defense.result == Defense.DefenseResult.ShieldHit || defense.result == Defense.DefenseResult.Failure) {
            damageDescription = " But took no injury.";
        }
        if (defense.shieldDamage != 0) {
            damageDescription = String.valueOf(damageDescription) + " <b>Shield damaged " + defense.shieldDamage + ".</b>";
        }
        this.logEvent("<b>" + Name + "</b> " + defenseDescription + damageDescription);
    }

    public int getCurrentDefenseValue(Defense.DefenseType type) {
        int Parry = this.getTraitValueInt(BasicTrait.Parry);
        int Block = this.getTraitValueInt(BasicTrait.Block);
        int Dodge = this.getTraitValueInt(BasicTrait.Dodge);
        int Injury = this.getTraitValueInt(BasicTrait.Injury);
        int Fatigue = this.getTraitValueInt(BasicTrait.Fatigue);
        int HP = this.getTraitValueInt(BasicTrait.HP);
        int FP = this.getTraitValueInt(BasicTrait.FP);
        int currentDefense = 0;
        switch (type) {
            case Parry: {
                currentDefense = Parry - this.getTempInt("numParry") * 4;
                break;
            }
            case Block: {
                currentDefense = Block - this.getTempInt("numBlock") * 5;
                break;
            }
            case Dodge: {
                currentDefense = Dodge;
                if (Injury > 2 * HP / 3) {
                    currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
                }
                if (Fatigue <= 2 * FP / 3) break;
                currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
            }
        }
        return currentDefense;
    }

    public static enum ActorStatus {
        Attacking,
        Waiting,
        Disarmed,
        StunPhys,
        StunMental,
        StunRecovr,
        Prone,
        Kneeling,
        Disabled,
        Unconscious,
        Dead;

    }

    public static enum ActorType {
        PC,
        Enemy,
        Ally,
        Neutral,
        Special;

    }

    public static enum BasicTrait {
        Name,
        ST,
        HP,
        Speed,
        DX,
        Will,
        Move,
        IQ,
        Per,
        HT,
        FP,
        SM,
        Fatigue,
        Injury,
        Dodge,
        Parry,
        Block,
        DR,
        Shield_DB,
        Shield_DR,
        Shield_HP,
        Notes;

    }

    private class Trait
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public String value;

        public Trait(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

