/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.data.Actor;
import gurpsinittool.data.Attack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultTreeModel;

public class ActorGroupFile {
    private static final boolean DEBUG = false;
    public static int currentSchemaVer = 5;

    public static void OpenActorGroupTree(GroupTree groupTree, File openFile) {
        BufferedReader input;
        FileReader file;
        try {
            file = new FileReader(openFile);
            input = new BufferedReader(file);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return;
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new GroupTreeNode("Groups", true));
        try {
            Pattern startFile = Pattern.compile("^<GURPSActorGroupList schemaVer=\"(\\d+)\">$");
            String line = input.readLine();
            Matcher matcher = startFile.matcher(line);
            if (!matcher.matches()) {
                input.close();
                System.err.println("Error: first line does not specify start of ActorGroupList!");
                return;
            }
            int schemaVer = Integer.parseInt(matcher.group(1));
            switch (schemaVer) {
                case 0: {
                    ActorGroupFile.readSchema0(input, treeModel);
                    break;
                }
                case 1: {
                    ActorGroupFile.readSchema1(input, treeModel);
                    break;
                }
                case 2: {
                    ActorGroupFile.readSchema2(input, treeModel);
                    break;
                }
                case 3: {
                    ActorGroupFile.readSchema3(input, treeModel);
                    break;
                }
                case 4: {
                    ActorGroupFile.readSchema4(input, treeModel);
                    break;
                }
                case 5: {
                    ActorGroupFile.readSchema5(input, treeModel);
                    break;
                }
                default: {
                    System.err.println("ActorGroupFile: Unknown schema version: " + schemaVer + "!");
                }
            }
            input.close();
            file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        groupTree.setModel(treeModel);
    }

    public static void SaveActorGroupTree(GroupTree groupTree, File saveFile) {
        StringBuffer buffer = new StringBuffer();
        GroupTreeNode rootNode = (GroupTreeNode)groupTree.getModel().getRoot();
        ArrayList<GroupTreeNode> currentNodes = new ArrayList<GroupTreeNode>(Arrays.asList(rootNode));
        ArrayList<Integer> currentPositions = new ArrayList<Integer>(Arrays.asList(0));
        buffer.append("<GURPSActorGroupList schemaVer=\"" + currentSchemaVer + "\">\n");
        buffer.append("<GroupFolder name=\"" + rootNode.toString() + "\">\n");
        while (currentNodes.size() > 0) {
            if (currentPositions.get(0) >= currentNodes.get(0).getChildCount()) {
                currentNodes.remove(0);
                currentPositions.remove(0);
                buffer.append("</GroupFolder>\n");
                continue;
            }
            GroupTreeNode node = (GroupTreeNode)currentNodes.get(0).getChildAt(currentPositions.get(0));
            currentPositions.set(0, currentPositions.get(0) + 1);
            if (node.isFolder()) {
                buffer.append("<GroupFolder name=\"" + node.toString() + "\">\n");
                currentNodes.add(0, node);
                currentPositions.add(0, 0);
                continue;
            }
            buffer.append("<ActorGroup name=\"" + node.toString() + "\">\n");
            ArrayList<Actor> actorList = node.getActorList();
            int i = 0;
            while (i < actorList.size() - 1) {
                buffer.append(ActorGroupFile.SerializeActor(actorList.get(i)));
                ++i;
            }
            buffer.append("</ActorGroup>\n");
        }
        buffer.append("</GURPSActorGroupList>");
        String filename = saveFile.getPath();
        try {
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(buffer.toString());
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static String SerializeActor(Actor actor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<Actor name=\"" + actor.getTraitValue(Actor.BasicTrait.Name) + "\"" + " default_attack=\"" + actor.getDefaultAttack() + "\"" + " state=\"[" + actor.getStatusesString() + "]\"" + " type=\"" + actor.getType().toString() + "\"" + ">\n");
        for (String traitName : actor.getAllTraitNames()) {
            stringWriter.append(ActorGroupFile.SerializeTrait(traitName, actor.getTraitValue(traitName)));
        }
        int i = 0;
        while (i < actor.getNumAttacks()) {
            stringWriter.append(ActorGroupFile.SerializeAttack(actor.getAttack(i)));
            ++i;
        }
        stringWriter.append("</Actor>\n");
        return stringWriter.toString();
    }

    public static String SerializeTrait(String traitName, String value) {
        return "<" + traitName + ">" + value + "</" + traitName + ">\n";
    }

    public static String SerializeAttack(Attack attack) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<Attack name=\"" + attack.Name + "\" skill=\"" + attack.Skill + "\" damage=\"" + attack.Damage + "\" unbalanced=\"" + attack.Unbalanced + "\" />\n");
        return stringWriter.toString();
    }

    public static HashSet<Actor.ActorStatus> parseOldState(String state) {
        HashSet<Actor.ActorStatus> status = new HashSet<Actor.ActorStatus>();
        if (!state.equals("Active")) {
            status.add(Actor.ActorStatus.valueOf(state));
        }
        return status;
    }

    public static HashSet<Actor.ActorStatus> parseState(String stateString) {
        HashSet<Actor.ActorStatus> status = new HashSet<Actor.ActorStatus>();
        Pattern states = Pattern.compile("^\\[(.*)\\]$");
        Matcher matcher = states.matcher(stateString);
        if (!matcher.matches()) {
            System.err.println("Error: stateString does not conform to pattern! " + stateString);
        } else {
            String[] stringArray = matcher.group(1).split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.length() > 0) {
                    status.add(Actor.ActorStatus.valueOf(part));
                }
                ++n2;
            }
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema5(BufferedReader input, DefaultTreeModel treeModel) {
        block19: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                trait = Pattern.compile("^<([^\"]+)>(.*)</([^\"]+)>$");
                startTrait = Pattern.compile("^<([^\"]+)>(.*)$");
                endTrait = Pattern.compile("^(.*)</([^\"]+)>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl94
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = new Actor(matcher.group(1), Actor.ActorType.valueOf(matcher.group(4)));
                        currentActor.setAllStatuses(ActorGroupFile.parseState(matcher.group(3)));
                        currentActor.setDefaultAttack(Integer.parseInt(matcher.group(2)));
                        aName = currentActor.getTraitValue(Actor.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                continue;
                            }
                            matcher = trait.matcher(line);
                            if (matcher.matches()) {
                                if (matcher.group(1).equals(matcher.group(3))) {
                                    if (!currentActor.hasTrait(matcher.group(1))) {
                                        currentActor.addTrait(matcher.group(1), matcher.group(2));
                                        continue;
                                    }
                                    currentActor.setTrait(matcher.group(1), matcher.group(2));
                                    continue;
                                }
                                System.err.println("ActorGroupFile: start/end tags do not match! " + line);
                                continue;
                            }
                            matcher = startTrait.matcher(line);
                            if (matcher.matches()) {
                                traitName = matcher.group(1);
                                traitValue = new StringBuilder(String.valueOf(matcher.group(2)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endTrait.matcher(line);
                                    if (matcher.matches()) {
                                        traitValue.append(matcher.group(1));
                                        if (!traitName.equals(matcher.group(2))) {
                                            System.err.println("ActorGroupFile: multiline start/end tags do not match! Start: " + traitName + ", End: " + matcher.group(2));
                                        }
                                        if (!currentActor.hasTrait(traitName)) {
                                            currentActor.addTrait(traitName, traitValue.toString());
                                            continue block3;
                                        }
                                        currentActor.setTrait(traitName, traitValue.toString());
                                        continue block3;
                                    }
                                    traitValue.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            System.out.println("ActorGroupFile: -W- Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block19;
                    System.out.println("ActorGroupFile: -W- Cannot parse line: " + line);
lbl94:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl95:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema4(BufferedReader input, DefaultTreeModel treeModel) {
        block15: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" parry=\"([^\"]+)\" block=\"([^\"]+)\" dodge=\"([^\"]+)\" dr=\"([^\"]+)\" db=\"([^\"]+)\" shield_dr=\"([^\"]+)\" shield_hp=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl78
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseState(matcher.group(16)), Actor.ActorType.valueOf(matcher.group(17)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10)), Integer.parseInt(matcher.group(11)), Integer.parseInt(matcher.group(12)), Integer.parseInt(matcher.group(13)), Integer.parseInt(matcher.group(14)), Integer.parseInt(matcher.group(15)));
                        aName = currentActor.getTraitValue(Actor.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                continue;
                            }
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(Actor.BasicTrait.Notes, matcher.group(1));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(Actor.BasicTrait.Notes, actorNotes.toString());
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            System.out.println("ActorGroupFile: -W- Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block15;
                    System.out.println("ActorGroupFile: -W- Cannot parse line: " + line);
lbl78:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl79:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema3(BufferedReader input, DefaultTreeModel treeModel) {
        block15: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" parry=\"([^\"]+)\" block=\"([^\"]+)\" dodge=\"([^\"]+)\" dr=\"([^\"]+)\" db=\"([^\"]+)\" shield_dr=\"([^\"]+)\" shield_hp=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl78
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(16)), Actor.ActorType.valueOf(matcher.group(17)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10)), Integer.parseInt(matcher.group(11)), Integer.parseInt(matcher.group(12)), Integer.parseInt(matcher.group(13)), Integer.parseInt(matcher.group(14)), Integer.parseInt(matcher.group(15)));
                        aName = currentActor.getTraitValue(Actor.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                continue;
                            }
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(Actor.BasicTrait.Notes, matcher.group(1));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(Actor.BasicTrait.Notes, actorNotes.toString());
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            System.out.println("ActorGroupFile: -W- Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block15;
                    System.out.println("ActorGroupFile: -W- Cannot parse line: " + line);
lbl78:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl79:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema2(BufferedReader input, DefaultTreeModel treeModel) {
        block13: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" dodge=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl70
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(9)), Actor.ActorType.valueOf(matcher.group(10)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), 9, 9, Integer.parseInt(matcher.group(8)), 0, 0, 4, 20, 0);
                        aName = currentActor.getTraitValue(Actor.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(Actor.BasicTrait.Notes, matcher.group(1));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (!matcher.matches()) continue;
                            actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                            while ((line = input.readLine()) != null) {
                                matcher = endNotes.matcher(line);
                                if (matcher.matches()) {
                                    actorNotes.append(matcher.group(1));
                                    currentActor.setTrait(Actor.BasicTrait.Notes, actorNotes.toString());
                                    continue block3;
                                }
                                actorNotes.append(String.valueOf(line) + "\n");
                            }
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block13;
lbl70:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl71:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema1(BufferedReader input, DefaultTreeModel treeModel) {
        block13: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl70
                System.err.println("Error: second line does not specify start of base folder!");
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(5)), Actor.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 9, 9, 8, 0, 0, 4, 20, 0);
                        aName = currentActor.getTraitValue(Actor.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(Actor.BasicTrait.Notes, matcher.group(1));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (!matcher.matches()) continue;
                            actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                            while ((line = input.readLine()) != null) {
                                matcher = endNotes.matcher(line);
                                if (matcher.matches()) {
                                    actorNotes.append(matcher.group(1));
                                    currentActor.setTrait(Actor.BasicTrait.Notes, actorNotes.toString());
                                    continue block3;
                                }
                                actorNotes.append(String.valueOf(line) + "\n");
                            }
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) break block13;
lbl70:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl71:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readSchema0(BufferedReader input, DefaultTreeModel treeModel) {
        GroupTreeNode currentNode = (GroupTreeNode)treeModel.getRoot();
        try {
            Pattern endFile = Pattern.compile("^</GURPSActorGroupList>$");
            Pattern startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
            Pattern endFolder = Pattern.compile("^</GroupFolder>$");
            Pattern startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
            Pattern endGroup = Pattern.compile("^</ActorGroup>$");
            Pattern actor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\"></Actor>$");
            String line = input.readLine();
            Matcher matcher = startFolder.matcher(line);
            if (!matcher.matches()) {
                System.err.println("Error: second line does not specify start of base folder!");
                return;
            }
            while (true) {
                GroupTreeNode newNode;
                String name;
                if ((line = input.readLine()) == null) {
                    return;
                }
                matcher = startFolder.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, true);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = startGroup.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, false);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = actor.matcher(line);
                if (matcher.matches()) {
                    Actor currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(5)), Actor.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 9, 9, 8, 0, 0, 4, 20, 0);
                    ArrayList<Actor> actorList = currentNode.getActorList();
                    actorList.add(actorList.size() - 1, currentActor);
                    continue;
                }
                matcher = endFolder.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endGroup.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endFile.matcher(line);
                if (matcher.matches()) break;
            }
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static Actor createLegacyActor(String name, HashSet<Actor.ActorStatus> status, Actor.ActorType type, int ht, int hp, int damage, int fp, int fatigue, int move, int parry, int block, int dodge, int dr, int db, int shield_dr, int shield_hp, int default_attack) {
        Actor a = new Actor(name, type);
        a.setAllStatuses(status);
        a.setDefaultAttack(default_attack);
        a.setTrait(Actor.BasicTrait.HT, ht);
        a.setTrait(Actor.BasicTrait.HP, hp);
        a.setTrait(Actor.BasicTrait.Injury, damage);
        a.setTrait(Actor.BasicTrait.FP, fp);
        a.setTrait(Actor.BasicTrait.Fatigue, fatigue);
        a.setTrait(Actor.BasicTrait.Move, move);
        a.setTrait(Actor.BasicTrait.Parry, parry);
        a.setTrait(Actor.BasicTrait.Block, block);
        a.setTrait(Actor.BasicTrait.Dodge, dodge);
        a.setTrait(Actor.BasicTrait.DR, dr);
        a.setTrait(Actor.BasicTrait.Shield_DB, db);
        a.setTrait(Actor.BasicTrait.Shield_DR, shield_dr);
        a.setTrait(Actor.BasicTrait.Shield_HP, shield_hp);
        return a;
    }
}

