/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Actor;
import gurpsinittool.data.Damage;
import gurpsinittool.data.HitLocations;
import gurpsinittool.util.DieRoller;

public class Defense {
    public DefenseType type;
    public boolean ee = false;
    public boolean retreat = false;
    public boolean side = false;
    public boolean stunned = false;
    public boolean shield = false;
    public String position = "";
    public int otherMod = 0;
    public int roll;
    public int override_dr;
    public Damage damage;
    public HitLocations.HitLocation location;
    public int effectiveDefense;
    public DefenseResult result;
    public int fatigue;
    public int injury;
    public int shieldDamage;
    public boolean majorWound;
    public boolean cripplingInjury;

    public void setInitialOptions(Actor actor) {
        int effParry = actor.getCurrentDefenseValue(DefenseType.Parry);
        int effBlock = actor.getCurrentDefenseValue(DefenseType.Block);
        int effDodge = actor.getCurrentDefenseValue(DefenseType.Dodge);
        int ShieldDB = actor.getTraitValueInt(Actor.BasicTrait.Shield_DB);
        int ShieldHP = actor.getTraitValueInt(Actor.BasicTrait.Shield_HP);
        this.type = effParry > effDodge && effParry >= effBlock ? DefenseType.Parry : (effBlock > effDodge && effBlock > effParry ? DefenseType.Block : DefenseType.Dodge);
        boolean bl = this.shield = ShieldDB > 0 && actor.getTempInt("shieldDamage") < ShieldHP;
        if (actor.isStunned()) {
            this.stunned = true;
        }
        if (actor.hasStatus(Actor.ActorStatus.Kneeling)) {
            this.position = "Kneeling";
        }
        if (actor.hasStatus(Actor.ActorStatus.Prone)) {
            this.position = "Prone";
        }
    }

    public void calcDefenseResults(Actor actor) {
        this.calcEffectiveDefense(actor);
        this.calcDefenseResult(actor);
        this.calcInjury(actor);
    }

    private void calcEffectiveDefense(Actor actor) {
        this.effectiveDefense = actor.getCurrentDefenseValue(this.type);
        if (this.type != DefenseType.None) {
            if (this.ee) {
                this.effectiveDefense += 2;
                this.fatigue = 1;
            }
            if (this.retreat) {
                this.effectiveDefense += this.type == DefenseType.Dodge ? 3 : 1;
            }
            if (this.side) {
                this.effectiveDefense -= 2;
            }
            if (this.stunned) {
                this.effectiveDefense -= 4;
            }
            if (this.shield) {
                this.effectiveDefense += actor.getTraitValueInt(Actor.BasicTrait.Shield_DB);
            }
            if (this.position.equals("Kneeling")) {
                this.effectiveDefense -= 2;
            }
            if (this.position.equals("Prone")) {
                this.effectiveDefense -= 3;
            }
            this.effectiveDefense += this.otherMod;
        }
    }

    private void calcDefenseResult(Actor actor) {
        int shield_db;
        int n = shield_db = this.shield ? actor.getTraitValueInt(Actor.BasicTrait.Shield_DB) : 0;
        this.result = this.type == DefenseType.None ? DefenseResult.Failure : (DieRoller.isCritSuccess(this.roll, this.effectiveDefense) ? DefenseResult.CritSuccess : (DieRoller.isFailure(this.roll, this.effectiveDefense) ? DefenseResult.Failure : (DieRoller.isFailure(this.roll, this.effectiveDefense - shield_db) ? DefenseResult.ShieldHit : DefenseResult.Success)));
    }

    private void calcInjury(Actor actor) {
        int coverDR = 0;
        this.injury = 0;
        this.shieldDamage = 0;
        this.majorWound = false;
        this.cripplingInjury = false;
        int ShieldDR = actor.getTraitValueInt(Actor.BasicTrait.Shield_DR);
        int ShieldHP = actor.getTraitValueInt(Actor.BasicTrait.Shield_HP);
        int HP = actor.getTraitValueInt(Actor.BasicTrait.HP);
        switch (this.result) {
            case CritSuccess: 
            case Success: {
                return;
            }
            case ShieldHit: {
                int shieldBasicDamage = (int)((double)this.damage.BasicDamage - Math.floor((double)ShieldDR / this.damage.ArmorDivisor));
                shieldBasicDamage = Math.min((int)Math.ceil(ShieldHP / 4), shieldBasicDamage);
                shieldBasicDamage = Math.max(0, shieldBasicDamage);
                this.shieldDamage = (int)Math.floor((double)shieldBasicDamage * this.damage.DamageMultiplierHomogenous());
                this.shieldDamage = this.shieldDamage <= 0 && shieldBasicDamage > 0 ? 1 : this.shieldDamage;
                coverDR = (int)(Math.floor((double)ShieldDR / this.damage.ArmorDivisor) + Math.ceil(ShieldHP / 4));
            }
            case Failure: {
                int totalDR = this.override_dr + this.location.extraDR;
                int basicDamage = (int)((double)(this.damage.BasicDamage - coverDR) - Math.floor((double)totalDR / this.damage.ArmorDivisor));
                basicDamage = Math.max(0, basicDamage);
                double damageMultiplier = this.location.DamageMultiplier(this.damage.Type);
                this.injury = (int)((double)basicDamage * damageMultiplier);
                int n = this.injury = this.injury <= 0 && basicDamage > 0 ? 1 : this.injury;
                if (this.location.cripplingThreshold != 0.0) {
                    int cripplingThreshold = (int)Math.floor((double)HP * this.location.cripplingThreshold + 1.00001);
                    if (this.injury < cripplingThreshold) break;
                    this.injury = cripplingThreshold;
                    this.cripplingInjury = true;
                    this.majorWound = true;
                    break;
                }
                int majorWoundThreshold = (int)Math.floor((double)(HP * 1 / 2) + 1.00001);
                if (this.injury < majorWoundThreshold) break;
                this.majorWound = true;
            }
        }
    }

    public static enum DefenseResult {
        CritSuccess,
        Success,
        ShieldHit,
        Failure;

    }

    public static enum DefenseType {
        Parry,
        Block,
        Dodge,
        None;

    }
}

