/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.app.GITApp;
import gurpsinittool.data.GameSettings;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class OptionsWindow
extends JFrame {
    public GameSettings currentSettings = new GameSettings();
    private Properties propertyBag;
    private JButton applyButton;
    private JCheckBox auto_attack;
    private JCheckBox auto_knockdown;
    private JCheckBox auto_shock;
    private JCheckBox auto_stunrecovery;
    private JCheckBox auto_unconsciousness;
    private JButton cancelButton;
    private JPanel combatAutomationPanel;
    private JPanel jPanel1;
    private GameSettings localSettings;
    private JCheckBox log_statuschanges;
    private JButton okButton;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GITApp.validateOnScreen(this);
            if (!this.isVisible()) {
                this.copySettingsToComponents();
            } else if (this.getState() == 1) {
                this.setState(0);
            }
        }
        super.setVisible(visible);
    }

    public OptionsWindow(Properties propertyBag) {
        this.propertyBag = propertyBag;
        this.initComponents();
        this.setDefaultProperties();
        this.setLocation(Integer.valueOf(propertyBag.getProperty("Options.location.x")), Integer.valueOf(propertyBag.getProperty("Options.location.y")));
        this.setSize(Integer.valueOf(propertyBag.getProperty("Options.size.width")), Integer.valueOf(propertyBag.getProperty("Options.size.height")));
        if (propertyBag.containsKey("Options.game.AUTO_ATTACK")) {
            this.currentSettings.AUTO_ATTACK = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_ATTACK"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_KNOCKDOWNSTUN")) {
            this.currentSettings.AUTO_KNOCKDOWNSTUN = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_KNOCKDOWNSTUN"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_STUNRECOVERY")) {
            this.currentSettings.AUTO_STUNRECOVERY = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_STUNRECOVERY"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_UNCONSCIOUS")) {
            this.currentSettings.AUTO_UNCONSCIOUS = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_UNCONSCIOUS"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_SHOCK")) {
            this.currentSettings.AUTO_SHOCK = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_SHOCK"));
        }
        if (propertyBag.containsKey("Options.game.LOG_STATUSCHANGES")) {
            this.currentSettings.LOG_STATUSCHANGES = Boolean.valueOf(propertyBag.getProperty("Options.game.LOG_STATUSCHANGES"));
        }
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("Options.location.x")) {
            this.propertyBag.setProperty("Options.location.x", "500");
        }
        if (!this.propertyBag.containsKey("Options.location.y")) {
            this.propertyBag.setProperty("Options.location.y", "300");
        }
        if (!this.propertyBag.containsKey("Options.size.width")) {
            this.propertyBag.setProperty("Options.size.width", String.valueOf(this.getPreferredSize().width));
        }
        if (!this.propertyBag.containsKey("Options.size.height")) {
            this.propertyBag.setProperty("Options.size.height", String.valueOf(this.getPreferredSize().height));
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("Options.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("Options.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("Options.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("Options.size.height", String.valueOf(this.getSize().height));
        this.propertyBag.setProperty("Options.game.AUTO_ATTACK", String.valueOf(this.currentSettings.AUTO_ATTACK));
        this.propertyBag.setProperty("Options.game.AUTO_KNOCKDOWNSTUN", String.valueOf(this.currentSettings.AUTO_KNOCKDOWNSTUN));
        this.propertyBag.setProperty("Options.game.AUTO_STUNRECOVERY", String.valueOf(this.currentSettings.AUTO_STUNRECOVERY));
        this.propertyBag.setProperty("Options.game.AUTO_UNCONSCIOUS", String.valueOf(this.currentSettings.AUTO_UNCONSCIOUS));
        this.propertyBag.setProperty("Options.game.AUTO_SHOCK", String.valueOf(this.currentSettings.AUTO_SHOCK));
        this.propertyBag.setProperty("Options.game.LOG_STATUSCHANGES", String.valueOf(this.currentSettings.LOG_STATUSCHANGES));
    }

    private void initComponents() {
        this.localSettings = new GameSettings();
        this.combatAutomationPanel = new JPanel();
        this.auto_attack = new JCheckBox();
        this.auto_unconsciousness = new JCheckBox();
        this.auto_knockdown = new JCheckBox();
        this.auto_stunrecovery = new JCheckBox();
        this.auto_shock = new JCheckBox();
        this.okButton = new JButton();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.log_statuschanges = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("InitTool Settings");
        this.combatAutomationPanel.setBorder(BorderFactory.createTitledBorder("Enemy Automation"));
        this.auto_attack.setText("Attack");
        this.auto_attack.setToolTipText("Enemy creatures with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.auto_unconsciousness.setText("Unconsciousness Checks");
        this.auto_unconsciousness.setToolTipText("Enemy creatures check for unconsciousness at the start of each of their turns.");
        this.auto_knockdown.setText("Knockdown and Stunning");
        this.auto_knockdown.setToolTipText("Enemy Creatures check for knockdown and stunning when taking sufficient damage.");
        this.auto_stunrecovery.setText("Stun Recovery");
        this.auto_stunrecovery.setToolTipText("Stunned Enemy Creatures check for stun recovery at the start of their turns.");
        this.auto_shock.setText("Shock");
        this.auto_shock.setToolTipText("Track and apply shock to Enemy attack rolls");
        this.auto_shock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.auto_shockActionPerformed(evt);
            }
        });
        GroupLayout combatAutomationPanelLayout = new GroupLayout(this.combatAutomationPanel);
        this.combatAutomationPanel.setLayout(combatAutomationPanelLayout);
        combatAutomationPanelLayout.setHorizontalGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combatAutomationPanelLayout.createSequentialGroup().addGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.auto_attack).addComponent(this.auto_unconsciousness).addComponent(this.auto_knockdown).addComponent(this.auto_stunrecovery).addComponent(this.auto_shock)).addGap(0, 0, Short.MAX_VALUE)));
        combatAutomationPanelLayout.setVerticalGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combatAutomationPanelLayout.createSequentialGroup().addComponent(this.auto_attack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.auto_unconsciousness).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.auto_knockdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, Short.MAX_VALUE).addComponent(this.auto_stunrecovery).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.auto_shock).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.okButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Logging"));
        this.log_statuschanges.setText("Status Changes");
        this.log_statuschanges.setToolTipText("Log all status changes in the encounter log");
        this.log_statuschanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.log_statuschangesActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.log_statuschanges).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.log_statuschanges));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combatAutomationPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 89, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.combatAutomationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.applyButton).addComponent(this.okButton))));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        System.out.println("DefenseDialog: OK!");
        this.copyComponentsToSettings();
        this.setVisible(false);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        System.out.println("OptionsWindow: Apply!");
        this.copyComponentsToSettings();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void auto_shockActionPerformed(ActionEvent evt) {
    }

    private void log_statuschangesActionPerformed(ActionEvent evt) {
    }

    private void copySettingsToComponents() {
        this.auto_attack.setSelected(this.currentSettings.AUTO_ATTACK);
        this.auto_knockdown.setSelected(this.currentSettings.AUTO_KNOCKDOWNSTUN);
        this.auto_stunrecovery.setSelected(this.currentSettings.AUTO_STUNRECOVERY);
        this.auto_unconsciousness.setSelected(this.currentSettings.AUTO_UNCONSCIOUS);
        this.auto_shock.setSelected(this.currentSettings.AUTO_SHOCK);
        this.log_statuschanges.setSelected(this.currentSettings.LOG_STATUSCHANGES);
    }

    public void copyComponentsToSettings() {
        this.currentSettings.AUTO_ATTACK = this.auto_attack.isSelected();
        this.currentSettings.AUTO_KNOCKDOWNSTUN = this.auto_knockdown.isSelected();
        this.currentSettings.AUTO_STUNRECOVERY = this.auto_stunrecovery.isSelected();
        this.currentSettings.AUTO_UNCONSCIOUS = this.auto_unconsciousness.isSelected();
        this.currentSettings.AUTO_SHOCK = this.auto_shock.isSelected();
        this.currentSettings.LOG_STATUSCHANGES = this.log_statuschanges.isSelected();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OptionsWindow(new Properties()).setVisible(true);
            }
        });
    }
}

