/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupManager;
import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.ui.ActorDetailsPanel_v2;
import gurpsinittool.ui.CriticalTablesDialog;
import gurpsinittool.ui.OptionsWindow;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class GITApp
extends JFrame
implements ActionListener,
EncounterLogEventListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    public static final String version = "1.2.0";
    private static final boolean DEBUG = false;
    private InitTable initTable;
    private JTextPane logTextArea;
    private HTMLDocument logTextDocument;
    private HTMLEditorKit kit;
    private ActorDetailsPanel_v2 detailsPanel;
    private GroupManager groupManager;
    private OptionsWindow optionsWindow;
    private CriticalTablesDialog criticalTables;
    private Properties propertyBag = new Properties();
    private JLabel roundCounter;
    private JSplitPane jSplitPaneVertical;
    private JSplitPane jSplitPaneHorizontal;
    private Integer round = 0;

    private static void createAndShowGUI() {
        GITApp mainApp = new GITApp("GURPS Initiative Tool");
        mainApp.setDefaultCloseOperation(0);
        mainApp.loadProperties();
        mainApp.addComponentsToPane();
        if (Boolean.valueOf(mainApp.propertyBag.getProperty("GITApp.Manager.visible")).booleanValue()) {
            mainApp.groupManager.setVisible(true);
        }
        mainApp.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITApp.createAndShowGUI();
            }
        });
    }

    public GITApp(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("resetRound".equals(e.getActionCommand())) {
            this.round = 0;
            this.refreshRoundText();
            this.initTable.resetEncounter();
            this.nextActor();
        } else if ("openGroupManager".equals(e.getActionCommand())) {
            GITApp.validateOnScreen(this.groupManager);
            this.groupManager.setVisible(true);
        } else if ("openCriticalTables".equals(e.getActionCommand())) {
            GITApp.validateOnScreen(this.criticalTables);
            this.criticalTables.setVisible(true);
        } else if ("sizeColumns".equals(e.getActionCommand())) {
            this.initTable.autoSizeColumns();
        } else if ("actorsStand".equals(e.getActionCommand())) {
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
        } else if ("actorsKneel".equals(e.getActionCommand())) {
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, true);
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
        } else if ("actorsProne".equals(e.getActionCommand())) {
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
            this.initTable.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, true);
        } else if ("actorsStunPhysToggle".equals(e.getActionCommand())) {
            this.initTable.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunPhys);
        } else if ("actorsStunMentalToggle".equals(e.getActionCommand())) {
            this.initTable.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunMental);
        } else if ("actorsDisarmToggle".equals(e.getActionCommand())) {
            this.initTable.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Disarmed);
        } else if ("actorsUnconsciousToggle".equals(e.getActionCommand())) {
            this.initTable.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Unconscious);
        } else if ("actorsDeadToggle".equals(e.getActionCommand())) {
            this.initTable.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Dead);
        } else if ("Options".equals(e.getActionCommand())) {
            this.optionsWindow.setVisible(true);
        } else if ("About".equals(e.getActionCommand())) {
            this.showAboutDialog();
        } else {
            System.out.println("GITApp: -W- Unknown action performed: " + e.getActionCommand());
        }
    }

    @Override
    public void encounterLogMessageSent(EncounterLogEvent evt) {
        this.addLogLine(evt.logMsg);
    }

    public void addLogLine(String line) {
        this.addLogLine(line, true);
    }

    public void addLogLine(String line, boolean addRound) {
        if (this.round <= 0) {
            return;
        }
        try {
            String round = addRound ? "Round " + this.roundCounter.getText() + ": " : "";
            this.kit.insertHTML(this.logTextDocument, this.logTextDocument.getLength(), String.valueOf(round) + line, 0, 0, null);
        }
        catch (BadLocationException e) {
            System.out.println("-E- addLogLine: BadLocationException trying to add line: " + line);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("-E- addLogLine: IOException trying to add line: " + line);
            e.printStackTrace();
        }
        this.logTextArea.select(this.logTextDocument.getLength(), this.logTextDocument.getLength());
    }

    public boolean nextActor() {
        if (this.initTable.getActorTableModel().getActiveActorIndex() == -1) {
            this.round = this.round + 1;
            this.refreshRoundText();
            this.addLogLine("<b>** Round " + this.roundCounter.getText() + " **</b>", false);
        }
        return this.initTable.nextActor();
    }

    public void nextRound() {
        if (this.initTable.getActiveActor() != null) {
            this.endRound();
        }
        this.nextActor();
    }

    public void endRound() {
        while (!this.nextActor()) {
        }
    }

    private void refreshRoundText() {
        this.roundCounter.setText(this.round.toString());
        int minimumWidth = this.roundCounter.getMinimumSize().width / 10 * 10;
        if (this.roundCounter.getMinimumSize().width + 1 != 0) {
            minimumWidth += 10;
        }
        this.roundCounter.setPreferredSize(new Dimension(minimumWidth, 20));
    }

    private void addComponentsToPane() {
        this.optionsWindow = new OptionsWindow(this.propertyBag);
        this.optionsWindow.setDefaultCloseOperation(1);
        Actor.settings = this.optionsWindow.currentSettings;
        this.groupManager = new GroupManager(this.propertyBag);
        this.criticalTables = new CriticalTablesDialog((Frame)this, false);
        this.setDefaultProperties();
        this.criticalTables.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.location.y")));
        this.criticalTables.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.size.height")));
        JMenuBar menubar = new JMenuBar();
        JMenu menuFile = new JMenu("Edit");
        menuFile.setMnemonic(69);
        JMenuItem menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cut.png"), "Cut"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/page_copy.png"), "Copy"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/paste_plain.png"), "Paste"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem("Options", 79);
        menuItem.setText("Options");
        menuItem.setMnemonic(79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.addActionListener(this);
        menuFile.add(menuItem);
        menubar.add(menuFile);
        menubar.add(Box.createHorizontalGlue());
        JButton menuButton = new JButton("About");
        menuButton.setOpaque(true);
        menuButton.setContentAreaFilled(false);
        menuButton.setBorderPainted(false);
        menuButton.setFocusable(false);
        menuButton.addActionListener(this);
        menubar.add(menuButton);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar("Encounter Control Toolbar");
        JButton button = new JButton();
        URL imageURL = GITApp.class.getResource("/resources/images/control_play_blue.png");
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, "Next Actor"));
        }
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Step to next actor (Alt+N)");
        AbstractAction action = new AbstractAction("nextActor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.nextActor();
            }
        };
        button.setMnemonic(78);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_end_blue.png"), "End Round"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Step to the end of this round (Ctrl+E)");
        action = new AbstractAction("endRound"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.endRound();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control E"), "endRound");
        button.getActionMap().put("endRound", action);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_fastforward_blue.png"), "Next Round"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Step to the next round (Ctrl+N)");
        action = new AbstractAction("nextRound"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.nextRound();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control N"), "nextRound");
        button.getActionMap().put("nextRound", action);
        button.addActionListener(action);
        toolbar.add(button);
        JLabel label = new JLabel("Round:");
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        toolbar.add(label);
        label = new JLabel("0");
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        label.setPreferredSize(new Dimension(20, 20));
        this.roundCounter = label;
        toolbar.add(label);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/control_start_blue.png"), "Reset Encounter"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Reset the round counter (Alt+R)");
        button.setActionCommand("resetRound");
        button.setMnemonic(82);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/script_code.png"), "Auto-size columns"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Auto re-size the table columns to best fit (Alt+A)");
        button.setActionCommand("sizeColumns");
        button.setMnemonic(65);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/wrench_orange.png"), "Attack"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Selected actors attack (Ctrl+A)");
        action = new AbstractAction("selectedActorsAttack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.initTable.selectedActorsAttack();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control A"), "actorsAttack");
        button.getInputMap(0).put(KeyStroke.getKeyStroke("control A"), "actorsAttack");
        button.getActionMap().put("actorsAttack", action);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/shield.png"), "Defend"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Selected actor defends (Ctrl+D)");
        action = new AbstractAction("selectedActorDefend"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.initTable.selectedActorDefend();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control D"), "actorDefend");
        button.getActionMap().put("actorDefend", action);
        button.addActionListener(action);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/tag_blue_add.png"), "Tag"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Add enemy tags (Ctrl+T)");
        action = new AbstractAction("tagActors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.initTable.getActorTableModel().autoTagActors();
                GITApp.this.initTable.autoSizeColumns();
            }
        };
        button.getInputMap(2).put(KeyStroke.getKeyStroke("control T"), "tagActors");
        button.getActionMap().put("tagActors", action);
        button.addActionListener(action);
        toolbar.add(button);
        toolbar.addSeparator();
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/arrow_up.png"), "Standing"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Standing");
        button.setActionCommand("actorsStand");
        button.addActionListener(this);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/arrow_down_right.png"), "Kneeling"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Kneeling");
        button.setActionCommand("actorsKneel");
        button.addActionListener(this);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/arrow_down.png"), "Prone"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Prone");
        button.setActionCommand("actorsProne");
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/transmit.png"), "Physical Stun"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Physically Stunned");
        button.setActionCommand("actorsStunPhysToggle");
        button.addActionListener(this);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/transmit_blue.png"), "Mental Stun"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Mentally Stunned");
        button.setActionCommand("actorsStunMentalToggle");
        button.addActionListener(this);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/plus_blue.png"), "Disarmed"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Disarmed");
        button.setActionCommand("actorsDisarmToggle");
        button.addActionListener(this);
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cross_yellow.png"), "Unconscious"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setActionCommand("actorsUnconsciousToggle");
        button.addActionListener(this);
        button.setToolTipText("Unconscious");
        toolbar.add(button);
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cross.png"), "Dead"));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setToolTipText("Dead");
        button.setActionCommand("actorsDeadToggle");
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/table_error.png"), "Critical Tables"));
        button.setToolTipText("Open Critical Tables (Alt+C)");
        button.setActionCommand("openCriticalTables");
        button.setMnemonic(67);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.addSeparator();
        button = new JButton();
        button.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/group.png"), "Group Manager"));
        button.setToolTipText("Manage Actor Groups (Alt+G)");
        button.setActionCommand("openGroupManager");
        button.setMnemonic(71);
        button.addActionListener(this);
        toolbar.add(button);
        toolbar.setRollover(true);
        this.getContentPane().add((Component)toolbar, "First");
        this.logTextArea = new JTextPane();
        this.logTextDocument = new HTMLDocument();
        this.kit = new HTMLEditorKit();
        this.logTextArea.setEditorKit(this.kit);
        this.logTextArea.setDocument(this.logTextDocument);
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Tahoma", 0, 11));
        this.initTable = new InitTable(this.propertyBag, true);
        this.initTable.getSelectionModel().addListSelectionListener(this);
        this.initTable.getActorTableModel().addEncounterLogEventListener(this);
        this.initTable.getActorTableModel().addTableModelListener(this);
        this.initTable.getInputMap(1).put(KeyStroke.getKeyStroke("control A"), "actorsAttack");
        action = new AbstractAction("selectedActorsAttack"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITApp.this.initTable.selectedActorsAttack();
            }
        };
        this.initTable.getActionMap().put("actorsAttack", action);
        JScrollPane tableScrollPane = new JScrollPane(this.initTable);
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        this.detailsPanel = new ActorDetailsPanel_v2();
        JScrollPane actorDetailsPane = new JScrollPane(this.detailsPanel);
        actorDetailsPane.setMinimumSize(new Dimension(this.detailsPanel.getPreferredSize().width + 20, 0));
        this.jSplitPaneVertical = new JSplitPane(0, tableScrollPane, logScrollPane);
        this.jSplitPaneVertical.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitVertical.dividerLocation")));
        this.jSplitPaneVertical.setResizeWeight(0.8);
        this.jSplitPaneHorizontal = new JSplitPane(1, this.jSplitPaneVertical, actorDetailsPane);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.getContentPane().add((Component)this.jSplitPaneHorizontal, "Center");
        this.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.location.y")));
        this.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.size.height")));
        GITApp.validateOnScreen(this);
        this.addWindowListener(new GITAppWindowListener());
    }

    private void loadProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            FileInputStream propIn = new FileInputStream(propertyFile);
            this.propertyBag.load(propIn);
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: loadProperties: File not found: " + e.toString());
        }
        catch (IOException e) {
            System.out.println("GITApp: loadProperties: Error reading file! " + e.toString());
            e.printStackTrace();
        }
    }

    private boolean saveProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            FileOutputStream propOut = new FileOutputStream(propertyFile);
            this.propertyBag.store(propOut, "GITApp Properties");
        }
        catch (FileNotFoundException e) {
            System.out.println("GITApp: saveProperties: File not found? " + e.toString());
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("GITApp: saveProperties: Error writing to file! " + e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("GITApp.Manager.visible")) {
            this.propertyBag.setProperty("GITApp.Manager.visible", "false");
        }
        if (!this.propertyBag.containsKey("GITApp.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", "460");
        }
        if (!this.propertyBag.containsKey("GITApp.splitVertical.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.location.x")) {
            this.propertyBag.setProperty("GITApp.location.x", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.location.y")) {
            this.propertyBag.setProperty("GITApp.location.y", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.size.width")) {
            this.propertyBag.setProperty("GITApp.size.width", "760");
        }
        if (!this.propertyBag.containsKey("GITApp.size.height")) {
            this.propertyBag.setProperty("GITApp.size.height", "480");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.x")) {
            this.propertyBag.setProperty("GITApp.defense.location.x", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.y")) {
            this.propertyBag.setProperty("GITApp.defense.location.y", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.location.x")) {
            this.propertyBag.setProperty("GITApp.crittables.location.x", "175");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.location.y")) {
            this.propertyBag.setProperty("GITApp.crittables.location.y", "175");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.size.width")) {
            this.propertyBag.setProperty("GITApp.crittables.size.width", String.valueOf(this.criticalTables.getPreferredSize().width));
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.size.height")) {
            this.propertyBag.setProperty("GITApp.crittables.size.height", String.valueOf(this.criticalTables.getPreferredSize().height));
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("GITApp.Manager.visible", String.valueOf(this.groupManager.isVisible()));
        this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", String.valueOf(this.jSplitPaneVertical.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("GITApp.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("GITApp.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("GITApp.size.height", String.valueOf(this.getSize().height));
        this.propertyBag.setProperty("GITApp.crittables.location.x", String.valueOf(this.criticalTables.getLocation().x));
        this.propertyBag.setProperty("GITApp.crittables.location.y", String.valueOf(this.criticalTables.getLocation().y));
        this.propertyBag.setProperty("GITApp.crittables.size.width", String.valueOf(this.criticalTables.getSize().width));
        this.propertyBag.setProperty("GITApp.crittables.size.height", String.valueOf(this.criticalTables.getSize().height));
    }

    public static void validateOnScreen(Component c) {
        Rectangle window = c.getBounds();
        Rectangle virtualscreen = new Rectangle();
        GraphicsDevice[] gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int j = 0;
        while (j < gs.length) {
            GraphicsConfiguration[] gc = gs[j].getConfigurations();
            int i = 0;
            while (i < gc.length) {
                virtualscreen = virtualscreen.union(gc[i].getBounds());
                ++i;
            }
            ++j;
        }
        if (!virtualscreen.contains(window)) {
            if (window.x < virtualscreen.x) {
                window.translate(virtualscreen.x - window.x, 0);
            }
            if (window.y < virtualscreen.y) {
                window.translate(0, virtualscreen.y - window.y);
            }
            if (window.height > virtualscreen.height) {
                window.height = virtualscreen.height;
            }
            if (window.width > virtualscreen.width) {
                window.width = virtualscreen.width;
            }
            if (window.x + window.width > virtualscreen.x + virtualscreen.width) {
                window.translate(virtualscreen.x + virtualscreen.width - (window.x + window.width), 0);
            }
            if (window.y + window.height > virtualscreen.y + virtualscreen.height) {
                window.translate(0, virtualscreen.y + virtualscreen.height - (window.y + window.height));
            }
        }
        c.setLocation(window.x, window.y);
    }

    private void showAboutDialog() {
        String famfamcredit = "<a href=\"http://www.famfamfam.com/lab/icons/silk/\">Silk</a> icons by <a href=\"http://www.famfamfam.com/\">Mark James</a> licensed under <a href=\"http://creativecommons.org/licenses/by/2.5/\">CC BY 2.5</a> / used with minor changes.";
        String policy = "GURPS is a trademark of Steve Jackson Games, and its rules and art are copyrighted by Steve Jackson Games. All rights are reserved by Steve Jackson Games. This game aid is the original creation of Damian Small and is released for free distribution, and not for resale, under the permissions granted in the <a href=\"http://www.sjgames.com/general/online_policy.html\">Steve Jackson Games Online Policy</a>.";
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\"><b>GURPS Initiative Tool</b><br>Version: " + version + "<br><p style='width: 300px;'>" + policy + "</p><p style='width: 300px;'>" + famfamcredit + "</p><br></body></html>");
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        ep.setEditable(false);
        ep.setBackground(new JLabel().getBackground());
        JOptionPane.showMessageDialog(this, ep, "About GURPS Initiative Tool", 1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.detailsPanel.setActor(this.initTable.getSelectedActor());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.detailsPanel.setActor(this.initTable.getSelectedActor());
        }
    }

    class GITAppWindowListener
    implements WindowListener {
        GITAppWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            GITApp.this.updateProperties();
            GITApp.this.groupManager.updateProperties();
            GITApp.this.optionsWindow.updateProperties();
            if (GITApp.this.groupManager.querySaveChanges() && GITApp.this.saveProperties()) {
                System.exit(0);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }
}

