/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.EncounterLogEventListener;
import gurpsinittool.util.EncounterLogEventSource;
import gurpsinittool.util.FileChangeEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class InitTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String[] columnNames = new String[]{"Act", "Name", "Speed", "Move", "HT", "HP", "Damage", "FP", "Fatigue", "Status"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class, Float.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class};
    private static int numColumns = 10;
    Actor newActor = new Actor();
    private ArrayList<Actor> actorList = new ArrayList();
    private int activeActor = -1;
    public static Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
    public static int flagMaxNum = 6;
    protected EncounterLogEventSource encounterLogEventSource = new EncounterLogEventSource();
    protected CleanFileChangeEventSource cleanFileChangeEventSource = new CleanFileChangeEventSource(this);

    public InitTableModel() {
        this.addNewActor();
        Actor.LogEventSource = this.encounterLogEventSource;
    }

    public void addActor(Actor actor, int destRow) {
        System.out.println("table model.addActor: start: " + actor.getTraitValue(ActorBase.BasicTrait.Name));
        actor.addPropertyChangeListener(this);
        if (destRow > this.actorList.size() - 1) {
            destRow = this.actorList.size() - 1;
        } else if (destRow < 0) {
            destRow = 0;
        }
        if (destRow <= this.activeActor) {
            ++this.activeActor;
        }
        this.actorList.add(destRow, actor);
        this.setDirty();
        this.fireTableRowsInserted(destRow, destRow);
        System.out.println("table model.addActor: done");
    }

    private void addNewActor() {
        Actor actor = new Actor(this.newActor);
        actor.addPropertyChangeListener(this);
        this.actorList.add(this.actorList.size(), actor);
        this.setDirty();
        this.fireTableRowsInserted(this.actorList.size() - 1, this.actorList.size() - 1);
    }

    public int getActiveActorIndex() {
        return this.activeActor;
    }

    public Actor getActiveActor() {
        if (this.activeActor < 0) {
            return null;
        }
        return this.getActor(this.activeActor);
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return actor.getTraitValue(ActorBase.BasicTrait.Name);
            }
            case Speed: {
                return Float.valueOf(Float.parseFloat(actor.getTraitValue(ActorBase.BasicTrait.Speed)));
            }
            case Move: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Move);
            }
            case HT: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.HT);
            }
            case HP: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.HP);
            }
            case Damage: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Injury);
            }
            case FP: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.FP);
            }
            case Fatigue: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
            }
            case Status: {
                return actor.getAllStatuses();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("ActorTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        switch (columns.values()[col]) {
            // Empty switch
        }
        Actor a = this.actorList.get(row);
        switch (columns.values()[col]) {
            case Name: {
                a.setTrait(ActorBase.BasicTrait.Name, (String)value);
                break;
            }
            case Speed: {
                a.setTrait(ActorBase.BasicTrait.Speed, String.valueOf((Float)value));
                break;
            }
            case Move: {
                a.setTrait(ActorBase.BasicTrait.Move, String.valueOf((Integer)value));
                break;
            }
            case HT: {
                a.setTrait(ActorBase.BasicTrait.HT, String.valueOf((Integer)value));
                break;
            }
            case HP: {
                a.setTrait(ActorBase.BasicTrait.HP, String.valueOf((Integer)value));
                break;
            }
            case Damage: {
                a.setTrait(ActorBase.BasicTrait.Injury, String.valueOf((Integer)value));
                break;
            }
            case FP: {
                a.setTrait(ActorBase.BasicTrait.FP, String.valueOf((Integer)value));
                break;
            }
            case Fatigue: {
                a.setTrait(ActorBase.BasicTrait.Fatigue, String.valueOf((Integer)value));
                break;
            }
            case Status: {
                a.setAllStatuses((HashSet)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (columns.values()[col]) {
            case Act: {
                return false;
            }
        }
        return true;
    }

    public boolean nextActor() {
        this.setDirty();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        boolean isNewRound = this.nextActorInternal();
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        return isNewRound;
    }

    protected boolean nextActorInternal() {
        Actor currentActor;
        do {
            ++this.activeActor;
            if (this.activeActor >= this.actorList.size() - 1) {
                this.activeActor = -1;
                return true;
            }
            currentActor = this.getActiveActor();
            currentActor.NextTurn();
        } while (currentActor.hasStatus(ActorBase.ActorStatus.Disabled) || currentActor.hasStatus(ActorBase.ActorStatus.Unconscious) || currentActor.hasStatus(ActorBase.ActorStatus.Dead) || currentActor.hasStatus(ActorBase.ActorStatus.Waiting));
        return false;
    }

    public void removeActor(int row) {
        Actor actor = this.getActor(row);
        actor.removePropertyChangeListener(this);
        this.actorList.remove(row);
        if (row < this.activeActor) {
            --this.activeActor;
        } else if (row == this.activeActor) {
            --this.activeActor;
            this.nextActor();
        }
        this.setDirty();
        this.fireTableRowsDeleted(row, row);
    }

    public void removeActor(Actor actor) {
        while (this.actorList.contains(actor)) {
            int row = this.actorList.indexOf(actor);
            this.removeActor(row);
        }
    }

    public void resetEncounter() {
        this.setDirty();
        int i = 0;
        while (i < this.actorList.size() - 1) {
            this.actorList.get(i).Reset();
            ++i;
        }
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
            this.activeActor = -1;
        }
    }

    public void setActorList(ArrayList<Actor> actorList) {
        for (Actor a : this.actorList) {
            a.removePropertyChangeListener(this);
        }
        this.fireTableRowsDeleted(0, this.getRowCount());
        if (actorList == null) {
            this.actorList = new ArrayList();
        } else {
            this.actorList = actorList;
            for (Actor a : this.actorList) {
                a.addPropertyChangeListener(this);
            }
        }
        this.fireTableDataChanged();
    }

    public void setActiveRow(int row) {
        if (row > this.getRowCount() - 2) {
            throw new IndexOutOfBoundsException("Specified row is not an actor");
        }
        if (this.activeActor != -1) {
            this.fireTableCellUpdated(this.activeActor, 0);
        }
        this.activeActor = row;
        this.getActiveActor().removeStatus(ActorBase.ActorStatus.Waiting);
        this.setDirty();
        this.fireTableCellUpdated(this.activeActor, 0);
    }

    public void autoTagActors() {
        HashSet<String> tags = this.catalogTags(true);
        int i = 0;
        while (i < this.actorList.size() - 1) {
            Actor a = this.actorList.get(i);
            if (!(!a.isTypeAutomated() || a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead) || a.hasStatus(ActorBase.ActorStatus.Waiting))) {
                this.tagActor(a, tags);
            }
            ++i;
        }
    }

    public void removeTag(Actor actor) {
        String aName;
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        Matcher matcher = nameTag.matcher(aName = actor.getTraitValue(ActorBase.BasicTrait.Name));
        if (matcher.matches()) {
            String name = matcher.group(1);
            actor.setTrait(ActorBase.BasicTrait.Name, name);
        }
    }

    public void tagActor(Actor actor) {
        this.tagActor(actor, this.catalogTags(false));
    }

    public void tagActor(Actor actor, HashSet<String> tags) {
        String aName = actor.getTraitValue(ActorBase.BasicTrait.Name);
        if (!nameTag.matcher(aName).matches()) {
            String tag = InitTableModel.getNextTag(tags);
            System.out.println("InitTableModel:tagActor: Tagging actor " + aName + " with " + "[" + tag + "]");
            actor.setTrait(ActorBase.BasicTrait.Name, String.valueOf(aName) + " [" + tag + "]");
            tags.add(tag);
        }
    }

    public HashSet<String> catalogTags(boolean clean) {
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        HashSet<String> tags = new HashSet<String>();
        int i = 0;
        while (i < this.actorList.size() - 1) {
            Actor a = this.actorList.get(i);
            String aName = a.getTraitValue(ActorBase.BasicTrait.Name);
            System.out.println("catalogTags: Cataloging actor: " + aName);
            Matcher matcher = nameTag.matcher(aName);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String tag = matcher.group(2);
                if (clean && a.isTypeAutomated() && (a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead))) {
                    System.out.println("catalogTags: cleaning tag: " + tag);
                    a.setTrait(ActorBase.BasicTrait.Name, name);
                } else {
                    if (tags.contains(tag)) {
                        System.out.println("-W- InitTableModel::catalogTags: Duplicate tag detected! " + tag);
                    }
                    tags.add(tag);
                }
            }
            ++i;
        }
        return tags;
    }

    private static String getNextTag(HashSet<String> tags) {
        flagColors[] flagColorsArray = flagColors.values();
        int n = flagColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            flagColors color = flagColorsArray[n2];
            int i = 1;
            while (i <= flagMaxNum) {
                String tag = String.valueOf(color.toString()) + i;
                if (!tags.contains(tag)) {
                    return tag;
                }
                ++i;
            }
            ++n2;
        }
        System.out.println("-W- InitTableModel:getNextTag: no free tags!");
        return "S99";
    }

    public void addEncounterLogEventListener(EncounterLogEventListener listener) {
        this.encounterLogEventSource.addEncounterLogEventListener(listener);
    }

    public void removeEncounterLogEventListener(EncounterLogEventListener listener) {
        this.encounterLogEventSource.removeEncounterLogEventListener(listener);
    }

    public boolean isClean() {
        return this.cleanFileChangeEventSource.isClean();
    }

    public void setClean() {
        this.cleanFileChangeEventSource.setClean();
    }

    public void setDirty() {
        this.cleanFileChangeEventSource.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.removeFileChangeEventListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (Actor.class.isInstance(e.getSource())) {
            this.setDirty();
            Actor actor = (Actor)e.getSource();
            System.out.println("InitTableModel: propertyChange: got notification from actor " + actor.getTraitValue(ActorBase.BasicTrait.Name));
            int[] rows = this.getActorRows(actor);
            int i = 0;
            while (i < rows.length) {
                if (rows[i] == this.getRowCount() - 1) {
                    this.addNewActor();
                }
                this.fireTableRowsUpdated(rows[i], rows[i]);
                ++i;
            }
        }
    }

    public static enum columns {
        Act,
        Name,
        Speed,
        Move,
        HT,
        HP,
        Damage,
        FP,
        Fatigue,
        Status;

    }

    public static enum flagColors {
        R,
        B;

    }
}

