/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Damage;
import gurpsinittool.data.Defense;
import gurpsinittool.data.HitLocations;
import gurpsinittool.util.DieRoller;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DefenseDialog
extends JDialog {
    Actor actor;
    public Defense defense = new Defense();
    public boolean valid = false;
    private JRadioButton blockButton;
    private JLabel blockNote;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JTextField damageTextField;
    private JLabel db;
    private JRadioButton dodgeButton;
    private JLabel dodgeNote;
    private JFormattedTextField drTextField;
    private JCheckBox eeCheck;
    private JLabel effectiveDefense;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox locationCombo;
    private JTextField name;
    private JRadioButton noneButton;
    private JButton okButton;
    private JSpinner otherSpinner;
    private JRadioButton parryButton;
    private JLabel parryNote;
    private JComboBox positionCombo;
    private JButton rerollButton;
    private JTextField result;
    private JCheckBox retreatCheck;
    private JFormattedTextField rollTextField;
    private JCheckBox shieldCheckBox;
    private JLabel shield_dr;
    private JLabel shield_hp;
    private JCheckBox sideCheck;
    private JCheckBox stunnedCheck;

    public DefenseDialog(Actor actor, Window parent) {
        super(parent, DEFAULT_MODALITY_TYPE);
        this.initComponents();
        this.initEnterEsc();
        this.initLocationCombo();
        this.initPositionCombo();
        this.setActor(actor);
        this.damageTextField.selectAll();
        this.damageTextField.requestFocusInWindow();
    }

    private void initLocationCombo() {
        Vector<String> comboItems = new Vector<String>();
        HitLocations.LocationType[] locationTypeArray = HitLocations.LocationType.values();
        int n = locationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HitLocations.LocationType location = locationTypeArray[n2];
            comboItems.add(HitLocations.locations.get((Object)((Object)location)).description);
            ++n2;
        }
        this.locationCombo.setModel(new DefaultComboBoxModel(comboItems));
    }

    private void initPositionCombo() {
        Vector<String> comboItems = new Vector<String>();
        comboItems.add("Standing");
        comboItems.add("Kneeling");
        comboItems.add("Prone");
        this.positionCombo.setModel(new DefaultComboBoxModel(comboItems));
    }

    private void initEnterEsc() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.okButtonActionPerformed(actionEvent);
            }
        };
        AbstractAction eeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.eeCheck.doClick();
            }
        };
        AbstractAction retreatAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.retreatCheck.doClick();
            }
        };
        AbstractAction sideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.sideCheck.doClick();
            }
        };
        AbstractAction stunAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.stunnedCheck.doClick();
            }
        };
        AbstractAction deceptiveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefenseDialog.this.otherSpinner.setValue(DefenseDialog.this.otherSpinner.getPreviousValue());
            }
        };
        this.damageTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.damageTextField.getActionMap().put("OK", okAction);
        this.damageTextField.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.damageTextField.getActionMap().put("CANCEL", cancelAction);
        this.locationCombo.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.locationCombo.getActionMap().put("OK", okAction);
        this.locationCombo.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.locationCombo.getActionMap().put("CANCEL", cancelAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.getRootPane().getActionMap().put("OK", okAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", cancelAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control E"), "ExtraEffort");
        this.getRootPane().getActionMap().put("ExtraEffort", eeAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control R"), "Retreat");
        this.getRootPane().getActionMap().put("Retreat", retreatAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control S"), "Side");
        this.getRootPane().getActionMap().put("Side", sideAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control T"), "Stun");
        this.getRootPane().getActionMap().put("Stun", stunAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control D"), "Deceptive");
        this.getRootPane().getActionMap().put("Deceptive", deceptiveAction);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.blockNote = new JLabel();
        this.dodgeNote = new JLabel();
        this.jLabel4 = new JLabel();
        this.parryNote = new JLabel();
        this.jLabel2 = new JLabel();
        this.shieldCheckBox = new JCheckBox();
        this.blockButton = new JRadioButton();
        this.cancelButton = new JButton();
        this.parryButton = new JRadioButton();
        this.rerollButton = new JButton();
        this.retreatCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.dodgeButton = new JRadioButton();
        this.eeCheck = new JCheckBox();
        this.sideCheck = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.effectiveDefense = new JLabel();
        this.name = new JTextField();
        this.result = new JTextField();
        this.shield_dr = new JLabel();
        this.db = new JLabel();
        this.shield_hp = new JLabel();
        this.jLabel8 = new JLabel();
        this.rollTextField = new JFormattedTextField();
        this.drTextField = new JFormattedTextField();
        this.damageTextField = new JTextField();
        this.otherSpinner = new JSpinner();
        this.locationCombo = new JComboBox();
        this.jLabel9 = new JLabel();
        this.noneButton = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.stunnedCheck = new JCheckBox();
        this.positionCombo = new JComboBox();
        this.jLabel10 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.okButton.setMnemonic('k');
        this.okButton.setText("OK");
        this.okButton.setToolTipText("");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.blockNote.setText("(10-4=12)");
        this.dodgeNote.setText("(10)");
        this.jLabel4.setText("Other");
        this.parryNote.setText("(10-8=12)");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Damage:");
        this.shieldCheckBox.setSelected(true);
        this.shieldCheckBox.setText("Shield:");
        this.shieldCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.blockButton);
        this.blockButton.setText("Block");
        this.blockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.parryButton);
        this.parryButton.setSelected(true);
        this.parryButton.setText("Parry");
        this.parryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.rerollButton.setText("Reroll");
        this.rerollButton.setMargin(new Insets(2, 4, 2, 4));
        this.rerollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.rerollButtonActionPerformed(evt);
            }
        });
        this.retreatCheck.setText("Retreat");
        this.retreatCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Roll:");
        this.buttonGroup1.add(this.dodgeButton);
        this.dodgeButton.setText("Dodge");
        this.dodgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.eeCheck.setText("Extra Effort");
        this.eeCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.sideCheck.setText("Side Attack");
        this.sideCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("<HTML>Effective<br>Defense</HTML>");
        this.effectiveDefense.setFont(new Font("Tahoma", 1, 24));
        this.effectiveDefense.setText("97");
        this.name.setEditable(false);
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setFont(new Font("Tahoma", 1, 20));
        this.name.setText("name");
        this.name.setBorder(null);
        this.name.setFocusable(false);
        this.result.setEditable(false);
        this.result.setBackground(new Color(236, 233, 216));
        this.result.setFont(new Font("Tahoma", 1, 12));
        this.result.setText("result");
        this.result.setBorder(null);
        this.result.setFocusable(false);
        this.shield_dr.setText("DR: 4");
        this.db.setFont(new Font("Tahoma", 1, 11));
        this.db.setText("DB: 2");
        this.shield_hp.setText("HP: 20/20");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("DR:");
        this.rollTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.rollTextField.setText("98");
        this.drTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.otherSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DefenseDialog.this.otherSpinnerStateChanged(evt);
            }
        });
        this.locationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.locationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.locationCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DefenseDialog.this.locationComboKeyReleased(evt);
            }
        });
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Location:");
        this.buttonGroup1.add(this.noneButton);
        this.noneButton.setText("None");
        this.noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Defense Type:");
        this.stunnedCheck.setText("Stunned");
        this.stunnedCheck.setToolTipText("");
        this.stunnedCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.positionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.positionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.positionCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DefenseDialog.this.locationComboKeyReleased(evt);
            }
        });
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Posture:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addComponent(this.result).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addGap(1, 1, 1).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dodgeButton).addComponent(this.parryButton, GroupLayout.Alignment.LEADING)).addComponent(this.blockButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.blockNote).addComponent(this.dodgeNote).addComponent(this.parryNote))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7, -2, 51, -2).addComponent(this.noneButton, GroupLayout.Alignment.LEADING)).addGap(3, 3, 3).addComponent(this.effectiveDefense, -2, 50, -2)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionCombo, -2, 75, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.eeCheck).addComponent(this.retreatCheck).addComponent(this.sideCheck).addGroup(layout.createSequentialGroup().addComponent(this.otherSpinner, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.shield_dr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shield_hp)).addComponent(this.stunnedCheck).addGroup(layout.createSequentialGroup().addComponent(this.shieldCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.db, -1, -1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel8).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drTextField, -2, 27, -2).addComponent(this.damageTextField, -2, 55, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.locationCombo, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.rollTextField, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rerollButton)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.name, -2, 28, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eeCheck).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.retreatCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sideCheck)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parryButton).addComponent(this.parryNote)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.blockButton).addComponent(this.blockNote)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dodgeButton).addComponent(this.dodgeNote).addComponent(this.stunnedCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noneButton).addComponent(this.shieldCheckBox).addComponent(this.db)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.shield_dr).addComponent(this.shield_hp).addComponent(this.jLabel10).addComponent(this.positionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.otherSpinner, -2, -1, -2)).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.effectiveDefense, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.rollTextField, -2, -1, -2).addComponent(this.rerollButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.drTextField, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.damageTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.result, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton))).addComponent(this.locationCombo, -2, -1, -2))));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        System.out.println("DefenseDialog: OK!");
        this.valid = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        System.out.println("DefenseDialog: CANCEL!");
        this.setVisible(false);
    }

    private void rerollButtonActionPerformed(ActionEvent evt) {
        this.rollDefense();
    }

    private void otherSpinnerStateChanged(ChangeEvent evt) {
        this.updateDefenseResults();
    }

    private void locationComboKeyReleased(KeyEvent evt) {
        this.updateDefenseResults();
    }

    private void checkItemStateChanged(ItemEvent evt) {
        this.updateDefenseResults();
    }

    private void radioButtonActionPerformed(ActionEvent evt) {
        this.updateDefenseResults();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefenseDialog dialog = new DefenseDialog(null, new JWindow());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void setActor(Actor actor) {
        this.actor = actor;
        this.defense.setInitialOptions(actor);
        this.name.setText(actor.getTraitValue(ActorBase.BasicTrait.Name));
        switch (actor.getType()) {
            case PC: {
                this.name.setBackground(new Color(200, 255, 200));
                break;
            }
            case Ally: {
                this.name.setBackground(new Color(200, 200, 255));
                break;
            }
            case Enemy: {
                this.name.setBackground(new Color(255, 200, 200));
                break;
            }
            case Neutral: {
                this.name.setBackground(new Color(200, 200, 200));
                break;
            }
            case Special: {
                this.name.setBackground(new Color(255, 200, 255));
            }
        }
        int effParry = actor.getCurrentDefenseValue(Defense.DefenseType.Parry);
        int effBlock = actor.getCurrentDefenseValue(Defense.DefenseType.Block);
        int effDodge = actor.getCurrentDefenseValue(Defense.DefenseType.Dodge);
        int Parry = actor.getTraitValueInt(ActorBase.BasicTrait.Parry);
        int Block = actor.getTraitValueInt(ActorBase.BasicTrait.Block);
        int Dodge = actor.getTraitValueInt(ActorBase.BasicTrait.Dodge);
        this.parryNote.setText(String.valueOf(effParry) + (effParry != Parry ? " (base: " + Parry + ")" : ""));
        this.blockNote.setText(String.valueOf(effBlock) + (effBlock != Block ? " (base: " + Block + ")" : ""));
        this.dodgeNote.setText(String.valueOf(effDodge) + (effDodge != Dodge ? " (base: " + Dodge + ")" : ""));
        switch (this.defense.type) {
            case Parry: {
                this.parryButton.setSelected(true);
                break;
            }
            case Block: {
                this.blockButton.setSelected(true);
                break;
            }
            case Dodge: {
                this.dodgeButton.setSelected(true);
                break;
            }
            case None: {
                this.noneButton.setSelected(true);
            }
        }
        this.eeCheck.setSelected(this.defense.ee);
        this.retreatCheck.setSelected(this.defense.retreat);
        this.sideCheck.setSelected(this.defense.side);
        this.stunnedCheck.setSelected(this.defense.stunned);
        this.shieldCheckBox.setSelected(this.defense.shield);
        int ShieldDB = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DB);
        int ShieldDR = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DR);
        int ShieldHP = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_HP);
        int DR = actor.getTraitValueInt(ActorBase.BasicTrait.DR);
        this.db.setText("DB: " + ShieldDB);
        this.shield_dr.setText("DR: " + ShieldDR);
        this.shield_hp.setText("HP: " + (ShieldHP - actor.getTempInt("shieldDamage")) + "/" + ShieldHP);
        this.drTextField.setText("" + DR);
        if (this.defense.position.equals("Kneeling")) {
            this.positionCombo.setSelectedIndex(1);
        }
        if (this.defense.position.equals("Prone")) {
            this.positionCombo.setSelectedIndex(2);
        }
        this.rollDefense();
        this.updateDefenseResults();
        JFormattedTextField field = (JFormattedTextField)this.otherSpinner.getEditor().getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.rollTextField.getDocument().addDocumentListener(new ValueDocumentListener());
        this.drTextField.getDocument().addDocumentListener(new ValueDocumentListener());
        this.damageTextField.getDocument().addDocumentListener(new ValueDocumentListener());
    }

    private void rollDefense() {
        this.rollTextField.setText(String.valueOf(DieRoller.roll3d6()));
    }

    private void updateDefenseResults() {
        if (this.actor == null) {
            return;
        }
        if (!this.parseInputFields()) {
            return;
        }
        this.updateDefenseSettings();
        this.defense.calcDefenseResults(this.actor);
        this.effectiveDefense.setText(String.valueOf(this.defense.effectiveDefense));
        this.setResultMessage();
    }

    private void updateDefenseSettings() {
        if (this.parryButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Parry;
        } else if (this.blockButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Block;
        } else if (this.dodgeButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Dodge;
        } else if (this.noneButton.isSelected()) {
            this.defense.type = Defense.DefenseType.None;
        } else {
            System.out.println("-E- DefenseDialog: updateDefenseSettings: no defense selected!");
        }
        this.defense.ee = this.eeCheck.isSelected();
        this.defense.retreat = this.retreatCheck.isSelected();
        this.defense.side = this.sideCheck.isSelected();
        this.defense.stunned = this.stunnedCheck.isSelected();
        this.defense.shield = this.shieldCheckBox.isSelected();
        this.defense.position = this.positionCombo.getSelectedItem().toString();
        try {
            this.defense.otherMod = Integer.parseInt(this.otherSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean parseInputFields() {
        boolean parseSuccess = true;
        try {
            this.defense.roll = Integer.parseInt(this.rollTextField.getText());
            this.rollTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.rollTextField.setForeground(Color.RED);
            System.out.println("-W- DefenseDialog.parseInputFields: Error parsing roll field! '" + this.rollTextField.getText() + "': " + e.getMessage());
            parseSuccess = false;
        }
        try {
            this.defense.override_dr = Integer.parseInt(this.drTextField.getText());
            this.drTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.drTextField.setForeground(Color.RED);
            System.out.println("-W- DefenseDialog.parseInputFields: Error parsing dr field! '" + this.drTextField.getText() + "': " + e.getMessage());
            parseSuccess = false;
        }
        try {
            this.defense.damage = Damage.ParseDamage(this.damageTextField.getText());
            this.damageTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.damageTextField.setForeground(Color.RED);
            System.out.println("-W- DefenseDialog.parseInputFields: Error parsing damage field! '" + this.damageTextField.getText() + "': " + e.getMessage());
            parseSuccess = false;
        }
        this.defense.location = HitLocations.getLocationFromName((String)this.locationCombo.getSelectedItem());
        return parseSuccess;
    }

    private void setResultMessage() {
        String message = "";
        switch (this.defense.result) {
            case CritSuccess: {
                this.result.setText("Critical Defense!");
                this.result.setBackground(new Color(200, 200, 255));
                return;
            }
            case Success: {
                this.result.setText("Defended!");
                this.result.setBackground(new Color(200, 200, 200));
                return;
            }
            case ShieldHit: {
                message = "Shield ";
            }
            case Failure: {
                message = String.valueOf(message) + "Hit";
            }
        }
        if (this.defense.injury != 0) {
            this.result.setBackground(new Color(255, 200, 200));
            message = String.valueOf(message) + ": " + this.defense.injury;
            if (this.defense.cripplingInjury) {
                message = String.valueOf(message) + " crippling";
            } else if (this.defense.majorWound) {
                message = String.valueOf(message) + " major";
            }
            message = String.valueOf(message) + " injury!";
        } else {
            this.result.setBackground(new Color(200, 200, 200));
            message = String.valueOf(message) + ": no injury";
        }
        if (this.defense.result == Defense.DefenseResult.ShieldHit) {
            if (this.defense.shieldDamage != 0 && this.defense.injury == 0) {
                this.result.setBackground(new Color(255, 255, 200));
            }
            message = String.valueOf(message) + " (" + this.defense.shieldDamage + " shld dmg)";
        }
        this.result.setText(message);
    }

    protected class ModDocumentListener
    implements DocumentListener {
        protected ModDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }
    }

    protected class ValueDocumentListener
    implements DocumentListener {
        protected ValueDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }
    }
}

