/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.data.Attack;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class AttackTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String[] columnNames = new String[]{"Name", "Skill", "Damage", "U"};
    private Class<?>[] columnClasses = new Class[]{String.class, Integer.class, String.class, Boolean.class};
    private static int numColumns = 4;
    private Actor currentActor = null;

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.currentActor == null) {
            return 0;
        }
        return this.currentActor.getNumAttacks();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentActor == null) {
            return null;
        }
        Attack attack = this.currentActor.getAttack(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return attack.Name;
            }
            case Skill: {
                return attack.Skill;
            }
            case Damage: {
                return attack.Damage;
            }
            case Unbalanced: {
                return attack.Unbalanced;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("AttackTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        if (this.getValueAt(row, col).equals(value)) {
            System.out.println("AttackTableModel: setValueAt: values are identical. Exiting.");
            return;
        }
        Attack a = this.currentActor.getAttack(row);
        switch (columns.values()[col]) {
            case Name: {
                a.Name = (String)value;
                break;
            }
            case Skill: {
                a.Skill = (Integer)value;
                break;
            }
            case Damage: {
                a.Damage = (String)value;
                break;
            }
            case Unbalanced: {
                a.Unbalanced = (Boolean)value;
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.currentActor != null;
    }

    public void setActor(Actor actor) {
        this.currentActor = actor;
        this.fireTableDataChanged();
    }

    public void addAttack() {
        if (this.currentActor != null) {
            this.currentActor.addAttack(new Attack());
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }
    }

    public void removeAttacks(int[] rows) {
        if (this.currentActor != null && rows.length > 0) {
            int i = rows.length - 1;
            while (i >= 0) {
                System.out.println("AttackTableModel: Deleting row: " + rows[i]);
                this.currentActor.removeAttack(rows[i]);
                --i;
            }
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }
    }

    public void setDefaultAttack(int row) {
        if (row < 0 || row >= this.currentActor.getNumAttacks()) {
            System.out.println("AttackTableModel:setDefaultAttack: row out of range! " + row);
            return;
        }
        int oldDefault = this.currentActor.getDefaultAttack();
        this.currentActor.setDefaultAttack(row);
        this.fireTableRowsUpdated(oldDefault, oldDefault);
        this.fireTableRowsUpdated(row, row);
    }

    public class AttackTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getRowSorter().convertRowIndexToModel(row) == AttackTableModel.this.currentActor.getDefaultAttack()) {
                Font oldFont = c.getFont();
                Font newFont = new Font(oldFont.getName(), 1, oldFont.getSize());
                c.setFont(newFont);
            }
            return c;
        }
    }

    public static enum columns {
        Name,
        Skill,
        Damage,
        Unbalanced;

    }
}

