/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.data.Actor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GroupTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private GroupTree parent;
    protected static DataFlavor actorGroupFlavor = new DataFlavor(GroupTreeNode.class, "GURPS Actor Group Object");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{actorGroupFlavor};

    public GroupTreeTransferHandler(GroupTree parent, String property) {
        super(property);
        this.parent = parent;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        if (insertPath == null) {
            return false;
        }
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            this.parent.setDropMode(DropMode.INSERT);
            return true;
        }
        if (support.isDataFlavorSupported(InitTableTransferHandler.initTableActorFlavor) || support.isDataFlavorSupported(InitTableTransferHandler.groupTableActorFlavor)) {
            this.parent.setDropMode(DropMode.ON);
            support.setDropAction(1);
            if (!parentNode.isFolder()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        GroupTree tree = (GroupTree)support.getComponent();
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        int insertIndex = dl.getChildIndex();
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        Transferable t = support.getTransferable();
        int action = support.getDropAction();
        System.out.println("GroupTreeTransferHandler.importData: starting action " + action);
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            GroupTreeNode transferNode;
            System.out.println("GroupTreeTransferHandler.importData: Retrieving node data...");
            try {
                transferNode = (GroupTreeNode)t.getTransferData(actorGroupFlavor);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("GroupTreeTransferHandler.importData: -E- Unsupported Flavor Exception");
                return false;
            }
            catch (IOException e) {
                System.err.println("GroupTreeTransferHandler.importData: -E- IO Exception:" + e.toString());
                return false;
            }
            TreePath transferPath = new TreePath(transferNode.getPath());
            if (action == 2 && !tree.isSelectionEmpty()) {
                TreePath selectionPath = tree.getSelectionPath();
                if (transferPath.getPathCount() == selectionPath.getPathCount() && insertPath.getPathCount() >= selectionPath.getPathCount()) {
                    System.out.println("GroupTreeTransferHandler.importData: Comparing paths: " + insertPath + " vs " + selectionPath + " vs " + transferPath);
                    int i = 0;
                    while (i < selectionPath.getPathCount()) {
                        System.out.println("GroupTreeTransferHandler.importData: Checking node path: " + insertPath.getPath()[i] + " vs " + selectionPath.getPath()[i]);
                        if (!transferPath.getPathComponent(i).toString().equals(selectionPath.getPathComponent(i).toString())) {
                            System.out.println("GroupTreeTransferHandler.importData: Paths are NOT identical (transfer != selection): allowing move");
                            break;
                        }
                        if (!insertPath.getPathComponent(i).equals(selectionPath.getPathComponent(i))) {
                            System.out.println("GroupTreeTransferHandler.importData: Paths are NOT identical (insert != selection): allowing move");
                            break;
                        }
                        if (i == selectionPath.getPathCount() - 1) {
                            System.out.println("GroupTreeTransferHandler.importData: Paths are identical: disallowing move");
                            return false;
                        }
                        ++i;
                    }
                }
            }
            System.out.println("GroupTreeTransferHandler.importData: Inserting node " + transferPath.toString() + " @ " + insertIndex);
            if (insertIndex >= 0) {
                treeModel.insertNodeInto(transferNode, parentNode, insertIndex);
            } else {
                treeModel.insertNodeInto(transferNode, parentNode, parentNode.getChildCount());
            }
            if (action == 2) {
                tree.setSelectionPath(new TreePath(transferNode.getPath()));
            }
        } else {
            Actor[] actorRows;
            if (parentNode.isFolder()) {
                System.out.println("GroupTreeTransferHandler.importData: -E- attempting to drop rows on folder!");
                return false;
            }
            System.out.println("GroupTreeTransferHandler.importData: Retrieving actor data...");
            try {
                actorRows = (Actor[])t.getTransferData(InitTableTransferHandler.initTableActorFlavor);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("GroupTreeTransferHandler.importData: importData -E- Unsupported Flavor Exception");
                return false;
            }
            catch (IOException e) {
                System.err.println("GroupTreeTransferHandler.importData: importData -E- IO Exception");
                return false;
            }
            System.out.println("GroupTreeTransferHandler.importData:  Transferable data retrieved.");
            ArrayList<Actor> actorList = parentNode.getActorList();
            if (this.parent.getSelectionPath().getLastPathComponent().equals(parentNode)) {
                System.out.println("GroupTreeTransferHandler.importData: Selected node is changing");
                InitTableModel model = (InitTableModel)this.parent.getGroupTable().getModel();
                int i = actorRows.length - 1;
                while (i >= 0) {
                    System.out.println("GroupTreeTransferHandler.importData: Adding actor through ActorTableModel # " + i);
                    model.addActor(actorRows[i], model.getRowCount() - 1);
                    --i;
                }
            } else {
                int i = actorRows.length - 1;
                while (i >= 0) {
                    System.out.println("GroupTreeTransferHandler.importData: Adding actor # " + i);
                    actorList.add(actorList.size() - 1, actorRows[i]);
                    --i;
                }
                tree.setDirty();
            }
        }
        System.out.println("GroupTreeTransferHandler.importData: done");
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        GroupTree tree = (GroupTree)c;
        TreePath transferPath = tree.getSelectionPath();
        if (transferPath == null) {
            return null;
        }
        return new TransferableActorGroup((GroupTreeNode)transferPath.getLastPathComponent());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        GroupTreeNode transferNode;
        System.out.println("GroupTreeTransferHandler.exportDone: starting action " + action);
        GroupTree tree = (GroupTree)source;
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        try {
            transferNode = (GroupTreeNode)data.getTransferData(actorGroupFlavor);
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("GroupTreeTransferHandler: exportDone -E- UnsupportedFlavorException");
            return;
        }
        catch (IOException e) {
            System.out.println("GroupTreeTransferHandler: exportDone -E- IOException");
            return;
        }
        TreePath transferPath = new TreePath(transferNode.getPath());
        if (action == 2) {
            System.out.println("GroupTreeTransferHandler:  Removing path that was transfered: " + transferPath.toString());
            treeModel.removeNodeFromParent(transferNode);
        } else if (action == 1) {
            tree.setSelectionPath(transferPath);
        }
        System.out.println("GroupTreeTransferHandler.exportDone: done");
    }

    class TransferableActorGroup
    implements Transferable {
        GroupTreeNode transferNode;

        public TransferableActorGroup(GroupTreeNode transferNode) {
            this.transferNode = transferNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(actorGroupFlavor)) {
                System.out.println("GroupTreeTransferHandler:  Exporting data to " + flavor + " flavor, path: " + new TreePath(this.transferNode.getPath()).toString());
                return this.transferNode;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(actorGroupFlavor);
        }
    }
}

