/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.FileChangeEventListener;
import gurpsinittool.util.SearchSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class InitTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String[] columnNames = new String[]{"Act", "Name", "Speed", "Move", "HT", "HP", "Injury", "FP", "Fatigue", "Status"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class, Float.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class};
    private static int numColumns = 10;
    Actor newActor = new Actor();
    private ArrayList<Actor> actorList = new ArrayList();
    protected CleanFileChangeEventSource cleanFileChangeEventSource = new CleanFileChangeEventSource(this);

    public InitTableModel() {
        this.addNewActor();
    }

    public void addActor(Actor actor, int destRow) {
        System.out.println("table model.addActor: start: " + actor.getTraitValue(ActorBase.BasicTrait.Name));
        actor.addPropertyChangeListener(this);
        if (destRow > this.actorList.size() - 1) {
            destRow = this.actorList.size() - 1;
        } else if (destRow < 0) {
            destRow = 0;
        }
        this.actorList.add(destRow, actor);
        this.setDirty();
        this.fireTableRowsInserted(destRow, destRow);
        System.out.println("table model.addActor: done");
    }

    private void addNewActor() {
        Actor actor = new Actor(this.newActor);
        actor.addPropertyChangeListener(this);
        this.actorList.add(this.actorList.size(), actor);
        this.setDirty();
        this.fireTableRowsInserted(this.actorList.size() - 1, this.actorList.size() - 1);
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return actor.getTraitValue(ActorBase.BasicTrait.Name);
            }
            case Speed: {
                return Float.valueOf(Float.parseFloat(actor.getTraitValue(ActorBase.BasicTrait.Speed)));
            }
            case Move: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Move);
            }
            case HT: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.HT);
            }
            case HP: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.HP);
            }
            case Injury: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Injury);
            }
            case FP: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.FP);
            }
            case Fatigue: {
                return actor.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
            }
            case Status: {
                return actor.getAllStatuses();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("ActorTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        switch (columns.values()[col]) {
            // Empty switch
        }
        Actor a = this.actorList.get(row);
        switch (columns.values()[col]) {
            case Name: {
                a.setTrait(ActorBase.BasicTrait.Name, (String)value);
                break;
            }
            case Speed: {
                a.setTrait(ActorBase.BasicTrait.Speed, String.valueOf((Float)value));
                break;
            }
            case Move: {
                a.setTrait(ActorBase.BasicTrait.Move, String.valueOf((Integer)value));
                break;
            }
            case HT: {
                a.setTrait(ActorBase.BasicTrait.HT, String.valueOf((Integer)value));
                break;
            }
            case HP: {
                a.setTrait(ActorBase.BasicTrait.HP, String.valueOf((Integer)value));
                break;
            }
            case Injury: {
                a.setTrait(ActorBase.BasicTrait.Injury, String.valueOf((Integer)value));
                break;
            }
            case FP: {
                a.setTrait(ActorBase.BasicTrait.FP, String.valueOf((Integer)value));
                break;
            }
            case Fatigue: {
                a.setTrait(ActorBase.BasicTrait.Fatigue, String.valueOf((Integer)value));
                break;
            }
            case Status: {
                a.setAllStatuses((HashSet)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (columns.values()[col]) {
            case Act: {
                return false;
            }
        }
        return true;
    }

    public void removeActor(int row) {
        Actor actor = this.getActor(row);
        actor.removePropertyChangeListener(this);
        this.actorList.remove(row);
        this.setDirty();
        this.fireTableRowsDeleted(row, row);
    }

    public void setActorList(ArrayList<Actor> actorList) {
        for (Actor a : this.actorList) {
            a.removePropertyChangeListener(this);
        }
        this.fireTableRowsDeleted(0, this.getRowCount());
        if (actorList == null) {
            this.actorList = new ArrayList();
        } else {
            this.actorList = actorList;
            for (Actor a : this.actorList) {
                a.addPropertyChangeListener(this);
            }
        }
        this.fireTableDataChanged();
    }

    public int searchActors(int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        return SearchSupport.searchActorList(this.actorList, startingIndex, endingIndex, next, reverse, pattern);
    }

    public boolean isClean() {
        return this.cleanFileChangeEventSource.isClean();
    }

    public void setClean() {
        this.cleanFileChangeEventSource.setClean();
    }

    public void setDirty() {
        this.cleanFileChangeEventSource.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.removeFileChangeEventListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (Actor.class.isInstance(e.getSource())) {
            this.setDirty();
            Actor actor = (Actor)e.getSource();
            System.out.println("InitTableModel: propertyChange: got notification from actor " + actor.getTraitValue(ActorBase.BasicTrait.Name));
            int[] rows = this.getActorRows(actor);
            int i = 0;
            while (i < rows.length) {
                if (rows[i] == this.getRowCount() - 1) {
                    this.addNewActor();
                }
                this.fireTableRowsUpdated(rows[i], rows[i]);
                ++i;
            }
            System.out.println("InitTableModel: propertyChange: done with actor " + actor.getTraitValue(ActorBase.BasicTrait.Name));
        } else if (e.getPropertyName().equals("ActiveActor")) {
            int oldValue = (Integer)e.getOldValue();
            int newValue = (Integer)e.getNewValue();
            if (oldValue != -1) {
                this.fireTableRowsUpdated(oldValue, oldValue);
            }
            if (newValue != -1) {
                this.fireTableRowsUpdated(newValue, newValue);
            }
        }
    }

    public static enum columns {
        Act,
        Name,
        Speed,
        Move,
        HT,
        HP,
        Injury,
        FP,
        Fatigue,
        Status;

    }
}

