/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Attack;
import gurpsinittool.data.CriticalTables;
import gurpsinittool.data.Damage;
import gurpsinittool.data.Defense;
import gurpsinittool.util.DieRoller;

public class Actor
extends ActorBase {
    private static final long serialVersionUID = 1L;

    public Actor() {
    }

    public Actor(Actor anActor) {
        super(anActor);
    }

    public void NextTurn() {
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        if (Actor.settings.AUTO_SHOCK) {
            int injury = this.getTempInt("shock.next");
            int injury_per_shock = this.getTraitValueInt(ActorBase.BasicTrait.HP) / 10;
            int LHPT = this.hasTrait("HPT") ? 0 : (this.hasTrait("LPT") ? 2 : 1);
            this.setTemp("shock", LHPT * Math.min(injury / injury_per_shock, 4));
        }
        this.setTemp("shock.next", 0);
        int Injury = this.getTraitValueInt(ActorBase.BasicTrait.Injury);
        int HP = this.getTraitValueInt(ActorBase.BasicTrait.HP);
        int HT = this.getTraitValueInt(ActorBase.BasicTrait.HT);
        if (!(!this.isTypeAutomated() || this.hasStatus(ActorBase.ActorStatus.Unconscious) || this.hasStatus(ActorBase.ActorStatus.Disabled) || this.hasStatus(ActorBase.ActorStatus.Dead) || this.hasStatus(ActorBase.ActorStatus.Waiting))) {
            if (Actor.settings.AUTO_UNCONSCIOUS && Injury >= HP) {
                int penalty = (int)(-1.0 * (Math.floor((double)Injury / (double)HP) - 1.0));
                int result = DieRoller.roll3d6();
                String details = "(HT: " + HT + ", penalty: " + penalty + ", roll: " + result + ")";
                if (DieRoller.isFailure(result, HT + penalty)) {
                    this.logEventTypeName("<b><font color=red>failed</font></b> consciousness roll " + details);
                    this.clearStatuses();
                    this.addStatus(ActorBase.ActorStatus.Unconscious);
                    this.setPosture(ActorBase.ActorStatus.Prone);
                    this.addStatus(ActorBase.ActorStatus.Disarmed);
                } else {
                    this.logEventTypeName("passed consciousness roll " + details);
                }
            }
            if (Actor.settings.AUTO_STUNRECOVERY) {
                int roll;
                int recoverTarget;
                this.removeStatus(ActorBase.ActorStatus.StunRecovr);
                if (this.hasStatus(ActorBase.ActorStatus.StunMental)) {
                    recoverTarget = this.getTraitValueInt(ActorBase.BasicTrait.IQ);
                    if (this.hasTrait("CR")) {
                        recoverTarget += 6;
                    }
                    if (DieRoller.isSuccess(roll = DieRoller.roll3d6(), recoverTarget)) {
                        this.logEventTypeName("is now recovering from Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorBase.ActorStatus.StunMental);
                        this.addStatus(ActorBase.ActorStatus.StunRecovr);
                    } else {
                        this.logEventTypeName("<b>failed</b> recovery roll for Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                }
                if (this.hasStatus(ActorBase.ActorStatus.StunPhys)) {
                    recoverTarget = this.getTraitValueInt(ActorBase.BasicTrait.HT);
                    roll = DieRoller.roll3d6();
                    if (DieRoller.isSuccess(roll, recoverTarget)) {
                        this.logEventTypeName("is now recovering from Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorBase.ActorStatus.StunPhys);
                        this.addStatus(ActorBase.ActorStatus.StunRecovr);
                    } else {
                        this.logEventTypeName("<b>failed</b> recovery roll for Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                }
            }
            if (Actor.settings.AUTO_ATTACK && this.hasStatus(ActorBase.ActorStatus.Attacking) && !this.isStunned()) {
                this.Attack();
            }
        }
    }

    public void Reset() {
        this.clearStatuses();
        this.setTrait(ActorBase.BasicTrait.Injury, "0");
        this.setTrait(ActorBase.BasicTrait.Fatigue, "0");
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    public boolean isStunned() {
        return this.hasStatus(ActorBase.ActorStatus.StunPhys) || this.hasStatus(ActorBase.ActorStatus.StunMental) || this.hasStatus(ActorBase.ActorStatus.StunRecovr);
    }

    public void Attack(int num) {
        CriticalTables.Entry crit_result;
        String hit_miss;
        if (num < 0 || num >= this.attacks.size()) {
            System.err.println("-E- Actor:Attack: invalid attack attempted: id # " + String.valueOf(num));
            return;
        }
        Attack attack = (Attack)this.attacks.get(num);
        int eff_skill = attack.Skill;
        if (this.hasStatus(ActorBase.ActorStatus.Prone)) {
            eff_skill -= 4;
        } else if (this.hasStatus(ActorBase.ActorStatus.Kneeling)) {
            eff_skill -= 2;
        }
        if (Actor.settings.AUTO_SHOCK) {
            eff_skill -= this.getTempInt("shock");
        }
        int roll = DieRoller.roll3d6();
        int margin = eff_skill - roll;
        String crit_string = "";
        if (DieRoller.isCritFailure(roll, eff_skill)) {
            hit_miss = "<b><font color=red>Critical miss</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_miss);
            crit_string = "<br/> <i><font color=gray><b>Critical Miss Table Result:</b>" + crit_result.notes + "</font></i>";
        } else if (DieRoller.isCritSuccess(roll, eff_skill)) {
            hit_miss = "<b><font color=blue>Critical hit</font></b>";
            crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_hit);
            crit_string = "<br/> <i><font color=gray><b>Critical Hit Table Result:</b>" + crit_result.notes + "</font></i>";
        } else {
            hit_miss = DieRoller.isSuccess(roll, eff_skill) ? "<b>hit</b>" : "miss";
        }
        boolean isHit = DieRoller.isSuccess(roll, eff_skill);
        Damage damage = Damage.ParseDamage(attack.Damage);
        if (attack.Unbalanced) {
            this.setTemp("numParry", this.getTempInt("numParry") + 1);
        }
        String armorDivStr = "";
        if (damage.ArmorDivisor != 1.0) {
            armorDivStr = damage.ArmorDivisor == (double)((int)damage.ArmorDivisor) ? "(" + String.format("%d", (int)damage.ArmorDivisor) + ")" : "(" + String.format("%s", damage.ArmorDivisor) + ")";
        }
        this.logEventTypeName("attacks with " + attack.Name + ": " + hit_miss + " (" + roll + "/" + eff_skill + "=" + margin + ") for damage " + (isHit ? "<font color=red><b>" : "") + damage.BasicDamage + armorDivStr + " " + (Object)((Object)damage.Type) + (isHit ? "</b></font>" : "") + " (" + attack.Damage + ")" + crit_string);
    }

    public void Attack() {
        if (this.attacks.size() < 1) {
            this.logEventTypeName("<i><font color=gray>has no attacks defined!</font></i>");
            return;
        }
        if (this.defaultAttack < 0 || this.defaultAttack >= this.attacks.size()) {
            this.logEventError("has invalid default attack: " + this.defaultAttack);
            return;
        }
        this.Attack(this.defaultAttack);
    }

    public String Defend(Defense defense) {
        this.RecordDefenseAttempt(defense);
        this.LogDefenseResults(defense);
        this.ProcessDefenseResults(defense);
        this.KnockdownStunningCheck(defense);
        return "";
    }

    private void RecordDefenseAttempt(Defense defense) {
        int Fatigue = this.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
        this.setTrait(ActorBase.BasicTrait.Fatigue, String.valueOf(Fatigue + defense.fatigue));
        this.setTemp("shieldDamage", this.getTempInt("shieldDamage") + defense.shieldDamage);
        switch (defense.type) {
            case Parry: {
                this.setTemp("numParry", this.getTempInt("numParry") + 1);
                break;
            }
            case Block: {
                this.setTemp("numBlock", this.getTempInt("numBlock") + 1);
            }
        }
    }

    private void LogDefenseResults(Defense defense) {
        String resultType = defense.result == Defense.DefenseResult.CritSuccess ? "<b><font color=blue>critically</font></b>" : (defense.result == Defense.DefenseResult.Success ? "successfully" : (defense.result == Defense.DefenseResult.ShieldHit ? "partially" : "unsuccessfully"));
        String defenseDescription = "";
        switch (defense.type) {
            case Parry: {
                defenseDescription = String.valueOf(resultType) + " parried blow.";
                break;
            }
            case Block: {
                defenseDescription = String.valueOf(resultType) + " blocked blow.";
                break;
            }
            case Dodge: {
                defenseDescription = String.valueOf(resultType) + " dodged blow.";
                break;
            }
            case None: {
                defenseDescription = "made no defense against blow.";
            }
        }
        if (defense.result == Defense.DefenseResult.CritFailure) {
            defenseDescription = "<b><font color=red>critically</font></b> failed " + defense.type.toString().toLowerCase() + ".";
        }
        String damageDescription = "";
        if (defense.injury != 0) {
            String knockdownstunningPenalty;
            damageDescription = " Sustained <b><font color=red>" + defense.injury + "</font></b> injury to the " + defense.location.type.name();
            String string = knockdownstunningPenalty = defense.location.knockdownPenalty != 0 ? " @ " + defense.location.knockdownPenalty : "";
            if (defense.cripplingInjury) {
                damageDescription = String.valueOf(damageDescription) + " <b>(crippling" + knockdownstunningPenalty + ")</br>";
            } else if (defense.majorWound) {
                damageDescription = String.valueOf(damageDescription) + " <b>(major" + knockdownstunningPenalty + ")</br>";
            }
            damageDescription = String.valueOf(damageDescription) + ".";
        } else if (defense.result == Defense.DefenseResult.ShieldHit || defense.result == Defense.DefenseResult.Failure) {
            damageDescription = " But took no injury.";
        }
        if (defense.shieldDamage != 0) {
            damageDescription = String.valueOf(damageDescription) + " <b>Shield damaged " + defense.shieldDamage + ".</b>";
        }
        this.logEventTypeName(String.valueOf(defenseDescription) + damageDescription);
    }

    private void ProcessDefenseResults(Defense defense) {
        this.setTrait(ActorBase.BasicTrait.Injury, String.valueOf(this.getTraitValueInt(ActorBase.BasicTrait.Injury) + defense.injury));
        if (defense.result == Defense.DefenseResult.CritFailure) {
            switch (defense.type) {
                case Parry: {
                    CriticalTables.Entry crit_result = CriticalTables.getRandomEntry(CriticalTables.critical_miss);
                    String crit_string = "<i><font color=gray><b>Critical Miss Table Result:</b>" + crit_result.notes + "</font></i>";
                    this.logEventTypeName(crit_string);
                    break;
                }
                case Block: {
                    this.logEventTypeName("Loses grip on shield, must ready before next block");
                    break;
                }
                case Dodge: {
                    if (!this.hasStatus(ActorBase.ActorStatus.Prone)) {
                        this.logEventTypeName("Falls prone.");
                    }
                    this.setPosture(ActorBase.ActorStatus.Prone);
                    break;
                }
                case None: {
                    System.err.println("-E- unexpected 'None' defense type for critical failure!");
                }
            }
        }
    }

    private void KnockdownStunningCheck(Defense defense) {
        int HT = this.getTraitValueInt(ActorBase.BasicTrait.HT);
        int HP = this.getTraitValueInt(ActorBase.BasicTrait.HP);
        if (defense.cripplingInjury || defense.majorWound || (double)defense.injury >= (double)HP / 10.0 && (defense.location.headWound || defense.location.knockdownPenalty < 0)) {
            int effHT = HT;
            String knockdownDescription = "";
            if (defense.cripplingInjury) {
                effHT += defense.location.knockdownPenalty;
                knockdownDescription = " for crippling injury";
            } else if (defense.majorWound) {
                effHT += defense.location.knockdownPenalty;
                knockdownDescription = " for major wound";
            }
            if (this.hasTrait("HPT")) {
                effHT += 3;
            }
            if (this.hasTrait("LPT")) {
                effHT -= 4;
            }
            int roll = DieRoller.roll3d6();
            boolean success = DieRoller.isSuccess(roll, effHT);
            this.logEventTypeName("Knockdown/Stunning check" + knockdownDescription + ": rolled " + roll + " against " + effHT + " => " + (!success ? "<b>failed</b>" : "succeeded"));
            if (this.isTypeAutomated() && Actor.settings.AUTO_KNOCKDOWNSTUN && !success) {
                this.addStatus(ActorBase.ActorStatus.StunPhys);
                this.removeStatus(ActorBase.ActorStatus.StunRecovr);
                this.setPosture(ActorBase.ActorStatus.Prone);
                this.addStatus(ActorBase.ActorStatus.Disarmed);
            }
        }
    }

    public int getCurrentDefenseValue(Defense.DefenseType type) {
        int Parry = this.getTraitValueInt(ActorBase.BasicTrait.Parry);
        int Block = this.getTraitValueInt(ActorBase.BasicTrait.Block);
        int Dodge = this.getTraitValueInt(ActorBase.BasicTrait.Dodge);
        int Injury = this.getTraitValueInt(ActorBase.BasicTrait.Injury);
        int Fatigue = this.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
        int HP = this.getTraitValueInt(ActorBase.BasicTrait.HP);
        int FP = this.getTraitValueInt(ActorBase.BasicTrait.FP);
        int currentDefense = 0;
        switch (type) {
            case Parry: {
                currentDefense = Parry - this.getTempInt("numParry") * 4;
                break;
            }
            case Block: {
                currentDefense = Block - this.getTempInt("numBlock") * 5;
                break;
            }
            case Dodge: {
                currentDefense = Dodge;
                if (Injury > 2 * HP / 3) {
                    currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
                }
                if (Fatigue <= 2 * FP / 3) break;
                currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
            }
        }
        return currentDefense;
    }
}

