/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Attack;
import gurpsinittool.data.GameSettings;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogEventSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ActorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final EncounterLogEventSource LogEventSource = new EncounterLogEventSource();
    public static GameSettings settings;
    private transient PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    private HashSet<ActorStatus> statuses;
    protected ActorType type;
    protected HashMap<String, Trait> traits = new HashMap();
    protected int defaultAttack = 0;
    protected ArrayList<Attack> attacks;
    protected HashMap<String, Trait> temps = new HashMap();

    public ActorBase() {
        this("", ActorType.Enemy);
    }

    public ActorBase(String name, ActorType type) {
        this.statuses = new HashSet();
        this.type = type;
        this.InitializeBasicTraits();
        this.setTrait(BasicTrait.Name, name);
        this.attacks = new ArrayList();
    }

    public ActorBase(ActorBase anActor) {
        this(anActor.getTrait((BasicTrait)BasicTrait.Name).value, anActor.type);
        this.statuses.addAll(anActor.statuses);
        Iterator<Trait> iterator = anActor.traits.values().iterator();
        while (iterator.hasNext()) {
            Trait value;
            Trait trait = value = iterator.next();
            this.setTrait(trait.name, trait.value);
        }
        int i = 0;
        while (i < anActor.attacks.size()) {
            this.attacks.add(anActor.attacks.get(i));
            ++i;
        }
    }

    private void InitializeBasicTraits() {
        String[] defaultBasicTraitValues = new String[]{"unnamed", "10", "10", "5.00", "10", "10", "5", "10", "10", "10", "10", "0", "0", "0", "8", "9", "9", "0", "2", "4", "20", ""};
        BasicTrait[] traitNames = BasicTrait.values();
        int i = 0;
        while (i < traitNames.length) {
            String traitValue = defaultBasicTraitValues[i];
            String traitName = traitNames[i].toString();
            this.addTrait(traitName, traitValue);
            ++i;
        }
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mPcs = new PropertyChangeSupport(this);
    }

    public boolean hasStatus(ActorStatus status) {
        return this.statuses.contains((Object)status);
    }

    public void addStatus(ActorStatus status) {
        if (!this.statuses.contains((Object)status)) {
            this.statuses.add(status);
            if (ActorBase.settings.LOG_STATUSCHANGES) {
                this.logEventTypeName("added status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
            }
            this.mPcs.firePropertyChange("Status", null, (Object)status);
        }
    }

    public HashSet<ActorStatus> getAllStatuses() {
        return new HashSet<ActorStatus>(this.statuses);
    }

    public void setAllStatuses(HashSet<ActorStatus> newStatuses) {
        if (!this.statuses.containsAll(newStatuses) || !newStatuses.containsAll(this.statuses)) {
            String oldStatuses = this.getStatusesString();
            this.statuses.clear();
            this.statuses.addAll(newStatuses);
            if (ActorBase.settings.LOG_STATUSCHANGES) {
                this.logEventTypeName("status set to <b>[" + this.getStatusesString() + "]</b>");
            }
            this.mPcs.firePropertyChange("Statuses", oldStatuses, this.getStatusesString());
        }
    }

    public void removeStatus(ActorStatus status) {
        if (this.statuses.contains((Object)status)) {
            this.statuses.remove((Object)status);
            if (ActorBase.settings.LOG_STATUSCHANGES) {
                this.logEventTypeName("removed status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
            }
            this.mPcs.firePropertyChange("Status", (Object)status, null);
        }
    }

    public void clearStatuses() {
        if (this.statuses.size() > 0) {
            int size = this.statuses.size();
            this.statuses.clear();
            this.mPcs.firePropertyChange("Status", (Object)size, null);
        }
    }

    public String getStatusesString() {
        int[] scodes = new int[this.statuses.size()];
        int i = 0;
        for (ActorStatus as : this.statuses) {
            scodes[i++] = as.ordinal();
        }
        Arrays.sort(scodes);
        String text = "";
        int j = 0;
        while (j < scodes.length) {
            if (j != 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ActorStatus.values()[scodes[j]].toString();
            ++j;
        }
        return text;
    }

    public void setPosture(ActorStatus posture) {
        if (posture == ActorStatus.Kneeling) {
            this.removeStatus(ActorStatus.Prone);
            this.addStatus(posture);
        } else if (posture == ActorStatus.Prone) {
            this.removeStatus(ActorStatus.Kneeling);
            this.addStatus(posture);
        } else if (posture == null) {
            this.removeStatus(ActorStatus.Kneeling);
            this.removeStatus(ActorStatus.Prone);
        }
    }

    public ActorType getType() {
        return this.type;
    }

    public void setType(ActorType type) {
        if (this.type != type) {
            ActorType oldType = this.type;
            this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> type changed to <b>" + (Object)((Object)type) + "</b>");
            this.type = type;
            this.mPcs.firePropertyChange("Type", (Object)oldType, (Object)type);
        }
    }

    public boolean isTypeAutomated() {
        return this.type == ActorType.Enemy || this.type == ActorType.Ally || this.type == ActorType.Neutral;
    }

    public int getDefaultAttack() {
        return this.defaultAttack;
    }

    public void setDefaultAttack(int index) {
        if (this.defaultAttack != index && index < this.attacks.size()) {
            int oldDefault = this.defaultAttack;
            this.defaultAttack = index;
            this.mPcs.firePropertyChange("DefaultAttack", oldDefault, this.defaultAttack);
        }
    }

    public int getNumAttacks() {
        return this.attacks.size();
    }

    public Attack getAttack(int index) {
        return this.attacks.get(index);
    }

    public void addAttack(Attack attack) {
        this.attacks.add(attack);
        this.mPcs.firePropertyChange("Attacks", this.attacks.size() - 1, this.attacks.size());
    }

    public void removeAttack(int index) {
        if (index < this.attacks.size()) {
            if (index < this.defaultAttack) {
                --this.defaultAttack;
            }
            if (index == this.defaultAttack) {
                this.defaultAttack = 0;
            }
            this.attacks.remove(index);
            this.mPcs.firePropertyChange("Attacks", this.attacks.size() + 1, this.attacks.size());
        }
    }

    public boolean hasTrait(String name) {
        return this.traits.containsKey(name);
    }

    public static boolean isBasicTrait(String name) {
        BasicTrait[] basicTraitArray = BasicTrait.values();
        int n = basicTraitArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicTrait b = basicTraitArray[n2];
            if (b.name().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Trait getTrait(String name) {
        if (!this.traits.containsKey(name)) {
            System.out.println("-E- Actor:GetTrait: requested trait that does not exist: " + name);
            return null;
        }
        return this.traits.get(name);
    }

    private Trait getTrait(BasicTrait trait) {
        return this.traits.get(trait.toString());
    }

    public String getTraitValue(String name) {
        return this.getTrait((String)name).value;
    }

    public String getTraitValue(BasicTrait trait) {
        return this.getTrait((BasicTrait)trait).value;
    }

    public int getTraitValueInt(BasicTrait trait) {
        try {
            return Integer.parseInt(this.getTrait((BasicTrait)trait).value);
        }
        catch (NumberFormatException e) {
            System.err.println("Actor: getValueInt: Error parsing value: " + this.getTrait((BasicTrait)trait).value);
            e.printStackTrace();
            return 0;
        }
    }

    public ArrayList<String> getTraitValueArray(String name) {
        if (this.hasTrait(name)) {
            return new ArrayList<String>(Arrays.asList(this.getTrait((String)name).value.split("\\s*;\\s*")));
        }
        return new ArrayList<String>();
    }

    public Collection<String> getAllTraitNames() {
        return this.traits.keySet();
    }

    public void setTrait(String name, String value) {
        if (!this.hasTrait(name)) {
            System.err.println("Actor.setTrait: trait does not exist: " + name);
            return;
        }
        Trait trait = this.getTrait(name);
        if (!trait.value.equals(value)) {
            String oldValue = trait.value;
            if (name == "Injury") {
                int newValue = Integer.valueOf(value);
                newValue = Math.max(newValue, 0);
                value = String.valueOf(newValue);
                int HP = this.getTraitValueInt(BasicTrait.HP);
                int diff = this.getTraitValueInt(BasicTrait.Injury) - newValue;
                if (diff < 0) {
                    this.setTemp("shock.next", this.getTempInt("shock.next") - diff);
                    this.logEventTypeName("took <b><font color=red>" + -1 * diff + "</font></b> damage (now " + (HP - newValue) + " HP).");
                } else {
                    this.logEventTypeName("healed <b><font color=blue>" + diff + "</font></b> (now " + (HP - newValue) + " HP).");
                }
            } else if (name == "Fatigue") {
                int newValue = Integer.valueOf(value);
                newValue = Math.max(newValue, 0);
                value = String.valueOf(newValue);
                int FP = this.getTraitValueInt(BasicTrait.FP);
                int diff = this.getTraitValueInt(BasicTrait.Fatigue) - newValue;
                if (diff < 0) {
                    this.logEventTypeName("lost <b>" + -1 * diff + "</b> fatigue (now " + (FP - newValue) + " FP).");
                } else {
                    this.logEventTypeName("recoverd <b>" + diff + "</b> fatigue (now " + (FP - newValue) + " FP).");
                }
            }
            trait.value = value;
            this.mPcs.firePropertyChange("trait." + name, oldValue, value);
        }
    }

    public void setTrait(BasicTrait trait, String value) {
        this.setTrait(trait.toString(), value);
    }

    public void setTrait(BasicTrait trait, int value) {
        this.setTrait(trait, String.valueOf(value));
    }

    public void setTrait(String name, int value) {
        this.setTrait(name, String.valueOf(value));
    }

    public boolean addTrait(String name, String value) {
        if (this.hasTrait(name)) {
            System.err.println("Actor.addTrait: trait already exists! " + name);
            return false;
        }
        Trait newTrait = new Trait(name, value);
        this.traits.put(name, newTrait);
        this.mPcs.firePropertyChange("trait." + name, null, value);
        return true;
    }

    public boolean removeTrait(String name) {
        if (ActorBase.isBasicTrait(name)) {
            System.out.println("-E- removeTrait: cannot remove basic traits! => " + name);
            return false;
        }
        if (!this.hasTrait(name)) {
            System.out.println("-E- removeTrait: cannot remove non-existant trait! => " + name);
            return false;
        }
        String oldValue = this.getTraitValue(name);
        this.traits.remove(name);
        this.mPcs.firePropertyChange("trait." + name, oldValue, null);
        return true;
    }

    public boolean renameTrait(String oldName, String newName) {
        if (ActorBase.isBasicTrait(oldName)) {
            System.out.println("-E- renameTrait: Cannot rename BasicTrait! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        if (this.hasTrait(newName)) {
            System.out.println("-E- renameTrait: New trait name already exists! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        if (!this.hasTrait(oldName)) {
            System.out.println("-E- renameTrait: Old name does not exist! oldName: " + oldName + ", newName: " + newName);
            return false;
        }
        Trait trait = this.getTrait(oldName);
        String value = trait.value;
        trait.name = newName;
        this.traits.remove(oldName);
        this.mPcs.firePropertyChange("trait." + oldName, value, null);
        this.traits.put(newName, trait);
        this.mPcs.firePropertyChange("trait." + newName, null, value);
        return true;
    }

    public boolean hasTemp(String name) {
        return this.temps.containsKey(name);
    }

    private Trait getTemp(String name) {
        return this.temps.get(name);
    }

    public String getTempValue(String name) {
        return this.temps.get((Object)name).value;
    }

    public int getTempInt(String name) {
        return Integer.parseInt(this.getTemp((String)name).value);
    }

    public void setTemp(String name, String value) {
        if (this.hasTemp(name)) {
            this.getTemp((String)name).value = value;
        } else {
            Trait newTrait = new Trait(name, value);
            this.temps.put(name, newTrait);
        }
    }

    public void setTemp(String name, int value) {
        this.setTemp(name, String.valueOf(value));
    }

    public Collection<String> getAllTempNames() {
        return this.temps.keySet();
    }

    protected void logEvent(String text) {
        if (LogEventSource != null) {
            LogEventSource.fireEncounterLogEvent(new EncounterLogEvent(this, text));
        }
    }

    protected void logEventTypeName(String text) {
        String prepend = "";
        String color = "";
        switch (this.type) {
            case Enemy: {
                color = "red";
                break;
            }
            case Ally: {
                color = "blue";
                break;
            }
            case Neutral: {
                color = "grey";
                break;
            }
            case PC: {
                color = "green";
                break;
            }
            case Special: {
                color = "purple";
            }
        }
        prepend = String.valueOf(prepend) + "[<b><font color=" + color + ">" + this.type.toString() + "</font></b>] ";
        prepend = String.valueOf(prepend) + "<b>" + this.getTraitValue(BasicTrait.Name) + "</b> ";
        this.logEvent(String.valueOf(prepend) + text);
    }

    protected void logEventError(String text) {
        this.logEventTypeName("<i><b><font color=red>-E-: " + text + "</font></b></i>");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    public static enum ActorStatus {
        Attacking,
        Disarmed,
        StunPhys,
        StunMental,
        StunRecovr,
        Kneeling,
        Prone,
        Waiting,
        Disabled,
        Unconscious,
        Dead;

    }

    public static enum ActorType {
        PC,
        Enemy,
        Ally,
        Neutral,
        Special;

    }

    public static enum BasicTrait {
        Name,
        ST,
        HP,
        Speed,
        DX,
        Will,
        Move,
        IQ,
        Per,
        HT,
        FP,
        SM,
        Fatigue,
        Injury,
        Dodge,
        Parry,
        Block,
        DR,
        Shield_DB,
        Shield_DR,
        Shield_HP,
        Notes;

    }

    private class Trait
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public String value;

        public Trait(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

