/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import gurpsinittool.data.Damage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DR {
    private int base;
    private int cr_mod;

    public DR(int base) {
        this(base, 0);
    }

    public DR(int base, int cr_mod) {
        this.base = base;
        this.cr_mod = cr_mod;
    }

    public static DR ParseDR(String DRString) throws ParseException {
        Pattern empty = Pattern.compile("^$");
        Pattern num = Pattern.compile("^(\\d+)$");
        Pattern split = Pattern.compile("^(\\d+)/(\\d+)$");
        Matcher matcher = empty.matcher(DRString);
        if (matcher.matches()) {
            return new DR(0);
        }
        matcher = num.matcher(DRString);
        if (matcher.matches()) {
            int base = Integer.parseInt(matcher.group(1));
            return new DR(base);
        }
        matcher = split.matcher(DRString);
        if (matcher.matches()) {
            int base = Integer.parseInt(matcher.group(1));
            int cr_num = Integer.parseInt(matcher.group(2));
            return new DR(base, cr_num - base);
        }
        System.out.println("-E- DR:ParseDR: unable to parse string! " + DRString);
        throw new ParseException("ParseDR: Unable to parse string: " + DRString, 0);
    }

    public int getDRforType(Damage.DamageType type) {
        switch (type) {
            case aff: 
            case burn: 
            case cor: 
            case cut: 
            case fat: 
            case imp: 
            case pi_: 
            case pi: 
            case pi4: 
            case pi44: 
            case spec: 
            case tbb: 
            case tox: {
                return this.base;
            }
            case cr: {
                return this.base + this.cr_mod;
            }
        }
        System.out.println("-E- DR:getDRforType: unhandled type! " + type.toString());
        return 0;
    }
}

