/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import gurpsinittool.data.HitLocations;
import gurpsinittool.util.DieRoller;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Damage {
    public int BasicDamage;
    public double ArmorDivisor;
    public boolean Explosive;
    public DamageType Type;

    public Damage(int basic, DamageType type) {
        this(basic, 1.0, type, false);
    }

    public Damage(int basic, double divisor, DamageType type, boolean explosive) {
        this.BasicDamage = basic;
        this.ArmorDivisor = divisor;
        this.Type = type;
        this.Explosive = explosive;
        int min_damage = type == DamageType.cr ? 0 : 1;
        this.BasicDamage = this.BasicDamage < min_damage ? min_damage : this.BasicDamage;
    }

    public static Damage ParseDamage(String damage) throws ParseException {
        Pattern empty = Pattern.compile("^$");
        Pattern numdivtype = Pattern.compile("^(\\d+)\\s*(\\(([\\d\\.]+)\\))?\\s*([^d\\d\\s]+)?\\s*(ex)?$");
        Pattern dicedivtype = Pattern.compile("^(\\d+)d[+]?([-]?\\d+)?\\s*(\\(([\\d\\.]+)\\))?\\s*([^d\\d\\s]+)?\\s*(ex)?$");
        Matcher matcher = empty.matcher(damage);
        if (matcher.matches()) {
            return new Damage(0, DamageType.cr);
        }
        matcher = numdivtype.matcher(damage);
        if (matcher.matches()) {
            int num = Integer.parseInt(matcher.group(1));
            double div = matcher.group(3) != null ? Double.parseDouble(matcher.group(3)) : 1.0;
            DamageType type = matcher.group(4) != null ? Damage.ParseType(matcher.group(4)) : DamageType.cut;
            boolean explosive = matcher.group(5) != null;
            return new Damage(num, div, type, explosive);
        }
        matcher = dicedivtype.matcher(damage);
        if (matcher.matches()) {
            int dice = Integer.parseInt(matcher.group(1));
            int adds = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
            double div = matcher.group(4) != null ? Double.parseDouble(matcher.group(4)) : 1.0;
            DamageType type = matcher.group(5) != null ? Damage.ParseType(matcher.group(5)) : DamageType.cut;
            boolean explosive = matcher.group(6) != null;
            return new Damage(DieRoller.rollDiceAdds(dice, adds), div, type, explosive);
        }
        System.out.println("-E- Damage:ParseDamage: unable to parse string! " + damage);
        throw new ParseException("ParseDamage: Unable to parse string: " + damage, 0);
    }

    public double DamageMultiplier() {
        return Damage.DamageMultiplier(this.Type);
    }

    public double DamageMultiplier(HitLocations.HitLocation location) {
        return location.DamageMultiplier(this.Type);
    }

    public double DamageMultiplierHomogenous() {
        return Damage.DamageMultiplierHomogenous(this.Type);
    }

    public double DamageMultiplierHomogenous(HitLocations.HitLocation location) {
        double locmult = location.DamageMultiplier(this.Type);
        if (locmult > this.DamageMultiplier()) {
            return locmult;
        }
        return this.DamageMultiplierHomogenous();
    }

    public double DamageMultiplierUnliving() {
        return Damage.DamageMultiplierUnliving(this.Type);
    }

    public double DamageMultiplierUnliving(HitLocations.HitLocation location) {
        double locmult = location.DamageMultiplier(this.Type);
        if (locmult > this.DamageMultiplier()) {
            return locmult;
        }
        return this.DamageMultiplierUnliving();
    }

    public int DamageMaxDiffuse() {
        if (this.Explosive) {
            return Integer.MAX_VALUE;
        }
        return Damage.DamageMaxDiffuse(this.Type);
    }

    public static DamageType ParseType(String type) throws ParseException {
        type = type.replace('-', '_');
        type = type.replace('+', '4');
        try {
            return DamageType.valueOf(type);
        }
        catch (Exception e) {
            System.out.println("-E- ParseType: unable to parse string! " + type);
            throw new ParseException("ParseType: Unable to parse string: " + type, 0);
        }
    }

    public static double DamageMultiplier(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case pi: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: 
            case pi4: {
                return 1.5;
            }
            case imp: 
            case pi44: {
                return 2.0;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        System.out.println("-E- Damage:DamageMultiplier: unhandled type! " + type.toString());
        return 0.0;
    }

    public static double DamageMultiplierUnliving(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.2;
            }
            case pi: {
                return 0.334;
            }
            case pi4: {
                return 0.5;
            }
            case imp: 
            case pi44: {
                return 1.0;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        System.out.println("-E- DamageMultiplierUnliving: unhandled type! " + type.toString());
        return 0.0;
    }

    public static double DamageMultiplierHomogenous(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.1;
            }
            case pi: {
                return 0.2;
            }
            case pi4: {
                return 0.334;
            }
            case imp: 
            case pi44: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        System.out.println("-E- Damage:DamageMultiplierHomogenous: unhandled type! " + type.toString());
        return 0.0;
    }

    public static int DamageMaxDiffuse(DamageType type) {
        switch (type) {
            case imp: 
            case pi_: 
            case pi: 
            case pi4: 
            case pi44: {
                return 1;
            }
            case burn: 
            case cor: 
            case cr: 
            case cut: 
            case tbb: 
            case tox: {
                return 2;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0;
            }
        }
        System.out.println("-E- DamageMaxDiffuse: unhandled type! " + type.toString());
        return 0;
    }

    public static enum DamageType {
        aff,
        burn,
        cor,
        cr,
        cut,
        fat,
        imp,
        pi_,
        pi,
        pi4,
        pi44,
        spec,
        tbb,
        tox;

    }
}

