/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.ui.DefenseDialog;
import gurpsinittool.util.GAction;
import gurpsinittool.util.MiscUtil;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class GameMaster {
    private Integer round = 0;
    private Integer activeActor = -1;
    private static final boolean DEBUG = false;
    private PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    public InitTable initTable;
    public DefenseDialog defenseDialog;
    public Action actionNextActor;
    public Action actionEndRound;
    public Action actionNextRound;
    public Action actionResetRound;
    public Action actionTagActors;
    public Action actionAttack;
    public Action actionDefend;
    public Action actionPostureStanding;
    public Action actionPostureKneeling;
    public Action actionPostureProne;
    public Action actionStatusTogglePhysicalStun;
    public Action actionStatusToggleMentalStun;
    public Action actionStatusToggleRecoveringStun;
    public Action actionStatusToggleAttacking;
    public Action actionStatusToggleDisarmed;
    public Action actionStatusToggleUnconscious;
    public Action actionStatusToggleDead;
    public Action actionCoordinateSelectedStatusPhysicalStun;
    public Action actionCoordinateSelectedStatusMentalStun;
    public Action actionCoordinateSelectedStatusRecoveringStun;
    public Action actionCoordinateSelectedStatusAttacking;
    public Action actionCoordinateSelectedStatusDisarmed;
    public Action actionCoordinateSelectedStatusUnconscious;
    public Action actionCoordinateSelectedStatusDead;
    public Action actionCoordinateSelectedStatusWaiting;
    public Action actionCoordinateSelectedStatusDisabled;
    public Action actionSetSelectedTypePC;
    public Action actionSetSelectedTypeAlly;
    public Action actionSetSelectedTypeNeutral;
    public Action actionSetSelectedTypeEnemy;
    public Action actionSetSelectedTypeSpecial;
    public Action actionDeleteSelectedActors;
    public Action actionResetSelectedActors;
    public Action actionSetSelectedActorActive;
    public Action actionTagSelectedActors;
    public Action actionRemoveTagSelectedActors;
    private static Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
    private static int flagMaxNum = 6;

    public GameMaster() {
        this.initializeActions();
    }

    public int getActiveActor() {
        return this.activeActor;
    }

    public int getRound() {
        return this.round;
    }

    private void selectActiveActor() {
        if (this.activeActor != -1) {
            this.initTable.setRowSelectionInterval(this.activeActor, this.activeActor);
        } else {
            this.initTable.clearSelection();
        }
    }

    private void setActiveActor(int newValue) {
        int oldValue = this.activeActor;
        this.activeActor = newValue;
        this.mPcs.firePropertyChange("ActiveActor", oldValue, newValue);
    }

    private void setRound(int newValue) {
        int oldValue = this.round;
        this.round = newValue;
        this.mPcs.firePropertyChange("Round", oldValue, newValue);
    }

    public void addActor(Actor actor, int position) {
        if (position <= this.activeActor) {
            this.activeActor = this.activeActor + 1;
        }
        this.initTable.getActorTableModel().addActor(actor, position);
    }

    public void removeActor(int row) {
        if (row < this.activeActor) {
            this.activeActor = this.activeActor - 1;
        } else if (row == this.activeActor) {
            this.activeActor = this.activeActor - 1;
            this.nextActor();
        }
        this.initTable.getActorTableModel().removeActor(row);
    }

    public void removeActor(Actor actor) {
        int[] rows = this.initTable.getActorTableModel().getActorRows(actor);
        int i = rows.length - 1;
        while (i >= 0) {
            this.removeActor(rows[i]);
            --i;
        }
    }

    private boolean nextActor() {
        Actor currentActor;
        if (this.activeActor == -1) {
            this.setRound(this.round + 1);
        }
        boolean retval = false;
        int actorRow = this.activeActor;
        do {
            if (++actorRow >= this.initTable.getActorTableModel().getRowCount() - 1) {
                actorRow = -1;
                retval = true;
                break;
            }
            currentActor = this.initTable.getActorTableModel().getActor(actorRow);
            currentActor.NextTurn();
        } while (currentActor.hasStatus(ActorBase.ActorStatus.Disabled) || currentActor.hasStatus(ActorBase.ActorStatus.Unconscious) || currentActor.hasStatus(ActorBase.ActorStatus.Dead) || currentActor.hasStatus(ActorBase.ActorStatus.Waiting));
        this.setActiveActor(actorRow);
        return retval;
    }

    protected void nextRound() {
        if (this.activeActor != -1) {
            this.endRound();
        }
        this.nextActor();
    }

    protected void endRound() {
        while (!this.nextActor()) {
        }
    }

    private void coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus status) {
        Actor a;
        Actor[] actors;
        this.initTable.stopCellEditing();
        boolean all_set = true;
        Actor[] actorArray = actors = this.initTable.getSelectedActors();
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            a = actorArray[n2];
            if (!a.hasStatus(status)) {
                all_set = false;
                break;
            }
            ++n2;
        }
        actorArray = actors;
        n = actors.length;
        n2 = 0;
        while (n2 < n) {
            a = actorArray[n2];
            if (all_set) {
                a.removeStatus(status);
            } else {
                a.addStatus(status);
            }
            ++n2;
        }
    }

    private void toggleStatusOfSelectedActors(ActorBase.ActorStatus status) {
        this.initTable.stopCellEditing();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            if (a.hasStatus(status)) {
                a.removeStatus(status);
            } else {
                a.addStatus(status);
            }
            ++n2;
        }
    }

    private void modifyStatusOfSelectedActors(ActorBase.ActorStatus status, boolean add) {
        this.initTable.stopCellEditing();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            if (add) {
                a.addStatus(status);
            } else {
                a.removeStatus(status);
            }
            ++n2;
        }
    }

    private void setSelectedType(ActorBase.ActorType t) {
        this.initTable.stopCellEditing();
        Actor[] actorArray = this.initTable.getSelectedActors();
        int n = actorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Actor a = actorArray[n2];
            a.setType(t);
            ++n2;
        }
    }

    private static String getNextTag(HashSet<String> tags) {
        flagColors[] flagColorsArray = flagColors.values();
        int n = flagColorsArray.length;
        int n2 = 0;
        while (n2 < n) {
            flagColors color = flagColorsArray[n2];
            int i = 1;
            while (i <= flagMaxNum) {
                String tag = String.valueOf(color.toString()) + i;
                if (!tags.contains(tag)) {
                    return tag;
                }
                ++i;
            }
            ++n2;
        }
        System.out.println("-W- GameMaster:getNextTag: no free tags!");
        return "S99";
    }

    private void autoTagActors() {
        HashSet<String> tags = this.catalogTags(true);
        int i = 0;
        while (i < this.initTable.getActorTableModel().getRowCount() - 1) {
            Actor a = this.initTable.getActorTableModel().getActor(i);
            if (!(!a.isTypeAutomated() || a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead) || a.hasStatus(ActorBase.ActorStatus.Waiting))) {
                this.tagActor(a, tags);
            }
            ++i;
        }
    }

    private void removeTag(Actor actor) {
        String aName;
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        Matcher matcher = nameTag.matcher(aName = actor.getTraitValue(ActorBase.BasicTrait.Name));
        if (matcher.matches()) {
            String name = matcher.group(1);
            actor.setTrait(ActorBase.BasicTrait.Name, name);
        }
    }

    private void tagActor(Actor actor) {
        this.tagActor(actor, this.catalogTags(false));
    }

    private void tagActor(Actor actor, HashSet<String> tags) {
        String aName = actor.getTraitValue(ActorBase.BasicTrait.Name);
        if (!nameTag.matcher(aName).matches()) {
            String tag = GameMaster.getNextTag(tags);
            actor.setTrait(ActorBase.BasicTrait.Name, String.valueOf(aName) + " [" + tag + "]");
            tags.add(tag);
        }
    }

    private HashSet<String> catalogTags(boolean clean) {
        Pattern nameTag = Pattern.compile("^(.*) \\[([^\\s]+)\\]$");
        HashSet<String> tags = new HashSet<String>();
        int i = 0;
        while (i < this.initTable.getActorTableModel().getRowCount() - 1) {
            Actor a = this.initTable.getActorTableModel().getActor(i);
            String aName = a.getTraitValue(ActorBase.BasicTrait.Name);
            Matcher matcher = nameTag.matcher(aName);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String tag = matcher.group(2);
                if (clean && a.isTypeAutomated() && (a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead))) {
                    System.out.println("GameMaster:catalogTags: cleaning tag: " + tag);
                    a.setTrait(ActorBase.BasicTrait.Name, name);
                } else {
                    if (tags.contains(tag)) {
                        System.out.println("-W- GameMaster:catalogTags: Duplicate tag detected! " + tag);
                    }
                    tags.add(tag);
                }
            }
            ++i;
        }
        return tags;
    }

    private void initializeActions() {
        this.actionNextActor = new GAction("Next Combatant", "Move to the next active combatant in the turn sequence (Ctrl+N)", new ImageIcon("src/resources/images/control_play_blue.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.nextActor();
                GameMaster.this.selectActiveActor();
            }
        };
        this.actionEndRound = new GAction("End Round", "Step to the end of the turn sequence (Ctrl+E)", new ImageIcon("src/resources/images/control_end_blue.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.endRound();
                GameMaster.this.selectActiveActor();
            }
        };
        this.actionNextRound = new GAction("Next Round", "Step to the start of the next round sequence (Ctrl+R)", new ImageIcon("src/resources/images/control_fastforward_blue.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.nextRound();
                GameMaster.this.selectActiveActor();
            }
        };
        this.actionResetRound = new GAction("Reset Round Counter", "Reset the round counter (Alt+R)", new ImageIcon("src/resources/images/control_start_blue.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setRound(0);
                GameMaster.this.setActiveActor(-1);
                GameMaster.this.nextActor();
            }
        };
        this.actionDeleteSelectedActors = new GAction("Delete", "Delete the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                int result = JOptionPane.showConfirmDialog(GameMaster.this.initTable, "Are you sure you want to delete these rows?", "Confirm Row Delete", 2);
                if (result == 0) {
                    int[] rows = GameMaster.this.initTable.getSelectedRows();
                    int i = rows.length - 1;
                    while (i >= 0) {
                        GameMaster.this.removeActor(rows[i]);
                        --i;
                    }
                }
            }
        };
        this.actionResetSelectedActors = new GAction("Reset", "Reset the state of the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    a.Reset();
                    ++n2;
                }
            }
        };
        this.actionSetSelectedActorActive = new GAction("Set Active", "Set the selected combatant to be currently active", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                int[] rows = GameMaster.this.initTable.getSelectedRows();
                GameMaster.this.setActiveActor(rows[0]);
                GameMaster.this.initTable.getActorTableModel().getActor(GameMaster.this.activeActor).removeStatus(ActorBase.ActorStatus.Waiting);
            }
        };
        this.actionTagActors = new GAction("Update Tags", "Update all tags (Ctrl+T)", new ImageIcon("src/resources/images/tag_blue_add.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.autoTagActors();
                GameMaster.this.initTable.autoSizeColumns();
            }
        };
        this.actionTagSelectedActors = new GAction("Tag", "Add tags to the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    GameMaster.this.tagActor(a);
                    ++n2;
                }
            }
        };
        this.actionRemoveTagSelectedActors = new GAction("Remove Tag", "Remove tags from the selected combatants", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    GameMaster.this.removeTag(a);
                    ++n2;
                }
            }
        };
        this.actionAttack = new GAction("Attack", "Selected combatants attack (Ctrl+K)", new ImageIcon("src/resources/images/sword.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.initTable.stopCellEditing();
                Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
                int n = actorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Actor a = actorArray[n2];
                    a.Attack();
                    ++n2;
                }
            }
        };
        this.actionDefend = new GAction("Defend", "Selected combatant defends (Ctrl+D)", new ImageIcon("src/resources/images/shield.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Actor actor = GameMaster.this.initTable.getSelectedActor();
                if (actor == null) {
                    return;
                }
                GameMaster.this.initTable.stopCellEditing();
                GameMaster.this.defenseDialog.setActor(actor);
                MiscUtil.validateOnScreen(GameMaster.this.defenseDialog);
                GameMaster.this.defenseDialog.setVisible(true);
                if (GameMaster.this.defenseDialog.valid) {
                    actor.Defend(GameMaster.this.defenseDialog.defense);
                }
            }
        };
        this.actionPostureStanding = new GAction("Standing", "Set posture to standing", new ImageIcon("src/resources/images/arrow_up.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
            }
        };
        this.actionPostureKneeling = new GAction("Kneeling", "Set posture to kneeling", new ImageIcon("src/resources/images/arrow_down_right.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, true);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, false);
            }
        };
        this.actionPostureProne = new GAction("Prone", "Set posture to prone", new ImageIcon("src/resources/images/arrow_down.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Kneeling, false);
                GameMaster.this.modifyStatusOfSelectedActors(ActorBase.ActorStatus.Prone, true);
            }
        };
        this.actionStatusTogglePhysicalStun = new GAction("Physical Stun", "Toggle Status: Physically Stunned", new ImageIcon("src/resources/images/stun_phys.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunPhys);
            }
        };
        this.actionStatusToggleMentalStun = new GAction("Mental Stun", "Toggle Status: Mentally Stunned", new ImageIcon("src/resources/images/stun_mental.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunMental);
            }
        };
        this.actionStatusToggleRecoveringStun = new GAction("Recovering from Stun", "Toggle Status: Recovering from Stun", new ImageIcon("src/resources/images/stun_recover.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.StunRecovr);
            }
        };
        this.actionStatusToggleAttacking = new GAction("Attacking", "Toggle Status: Attacking", new ImageIcon("src/resources/images/sword_rotate.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Attacking);
            }
        };
        this.actionStatusToggleDisarmed = new GAction("Disarmed", "Toggle Status: Disarmed", new ImageIcon("src/resources/images/plus_blue.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Disarmed);
            }
        };
        this.actionStatusToggleUnconscious = new GAction("Unconscious", "Toggle Status: Unconscious", new ImageIcon("src/resources/images/cross_yellow.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Unconscious);
            }
        };
        this.actionStatusToggleDead = new GAction("Dead", "Toggle Status: Dead", new ImageIcon("src/resources/images/cross.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.toggleStatusOfSelectedActors(ActorBase.ActorStatus.Dead);
            }
        };
        this.actionCoordinateSelectedStatusAttacking = new GAction("Attacking", "Change selected combatants' Attacking status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Attacking);
            }
        };
        this.actionCoordinateSelectedStatusDead = new GAction("Dead", "Change selected combatants' Dead status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Dead);
            }
        };
        this.actionCoordinateSelectedStatusDisabled = new GAction("Disabled", "Change selected combatants' Disabled status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Disabled);
            }
        };
        this.actionCoordinateSelectedStatusDisarmed = new GAction("Disarmed", "Change selected combatants' Disarmed status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Disarmed);
            }
        };
        this.actionCoordinateSelectedStatusUnconscious = new GAction("Unconscious", "Change selected combatants' Unconscious status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Unconscious);
            }
        };
        this.actionCoordinateSelectedStatusWaiting = new GAction("Waiting", "Change selected combatants' Waiting status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.Waiting);
            }
        };
        this.actionCoordinateSelectedStatusMentalStun = new GAction("Mental Stun", "Change selected combatants' Mental Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunMental);
            }
        };
        this.actionCoordinateSelectedStatusPhysicalStun = new GAction("Physical Stun", "Change selected combatants' Physical Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunPhys);
            }
        };
        this.actionCoordinateSelectedStatusRecoveringStun = new GAction("Recovering Stun", "Change selected combatants' Recovering Stun status to be the same", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.coordinatedChangeStatusOfSelectedActors(ActorBase.ActorStatus.StunRecovr);
            }
        };
        this.actionSetSelectedTypePC = new GAction("PC", "Set type to PC", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.PC);
            }
        };
        this.actionSetSelectedTypeAlly = new GAction("Ally", "Set type to Ally", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Ally);
            }
        };
        this.actionSetSelectedTypeNeutral = new GAction("Neutral", "Set type to Neutral", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Neutral);
            }
        };
        this.actionSetSelectedTypeEnemy = new GAction("Enemy", "Set type to Enemy", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Enemy);
            }
        };
        this.actionSetSelectedTypeSpecial = new GAction("Special", "Set type to Special", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameMaster.this.setSelectedType(ActorBase.ActorType.Special);
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    public class AttackNumAction
    extends AbstractAction {
        int num;

        public AttackNumAction(int num) {
            this.num = num;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GameMaster.this.initTable.stopCellEditing();
            Actor[] actorArray = GameMaster.this.initTable.getSelectedActors();
            int n = actorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Actor a = actorArray[n2];
                a.Attack(this.num);
                ++n2;
            }
        }
    }

    private static enum flagColors {
        R,
        B;

    }
}

