/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.textfield.ParsingField;
import gurpsinittool.app.textfield.ParsingFieldParser;
import gurpsinittool.app.textfield.ParsingFieldParserFactory;
import gurpsinittool.data.Actor;
import gurpsinittool.data.Attack;
import gurpsinittool.util.MiscUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class AttackTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String[] columnNames = new String[]{"Name", "Skill", "Damage", "U"};
    private Class<?>[] columnClasses = new Class[]{String.class, Integer.class, String.class, Boolean.class};
    private static int numColumns = 4;
    private Actor currentActor = null;

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.currentActor == null) {
            return 0;
        }
        return this.currentActor.getNumAttacks();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentActor == null) {
            return null;
        }
        Attack attack = this.currentActor.getAttack(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return attack.Name;
            }
            case Skill: {
                return attack.Skill;
            }
            case Damage: {
                return attack.Damage;
            }
            case Unbalanced: {
                return attack.Unbalanced;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        System.out.println("AttackTableModel: setValueAt: Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        if (this.getValueAt(row, col).equals(value)) {
            System.out.println("AttackTableModel: setValueAt: values are identical. Exiting.");
            return;
        }
        Attack a = this.currentActor.getAttack(row);
        switch (columns.values()[col]) {
            case Name: {
                a.Name = (String)value;
                break;
            }
            case Skill: {
                a.Skill = (Integer)value;
                break;
            }
            case Damage: {
                a.Damage = (String)value;
                break;
            }
            case Unbalanced: {
                a.Unbalanced = (Boolean)value;
            }
        }
        this.currentActor.setAttack(a, row);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.currentActor != null;
    }

    public void setActor(Actor actor) {
        this.currentActor = actor;
        this.fireTableDataChanged();
    }

    public void addAttack() {
        if (this.currentActor != null) {
            this.currentActor.addAttack(new Attack());
        }
    }

    public void removeAttacks(int[] rows) {
        if (this.currentActor != null && rows.length > 0) {
            int i = rows.length - 1;
            while (i >= 0) {
                System.out.println("AttackTableModel: Deleting row: " + rows[i]);
                this.currentActor.removeAttack(rows[i]);
                --i;
            }
        }
    }

    public void setDefaultAttack(int row) {
        if (row < 0 || row >= this.currentActor.getNumAttacks()) {
            System.out.println("AttackTableModel:setDefaultAttack: row out of range! " + row);
            return;
        }
        int oldDefault = this.currentActor.getDefaultAttack();
        this.currentActor.setDefaultAttack(row);
    }

    public class AttackTableCellEditor
    extends DefaultCellEditor {
        public AttackTableCellEditor(ParsingFieldParser parser) {
            super(new ParsingField(parser));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ParsingField c = (ParsingField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (isSelected) {
                c.selectAll();
            }
            return c;
        }
    }

    public class AttackTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            columns col;
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getRowSorter().convertRowIndexToModel(row) == AttackTableModel.this.currentActor.getDefaultAttack()) {
                MiscUtil.setLabelBold(c);
            }
            if ((col = columns.valueOf(table.getColumnName(column))) == columns.Damage && !ParsingFieldParserFactory.DamageParser().parseIsValid(c.getText())) {
                c.setForeground(Color.red);
            } else {
                c.setForeground(Color.black);
            }
            return c;
        }
    }

    public static enum columns {
        Name,
        Skill,
        Damage,
        Unbalanced;

    }
}

