/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.GroupTreeTransferHandler;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.Actor;
import gurpsinittool.data.GameMaster;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class InitTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected static DataFlavor initTableActorFlavor = new DataFlavor(InitTable.class, "GURPS Actor Object from init table");
    protected static DataFlavor groupTableActorFlavor = new DataFlavor(GroupTree.class, "GURPS Actor Object from group table");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{initTableActorFlavor, groupTableActorFlavor};

    public InitTableTransferHandler(String property) {
        super(property);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!(support.isDataFlavorSupported(initTableActorFlavor) || support.isDataFlavorSupported(groupTableActorFlavor) || support.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor))) {
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        InitTable table = (InitTable)support.getComponent();
        int row = dl.getRow();
        if (row == table.getRowCount()) {
            support.setShowDropLocation(false);
        }
        if (support.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor)) {
            support.setDropAction(1);
        }
        if (table.isInitTable() != support.isDataFlavorSupported(initTableActorFlavor)) {
            support.setDropAction(1);
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Actor[] actorRows;
        if (!this.canImport(support)) {
            return false;
        }
        Transferable t = support.getTransferable();
        try {
            if (t.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor)) {
                GroupTreeNode node = (GroupTreeNode)t.getTransferData(GroupTreeTransferHandler.actorGroupFlavor);
                ArrayList<Actor> actors = node.getActorList();
                actorRows = actors.subList(0, actors.size() - 1).toArray(new Actor[0]);
            } else {
                actorRows = (Actor[])t.getTransferData(initTableActorFlavor);
            }
        }
        catch (UnsupportedFlavorException e) {
            System.err.println("InitTableTransferHandler.importData: -E- Unsupported Flavor Exception");
            return false;
        }
        catch (IOException e) {
            System.err.println("InitTableTransferHandler.importData: -E- IO Exception: " + e.toString());
            return false;
        }
        InitTable table = (InitTable)support.getComponent();
        GameMaster gameMaster = table.getGameMaster();
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        table.stopCellEditing();
        int row = dl.getRow();
        if (row >= table.getRowCount()) {
            row = table.getRowCount() - 1;
        }
        gameMaster.startCompoundEdit();
        int i = actorRows.length - 1;
        while (i >= 0) {
            gameMaster.addActor(actorRows[i], row);
            table.getSelectionModel().addSelectionInterval(row, row);
            --i;
        }
        if (support.getDropAction() != 2) {
            gameMaster.endCompoundEdit("Copy");
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        InitTable table = (InitTable)c;
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        Arrays.sort(rows);
        InitTableModel tableModel = table.getActorTableModel();
        Actor[] actorRows = tableModel.getActors(rows);
        return new TransferableActor(actorRows, table.isInitTable());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            Actor[] actors;
            InitTable table = (InitTable)source;
            GameMaster gameMaster = table.getGameMaster();
            try {
                actors = (Actor[])data.getTransferData(initTableActorFlavor);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("InitTableTransferHandler.exportDone: -E- UnsupportedFlavorException");
                return;
            }
            catch (IOException e) {
                System.err.println("InitTableTransferHandler.exportDone: -E- IOException");
                return;
            }
            int i = 0;
            while (i < actors.length) {
                gameMaster.removeActor(actors[i]);
                ++i;
            }
            gameMaster.endCompoundEdit("Move");
        }
    }

    class TransferableActor
    implements Transferable {
        Actor[] actorRows;
        boolean isSourceInitTable;

        public TransferableActor(Actor[] actorRows, boolean isSourceInitTable) {
            this.actorRows = actorRows;
            this.isSourceInitTable = isSourceInitTable;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.isSourceInitTable) {
                return new DataFlavor[]{initTableActorFlavor};
            }
            return new DataFlavor[]{groupTableActorFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(initTableActorFlavor) || flavor.equals(groupTableActorFlavor)) {
                return this.actorRows;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(initTableActorFlavor) && this.isSourceInitTable || flavor.equals(groupTableActorFlavor) && !this.isSourceInitTable;
        }
    }
}

