/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.ActorGroupFile;
import gurpsinittool.data.GameMaster;
import gurpsinittool.ui.ActorDetailsPanel_v2;
import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import gurpsinittool.util.SearchSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;

public class GroupManager
extends JFrame
implements TreeSelectionListener,
ActionListener,
ItemListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private JSplitPane jSplitPaneVertical;
    private JSplitPane jSplitPaneHorizontal;
    private JScrollPane jScrollPaneTable;
    private JScrollPane jScrollPaneTree;
    private JScrollPane jScrollPaneDetails;
    private InitTable groupTable;
    private ActorDetailsPanel_v2 actorDetailsPanel;
    private JMenuBar jMenuBar;
    private JMenu jMenu;
    private JToolBar toolbar;
    private GroupTree groupTree;
    private JFileChooser fileChooser;
    private File saveAsFile;
    private boolean tableIsClean = true;
    private boolean treeIsClean = true;
    private Properties propertyBag;
    private GameMaster gameMaster;
    SearchSupport searchSupport;

    public GroupManager(Properties propertyBag) {
        super("Group Manager");
        this.propertyBag = propertyBag;
        this.setDefaultProperties();
        UIManager.put("Tree.leafIcon", new ImageIcon(GITApp.class.getResource("/resources/images/bullet_black.png")));
        UIManager.put("Tree.closedIcon", new ImageIcon(GITApp.class.getResource("/resources/images/folder.png")));
        UIManager.put("Tree.openIcon", new ImageIcon(GITApp.class.getResource("/resources/images/folder.png")));
        this.gameMaster = new GameMaster();
        this.actorDetailsPanel = new ActorDetailsPanel_v2(false);
        this.groupTable = new InitTable(this.gameMaster, false);
        this.groupTree = new GroupTree(this.groupTable);
        this.searchSupport = new SearchSupport(this.getRootPane(), this.groupTree, this.groupTable);
        this.gameMaster.initTable = this.groupTable;
        this.gameMaster.detailsPanel = this.actorDetailsPanel;
        this.groupTable.getActorTableModel().addUndoableEditListener(this.gameMaster);
        this.groupTree.addUndoableEditListener(this.gameMaster);
        this.setDefaultCloseOperation(1);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File("."));
        GroupFilter defaultFilter = new GroupFilter();
        this.fileChooser.addChoosableFileFilter(defaultFilter);
        this.fileChooser.setFileFilter(defaultFilter);
        this.jMenuBar = new JMenuBar();
        this.jMenu = new JMenu("File");
        this.jMenu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem("New", 78);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Open", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Save As...", 65);
        menuItem.getAccessibleContext().setAccessibleDescription("Select the file to save the group list to");
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Save the group list");
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.jMenu = new JMenu("Edit");
        this.jMenu.setMnemonic(69);
        menuItem = new JMenuItem(this.gameMaster.actionUndo);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem(this.gameMaster.actionRedo);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cut.png"), "Cut"));
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/page_copy.png"), "Copy"));
        this.jMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(86);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/paste_plain.png"), "Paste"));
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.jMenu = new JMenu("View");
        this.jMenu.setMnemonic(86);
        menuItem = new JCheckBoxMenuItem("Auto-fit columns");
        menuItem.setMnemonic(65);
        menuItem.setSelected(Boolean.valueOf(propertyBag.getProperty("Manager.groupTable.autoResize")));
        menuItem.getAccessibleContext().setAccessibleDescription("Table columns auto-fit automatically");
        menuItem.addItemListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Actor Details");
        menuItem.setSelected(Boolean.valueOf(propertyBag.getProperty("Manager.actorDetails.visible")));
        menuItem.setMnemonic(68);
        menuItem.addItemListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.setJMenuBar(this.jMenuBar);
        this.toolbar = this.searchSupport.getSearchToolBar();
        this.toolbar.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.toolbar, "First");
        this.groupTable.setVisible(false);
        this.groupTable.getSelectionModel().addListSelectionListener(this);
        this.groupTable.getActorTableModel().addFileChangeEventListener(new GroupFileChangeEventListener());
        this.groupTable.getActorTableModel().addTableModelListener(new GroupInitTableModelListener());
        this.groupTree.addTreeSelectionListener(this);
        this.groupTree.addFileChangeEventListener(new GroupFileChangeEventListener());
        this.jScrollPaneTable = new JScrollPane(this.groupTable);
        this.jScrollPaneDetails = new JScrollPane(this.actorDetailsPanel);
        this.jScrollPaneDetails.setMinimumSize(new Dimension(this.actorDetailsPanel.getPreferredSize().width + 20, 0));
        this.jScrollPaneTree = new JScrollPane(this.groupTree);
        this.jSplitPaneVertical = new JSplitPane(0, this.jScrollPaneTree, this.jScrollPaneTable);
        this.jSplitPaneHorizontal = new JSplitPane(1, this.jSplitPaneVertical, this.jScrollPaneDetails);
        this.jSplitPaneVertical.setDividerLocation(Integer.valueOf(propertyBag.getProperty("Manager.splitVertical.dividerLocation")));
        this.jSplitPaneVertical.setContinuousLayout(true);
        this.jSplitPaneVertical.setResizeWeight(0.95);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(propertyBag.getProperty("Manager.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setContinuousLayout(true);
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.layoutActorPanel();
        this.setLocation(Integer.valueOf(propertyBag.getProperty("Manager.location.x")), Integer.valueOf(propertyBag.getProperty("Manager.location.y")));
        this.setSize(Integer.valueOf(propertyBag.getProperty("Manager.size.width")), Integer.valueOf(propertyBag.getProperty("Manager.size.height")));
        if (propertyBag.containsKey("Manager.currentLoadedFile")) {
            this.saveAsFile = new File(propertyBag.getProperty("Manager.currentLoadedFile"));
            this.loadGroupFile(this.saveAsFile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Save As...".equals(e.getActionCommand())) {
            this.saveGroupFile(null);
        } else if ("Save".equals(e.getActionCommand())) {
            this.saveGroupFile(this.saveAsFile);
        } else if ("Open".equals(e.getActionCommand()) && this.querySaveChanges()) {
            this.loadGroupFile(null);
        } else if ("New".equals(e.getActionCommand()) && this.querySaveChanges()) {
            this.newGroupFile();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if ("Actor Details".equals(source.getText())) {
            boolean selected = e.getStateChange() == 1;
            this.propertyBag.setProperty("Manager.actorDetails.visible", String.valueOf(selected));
            this.layoutActorPanel();
        } else if ("Auto-fit columns".equals(source.getText())) {
            boolean selected = e.getStateChange() == 1;
            this.propertyBag.setProperty("Manager.groupTable.autoResize", String.valueOf(selected));
            if (selected) {
                this.groupTable.autoSizeColumns();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.groupTable.getCellEditor() != null) {
            this.groupTable.getCellEditor().stopCellEditing();
        }
        InitTableModel tableModel = this.groupTable.getActorTableModel();
        if (this.groupTree.getLastSelectedPathComponent() != null) {
            GroupTreeNode node = (GroupTreeNode)this.groupTree.getLastSelectedPathComponent();
            if (node.isLeaf()) {
                tableModel.setActorList(node.getActorList());
                this.groupTable.setVisible(true);
            } else {
                this.groupTable.setVisible(false);
                tableModel.setActorList(null);
            }
        } else {
            this.groupTable.setVisible(false);
            tableModel.setActorList(null);
        }
    }

    public boolean querySaveChanges() {
        int n;
        return this.tableIsClean && this.treeIsClean || !((n = JOptionPane.showOptionDialog(this, "The group has been modified. Save Changes?", "Group Changed", 1, 3, null, null, null)) == 0 ? !this.saveGroupFile(this.saveAsFile) : n == 2);
    }

    public void newGroupFile() {
        this.groupTree.setNewModel();
        this.saveAsFile = null;
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager");
    }

    public boolean loadGroupFile(File file) {
        if (file == null) {
            int retVal = this.fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                file = this.fileChooser.getSelectedFile();
            } else {
                return false;
            }
        }
        ActorGroupFile.OpenActorGroupTree(this.groupTree, file);
        this.saveAsFile = file;
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager - " + this.saveAsFile.getName());
        return true;
    }

    public boolean saveGroupFile(File file) {
        if (file == null) {
            int retVal = this.fileChooser.showSaveDialog(this);
            if (retVal == 0) {
                int response;
                file = this.fileChooser.getSelectedFile();
                if (!file.toString().contains(".")) {
                    file = new File(String.valueOf(file.toString()) + ".igroup");
                }
                if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        ActorGroupFile.SaveActorGroupTree(this.groupTree, file);
        this.groupTree.setClean();
        this.groupTable.getActorTableModel().setClean();
        super.setTitle("Group Manager - " + file.getName());
        this.saveAsFile = file;
        return true;
    }

    private void layoutActorPanel() {
        if (Boolean.valueOf(this.propertyBag.getProperty("Manager.actorDetails.visible")).booleanValue()) {
            this.getContentPane().remove(this.jSplitPaneVertical);
            this.jSplitPaneHorizontal.setLeftComponent(this.jSplitPaneVertical);
            this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("Manager.splitHorizontal.dividerLocation")));
            this.getContentPane().add((Component)this.jSplitPaneHorizontal, "Center");
            this.validate();
        } else {
            this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
            this.getContentPane().remove(this.jSplitPaneHorizontal);
            this.getContentPane().add((Component)this.jSplitPaneVertical, "Center");
            this.validate();
        }
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("Manager.actorDetails.visible")) {
            this.propertyBag.setProperty("Manager.actorDetails.visible", "true");
        }
        if (!this.propertyBag.containsKey("Manager.groupTable.autoResize")) {
            this.propertyBag.setProperty("Manager.groupTable.autoResize", "true");
        }
        if (!this.propertyBag.containsKey("Manager.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", "340");
        }
        if (!this.propertyBag.containsKey("Manager.splitVertical.dividerLocation")) {
            this.propertyBag.setProperty("Manager.splitVertical.dividerLocation", "200");
        }
        if (!this.propertyBag.containsKey("Manager.location.x")) {
            this.propertyBag.setProperty("Manager.location.x", "500");
        }
        if (!this.propertyBag.containsKey("Manager.location.y")) {
            this.propertyBag.setProperty("Manager.location.y", "300");
        }
        if (!this.propertyBag.containsKey("Manager.size.width")) {
            this.propertyBag.setProperty("Manager.size.width", "620");
        }
        if (!this.propertyBag.containsKey("Manager.size.height")) {
            this.propertyBag.setProperty("Manager.size.height", "450");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("Manager.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("Manager.splitVertical.dividerLocation", String.valueOf(this.jSplitPaneVertical.getDividerLocation()));
        this.propertyBag.setProperty("Manager.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("Manager.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("Manager.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("Manager.size.height", String.valueOf(this.getSize().height));
        if (this.saveAsFile != null) {
            this.propertyBag.setProperty("Manager.currentLoadedFile", this.saveAsFile.getAbsolutePath());
        } else {
            this.propertyBag.remove("Manager.currentLoadedFile");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.actorDetailsPanel.setActor(this.groupTable.getSelectedActor());
        }
    }

    class GroupFileChangeEventListener
    implements FileChangeEventListener {
        GroupFileChangeEventListener() {
        }

        @Override
        public void fileChangeOccured(FileChangeEvent evt) {
        }

        @Override
        public void fileCleanStatusChanged(FileChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof InitTableModel) {
                GroupManager.this.tableIsClean = evt.isClean;
            } else if (source instanceof GroupTree) {
                GroupManager.this.treeIsClean = evt.isClean;
            }
            if (GroupManager.this.tableIsClean && GroupManager.this.treeIsClean) {
                if (GroupManager.this.saveAsFile != null) {
                    GroupManager.this.setTitle("Group Manager - " + GroupManager.this.saveAsFile.getName());
                } else {
                    GroupManager.this.setTitle("Group Manager");
                }
            } else if (GroupManager.this.saveAsFile != null) {
                GroupManager.this.setTitle("Group Manager - " + GroupManager.this.saveAsFile.getName() + "*");
            } else {
                GroupManager.this.setTitle("Group Manager *");
            }
        }
    }

    private class GroupFilter
    extends FileFilter {
        private GroupFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.toString().endsWith(".igroup");
        }

        @Override
        public String getDescription() {
            return "InitTool Group (*.igroup)";
        }
    }

    class GroupInitTableModelListener
    implements TableModelListener {
        GroupInitTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            if (Boolean.valueOf(GroupManager.this.propertyBag.getProperty("Manager.groupTable.autoResize")).booleanValue()) {
                GroupManager.this.groupTable.autoSizeColumns();
            }
            GroupManager.this.actorDetailsPanel.setActor(GroupManager.this.groupTable.getSelectedActor());
        }
    }
}

