/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.GroupTreeTransferHandler;
import gurpsinittool.app.InitTable;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.FileChangeEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DropMode;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class GroupTree
extends JTree
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private UndoableEditSupport mUes = new UndoableEditSupport();
    protected CleanFileChangeEventSource mCfces = new CleanFileChangeEventSource(this);
    private static final boolean DEBUG = false;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private InitTable groupTable;
    private JPopupMenu popupMenu;

    public GroupTree(InitTable groupTable) {
        this.setNewModel();
        this.groupTable = groupTable;
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.setInvokesStopCellEditing(true);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setTransferHandler(new GroupTreeTransferHandler(this, "name"));
        this.getSelectionModel().setSelectionMode(1);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createMenuItem("New Folder", 70));
        this.popupMenu.add(this.createMenuItem("New Group", 71));
        this.popupMenu.add(this.createMenuItem("Delete", 127));
        this.popupMenu.add(this.createMenuItem("Rename", 82));
        MousePopupListener popupListener = new MousePopupListener();
        this.addMouseListener(popupListener);
    }

    private JMenuItem createMenuItem(String text, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.addActionListener(this);
        return menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("New Folder".equals(e.getActionCommand())) {
            GroupTreeNode newFolder = this.addNode("New Folder...", false);
            TreePath folderPath = new TreePath(newFolder.getPath());
            this.selectionModel.setSelectionPath(folderPath);
            this.startEditingAtPath(folderPath);
        } else if ("New Group".equals(e.getActionCommand())) {
            GroupTreeNode newGroup = this.addNode("New Group...", true);
            TreePath groupPath = new TreePath(newGroup.getPath());
            this.selectionModel.setSelectionPath(groupPath);
            this.startEditingAtPath(groupPath);
        } else if ("Delete".equals(e.getActionCommand())) {
            if (this.isSelectionEmpty()) {
                return;
            }
            int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this group?", "Confirm Group Delete", 2);
            if (result == 0) {
                this.removeCurrentNode();
            }
        } else if ("Rename".equals(e.getActionCommand())) {
            if (this.isSelectionEmpty()) {
                return;
            }
            this.startEditingAtPath(this.getSelectionPath());
        }
    }

    public InitTable getGroupTable() {
        return this.groupTable;
    }

    public GroupTreeNode addNode(String name, boolean leaf) {
        GroupTreeNode newNode = new GroupTreeNode(name, leaf);
        this.insertObjectAtSelection(newNode);
        this.scrollPathToVisible(new TreePath(newNode.getPath()));
        this.mUes.postEdit(new NodeEdit(newNode, true));
        return newNode;
    }

    public void insertNode(GroupTreeNode node, GroupTreeNode parentNode, int position) {
        this.treeModel.insertNodeInto(node, parentNode, position);
        this.mUes.postEdit(new NodeEdit(node, true));
    }

    private void insertObjectAtSelection(GroupTreeNode child) {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            this.treeModel.insertNodeInto(child, this.rootNode, this.rootNode.getChildCount());
        } else {
            GroupTreeNode node = (GroupTreeNode)selectionPath.getLastPathComponent();
            if (!node.isLeaf()) {
                this.treeModel.insertNodeInto(child, node, node.getChildCount());
            } else {
                GroupTreeNode parentNode = (GroupTreeNode)node.getParent();
                this.treeModel.insertNodeInto(child, parentNode, parentNode.getChildCount());
            }
        }
    }

    public void removeCurrentNode() {
        TreePath currentSelection = this.getSelectionPath();
        if (currentSelection != null) {
            GroupTreeNode currentNode = (GroupTreeNode)currentSelection.getLastPathComponent();
            this.removeNode(currentNode);
        }
    }

    public void removeNode(GroupTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent != null) {
            this.mUes.postEdit(new NodeEdit(node, false));
            this.treeModel.removeNodeFromParent(node);
            this.setDirty();
            return;
        }
    }

    public GroupTreeModel setNewModel() {
        GroupTreeModel model = new GroupTreeModel(new GroupTreeNode("Groups", false));
        this.setModel(model);
        return model;
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (this.treeModel != null && !GroupTreeModel.class.isInstance(newModel)) {
            System.err.println("-E- GroupTree: setModel: model must be a GroupTreeModel!");
        }
        super.setModel(newModel);
        this.treeModel = (DefaultTreeModel)newModel;
        this.rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.treeModel.addTreeModelListener(new GroupTreeModelListener());
    }

    public boolean isClean() {
        return this.mCfces.isClean();
    }

    public void setClean() {
        this.mCfces.setClean();
    }

    public void setDirty() {
        this.mCfces.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.mCfces.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.mCfces.removeFileChangeEventListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.mUes.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.mUes.removeUndoableEditListener(listener);
    }

    protected class GroupTreeModel
    extends DefaultTreeModel {
        public GroupTreeModel(TreeNode root) {
            super(root);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object userObj) {
            System.out.println("HERE: node name chaged!");
            GroupTreeNode node = (GroupTreeNode)path.getLastPathComponent();
            String oldName = (String)node.getUserObject();
            String newName = (String)userObj;
            if (oldName.equals(newName)) {
                return;
            }
            GroupTree.this.mUes.postEdit(new NodeRenameEdit(node, oldName, newName));
            super.valueForPathChanged(path, userObj);
        }
    }

    class GroupTreeModelListener
    implements TreeModelListener {
        GroupTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            GroupTree.this.setDirty();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            GroupTree.this.setDirty();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            GroupTree.this.setDirty();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GroupTree.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class NodeEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private GroupTreeNode node;
        private GroupTreeNode parent;
        private int index;
        boolean isInsert;

        public NodeEdit(GroupTreeNode node, boolean isInsert) {
            this.node = node;
            this.parent = (GroupTreeNode)node.getParent();
            this.index = this.parent.getIndex(node);
            this.isInsert = isInsert;
        }

        @Override
        public String getPresentationName() {
            return "Tree";
        }

        @Override
        public void undo() {
            super.undo();
            if (this.isInsert) {
                GroupTree.this.treeModel.removeNodeFromParent(this.node);
                GroupTree.this.setDirty();
            } else {
                GroupTree.this.treeModel.insertNodeInto(this.node, this.parent, this.index);
                GroupTree.this.scrollPathToVisible(new TreePath(this.node.getPath()));
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.isInsert) {
                GroupTree.this.treeModel.insertNodeInto(this.node, this.parent, this.index);
                GroupTree.this.scrollPathToVisible(new TreePath(this.node.getPath()));
            } else {
                GroupTree.this.treeModel.removeNodeFromParent(this.node);
                GroupTree.this.setDirty();
            }
        }
    }

    private class NodeRenameEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private GroupTreeNode node;
        private String oldName;
        private String newName;

        public NodeRenameEdit(GroupTreeNode node, String oldName, String newName) {
            this.node = node;
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public String getPresentationName() {
            return "Rename";
        }

        @Override
        public void undo() {
            super.undo();
            this.node.setUserObject(this.oldName);
            GroupTree.this.treeModel.nodeChanged(this.node);
        }

        @Override
        public void redo() {
            super.redo();
            this.node.setUserObject(this.newName);
            GroupTree.this.treeModel.nodeChanged(this.node);
        }
    }
}

