/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.data.Actor;
import gurpsinittool.data.GameMaster;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class GroupTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private GroupTree parent;
    protected static DataFlavor actorGroupFlavor = new DataFlavor(GroupTreeNode.class, "GURPS Actor Group Object");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{actorGroupFlavor};

    public GroupTreeTransferHandler(GroupTree parent, String property) {
        super(property);
        this.parent = parent;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        if (insertPath == null) {
            return false;
        }
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            this.parent.setDropMode(DropMode.INSERT);
            return true;
        }
        if (support.isDataFlavorSupported(InitTableTransferHandler.initTableActorFlavor) || support.isDataFlavorSupported(InitTableTransferHandler.groupTableActorFlavor)) {
            this.parent.setDropMode(DropMode.ON);
            support.setDropAction(1);
            if (parentNode.isLeaf()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        GroupTree tree = (GroupTree)support.getComponent();
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        int insertIndex = dl.getChildIndex();
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        Transferable t = support.getTransferable();
        int action = support.getDropAction();
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            GroupTreeNode transferNode;
            try {
                transferNode = (GroupTreeNode)t.getTransferData(actorGroupFlavor);
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("GroupTreeTransferHandler.importData: -E- Unsupported Flavor Exception");
                return false;
            }
            catch (IOException e) {
                System.err.println("GroupTreeTransferHandler.importData: -E- IO Exception:" + e.toString());
                return false;
            }
            TreePath transferPath = new TreePath(transferNode.getPath());
            if (action == 2 && !tree.isSelectionEmpty()) {
                TreePath selectionPath = tree.getSelectionPath();
                if (transferPath.getPathCount() == selectionPath.getPathCount() && insertPath.getPathCount() >= selectionPath.getPathCount()) {
                    int i = 0;
                    while (i < selectionPath.getPathCount()) {
                        if (!transferPath.getPathComponent(i).toString().equals(selectionPath.getPathComponent(i).toString()) || !insertPath.getPathComponent(i).equals(selectionPath.getPathComponent(i))) break;
                        if (i == selectionPath.getPathCount() - 1) {
                            return false;
                        }
                        ++i;
                    }
                }
                tree.getGroupTable().getGameMaster().startCompoundEdit();
            }
            if (insertIndex >= 0) {
                tree.insertNode(transferNode, parentNode, insertIndex);
            } else {
                tree.insertNode(transferNode, parentNode, parentNode.getChildCount());
            }
            if (action == 2) {
                tree.setSelectionPath(new TreePath(transferNode.getPath()));
            }
        } else {
            Actor[] actorRows;
            if (!parentNode.isLeaf()) {
                System.out.println("GroupTreeTransferHandler.importData: -E- attempting to drop rows on folder!");
                return false;
            }
            try {
                actorRows = (Actor[])t.getTransferData(InitTableTransferHandler.initTableActorFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            ArrayList<Actor> actorList = parentNode.getActorList();
            if (this.parent.getSelectionPath().getLastPathComponent().equals(parentNode)) {
                GameMaster gameMaster = this.parent.getGroupTable().getGameMaster();
                InitTableModel model = this.parent.getGroupTable().getActorTableModel();
                int i = actorRows.length - 1;
                while (i >= 0) {
                    gameMaster.addActor(actorRows[i], model.getRowCount() - 1);
                    --i;
                }
            } else {
                int i = actorRows.length - 1;
                while (i >= 0) {
                    actorList.add(actorList.size() - 1, actorRows[i]);
                    --i;
                }
                tree.setDirty();
            }
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        GroupTree tree = (GroupTree)c;
        TreePath transferPath = tree.getSelectionPath();
        if (transferPath == null) {
            return null;
        }
        return new TransferableActorGroup((GroupTreeNode)transferPath.getLastPathComponent());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        GroupTreeNode transferNode;
        GroupTree tree = (GroupTree)source;
        try {
            transferNode = (GroupTreeNode)data.getTransferData(actorGroupFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        TreePath transferPath = new TreePath(transferNode.getPath());
        if (action == 2) {
            tree.removeNode(transferNode);
            tree.getGroupTable().getGameMaster().endCompoundEdit("Move");
        } else if (action == 1) {
            tree.setSelectionPath(transferPath);
        }
    }

    class TransferableActorGroup
    implements Transferable {
        GroupTreeNode transferNode;

        public TransferableActorGroup(GroupTreeNode transferNode) {
            this.transferNode = transferNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(actorGroupFlavor)) {
                return this.transferNode;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(actorGroupFlavor);
        }
    }
}

