/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.GameMaster;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.FileChangeEventListener;
import gurpsinittool.util.SearchSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class InitTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private UndoableEditSupport mUes = new UndoableEditSupport();
    private String[] columnNames = new String[]{"Act", "Name", "Speed", "Move", "HT", "HP", "Injury", "FP", "Fatigue", "Status"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static int numColumns = 10;
    Actor newActor = new Actor();
    private ArrayList<Actor> actorList = new ArrayList();
    private GameMaster gameMaster;
    protected CleanFileChangeEventSource cleanFileChangeEventSource = new CleanFileChangeEventSource(this);

    public InitTableModel(GameMaster gameMaster) {
        this.gameMaster = gameMaster;
        this.addNewActor();
    }

    public void addActor(Actor actor, int destRow) {
        if (destRow > this.actorList.size() - 1) {
            destRow = this.actorList.size() - 1;
        } else if (destRow < 0) {
            destRow = 0;
        }
        this.mUes.postEdit(new AddActorEdit(actor, destRow));
        this.addActorToList(this.actorList, actor, destRow);
    }

    private void addActorToList(ArrayList<Actor> list, Actor actor, int position) {
        list.add(position, actor);
        if (list.equals(this.actorList)) {
            actor.addPropertyChangeListener(this);
            actor.addEncounterLogEventListener(this.gameMaster);
            actor.addUndoableEditListener(this.gameMaster);
            this.setDirty();
            this.fireTableRowsInserted(position, position);
        }
    }

    private void addNewActor() {
        Actor actor = new Actor(this.newActor);
        actor.addPropertyChangeListener(this);
        this.actorList.add(this.actorList.size(), actor);
        this.setDirty();
        this.fireTableRowsInserted(this.actorList.size() - 1, this.actorList.size() - 1);
    }

    public void removeActor(int row) {
        Actor actor = this.getActor(row);
        this.mUes.postEdit(new RemoveActorEdit(actor, row));
        this.removeActorFromList(this.actorList, actor, row);
    }

    private void removeActorFromList(ArrayList<Actor> list, Actor actor, int position) {
        list.remove(position);
        if (list.equals(this.actorList)) {
            actor.removePropertyChangeListener(this);
            actor.removeUndoableEditListener(this.gameMaster);
            actor.removeEncounterLogEventListener(this.gameMaster);
            this.setDirty();
            this.fireTableRowsDeleted(position, position);
        }
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return actor.getTraitValue(ActorBase.BasicTrait.Name);
            }
            case Speed: {
                return actor.getTraitValue(ActorBase.BasicTrait.Speed);
            }
            case Move: {
                return actor.getTraitValue(ActorBase.BasicTrait.Move);
            }
            case HT: {
                return actor.getTraitValue(ActorBase.BasicTrait.HT);
            }
            case HP: {
                return actor.getTraitValue(ActorBase.BasicTrait.HP);
            }
            case Injury: {
                return actor.getTraitValue(ActorBase.BasicTrait.Injury);
            }
            case FP: {
                return actor.getTraitValue(ActorBase.BasicTrait.FP);
            }
            case Fatigue: {
                return actor.getTraitValue(ActorBase.BasicTrait.Fatigue);
            }
            case Status: {
                return actor.getAllStatuses();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (columns.values()[col]) {
            // Empty switch
        }
        Actor a = this.actorList.get(row);
        switch (columns.values()[col]) {
            case Name: {
                a.setTrait(ActorBase.BasicTrait.Name, (String)value);
                break;
            }
            case Speed: {
                a.setTrait(ActorBase.BasicTrait.Speed, (String)value);
                break;
            }
            case Move: {
                a.setTrait(ActorBase.BasicTrait.Move, (String)value);
                break;
            }
            case HT: {
                a.setTrait(ActorBase.BasicTrait.HT, (String)value);
                break;
            }
            case HP: {
                a.setTrait(ActorBase.BasicTrait.HP, (String)value);
                break;
            }
            case Injury: {
                a.setTrait(ActorBase.BasicTrait.Injury, (String)value);
                break;
            }
            case FP: {
                a.setTrait(ActorBase.BasicTrait.FP, (String)value);
                break;
            }
            case Fatigue: {
                a.setTrait(ActorBase.BasicTrait.Fatigue, (String)value);
                break;
            }
            case Status: {
                a.setAllStatuses((HashSet)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (columns.values()[col]) {
            case Act: {
                return false;
            }
        }
        return true;
    }

    public void setActorList(ArrayList<Actor> actorList) {
        for (Actor a : this.actorList) {
            a.removePropertyChangeListener(this);
            a.removeUndoableEditListener(this.gameMaster);
            a.removeEncounterLogEventListener(this.gameMaster);
        }
        this.fireTableRowsDeleted(0, this.getRowCount());
        if (actorList == null) {
            this.actorList = new ArrayList();
        } else {
            this.actorList = actorList;
            int i = 0;
            while (i < this.actorList.size()) {
                Actor a = this.actorList.get(i);
                a.addPropertyChangeListener(this);
                if (i < this.actorList.size() - 1) {
                    a.addUndoableEditListener(this.gameMaster);
                    a.addEncounterLogEventListener(this.gameMaster);
                }
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public int searchActors(int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        return SearchSupport.searchActorList(this.actorList, startingIndex, endingIndex, next, reverse, pattern);
    }

    public boolean isClean() {
        return this.cleanFileChangeEventSource.isClean();
    }

    public void setClean() {
        this.cleanFileChangeEventSource.setClean();
    }

    public void setDirty() {
        this.cleanFileChangeEventSource.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.removeFileChangeEventListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (Actor.class.isInstance(e.getSource())) {
            this.setDirty();
            Actor actor = (Actor)e.getSource();
            int[] rows = this.getActorRows(actor);
            int i = 0;
            while (i < rows.length) {
                if (rows[i] == this.getRowCount() - 1) {
                    this.addNewActor();
                    actor.addUndoableEditListener(this.gameMaster);
                    actor.addEncounterLogEventListener(this.gameMaster);
                    this.mUes.postEdit(new AddActorEdit(this.actorList.get(this.actorList.size() - 2), this.actorList.size() - 2));
                }
                this.fireTableRowsUpdated(rows[i], rows[i]);
                ++i;
            }
        } else if (e.getPropertyName().equals("ActiveActor")) {
            int oldValue = (Integer)e.getOldValue();
            int newValue = (Integer)e.getNewValue();
            if (oldValue != -1) {
                this.fireTableRowsUpdated(oldValue, oldValue);
            }
            if (newValue != -1) {
                this.fireTableRowsUpdated(newValue, newValue);
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.mUes.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.mUes.removeUndoableEditListener(listener);
    }

    private class AddActorEdit
    extends AbstractUndoableEdit {
        private Actor actor;
        private int index;
        private ArrayList<Actor> list;

        public AddActorEdit(Actor actor, int index) {
            this.actor = actor;
            this.index = index;
            this.list = InitTableModel.this.actorList;
        }

        @Override
        public String getPresentationName() {
            return "Add";
        }

        @Override
        public void undo() {
            super.undo();
            InitTableModel.this.removeActorFromList(this.list, this.actor, this.index);
        }

        @Override
        public void redo() {
            super.redo();
            InitTableModel.this.addActorToList(this.list, this.actor, this.index);
        }
    }

    private class RemoveActorEdit
    extends AbstractUndoableEdit {
        private Actor actor;
        private int index;
        private ArrayList<Actor> list;

        public RemoveActorEdit(Actor actor, int index) {
            this.actor = actor;
            this.index = index;
            this.list = InitTableModel.this.actorList;
        }

        @Override
        public String getPresentationName() {
            return "Delete";
        }

        @Override
        public void undo() {
            super.undo();
            InitTableModel.this.addActorToList(this.list, this.actor, this.index);
        }

        @Override
        public void redo() {
            super.redo();
            InitTableModel.this.removeActorFromList(this.list, this.actor, this.index);
        }
    }

    public static enum columns {
        Act,
        Name,
        Speed,
        Move,
        HT,
        HP,
        Injury,
        FP,
        Fatigue,
        Status;

    }
}

