/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app.textfield;

import gurpsinittool.app.textfield.ParsingFieldParser;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ParsingField
extends JTextField {
    private ParsingFieldParser parser;
    private Color foregroundColor = Color.black;

    public ParsingFieldParser getParser() {
        return this.parser;
    }

    public void setParser(ParsingFieldParser parser) {
        this.parser = parser;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void refreshForeground() {
        if (this.parser.parseIsValid(this.getText())) {
            this.setForeground(this.foregroundColor);
        } else {
            this.setForeground(Color.red);
        }
    }

    public ParsingField() {
        this.getDocument().addDocumentListener(new ActorDocumentListener());
    }

    public ParsingField(ParsingFieldParser parser) {
        this.parser = parser;
        this.getDocument().addDocumentListener(new ActorDocumentListener());
    }

    public Object getParsedValue() {
        return this.parser.parseText(this.getText());
    }

    protected class ActorDocumentListener
    implements DocumentListener {
        protected ActorDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.parse_component_text();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.parse_component_text();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.parse_component_text();
        }

        private void parse_component_text() {
            if (ParsingField.this.parser.parseIsValid(ParsingField.this.getText())) {
                ParsingField.this.setForeground(ParsingField.this.foregroundColor);
            } else {
                ParsingField.this.setForeground(Color.red);
            }
        }
    }
}

