/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.util;

import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import javax.swing.event.EventListenerList;

public class CleanFileChangeEventSource {
    private static final boolean DEBUG = false;
    private boolean clean = true;
    private Object Source;
    protected EventListenerList fileChangeListenerList = new EventListenerList();

    public CleanFileChangeEventSource(Object source) {
        this.Source = source;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean() {
        if (!this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this.Source, true));
        }
        this.clean = true;
    }

    public void setDirty() {
        if (this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this.Source, false));
        }
        this.fireFileChangedEvent(new FileChangeEvent(this));
        this.clean = false;
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.add(FileChangeEventListener.class, listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.fileChangeListenerList.remove(FileChangeEventListener.class, listener);
    }

    void fireFileChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileChangeOccured(evt);
            }
            i += 2;
        }
    }

    void fireFileCleanStatusChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.fileChangeListenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileCleanStatusChanged(evt);
            }
            i += 2;
        }
    }
}

