/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.util;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.util.MiscUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SearchSupport {
    private static final boolean DEBUG = true;
    private JToolBar searchBar;
    private JTextField searchField;
    private boolean incrementalSearchInProgress = false;
    private JRootPane rootPane;
    private InitTable table;
    private int searchStartingTableIndex;
    private Pattern pattern;
    private SearchMode mode = SearchMode.Table;
    private GroupTree groupTree;
    private GroupTreeNode searchStartingNode;
    private ArrayList<GroupTreeNode> searchNodeList;
    public Action actionNextMatch;
    public Action actionPrevMatch;
    public Action actionSearchFocus;

    public SearchSupport(JRootPane rootPane, InitTable table) {
        this.rootPane = rootPane;
        this.table = table;
        this.initComponents();
    }

    public SearchSupport(JRootPane rootPane, GroupTree tree, InitTable table) {
        this(rootPane, table);
        this.mode = SearchMode.Tree;
        this.groupTree = tree;
    }

    private void initComponents() {
        this.searchBar = new JToolBar();
        JLabel searchLabel = new JLabel("Search: ");
        searchLabel.setToolTipText("Search combatant names (F3)");
        this.searchBar.add(searchLabel);
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Search combatant names (F3)");
        this.searchField.setColumns(20);
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            private void processTextChanges(DocumentEvent e) {
                SearchSupport.this.incrementalSearch();
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchSupport.this.incrementalSearchInProgress = false;
                SearchSupport.this.searchField.setForeground(Color.gray);
                SearchSupport.this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                MiscUtil.setTextFieldFontStyle(SearchSupport.this.searchField, 2);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchSupport.this.incrementalSearchInProgress = false;
                SearchSupport.this.searchField.setForeground(Color.black);
                MiscUtil.setTextFieldFontStyle(SearchSupport.this.searchField, 0);
                SearchSupport.this.searchField.selectAll();
            }
        });
        this.searchBar.add(this.searchField);
        this.actionPrevMatch = new GAction(this, "Search Up", "Find previous match (Ctrl+Shift+G)", new ImageIcon(GITApp.class.getResource("/resources/images/bullet_arrow_up.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                this.searchNext(true);
            }
        };
        this.actionNextMatch = new GAction(this, "Search Down", "Find next match (Ctrl+G)", new ImageIcon(GITApp.class.getResource("/resources/images/bullet_arrow_down.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                this.searchNext(false);
            }
        };
        this.actionSearchFocus = new GAction(this, "Search", "Search (F3)", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                searchField.requestFocusInWindow();
            }
        };
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("control G"), "SearchNext");
        this.rootPane.getActionMap().put("SearchNext", this.actionNextMatch);
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("control shift G"), "SearchPrev");
        this.rootPane.getActionMap().put("SearchPrev", this.actionPrevMatch);
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("F3"), "SearchFocus");
        this.rootPane.getActionMap().put("SearchFocus", this.actionSearchFocus);
        this.searchBar.add(MiscUtil.noTextButton(this.actionPrevMatch));
        this.searchBar.add(MiscUtil.noTextButton(this.actionNextMatch));
    }

    private void setStartingLocation() {
        switch (this.mode) {
            case Tree: {
                if (this.groupTree.getLastSelectedPathComponent() != null) {
                    this.searchStartingNode = (GroupTreeNode)this.groupTree.getLastSelectedPathComponent();
                    System.out.println("SearchSupport: setStartingLocation: Current group selection: " + this.groupTree.getLastSelectedPathComponent().toString());
                } else {
                    this.searchStartingNode = (GroupTreeNode)this.groupTree.getModel().getRoot();
                    System.out.println("SearchSupport: setStartingLocation: Starting at the beginning");
                }
            }
            case Table: {
                this.searchStartingTableIndex = this.table.getSelectedRow();
            }
        }
    }

    private void generateSearchNodeList() {
        if (this.mode == SearchMode.Tree) {
            System.out.println("SearchSupport: generateSearchNodeList: Generating list from enumeration");
            GroupTreeNode rootNode = (GroupTreeNode)this.groupTree.getModel().getRoot();
            Enumeration<TreeNode> en = rootNode.preorderEnumeration();
            this.searchNodeList = new ArrayList();
            while (en.hasMoreElements()) {
                this.searchNodeList.add((GroupTreeNode)en.nextElement());
            }
            System.out.println("SearchSupport: generateSearchNodeList: Done generating list from enumeration");
        }
    }

    private void searchNext(boolean reverse) {
        if (!this.updatePattern()) {
            return;
        }
        this.setStartingLocation();
        this.generateSearchNodeList();
        if (this.performSearch(true, reverse)) {
            this.setStartingLocation();
            return;
        }
        this.searchField.setBorder(BorderFactory.createLineBorder(Color.red));
        System.out.println("SearchSupport: incrementalSearch: nothing found");
    }

    private void incrementalSearch() {
        if (!this.updatePattern()) {
            return;
        }
        if (!this.incrementalSearchInProgress) {
            this.setStartingLocation();
            this.generateSearchNodeList();
            this.incrementalSearchInProgress = true;
        }
        if (this.performSearch(false, false)) {
            return;
        }
        this.searchField.setBorder(BorderFactory.createLineBorder(Color.red));
        System.out.println("SearchSupport: incrementalSearch: nothing found");
    }

    private boolean updatePattern() {
        String searchText = this.searchField.getText();
        if (searchText.equals("")) {
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return false;
        }
        System.out.println("SearchSupport: incrementalSearch: searching for text '" + searchText + "'");
        this.pattern = Pattern.compile(searchText, 18);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean performSearch(boolean next, boolean reverse) {
        switch (this.mode) {
            case Tree: {
                GroupTreeNode currentNode;
                if (this.searchStartingNode == null) {
                    System.err.println("SearchSupport: incrementalSearch: currentNode is null!");
                    return false;
                }
                int startingNodeIndex = this.searchNodeList.indexOf(this.searchStartingNode);
                if (startingNodeIndex == -1) {
                    System.err.println("SearchSupport: incrementalSearch: startingNodeIndex is invalid!");
                    return false;
                }
                int i = startingNodeIndex;
                if (this.searchStartingNode.isLeaf() && this.searchLeafNode(this.searchStartingNode, this.searchStartingTableIndex, -1, next, reverse, this.pattern)) {
                    return true;
                }
                do {
                    if (reverse) {
                        if (--i < 0) {
                            i = this.searchNodeList.size() - 1;
                        }
                    } else if (++i >= this.searchNodeList.size()) {
                        i = 0;
                    }
                    if (i != startingNodeIndex) continue;
                    if (!this.searchStartingNode.isLeaf()) return false;
                    if (!this.searchLeafNode(this.searchStartingNode, -1, this.searchStartingTableIndex, false, reverse, this.pattern)) return false;
                    return true;
                } while (!(currentNode = this.searchNodeList.get(i)).isLeaf() || !this.searchLeafNode(currentNode, -1, -1, false, reverse, this.pattern));
                return true;
            }
            case Table: {
                if (this.searchTable(this.searchStartingTableIndex, -1, next, reverse, this.pattern)) {
                    return true;
                }
                if (!this.searchTable(-1, this.searchStartingTableIndex, false, reverse, this.pattern)) return false;
                return true;
            }
        }
        return false;
    }

    private boolean searchLeafNode(GroupTreeNode currentNode, int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        ArrayList<Actor> actorList = currentNode.getActorList();
        System.out.println("SearchSupport: searchLeafNode: searching node " + currentNode.getUserObject().toString() + " starting at index " + startingIndex);
        int index = SearchSupport.searchActorList(actorList, startingIndex, endingIndex, next, reverse, pattern);
        if (index != -1) {
            System.out.println("SearchSupport: searchLeafNode: Found something!");
            TreePath path = new TreePath(currentNode.getPath());
            this.groupTree.setSelectionPath(path);
            this.groupTree.scrollPathToVisible(path);
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return true;
        }
        System.out.println("SearchSupport: incrementalSearch: done searching node");
        return false;
    }

    private boolean searchTable(int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        System.out.println("SearchSupport: searchTable: searching initTable starting at index " + startingIndex);
        int index = this.table.getActorTableModel().searchActors(startingIndex, endingIndex, next, reverse, pattern);
        if (index != -1) {
            System.out.println("SearchSupport: searchTable: Found something!");
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return true;
        }
        System.out.println("SearchSupport: searchTable: done searching");
        return false;
    }

    public static int searchActorList(ArrayList<Actor> actorList, int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern searchPattern) {
        int arraySize = actorList.size();
        System.out.println("SearchSupport: searchActorList: array size is " + arraySize);
        if (startingIndex == -1) {
            startingIndex = reverse ? arraySize - 1 : 0;
        } else if (next) {
            startingIndex = reverse ? --startingIndex : ++startingIndex;
        }
        endingIndex = endingIndex == -1 ? (reverse ? -1 : arraySize) : (reverse ? --endingIndex : ++endingIndex);
        int index = startingIndex;
        while (index != endingIndex && index < arraySize && index >= 0) {
            String actorName = actorList.get(index).getTraitValue(ActorBase.BasicTrait.Name);
            if (searchPattern.matcher(actorName).find()) {
                System.out.println("SearchSupport: searchActorList: found match at index " + index + ", name=" + actorName);
                return index;
            }
            if (reverse) {
                --index;
                continue;
            }
            ++index;
        }
        System.out.println("SearchSupport: searchActorList: reached end of array");
        return -1;
    }

    public JToolBar getSearchToolBar() {
        return this.searchBar;
    }

    public boolean hasFocus() {
        return this.searchField.hasFocus();
    }

    public boolean requestFocus() {
        return this.searchField.requestFocusInWindow();
    }

    private abstract class GAction
    extends AbstractAction {
        public GAction(String text, String tooltip, ImageIcon icon) {
            super(text, icon);
            this.putValue("ShortDescription", tooltip);
        }

        public GAction(String text, String tooltip, int mnemonic, ImageIcon icon) {
            super(text, icon);
            this.putValue("ShortDescription", tooltip);
            this.putValue("MnemonicKey", mnemonic);
        }
    }

    private static enum SearchMode {
        Table,
        Tree;

    }
}

