/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.BasicTable;
import gurpsinittool.app.GITApp;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.app.textfield.ParsingField;
import gurpsinittool.app.textfield.ParsingFieldParser;
import gurpsinittool.app.textfield.ParsingFieldParserFactory;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.GameMaster;
import gurpsinittool.ui.ColumnCustomizer;
import gurpsinittool.util.MiscUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class InitTable
extends BasicTable {
    private static final Logger LOG = Logger.getLogger(InitTable.class.getName());
    private JPopupMenu popupMenu;
    private JPopupMenu headerPopupMenu;
    private Map<ActorBase.ActorStatus, Action> coordinatedStatusMenuItems;
    private InitTableModel tableModel;
    private boolean isInitTable;
    private GameMaster gameMaster;
    private ColumnCustomizer columnCustomizerWindow;
    private Properties propertyBag;
    private String propertyPrefix;

    public InitTable(GameMaster gameMaster, boolean isInitTable, Properties propertyBag) {
        super(new InitTableModel(gameMaster));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.gameMaster = gameMaster;
        this.isInitTable = isInitTable;
        this.propertyBag = propertyBag;
        this.propertyPrefix = "InitTable." + (isInitTable ? "init" : "noninit");
        this.setDefaultProperties();
        this.tableModel = (InitTableModel)this.dataModel;
        gameMaster.addPropertyChangeListener(this.tableModel);
        this.columnCustomizerWindow = new ColumnCustomizer(this.tableModel);
        this.columnCustomizerWindow.setLocation(Integer.valueOf(propertyBag.getProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.x")), Integer.valueOf(propertyBag.getProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.y")));
        this.columnCustomizerWindow.setSize(Integer.valueOf(propertyBag.getProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.width")), Integer.valueOf(propertyBag.getProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.height")));
        this.initialize();
        ArrayList<String> columnArrayNames = new ArrayList<String>(Arrays.asList(propertyBag.getProperty(String.valueOf(this.propertyPrefix) + ".tableModel.columnNames").split(";")));
        this.tableModel.setColumnList(columnArrayNames);
        this.initializeColumnHandling();
    }

    public void autoSizeColumns() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting.");
        }
        TableColumn column = null;
        int i = 0;
        while (i < this.getColumnCount()) {
            column = this.getColumnModel().getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int j = 0;
            while (j < this.getRowCount()) {
                renderer = this.getCellRenderer(j, i);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(j, i), false, false, j, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++j;
            }
            column.setPreferredWidth(width);
            if (this.isInitTable && this.getColumnName(i).equals("Act")) {
                column.setMaxWidth(width);
                column.setMinWidth(width);
            }
            ++i;
        }
    }

    private JMenuItem createCoordinatedStatusMenuItem(Action action, ActorBase.ActorStatus status) {
        JMenuItem menuItem = new JMenuItem(action);
        this.coordinatedStatusMenuItems.put(status, action);
        return menuItem;
    }

    private void updateCoordinatedStatusMenuItems() {
        for (Map.Entry<ActorBase.ActorStatus, Action> entry : this.coordinatedStatusMenuItems.entrySet()) {
            Actor[] actors;
            ActorBase.ActorStatus status = entry.getKey();
            Action action = entry.getValue();
            boolean allSet = true;
            boolean allUnset = true;
            int[] rows = this.getSelectedRows();
            Actor[] actorArray = actors = this.tableModel.getActors(rows);
            int n = actors.length;
            int n2 = 0;
            while (n2 < n) {
                Actor a = actorArray[n2];
                if (a.hasStatus(status)) {
                    allUnset = false;
                } else {
                    allSet = false;
                }
                ++n2;
            }
            if (allSet) {
                action.putValue("SmallIcon", new ImageIcon(GITApp.class.getResource("/resources/images/tick.png"), "Tick"));
                continue;
            }
            if (allUnset) {
                action.putValue("SmallIcon", null);
                continue;
            }
            action.putValue("SmallIcon", new ImageIcon(GITApp.class.getResource("/resources/images/shape_square.png"), "Squar"));
        }
    }

    private void initialize() {
        this.setDefaultRenderer(Object.class, new InitTableCellRenderer());
        this.setDefaultEditor(String.class, new InitTableStringCellEditor(2));
        this.setTransferHandler(new InitTableTransferHandler("name"));
        this.setPreferredScrollableViewportSize(new Dimension(800, 270));
        this.setFillsViewportHeight(true);
        this.setSelectionMode(2);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setSurrendersFocusOnKeystroke(true);
        this.getTableHeader().setDefaultRenderer(new InitTableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.popupMenu = new JPopupMenu();
        this.coordinatedStatusMenuItems = new HashMap<ActorBase.ActorStatus, Action>();
        JMenu menuFile = new JMenu("Status");
        menuFile.setMnemonic(83);
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusAttacking, ActorBase.ActorStatus.Attacking));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusDisabled, ActorBase.ActorStatus.Disabled));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusDisarmed, ActorBase.ActorStatus.Disarmed));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusWaiting, ActorBase.ActorStatus.Waiting));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusMentalStun, ActorBase.ActorStatus.StunMental));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusPhysicalStun, ActorBase.ActorStatus.StunPhys));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusRecoveringStun, ActorBase.ActorStatus.StunRecovr));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusUnconscious, ActorBase.ActorStatus.Unconscious));
        menuFile.add(this.createCoordinatedStatusMenuItem(this.gameMaster.actionCoordinateSelectedStatusDead, ActorBase.ActorStatus.Dead));
        this.popupMenu.add(menuFile);
        menuFile = new JMenu("Posture");
        menuFile.setMnemonic(83);
        menuFile.add(new JMenuItem(this.gameMaster.actionPostureStanding));
        menuFile.add(new JMenuItem(this.gameMaster.actionPostureKneeling));
        menuFile.add(new JMenuItem(this.gameMaster.actionPostureProne));
        this.popupMenu.add(menuFile);
        menuFile = new JMenu("Type");
        menuFile.setMnemonic(84);
        menuFile.add(new JMenuItem(this.gameMaster.actionSetSelectedTypePC));
        menuFile.add(new JMenuItem(this.gameMaster.actionSetSelectedTypeAlly));
        menuFile.add(new JMenuItem(this.gameMaster.actionSetSelectedTypeNeutral));
        menuFile.add(new JMenuItem(this.gameMaster.actionSetSelectedTypeEnemy));
        menuFile.add(new JMenuItem(this.gameMaster.actionSetSelectedTypeSpecial));
        this.popupMenu.add(menuFile);
        if (this.isInitTable) {
            this.popupMenu.add(new JMenuItem(this.gameMaster.actionSetSelectedActorActive));
        }
        if (this.isInitTable) {
            this.popupMenu.add(new JMenuItem(this.gameMaster.actionAttack));
        }
        if (this.isInitTable) {
            this.popupMenu.add(new JMenuItem(this.gameMaster.actionDefend));
        }
        this.popupMenu.add(new JMenuItem(this.gameMaster.actionResetSelectedActors));
        this.popupMenu.add(new JMenuItem(this.gameMaster.actionDeleteSelectedActors));
        if (this.isInitTable) {
            this.popupMenu.add(new JMenuItem(this.gameMaster.actionTagSelectedActors));
        }
        if (this.isInitTable) {
            this.popupMenu.add(new JMenuItem(this.gameMaster.actionRemoveTagSelectedActors));
        }
        this.addMouseListener(new MousePopupListener(false));
        this.headerPopupMenu = new JPopupMenu();
        this.headerPopupMenu.add(new AbstractAction("Customize Columns"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InitTable.this.showColumnCustomizer();
            }
        });
        this.getTableHeader().addMouseListener(new MousePopupListener(true));
        JComboBox<ActorBase.ActorStatus> initTableStateEditor = new JComboBox<ActorBase.ActorStatus>();
        ActorBase.ActorStatus[] actorStatusArray = ActorBase.ActorStatus.values();
        int n = actorStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActorBase.ActorStatus a = actorStatusArray[n2];
            initTableStateEditor.addItem(a);
            ++n2;
        }
    }

    private void initializeColumnHandling() {
        int actColumnIndex = -1;
        int i = 0;
        while (i < this.getColumnCount()) {
            String columnName = this.getColumnName(i);
            if ("Act".equals(columnName)) {
                this.getColumnModel().getColumn(i).setResizable(false);
                actColumnIndex = i;
            } else if (columnName.equals("Speed")) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableCellEditor(ParsingFieldParserFactory.FloatParser()));
            } else if (columnName.equals("Injury") || columnName.equals("Fatigue")) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableDamageCellEditor());
            } else if (columnName.equals("Status")) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableStatusListCellEditor());
            } else if (columnName.equals("Type")) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableTypeListCellEditor());
            } else if (columnName.equals("Name")) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableStringCellEditor(1));
            } else if (Actor.isBasicTrait(columnName)) {
                this.getColumnModel().getColumn(i).setCellEditor(new InitTableCellEditor(ParsingFieldParserFactory.IntegerParser()));
            }
            ++i;
        }
        if (!this.isInitTable && actColumnIndex != -1) {
            this.getColumnModel().removeColumn(this.getColumnModel().getColumn(actColumnIndex));
        }
    }

    public boolean isInitTable() {
        return this.isInitTable;
    }

    public GameMaster getGameMaster() {
        return this.gameMaster;
    }

    public InitTableModel getActorTableModel() {
        return this.tableModel;
    }

    public Actor getSelectedActor() {
        int index = this.getSelectedRow();
        if (index < 0 || index >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.tableModel.getActor(index);
    }

    @Override
    public int[] getSelectedRows() {
        int[] rows = super.getSelectedRows();
        if (rows.length > 0 && rows[rows.length - 1] == this.getRowCount() - 1) {
            if (rows.length == 1) {
                return new int[0];
            }
            int[] newrows = new int[rows.length - 1];
            System.arraycopy(rows, 0, newrows, 0, newrows.length);
            return newrows;
        }
        return rows;
    }

    public Actor[] getSelectedActors() {
        int[] rows = this.getSelectedRows();
        return this.tableModel.getActors(rows);
    }

    public void stopCellEditing() {
        if (this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Got event: " + e + ", type=" + e.getType());
        }
        if (e.getType() == 0 && e.getFirstRow() == -1 && e.getColumn() == -1) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("    Detected data structure change");
            }
            this.initializeColumnHandling();
            this.autoSizeColumns();
        }
    }

    private static void formatComponentAlignment(JLabel c, Actor a, String columnName) {
        c.setHorizontalAlignment(2);
        c.setHorizontalTextPosition(10);
        if (a.hasStatus(ActorBase.ActorStatus.Waiting)) {
            c.setHorizontalAlignment(4);
        }
        if (columnName.equals("Act")) {
            c.setHorizontalAlignment(4);
        }
    }

    private static void formatComponentAlignment(JTextField c, Actor a) {
        c.setHorizontalAlignment(2);
        if (a.hasStatus(ActorBase.ActorStatus.Waiting)) {
            c.setHorizontalAlignment(4);
        }
    }

    private static void formatComponentColor(JComponent c, Actor a, boolean isSelected, boolean isEditable) {
        c.setForeground(Color.black);
        Color paleColor = new Color(255, 255, 255);
        Color greyColor = Color.gray;
        Color backgroundColor = new Color(255, 255, 255);
        switch (a.getType()) {
            case PC: {
                backgroundColor = new Color(128, 255, 128);
                break;
            }
            case Ally: {
                backgroundColor = new Color(128, 128, 255);
                break;
            }
            case Enemy: {
                backgroundColor = new Color(255, 128, 128);
                break;
            }
            case Neutral: {
                backgroundColor = new Color(128, 128, 128);
                break;
            }
            case Special: {
                backgroundColor = new Color(255, 128, 255);
            }
        }
        if (!isSelected) {
            backgroundColor = MiscUtil.setAlpha(backgroundColor, 150);
            backgroundColor = MiscUtil.blend(backgroundColor, paleColor);
        }
        if (!isEditable) {
            greyColor = MiscUtil.setAlpha(greyColor, 75);
            backgroundColor = MiscUtil.blend(backgroundColor, greyColor);
        }
        c.setBackground(backgroundColor);
        if (a.hasStatus(ActorBase.ActorStatus.Unconscious) || a.hasStatus(ActorBase.ActorStatus.Disabled) || a.hasStatus(ActorBase.ActorStatus.Dead)) {
            c.setForeground(Color.gray);
        }
    }

    private void formatEditField(JTextField c, boolean isSelected, boolean isEditable, int row) {
        if (row == this.getRowCount() - 1) {
            c.setBackground(Color.white);
            c.setForeground(Color.gray);
            c.setHorizontalAlignment(2);
            return;
        }
        Actor a = this.tableModel.getActor(row);
        InitTable.formatComponentColor(c, a, isSelected, isEditable);
        InitTable.formatComponentAlignment(c, a);
        c.setBorder(new LineBorder(Color.white));
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey(String.valueOf(this.propertyPrefix) + ".tableModel.columnNames")) {
            this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".tableModel.columnNames", String.join((CharSequence)";", ColumnCustomizer.DEFAULT_COLUMNS));
        }
        if (!this.propertyBag.containsKey(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.x")) {
            this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.x", "110");
        }
        if (!this.propertyBag.containsKey(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.y")) {
            this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.y", "110");
        }
        if (!this.propertyBag.containsKey(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.width")) {
            this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.width", String.valueOf(new ColumnCustomizer(null).getPreferredSize().width));
        }
        if (!this.propertyBag.containsKey(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.height")) {
            this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.height", String.valueOf(new ColumnCustomizer(null).getPreferredSize().height));
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".tableModel.columnNames", String.join((CharSequence)";", this.tableModel.getColumnNames()));
        this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.x", String.valueOf(this.columnCustomizerWindow.getLocation().x));
        this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.location.y", String.valueOf(this.columnCustomizerWindow.getLocation().y));
        this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.width", String.valueOf(this.columnCustomizerWindow.getSize().width));
        this.propertyBag.setProperty(String.valueOf(this.propertyPrefix) + ".columnCustomizer.size.height", String.valueOf(this.columnCustomizerWindow.getSize().height));
    }

    public void showColumnCustomizer() {
        this.columnCustomizerWindow.setVisible(true);
    }

    class InitTableCellEditor
    extends DefaultCellEditor {
        public InitTableCellEditor(ParsingFieldParser parser) {
            super(new ParsingField(parser));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ParsingField c = (ParsingField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (isSelected) {
                c.selectAll();
            }
            InitTable.this.formatEditField(c, isSelected, table.isCellEditable(row, column), row);
            c.refreshForeground();
            return c;
        }
    }

    class InitTableCellRenderer
    extends DefaultTableCellRenderer {
        InitTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String traitValue;
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String columnName = InitTable.this.getColumnName(column);
            c.setIcon(new ImageIcon());
            if (row == table.getRowCount() - 1) {
                c.setBackground(Color.white);
                c.setForeground(Color.gray);
                c.setHorizontalAlignment(2);
                if (columnName.equals("Name")) {
                    c.setText("new...");
                } else if (columnName.equals("Status")) {
                    c.setText("");
                }
                return c;
            }
            Actor a = InitTable.this.tableModel.getActor(row);
            InitTable.formatComponentColor(c, a, isSelected, table.isCellEditable(row, column));
            InitTable.formatComponentAlignment(c, a, columnName);
            if (columnName.equals("Act") && InitTable.this.gameMaster.getActiveActor() == row) {
                c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/go.png"), "Current Actor"));
            } else if (columnName.equals("Status")) {
                c.setText(a.getStatusesString());
            }
            if (columnName.equals("Speed")) {
                if (!ParsingFieldParserFactory.FloatParser().parseIsValid(c.getText())) {
                    c.setForeground(Color.red);
                }
            } else if ((columnName.equals("Move") || columnName.equals("HT") || columnName.equals("HP") || columnName.equals("Injury") || columnName.equals("FP") || columnName.equals("Fatigue")) && !ParsingFieldParserFactory.IntegerParser().parseIsValid(c.getText())) {
                c.setForeground(Color.red);
            }
            if (columnName.equals("Move") || columnName.equals("Dodge")) {
                int injury = a.getTraitValueInt(ActorBase.BasicTrait.Injury);
                int fatigue = a.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
                int hitPoints = a.getTraitValueInt(ActorBase.BasicTrait.HP);
                int fatiguePoints = a.getTraitValueInt(ActorBase.BasicTrait.FP);
                if (injury > 2 * hitPoints / 3 || fatigue > 2 * fatiguePoints / 3) {
                    int newValue;
                    int currentValue = a.getTraitValueInt(columnName);
                    if (injury > 2 * hitPoints / 3 && fatigue > 2 * fatiguePoints / 3) {
                        newValue = (int)Math.ceil((double)currentValue / 4.0);
                        c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/exclamation.png"), "Greatly reduced state"));
                    } else {
                        newValue = (int)Math.ceil((double)currentValue / 2.0);
                        c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Reduced state"));
                    }
                    c.setText(String.valueOf(newValue) + " (" + c.getText() + ")");
                    MiscUtil.setLabelBold(c);
                }
            } else if (columnName.equals("HT")) {
                int injury = a.getTraitValueInt(ActorBase.BasicTrait.Injury);
                int hitPoints = a.getTraitValueInt(ActorBase.BasicTrait.HP);
                if (injury >= (hitPoints = Math.max(hitPoints, 1))) {
                    int penalty = (int)(-1.0 * (Math.floor((double)injury / (double)hitPoints) - 1.0));
                    if (penalty < 0) {
                        MiscUtil.setLabelBold(c);
                        c.setText(String.valueOf(c.getText()) + " [" + penalty + "]");
                    }
                    c.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/error.png"), "Must check to stay conscious"));
                }
            } else if (Actor.isCustomTrait(columnName) && a.hasTrait(columnName) && (traitValue = a.getTraitValue(columnName)).equals("")) {
                c.setText("<html><em>[yes]</em></html>");
            }
            return c;
        }
    }

    class InitTableDamageCellEditor
    extends DefaultCellEditor {
        ParsingField tf;

        public InitTableDamageCellEditor() {
            super(new ParsingField());
            DamageDocumentFilter df = new DamageDocumentFilter();
            this.tf = (ParsingField)this.getComponent();
            this.tf.setParser(new DamageFieldParser());
            this.tf.addFocusListener(df);
            ((AbstractDocument)this.tf.getDocument()).setDocumentFilter(df);
        }

        @Override
        public Object getCellEditorValue() {
            return this.tf.getParsedValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf = (ParsingField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            InitTable.this.formatEditField(this.tf, isSelected, table.isCellEditable(row, column), row);
            this.tf.refreshForeground();
            return this.tf;
        }

        private class DamageDocumentFilter
        extends DocumentFilter
        implements FocusListener {
            boolean startingNew = true;
            boolean firstEdit = true;
            boolean hasFocus = false;

            private DamageDocumentFilter() {
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offs, int length) throws BadLocationException {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Remove: offs: " + offs + ", len:" + length + ".");
                }
                this.startingNew = false;
                super.remove(fb, offs, length);
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Insert:" + str + ".");
                }
                super.insertString(fb, offs, str, a);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Replace: '" + str + "', Offs=" + offs + ", Length=" + length + ".");
                }
                if (this.hasFocus || this.firstEdit || length > 0) {
                    this.firstEdit = false;
                    this.startingNew = true;
                    super.replace(fb, offs, length, str, a);
                } else if (this.startingNew && str.matches("\\d")) {
                    this.startingNew = false;
                    super.replace(fb, offs, 0, "+", null);
                    super.replace(fb, offs + 1, 0, str, a);
                } else if (this.startingNew && str.matches("=")) {
                    this.startingNew = false;
                    super.replace(fb, offs, 0, "+", null);
                } else {
                    this.startingNew = false;
                    super.replace(fb, offs, 0, str, a);
                }
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                this.hasFocus = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TextField focus gained.");
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                this.hasFocus = false;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TextField focus lost.");
                }
            }
        }

        private class DamageFieldParser
        extends ParsingFieldParser {
            Pattern pattern = Pattern.compile("^\\s*(-?\\d+)\\s*([\\+-])\\s*(-?\\d+)([\\s+-].*)?$");

            private DamageFieldParser() {
            }

            @Override
            public boolean parseIsValid(String text) {
                String result = this.internalParse(text);
                try {
                    Integer.valueOf(result);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }

            @Override
            public Object parseText(String text) {
                return this.internalParse(text);
            }

            private String internalParse(String working) {
                working = working.trim();
                Matcher matcher = this.pattern.matcher(working);
                while (matcher.matches()) {
                    Integer first = Integer.valueOf(matcher.group(1));
                    String operator = matcher.group(2);
                    Integer second = Integer.valueOf(matcher.group(3));
                    first = operator.equals("+") ? Integer.valueOf(first + second) : Integer.valueOf(first - second);
                    String extra = matcher.group(4);
                    if (extra != null) {
                        working = String.valueOf(first.toString()) + extra;
                        matcher = this.pattern.matcher(working);
                        continue;
                    }
                    return first.toString();
                }
                return working;
            }
        }
    }

    class InitTableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer base;

        public InitTableHeaderRenderer(TableCellRenderer base) {
            this.base = base;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)this.base.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String columnName = InitTable.this.getColumnName(column);
            if (columnName.equals("Injury") || columnName.equals("Fatigue")) {
                c.setForeground(Color.red);
            }
            return c;
        }
    }

    class InitTableStatusListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    FocusListener,
    ComponentListener {
        JList<ActorBase.ActorStatus> list;
        JScrollPane pane;
        JButton button = new JButton();
        JDialog dialog = null;
        boolean isEditing = false;

        public InitTableStatusListCellEditor() {
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setActionCommand("EDIT");
            this.button.addActionListener(this);
            this.button.addFocusListener(this);
            this.list = new JList<ActorBase.ActorStatus>(ActorBase.ActorStatus.values());
            this.list.setVisibleRowCount(ActorBase.ActorStatus.values().length);
            this.list.setSelectionMode(2);
            this.list.setSelectionModel(new DefaultListSelectionModel(){
                boolean gestureStarted = false;
                boolean adding = true;

                @Override
                public void setSelectionInterval(int index0, int index1) {
                    if (this.getValueIsAdjusting() && !this.gestureStarted && index0 != -1 && index1 != -1) {
                        this.adding = !super.isSelectedIndex(index0);
                        this.gestureStarted = true;
                    }
                    if (!this.getValueIsAdjusting() || this.adding) {
                        super.addSelectionInterval(index0, index1);
                    } else {
                        super.removeSelectionInterval(index0, index1);
                    }
                }

                @Override
                public void setValueIsAdjusting(boolean isAdjusting) {
                    if (!isAdjusting) {
                        this.gestureStarted = false;
                    }
                    super.setValueIsAdjusting(isAdjusting);
                }
            });
            this.pane = new JScrollPane(this.list);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.dialog == null) {
                this.dialog = new JDialog((Frame)InitTable.this.getTopLevelAncestor(), false);
                this.dialog.add(this.pane);
                this.dialog.setUndecorated(true);
                this.dialog.setBounds(0, 0, 10, 10);
                this.dialog.setModal(false);
                this.dialog.setFocusableWindowState(false);
                InitTable.this.getTopLevelAncestor().addComponentListener(this);
            }
            this.list.clearSelection();
            for (ActorBase.ActorStatus status : (HashSet)value) {
                this.list.setSelectedValue((Object)status, true);
            }
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            HashSet<ActorBase.ActorStatus> statuses = new HashSet<ActorBase.ActorStatus>(this.list.getSelectedValuesList());
            return statuses;
        }

        @Override
        public boolean stopCellEditing() {
            boolean retval = super.stopCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
            return retval;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("EDIT")) {
                this.dialog.setLocation(this.button.getLocationOnScreen());
                this.dialog.setSize(this.button.getWidth(), this.dialog.getPreferredSize().height);
                this.dialog.setVisible(true);
                this.isEditing = true;
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class InitTableStringCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private String actorName;
        Actor actor;

        public InitTableStringCellEditor(int clicksToStart) {
            super(new JTextField());
            this.setClickCountToStart(clicksToStart);
            this.editorComponent.addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.actor = ((InitTableModel)table.getModel()).getActor(row);
            this.actorName = this.actor.getTraitValue(ActorBase.BasicTrait.Name);
            InitTable.this.formatEditField(c, isSelected, table.isCellEditable(row, column), row);
            return c;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            String selctedActorName;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Focus gained on " + evt.toString());
            }
            if (!(selctedActorName = this.actor.getTraitValue(ActorBase.BasicTrait.Name)).equals(this.actorName)) {
                JTextField t = (JTextField)evt.getComponent();
                this.actorName = selctedActorName;
                t.setText(this.actorName);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Focus lost on " + evt.toString());
            }
            this.stopCellEditing();
        }
    }

    class InitTableTypeListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    MouseListener,
    FocusListener,
    ComponentListener {
        JList<ActorBase.ActorType> list;
        JScrollPane pane;
        JButton button = new JButton();
        JDialog dialog = null;
        boolean isEditing = false;

        public InitTableTypeListCellEditor() {
            this.button.setBorderPainted(false);
            this.button.setFocusPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setActionCommand("EDIT");
            this.button.addActionListener(this);
            this.button.addFocusListener(this);
            this.list = new JList<ActorBase.ActorType>(ActorBase.ActorType.values());
            this.list.setVisibleRowCount(ActorBase.ActorType.values().length);
            this.list.setSelectionMode(0);
            this.list.addMouseListener(this);
            this.pane = new JScrollPane(this.list);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.dialog == null) {
                this.dialog = new JDialog((Frame)InitTable.this.getTopLevelAncestor(), false);
                this.dialog.add(this.pane);
                this.dialog.setUndecorated(true);
                this.dialog.setBounds(0, 0, 10, 10);
                this.dialog.setModal(false);
                this.dialog.setFocusableWindowState(false);
                InitTable.this.getTopLevelAncestor().addComponentListener(this);
            }
            this.list.setSelectedValue(value, true);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.list.getSelectedValue();
        }

        @Override
        public boolean stopCellEditing() {
            boolean retval = super.stopCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
            return retval;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.dialog.setVisible(false);
            this.isEditing = false;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("EDIT")) {
                this.dialog.setLocation(this.button.getLocationOnScreen());
                this.dialog.setSize(this.button.getWidth(), this.dialog.getPreferredSize().height);
                this.dialog.setVisible(true);
                this.isEditing = true;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isEditing) {
                this.stopCellEditing();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.isEditing) {
                this.cancelCellEditing();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.isEditing) {
                this.cancelCellEditing();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        private boolean isHeader;

        public MousePopupListener(boolean isHeader) {
            this.isHeader = isHeader;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
            this.checkResize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (this.isHeader) {
                if (e.isPopupTrigger()) {
                    InitTable.this.headerPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (e.isPopupTrigger() & InitTable.this.getSelectedRows().length > 0) {
                InitTable.this.updateCoordinatedStatusMenuItems();
                InitTable.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void checkResize(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Cursor currentCursor = InitTable.this.getTableHeader().getCursor();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Double-click detected. Type is " + currentCursor.getType() + " (" + currentCursor.toString() + ")");
                }
                if (currentCursor.getType() == 11) {
                    InitTable.this.autoSizeColumns();
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Auto-sizing columns.");
                    }
                }
            }
        }
    }

    public abstract class TableColumnAction
    extends AbstractAction {
        private TableColumn column;
        private String name;

        public TableColumnAction(TableColumn column, String text) {
            super(text);
            this.putValue("SwingSelectedKey", true);
            this.column = column;
            this.name = text;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)arg0.getSource();
            if (menuItem.isSelected()) {
                InitTable.this.getColumnModel().addColumn(this.column);
            } else {
                InitTable.this.getColumnModel().removeColumn(this.column);
            }
        }
    }
}

