/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.GroupTreeTransferHandler;
import gurpsinittool.app.InitTable;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.GameMaster;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class InitTableTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(InitTableTransferHandler.class.getName());
    protected static DataFlavor initTableActorFlavor = new DataFlavor(InitTable.class, "GURPS Actor Object from init table");
    protected static DataFlavor groupTableActorFlavor = new DataFlavor(GroupTree.class, "GURPS Actor Object from group table");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{initTableActorFlavor, groupTableActorFlavor};

    public InitTableTransferHandler(String property) {
        super(property);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!(support.isDataFlavorSupported(initTableActorFlavor) || support.isDataFlavorSupported(groupTableActorFlavor) || support.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor))) {
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        InitTable table = (InitTable)support.getComponent();
        int row = dl.getRow();
        if (row == table.getRowCount()) {
            support.setShowDropLocation(false);
        }
        if (support.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor)) {
            support.setDropAction(1);
        }
        if (table.isInitTable() != support.isDataFlavorSupported(initTableActorFlavor)) {
            support.setDropAction(1);
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Actor[] actorRows;
        if (!this.canImport(support)) {
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting transferable data for InitTable import...");
        }
        Transferable t = support.getTransferable();
        try {
            if (t.isDataFlavorSupported(GroupTreeTransferHandler.actorGroupFlavor)) {
                GroupTreeNode node = (GroupTreeNode)t.getTransferData(GroupTreeTransferHandler.actorGroupFlavor);
                ArrayList<Actor> actors = node.getActorList();
                actorRows = actors.subList(0, actors.size() - 1).toArray(new Actor[0]);
            } else {
                actorRows = (Actor[])t.getTransferData(initTableActorFlavor);
            }
        }
        catch (UnsupportedFlavorException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Unsupported Flavor Exception: " + e.getMessage(), e);
            }
            return false;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "IOException: " + e.getMessage(), e);
            }
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Transferable data retrieved.");
        }
        InitTable table = (InitTable)support.getComponent();
        GameMaster gameMaster = table.getGameMaster();
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        table.stopCellEditing();
        int row = dl.getRow();
        if (row >= table.getRowCount()) {
            row = table.getRowCount() - 1;
        }
        gameMaster.startCompoundEdit();
        int i = actorRows.length - 1;
        while (i >= 0) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Adding actor # " + i + " @ row: " + row);
            }
            gameMaster.addActor(actorRows[i], row);
            table.getSelectionModel().addSelectionInterval(row, row);
            --i;
        }
        if (support.getDropAction() != 2) {
            gameMaster.endCompoundEdit("Copy");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Getting import data request: " + row + " String " + dl.toString());
            DataFlavor[] flavors = support.getDataFlavors();
            int i2 = 0;
            while (i2 < flavors.length) {
                LOG.finest("Debug flavor: " + flavors[i2].toString());
                ++i2;
            }
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        InitTable table = (InitTable)c;
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        Arrays.sort(rows);
        InitTableModel tableModel = table.getActorTableModel();
        Actor[] actorRows = tableModel.getActors(rows);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating new TransferableActor");
        }
        return new TransferableActor(actorRows, table.isInitTable());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            Actor[] actors;
            InitTable table = (InitTable)source;
            GameMaster gameMaster = table.getGameMaster();
            try {
                actors = (Actor[])data.getTransferData(initTableActorFlavor);
            }
            catch (UnsupportedFlavorException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "UnsupportedFlavorException: " + e.getMessage() + e);
                }
                return;
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "IOException: " + e.getMessage() + e);
                }
                return;
            }
            int i = 0;
            while (i < actors.length) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("After move, deleting actor " + actors[i].getTraitValue(ActorBase.BasicTrait.Name) + "...");
                }
                gameMaster.removeActor(actors[i]);
                ++i;
            }
            gameMaster.endCompoundEdit("Move");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Done: " + action);
        }
    }

    class TransferableActor
    implements Transferable {
        Actor[] actorRows;
        boolean isSourceInitTable;

        public TransferableActor(Actor[] actorRows, boolean isSourceInitTable) {
            this.actorRows = actorRows;
            this.isSourceInitTable = isSourceInitTable;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.isSourceInitTable) {
                return new DataFlavor[]{initTableActorFlavor};
            }
            return new DataFlavor[]{groupTableActorFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Starting to return data for flavor: " + flavor.toString());
            }
            if (flavor.equals(initTableActorFlavor) || flavor.equals(groupTableActorFlavor)) {
                return this.actorRows;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(initTableActorFlavor) && this.isSourceInitTable || flavor.equals(groupTableActorFlavor) && !this.isSourceInitTable;
        }
    }
}

