/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class TraitTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(TraitTableModel.class.getName());
    private String[] columnNames = new String[]{"Name", "Value"};
    private Class<?>[] columnClasses = new Class[]{String.class, String.class};
    private static int numColumns = 2;
    private boolean isTemp;
    private Actor currentActor = null;
    private ArrayList<String> displayedTraitKeys = new ArrayList();

    public TraitTableModel(boolean isTemp) {
        this.isTemp = isTemp;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.currentActor == null) {
            return 0;
        }
        return this.displayedTraitKeys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentActor == null) {
            return null;
        }
        String traitName = this.displayedTraitKeys.get(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return traitName;
            }
            case Value: {
                if (this.isTemp) {
                    return this.currentActor.getTempValue(traitName);
                }
                return this.currentActor.getTraitValue(traitName);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        }
        if (this.isTemp) {
            return;
        }
        if (this.getValueAt(row, col).equals(value)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Values are identical. Exiting.");
            }
            return;
        }
        String traitName = this.displayedTraitKeys.get(row);
        switch (columns.values()[col]) {
            case Name: {
                String newName = (String)value;
                if (this.currentActor.renameTrait(traitName, newName) || !LOG.isLoggable(Level.INFO)) break;
                LOG.info("Rename failed!");
                break;
            }
            case Value: {
                this.currentActor.setTrait(traitName, (String)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return !this.isTemp && this.currentActor != null;
    }

    public void setActor(Actor actor) {
        if (actor == this.currentActor) {
            return;
        }
        if (this.currentActor != null) {
            this.currentActor.removePropertyChangeListener(this);
        }
        this.currentActor = actor;
        if (this.currentActor != null) {
            this.currentActor.addPropertyChangeListener(this);
        }
        this.rebuildTable();
    }

    public void rebuildTable() {
        this.displayedTraitKeys.clear();
        this.displayedTraitKeys.addAll(this.getTraitNames());
        this.fireTableDataChanged();
    }

    private ArrayList<String> getTraitNames() {
        ArrayList<String> theList = new ArrayList<String>();
        if (this.currentActor != null) {
            if (this.isTemp) {
                theList.addAll(this.currentActor.getAllTempNames());
            } else {
                for (String traitName : this.currentActor.getAllTraitNames()) {
                    if (Actor.isBasicTrait(traitName)) continue;
                    theList.add(traitName);
                }
            }
        }
        Collections.sort(theList);
        return theList;
    }

    public String addTrait() {
        if (!this.isTemp && this.currentActor != null) {
            int num = 1;
            String prefix = "_new trait";
            while (this.currentActor.hasTrait(String.valueOf(prefix) + String.valueOf(num))) {
                ++num;
            }
            String name = String.valueOf(prefix) + String.valueOf(num);
            this.currentActor.addTrait(name, "");
            return name;
        }
        return null;
    }

    public int getTraitRow(String name) {
        int i = 0;
        while (i < this.displayedTraitKeys.size()) {
            if (name.equals(this.displayedTraitKeys.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeTraits(int[] rows) {
        if (!this.isTemp && this.currentActor != null && rows.length > 0) {
            int i = rows.length - 1;
            while (i >= 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Deleting row: " + rows[i]);
                }
                String traitName = this.displayedTraitKeys.get(rows[i]);
                this.currentActor.removeTrait(traitName);
                --i;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.isTemp) {
            return;
        }
        if (e.getSource() != this.currentActor) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Source of event is not current actor! Shouldn't happen!");
            }
        } else if (e.getPropertyName().startsWith("trait.")) {
            String name = e.getPropertyName().replaceFirst("^trait.", "");
            if (e.getOldValue() == null) {
                if (!Actor.isCustomTrait(name) && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Newly created trait is not custom! " + name);
                }
                if (this.displayedTraitKeys.contains(name) && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Newly created trait already in list of displayed traits! " + name);
                }
                this.displayedTraitKeys.add(name);
                this.fireTableRowsInserted(this.displayedTraitKeys.size() - 1, this.displayedTraitKeys.size() - 1);
            } else if (e.getNewValue() == null) {
                if (!this.displayedTraitKeys.contains(name) && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Deleted trait not in display traits list! " + name);
                }
                int index = this.displayedTraitKeys.indexOf(name);
                this.displayedTraitKeys.remove(index);
                this.fireTableRowsDeleted(index, index);
            } else if (Actor.isCustomTrait(name)) {
                if (!this.displayedTraitKeys.contains(name) && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Changed trait not in display traits list! " + name);
                }
                this.fireTableCellUpdated(this.displayedTraitKeys.indexOf(name), columns.Value.ordinal());
            }
        } else if ("traitName".equals(e.getPropertyName())) {
            if (!this.displayedTraitKeys.contains(e.getOldValue()) && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Renamed trait original name not in display traits list! " + e.getOldValue());
            }
            int index = this.displayedTraitKeys.indexOf(e.getOldValue());
            this.displayedTraitKeys.set(index, (String)e.getNewValue());
            this.fireTableCellUpdated(index, columns.Name.ordinal());
        }
    }

    public static enum columns {
        Name,
        Value;

    }
}

