/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Attack;
import gurpsinittool.data.CriticalTables;
import gurpsinittool.data.Damage;
import gurpsinittool.data.Defense;
import gurpsinittool.data.StrengthTables;
import gurpsinittool.util.DieRoller;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Actor
extends ActorBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Actor.class.getName());

    public Actor() {
    }

    public Actor(Actor anActor) {
        super(anActor);
    }

    public void nextTurn() {
        int injury;
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        if (Actor.settings.autoShock) {
            injury = this.getTempInt("shock.next");
            int injuryPerShock = this.getTraitValueInt(ActorBase.BasicTrait.HP) / 10;
            int n = injuryPerShock = injuryPerShock == 0 ? 1 : injuryPerShock;
            int shockMultiplier = this.hasTrait("High Pain Threshold") ? 0 : (this.hasTrait("Low Pain Threshold") ? 2 : 1);
            this.setTemp("shock", shockMultiplier * Math.min(injury / injuryPerShock, 4));
        }
        this.setTemp("shock.next", 0);
        injury = this.getTraitValueInt(ActorBase.BasicTrait.Injury);
        int hitPoints = this.getTraitValueInt(ActorBase.BasicTrait.HP);
        int health = this.getTraitValueInt(ActorBase.BasicTrait.HT);
        if (!(!this.isTypeAutomated() || this.hasStatus(ActorBase.ActorStatus.Unconscious) || this.hasStatus(ActorBase.ActorStatus.Disabled) || this.hasStatus(ActorBase.ActorStatus.Dead) || this.hasStatus(ActorBase.ActorStatus.Waiting))) {
            if (Actor.settings.autoUnconscious && injury >= hitPoints) {
                int penalty = (int)(-1.0 * (Math.floor((double)injury / (double)hitPoints) - 1.0));
                int result = DieRoller.roll3d6();
                String details = "(HT: " + health + ", penalty: " + penalty + ", roll: " + result + ")";
                if (DieRoller.isFailure(result, health + penalty)) {
                    this.logEventTypeName("<b><font color=red>failed</font></b> consciousness roll " + details);
                    this.setAllStatuses(new HashSet<ActorBase.ActorStatus>(Arrays.asList(ActorBase.ActorStatus.Unconscious, ActorBase.ActorStatus.Prone, ActorBase.ActorStatus.Disarmed)));
                } else {
                    this.logEventTypeName("passed consciousness roll " + details);
                }
            }
            if (Actor.settings.autoStunRecovery) {
                int roll;
                int recoverTarget;
                this.removeStatus(ActorBase.ActorStatus.StunRecovr);
                if (this.hasStatus(ActorBase.ActorStatus.StunMental)) {
                    recoverTarget = this.getTraitValueInt(ActorBase.BasicTrait.IQ);
                    if (this.hasTrait("Combat Reflexes")) {
                        recoverTarget += 6;
                    }
                    if (DieRoller.isSuccess(roll = DieRoller.roll3d6(), recoverTarget)) {
                        this.logEventTypeName("is now recovering from Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorBase.ActorStatus.StunMental);
                        this.addStatus(ActorBase.ActorStatus.StunRecovr);
                    } else {
                        this.logEventTypeName("<b>failed</b> recovery roll for Mental Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                }
                if (this.hasStatus(ActorBase.ActorStatus.StunPhys)) {
                    recoverTarget = this.getTraitValueInt(ActorBase.BasicTrait.HT);
                    roll = DieRoller.roll3d6();
                    if (DieRoller.isSuccess(roll, recoverTarget)) {
                        this.logEventTypeName("is now recovering from Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                        this.removeStatus(ActorBase.ActorStatus.StunPhys);
                        this.addStatus(ActorBase.ActorStatus.StunRecovr);
                    } else {
                        this.logEventTypeName("<b>failed</b> recovery roll for Physical Stun (rolled " + roll + " against " + recoverTarget + ")");
                    }
                }
            }
            if (Actor.settings.autoAttack && this.hasStatus(ActorBase.ActorStatus.Attacking) && !this.isStunned()) {
                this.attack();
            }
        }
    }

    public void reset() {
        this.clearStatuses();
        this.setTrait(ActorBase.BasicTrait.Injury, "0");
        this.setTrait(ActorBase.BasicTrait.Fatigue, "0");
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    public boolean isStunned() {
        return this.hasStatus(ActorBase.ActorStatus.StunPhys) || this.hasStatus(ActorBase.ActorStatus.StunMental) || this.hasStatus(ActorBase.ActorStatus.StunRecovr);
    }

    public void attack(int num) {
        String damageStr;
        CriticalTables.Entry critResult;
        String hitOrMiss;
        if (num < 0 || num >= this.attacks.size()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Invalid attack attempted: id # " + String.valueOf(num));
            }
            return;
        }
        Attack attack = (Attack)this.attacks.get(num);
        int effSkill = attack.skill;
        if (this.hasStatus(ActorBase.ActorStatus.Prone)) {
            effSkill -= 4;
        } else if (this.hasStatus(ActorBase.ActorStatus.Kneeling)) {
            effSkill -= 2;
        }
        if (Actor.settings.autoShock) {
            effSkill -= this.getTempInt("shock");
        }
        int roll = DieRoller.roll3d6();
        int margin = effSkill - roll;
        String critString = "";
        if (DieRoller.isCritFailure(roll, effSkill)) {
            hitOrMiss = "<b><font color=red>Critical miss</font></b>";
            critResult = CriticalTables.getRandomEntry(CriticalTables.criticalMiss);
            critString = "<br/> <i><font color=gray><b>Critical Miss Table Result:</b>" + critResult.notes + "</font></i>";
        } else if (DieRoller.isCritSuccess(roll, effSkill)) {
            hitOrMiss = "<b><font color=blue>Critical hit</font></b>";
            critResult = CriticalTables.getRandomEntry(CriticalTables.criticalHit);
            critString = "<br/> <i><font color=gray><b>Critical Hit Table Result:</b>" + critResult.notes + "</font></i>";
        } else {
            hitOrMiss = DieRoller.isSuccess(roll, effSkill) ? "<b>hit</b>" : "miss";
        }
        boolean isHit = DieRoller.isSuccess(roll, effSkill);
        if (attack.unbalanced) {
            this.setTemp("numParry", this.getTempInt("numParry") + 1);
        }
        try {
            Damage damage = Damage.parseDamage(attack.damage);
            String armorDivStr = "";
            if (damage.armorDivisor != 1.0) {
                armorDivStr = damage.armorDivisor == (double)((int)damage.armorDivisor) ? "(" + String.format("%d", (int)damage.armorDivisor) + ")" : "(" + String.format("%s", damage.armorDivisor) + ")";
            }
            damageStr = String.valueOf(isHit ? "<font color=red><b>" : "") + damage.basicDamage + armorDivStr + " " + (Object)((Object)damage.type) + (isHit ? "</b></font>" : "") + " (" + attack.damage + ")";
        }
        catch (ParseException e) {
            damageStr = String.valueOf(isHit ? "<font color=red><b>" : "") + "'" + attack.damage + "'" + (isHit ? "</b></font>" : "");
        }
        this.logEventTypeName("attacks with " + attack.name + ": " + hitOrMiss + " (" + roll + "/" + effSkill + "=" + margin + ") for damage " + damageStr + critString);
    }

    public void attack() {
        if (this.attacks.size() < 1) {
            this.logEventTypeName("<i><font color=gray>has no attacks defined!</font></i>");
            return;
        }
        if (this.defaultAttack < 0 || this.defaultAttack >= this.attacks.size()) {
            this.logEventError("has invalid default attack: " + this.defaultAttack);
            return;
        }
        this.attack(this.defaultAttack);
    }

    public String defend(Defense defense) {
        this.startCompoundEdit();
        this.recordDefenseAttempt(defense);
        this.logDefenseResults(defense);
        this.processDefenseResults(defense);
        this.knockdownStunningCheck(defense);
        this.endCompoundEdit("Defend");
        return "";
    }

    private void recordDefenseAttempt(Defense defense) {
        int fatigue = this.getTraitValueInt(ActorBase.BasicTrait.Fatigue);
        this.setTrait(ActorBase.BasicTrait.Fatigue, String.valueOf(fatigue + defense.fatigue));
        this.setTemp("shieldDamage", this.getTempInt("shieldDamage") + defense.shieldDamage);
        switch (defense.type) {
            case Parry: {
                this.setTemp("numParry", this.getTempInt("numParry") + 1);
                break;
            }
            case Block: {
                this.setTemp("numBlock", this.getTempInt("numBlock") + 1);
            }
        }
    }

    private void logDefenseResults(Defense defense) {
        String resultType = defense.result == Defense.DefenseResult.CritSuccess ? "<b><font color=blue>critically</font></b>" : (defense.result == Defense.DefenseResult.Success ? "successfully" : (defense.result == Defense.DefenseResult.ShieldHit ? "partially" : "unsuccessfully"));
        String defenseDescription = "";
        switch (defense.type) {
            case Parry: {
                defenseDescription = String.valueOf(resultType) + " parried blow.";
                break;
            }
            case Block: {
                defenseDescription = String.valueOf(resultType) + " blocked blow.";
                break;
            }
            case Dodge: {
                defenseDescription = String.valueOf(resultType) + " dodged blow.";
                break;
            }
            case None: {
                defenseDescription = "made no defense against blow.";
            }
        }
        if (defense.result == Defense.DefenseResult.CritFailure) {
            defenseDescription = "<b><font color=red>critically</font></b> failed " + defense.type.toString().toLowerCase() + ".";
        }
        String damageDescription = "";
        if (defense.injury != 0) {
            String knockdownstunningPenalty;
            damageDescription = " Sustained <b><font color=red>" + defense.injury + "</font></b> injury to the " + defense.location.type.name();
            String string = knockdownstunningPenalty = defense.location.knockdownPenalty != 0 ? " @ " + defense.location.knockdownPenalty : "";
            if (defense.cripplingInjury) {
                damageDescription = String.valueOf(damageDescription) + " <b>(crippling" + knockdownstunningPenalty + ")</br>";
            } else if (defense.majorWound) {
                damageDescription = String.valueOf(damageDescription) + " <b>(major" + knockdownstunningPenalty + ")</br>";
            }
            damageDescription = String.valueOf(damageDescription) + ".";
        } else if (defense.result == Defense.DefenseResult.ShieldHit || defense.result == Defense.DefenseResult.Failure) {
            damageDescription = " But took no injury.";
        }
        if (defense.shieldDamage != 0) {
            damageDescription = String.valueOf(damageDescription) + " <b>Shield damaged " + defense.shieldDamage + ".</b>";
        }
        this.logEventTypeName(String.valueOf(defenseDescription) + damageDescription);
        if (Actor.settings.logDefenseDetails) {
            String details = "defense details: " + defense.type.toString() + this.defenseNumberReport(defense.type);
            ArrayList<String> additional = new ArrayList<String>();
            if (defense.position != "Standing") {
                additional.add("position: " + defense.position);
            }
            if (defense.ee) {
                additional.add("EE");
            }
            if (defense.retreat) {
                additional.add("retreating");
            }
            if (defense.side) {
                additional.add("side attack");
            }
            if (defense.stunned) {
                additional.add("stunned");
            }
            if (defense.shield) {
                additional.add("shield used");
            }
            if (defense.otherMod != 0) {
                additional.add("other:" + String.valueOf(defense.otherMod));
            }
            if (!additional.isEmpty()) {
                details = String.valueOf(details) + ", " + String.join((CharSequence)";", additional);
            }
            details = String.valueOf(details) + ", effective defense: " + String.valueOf(defense.effectiveDefense) + "/ roll: " + String.valueOf(defense.roll) + ".";
            this.logEventTypeName(details);
        }
    }

    private String defenseNumberReport(Defense.DefenseType type) {
        int num = 0;
        switch (type) {
            case Parry: {
                num = this.getTempInt("numParry");
                break;
            }
            case Block: {
                num = this.getTempInt("numBlock");
            }
        }
        String result = "";
        if (num > 1) {
            result = " (" + String.valueOf(num);
            switch (num) {
                case 2: {
                    result = String.valueOf(result) + "nd";
                    break;
                }
                case 3: {
                    result = String.valueOf(result) + "rd";
                    break;
                }
                default: {
                    result = String.valueOf(result) + "th";
                }
            }
            result = String.valueOf(result) + " this turn)";
        }
        return result;
    }

    private void processDefenseResults(Defense defense) {
        this.setTrait(ActorBase.BasicTrait.Injury, String.valueOf(this.getTraitValueInt(ActorBase.BasicTrait.Injury) + defense.injury));
        if (defense.result == Defense.DefenseResult.CritFailure) {
            switch (defense.type) {
                case Parry: {
                    CriticalTables.Entry critResult = CriticalTables.getRandomEntry(CriticalTables.criticalMiss);
                    String critString = "<i><font color=gray><b>Critical Miss Table Result:</b>" + critResult.notes + "</font></i>";
                    this.logEventTypeName(critString);
                    break;
                }
                case Block: {
                    this.logEventTypeName("Loses grip on shield, must ready before next block");
                    break;
                }
                case Dodge: {
                    if (!this.hasStatus(ActorBase.ActorStatus.Prone)) {
                        this.logEventTypeName("Falls prone.");
                    }
                    this.setPosture(ActorBase.ActorStatus.Prone);
                    break;
                }
                case None: {
                    if (!LOG.isLoggable(Level.WARNING)) break;
                    LOG.warning("Unexpected 'None' defense type for critical failure!");
                }
            }
            if (defense.ee) {
                this.setTrait(ActorBase.BasicTrait.Injury, String.valueOf(this.getTraitValueInt(ActorBase.BasicTrait.Injury) + 1));
            }
        }
    }

    private void knockdownStunningCheck(Defense defense) {
        int health = this.getTraitValueInt(ActorBase.BasicTrait.HT);
        int hitPoints = this.getTraitValueInt(ActorBase.BasicTrait.HP);
        if (defense.cripplingInjury || defense.majorWound || (double)defense.injury >= (double)hitPoints / 10.0 && (defense.location.headWound || defense.location.knockdownPenalty < 0)) {
            int effHT = health;
            String knockdownDescription = "";
            if (defense.cripplingInjury) {
                effHT += defense.location.knockdownPenalty;
                knockdownDescription = " for crippling injury";
            } else if (defense.majorWound) {
                effHT += defense.location.knockdownPenalty;
                knockdownDescription = " for major wound";
            }
            if (this.hasTrait("High Pain Threshold")) {
                effHT += 3;
            }
            if (this.hasTrait("Low Pain Threshold")) {
                effHT -= 4;
            }
            int roll = DieRoller.roll3d6();
            boolean success = DieRoller.isSuccess(roll, effHT);
            this.logEventTypeName("Knockdown/Stunning check" + knockdownDescription + ": rolled " + roll + " against " + effHT + " => " + (!success ? "<b>failed</b>" : "succeeded"));
            if (this.isTypeAutomated() && Actor.settings.autoKnockdownStun && !success) {
                this.addStatus(ActorBase.ActorStatus.StunPhys);
                this.removeStatus(ActorBase.ActorStatus.StunRecovr);
                this.setPosture(ActorBase.ActorStatus.Prone);
                this.addStatus(ActorBase.ActorStatus.Disarmed);
            }
        }
    }

    public int getCurrentDefenseValue(Defense.DefenseType type) {
        int currentDefense = 0;
        switch (type) {
            case Parry: {
                currentDefense = this.getTraitValueInt(ActorBase.BasicTrait.Parry) - this.getTempInt("numParry") * 4;
                break;
            }
            case Block: {
                currentDefense = this.getTraitValueInt(ActorBase.BasicTrait.Block) - this.getTempInt("numBlock") * 5;
                break;
            }
            case Dodge: {
                currentDefense = this.getTraitValueInt(ActorBase.BasicTrait.Dodge);
                if (this.getTraitValueInt(ActorBase.BasicTrait.Injury) > 2 * this.getTraitValueInt(ActorBase.BasicTrait.HP) / 3) {
                    currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
                }
                if (this.getTraitValueInt(ActorBase.BasicTrait.Fatigue) <= 2 * this.getTraitValueInt(ActorBase.BasicTrait.FP) / 3) break;
                currentDefense = (int)Math.ceil((double)currentDefense / 2.0);
            }
        }
        return currentDefense;
    }

    @Override
    protected String calculateTrait(ActorBase.CalculatedTrait calcTrait) {
        int strength = this.getTraitValueInt(ActorBase.BasicTrait.ST);
        int strikingST = this.hasTrait("Striking ST") ? this.getTraitValueInt("Striking ST") : 0;
        int liftingST = this.hasTrait("Lifting ST") ? this.getTraitValueInt("Lifting ST") : 0;
        switch (calcTrait) {
            case BasicLift: {
                return StrengthTables.getBasicLift(strength + liftingST);
            }
            case BasicSwing: {
                return StrengthTables.getBasicDamageSwing(strength + strikingST);
            }
            case BasicThrust: {
                return StrengthTables.getBasicDamageThrust(strength + strikingST);
            }
            case CurrFP: {
                return String.valueOf(this.getTraitValueInt(ActorBase.BasicTrait.FP) - this.getTraitValueInt(ActorBase.BasicTrait.Fatigue));
            }
            case CurrHP: {
                return String.valueOf(this.getTraitValueInt(ActorBase.BasicTrait.HP) - this.getTraitValueInt(ActorBase.BasicTrait.Injury));
            }
        }
        return "unk";
    }
}

