/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Damage;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DR {
    private static final Logger LOG = Logger.getLogger(DR.class.getName());
    private int base;
    private int crMod;
    private boolean flexible;

    public DR(int base) {
        this(base, 0, false);
    }

    public DR(int base, boolean flexible) {
        this(base, 0, flexible);
    }

    public DR(int base, int crMod, boolean flexible) {
        this.base = base;
        this.crMod = crMod;
        this.flexible = flexible;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Created DR: " + base + ", " + crMod + ", " + flexible);
        }
    }

    public static DR parseDR(String drString) throws ParseException {
        Pattern empty = Pattern.compile("^$");
        Pattern drPat = Pattern.compile("^(\\d+)(?:/(\\d+))?(\\*)?(?:\\+(\\d+))?$");
        Matcher matcher = empty.matcher(drString);
        if (matcher.matches()) {
            return new DR(0);
        }
        matcher = drPat.matcher(drString);
        if (matcher.matches()) {
            int base = Integer.parseInt(matcher.group(1));
            int crMod = 0;
            if (matcher.group(2) != null) {
                int crNum = Integer.parseInt(matcher.group(2));
                crMod = crNum - base;
            }
            boolean flexible = "*".equals(matcher.group(3));
            if (matcher.group(4) != null) {
                int bonus = Integer.parseInt(matcher.group(4));
                base += bonus;
            }
            return new DR(base, crMod, flexible);
        }
        throw new ParseException("ParseDR: Unable to parse string: " + drString, 0);
    }

    public int getDRforType(Damage.DamageType type) {
        switch (type) {
            case aff: 
            case burn: 
            case cor: 
            case cut: 
            case fat: 
            case imp: 
            case pi_: 
            case pi: 
            case pi4: 
            case pi44: 
            case spec: 
            case tbb: 
            case tox: {
                return this.base;
            }
            case cr: {
                return this.base + this.crMod;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0;
    }
}

