/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.HitLocations;
import gurpsinittool.util.DieRoller;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Damage {
    private static final Logger LOG = Logger.getLogger(Damage.class.getName());
    public int basicDamage;
    public double armorDivisor;
    public boolean explosive;
    public DamageType type;

    public Damage(int basic, DamageType type) {
        this(basic, 1.0, type, false);
    }

    public Damage(int basic, double divisor, DamageType type, boolean explosive) {
        this.basicDamage = basic;
        this.armorDivisor = divisor;
        this.type = type;
        this.explosive = explosive;
        int minDamage = type == DamageType.cr ? 0 : 1;
        this.basicDamage = this.basicDamage < minDamage ? minDamage : this.basicDamage;
    }

    public static Damage parseDamage(String damage) throws ParseException {
        Pattern empty = Pattern.compile("^$");
        Pattern numdivtype = Pattern.compile("^(\\d+)\\s*(\\(([\\d\\.]+)\\))?\\s*([^d\\d\\s]+)?\\s*(ex)?$");
        Pattern dicedivtype = Pattern.compile("^(\\d+)d[+]?([-]?\\d+)?\\s*(\\(([\\d\\.]+)\\))?\\s*([^d\\d\\s]+)?\\s*(ex)?$");
        Matcher matcher = empty.matcher(damage);
        if (matcher.matches()) {
            return new Damage(0, DamageType.cr);
        }
        matcher = numdivtype.matcher(damage);
        if (matcher.matches()) {
            int num = Integer.parseInt(matcher.group(1));
            double div = matcher.group(3) != null ? Double.parseDouble(matcher.group(3)) : 1.0;
            DamageType type = matcher.group(4) != null ? Damage.parseType(matcher.group(4)) : DamageType.cut;
            boolean explosive = matcher.group(5) != null;
            return new Damage(num, div, type, explosive);
        }
        matcher = dicedivtype.matcher(damage);
        if (matcher.matches()) {
            int dice = Integer.parseInt(matcher.group(1));
            int adds = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
            double div = matcher.group(4) != null ? Double.parseDouble(matcher.group(4)) : 1.0;
            DamageType type = matcher.group(5) != null ? Damage.parseType(matcher.group(5)) : DamageType.cut;
            boolean explosive = matcher.group(6) != null;
            return new Damage(DieRoller.rollDiceAdds(dice, adds), div, type, explosive);
        }
        throw new ParseException("ParseDamage: Unable to parse string: " + damage, 0);
    }

    public double damageMultiplier() {
        return Damage.damageMultiplier(this.type);
    }

    public double damageMultiplier(HitLocations.HitLocation location) {
        return location.damageMultiplier(this.type);
    }

    public double damageMultiplierHomogenous() {
        return Damage.damageMultiplierHomogenous(this.type);
    }

    public double damageMultiplierHomogenous(HitLocations.HitLocation location) {
        double locmult = location.damageMultiplier(this.type);
        if (locmult > this.damageMultiplier()) {
            return locmult;
        }
        return this.damageMultiplierHomogenous();
    }

    public double damageMultiplierUnliving() {
        return Damage.damageMultiplierUnliving(this.type);
    }

    public double damageMultiplierUnliving(HitLocations.HitLocation location) {
        double locmult = location.damageMultiplier(this.type);
        if (locmult > this.damageMultiplier()) {
            return locmult;
        }
        return this.damageMultiplierUnliving();
    }

    public int damageMaxDiffuse() {
        if (this.explosive) {
            return Integer.MAX_VALUE;
        }
        return Damage.damageMaxDiffuse(this.type);
    }

    public static DamageType parseType(String type) throws ParseException {
        type = type.replace('-', '_');
        type = type.replace('+', '4');
        try {
            return DamageType.valueOf(type);
        }
        catch (Exception e) {
            throw new ParseException("ParseType: Unable to parse string: " + type, 0);
        }
    }

    public static double damageMultiplier(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case pi: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: 
            case pi4: {
                return 1.5;
            }
            case imp: 
            case pi44: {
                return 2.0;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0.0;
    }

    public static double damageMultiplierUnliving(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.2;
            }
            case pi: {
                return 0.334;
            }
            case pi4: {
                return 0.5;
            }
            case imp: 
            case pi44: {
                return 1.0;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0.0;
    }

    public static double damageMultiplierHomogenous(DamageType type) {
        switch (type) {
            case pi_: {
                return 0.1;
            }
            case pi: {
                return 0.2;
            }
            case pi4: {
                return 0.334;
            }
            case imp: 
            case pi44: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: {
                return 1.5;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0.0;
    }

    public static int damageMaxDiffuse(DamageType type) {
        switch (type) {
            case imp: 
            case pi_: 
            case pi: 
            case pi4: 
            case pi44: {
                return 1;
            }
            case burn: 
            case cor: 
            case cr: 
            case cut: 
            case tbb: 
            case tox: {
                return 2;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Unhandled type! " + type.toString());
        }
        return 0;
    }

    public static enum DamageType {
        aff,
        burn,
        cor,
        cr,
        cut,
        fat,
        imp,
        pi_,
        pi,
        pi4,
        pi44,
        spec,
        tbb,
        tox;

    }
}

