/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StrengthTables {
    private static final Logger LOG = Logger.getLogger(StrengthTables.class.getName());

    public static String getBasicLift(int strength) {
        return new DecimalFormat("#.#").format(StrengthTables.basicLift(strength));
    }

    public static Double basicLift(int strength) {
        double bl = (double)(strength * strength) / 5.0;
        if (bl > 10.0) {
            bl = Math.round(bl);
        }
        return bl;
    }

    public static String getEncumbrance(int encLevel, Double basicLift) {
        double lift = 0.0;
        switch (encLevel) {
            case 0: {
                lift = basicLift;
                break;
            }
            case 1: {
                lift = basicLift * 2.0;
                break;
            }
            case 2: {
                lift = basicLift * 3.0;
                break;
            }
            case 3: {
                lift = basicLift * 6.0;
                break;
            }
            case 4: {
                lift = basicLift * 10.0;
                break;
            }
            default: {
                if (!LOG.isLoggable(Level.WARNING)) break;
                LOG.warning("Invalid enc_level: " + encLevel);
            }
        }
        return new DecimalFormat("#.#").format(lift);
    }

    public static String getBasicDamageThrust(int strength) {
        if (strength == 0) {
            return StrengthTables.diceAdds(0, 0);
        }
        if (strength <= 10) {
            return StrengthTables.diceAdds(1, -6 + (strength - 1) / 2);
        }
        if (strength <= 40) {
            return StrengthTables.diceAdds(1 + (strength - 11) / 8, (strength - 11) % 8 / 2 - 1);
        }
        if (strength > 40 && strength < 45) {
            return StrengthTables.diceAdds(4, 1);
        }
        if (strength >= 45 && strength < 50) {
            return StrengthTables.diceAdds(5, 0);
        }
        if (strength >= 50 && strength < 55) {
            return StrengthTables.diceAdds(5, 2);
        }
        if (strength >= 55 && strength < 60) {
            return StrengthTables.diceAdds(6, 0);
        }
        if (strength >= 60 && strength < 65) {
            return StrengthTables.diceAdds(7, -1);
        }
        if (strength >= 65 && strength < 70) {
            return StrengthTables.diceAdds(7, 1);
        }
        if (strength >= 70) {
            return StrengthTables.diceAdds(1 + strength / 10, strength % 10 < 5 ? 0 : 2);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unsupported strength: " + strength);
        }
        return "err";
    }

    public static String getBasicDamageSwing(int strength) {
        if (strength == 0) {
            return StrengthTables.diceAdds(0, 0);
        }
        if (strength <= 8) {
            return StrengthTables.diceAdds(1, -5 + (strength - 1) / 2);
        }
        if (strength <= 40) {
            return StrengthTables.diceAdds(1 + (strength - 9) / 4, (strength - 9) % 4 - 1);
        }
        if (strength > 40 && strength < 45) {
            return StrengthTables.diceAdds(7, -1);
        }
        if (strength >= 45 && strength < 50) {
            return StrengthTables.diceAdds(7, 1);
        }
        if (strength >= 50 && strength < 55) {
            return StrengthTables.diceAdds(8, -1);
        }
        if (strength >= 55 && strength < 60) {
            return StrengthTables.diceAdds(8, 1);
        }
        if (strength >= 60) {
            return StrengthTables.diceAdds(3 + strength / 10, strength % 10 < 5 ? 0 : 2);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Unsupported strength: " + strength);
        }
        return "err";
    }

    public static String diceAdds(int dice, int adds) {
        if (dice == 0 && adds == 0) {
            return "";
        }
        if (adds == 0) {
            return String.valueOf(dice) + "d";
        }
        if (adds < 0) {
            return String.valueOf(dice) + "d" + adds;
        }
        return String.valueOf(dice) + "d+" + adds;
    }
}

