/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.gca;

import gurpsinittool.gca.GCATrait;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCACharacter {
    private static final Logger LOG = Logger.getLogger(GCACharacter.class.getName());
    private HashMap<String, String> basicValues = new HashMap();
    private HashMap<Integer, GCATrait> traits = new HashMap();

    public void setBasicValue(String name, String value) {
        if (this.basicValues.containsKey(name)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Already have basicValue key '" + name + ". Value: " + this.basicValues.get(name) + ", new value (discarded): " + value);
            }
        } else {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Setting Key: '" + name + "', Value: '" + value + "'");
            }
            this.basicValues.put(name, value);
        }
    }

    public boolean hasBasicValue(String name) {
        return this.basicValues.containsKey(name);
    }

    public String getBasicValue(String name) {
        if (this.basicValues.containsKey(name)) {
            return this.basicValues.get(name);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("No basicValue key '" + name + "'");
        }
        return null;
    }

    public void addTrait(GCATrait trait) {
        if (this.traits.containsKey(trait.getIdNum())) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Already have a trait # " + trait.getIdNum() + "!");
            }
        } else {
            this.traits.put(trait.getIdNum(), trait);
        }
    }

    public void addChildTrait(Integer parentID, GCATrait trait) {
        GCATrait parent = this.getTrait(parentID);
        if (parent == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Parent trait id '" + parentID + "' not found! Unable to add child!");
            }
        } else {
            parent.addChild(trait);
            this.addTrait(trait);
        }
    }

    public GCATrait getTrait(Integer traitID) {
        if (this.traits.containsKey(traitID)) {
            return this.traits.get(traitID);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Trait id '" + traitID + "' not found!");
        }
        return null;
    }

    public GCATrait findTraitByName(String sectionName, String traitName) {
        for (GCATrait trait : this.traits.values()) {
            if (!sectionName.equals(trait.getSection()) || !traitName.equals(trait.getName())) continue;
            return trait;
        }
        return null;
    }

    public Iterable<GCATrait> findTraitsInSection(String sectionName) {
        ArrayList<GCATrait> foundTraits = new ArrayList<GCATrait>();
        for (GCATrait trait : this.traits.values()) {
            if (!sectionName.equals(trait.getSection())) continue;
            foundTraits.add(trait);
        }
        return foundTraits;
    }
}

