/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.gca;

import gurpsinittool.gca.GCACharacter;
import gurpsinittool.gca.GCATrait;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GCAFile {
    private static final Logger LOG = Logger.getLogger(GCAFile.class.getName());

    private GCAFile() {
    }

    public static GCACharacter loadGCA4File(File openFile) throws FileNotFoundException {
        FileReader file;
        try {
            file = new FileReader(openFile);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        BufferedReader input = new BufferedReader(file);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading file " + openFile.getPath());
        }
        GCACharacter gcaCharacter = new GCACharacter();
        try {
            GCAFile.parseGCA4File(input, gcaCharacter);
            input.close();
            file.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return gcaCharacter;
    }

    private static void parseGCA4File(BufferedReader input, GCACharacter gcaCharacter) throws IOException {
        String line;
        Pattern sectionPattern = Pattern.compile("^\\[(\\w*)\\]$");
        Pattern specialIgnored = Pattern.compile("^(datafile|altcharactersheet)\\(.*");
        Pattern simpleValue = Pattern.compile("^(\\w+)\\(([^,]*)\\)$");
        Pattern nonsimpleValue = Pattern.compile("^(appearance|weight|charname)\\((.*)\\)$");
        Pattern idkey = Pattern.compile("^idkey\\((\\d+)\\)\\|,(.*)");
        Pattern idkeyChild = Pattern.compile("^idkey\\((\\d+)\\),parentkey\\((k?\\d+)\\)\\|,(.*)");
        Pattern idkeyGroup = Pattern.compile("^idkey\\((\\d+)\\),childkeylist\\(((?:k\\d+,?)+)\\)\\|,(.*)");
        Pattern idkeyChildGroup = Pattern.compile("^idkey\\((\\d+)\\),parentkey\\((k\\d+)\\),childkeylist\\(((?:k\\d+,?)+)\\)\\|,(.*)");
        Pattern rtfStart = Pattern.compile("^\\{\\\\rtf1");
        Pattern other = Pattern.compile("^(name|datecreated|facing|group|ownerid|st|break|op)\\(.*");
        Pattern encoding = Pattern.compile("^Encoding=UTF-8$");
        Pattern empty = Pattern.compile("^\\s*$");
        String sectionName = null;
        while ((line = input.readLine()) != null) {
            GCATrait trait;
            HashMap<String, String> keyHash;
            String value;
            String key;
            Matcher matcher = sectionPattern.matcher(line);
            if (matcher.matches()) {
                sectionName = matcher.group(1);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Found section: " + sectionName);
                continue;
            }
            if ("Author".equals(sectionName) || "LogEntry".equals(sectionName)) continue;
            matcher = specialIgnored.matcher(line);
            if (matcher.matches()) {
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("Found specialIgnored: " + matcher.group(1));
                continue;
            }
            matcher = simpleValue.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Found simple Key: " + matcher.group(1) + ", Value: " + matcher.group(2));
                }
                key = matcher.group(1);
                value = matcher.group(2);
                gcaCharacter.setBasicValue(key, value);
                continue;
            }
            matcher = nonsimpleValue.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Found non-simple Key: " + matcher.group(1) + ", Value: " + matcher.group(2));
                }
                key = matcher.group(1);
                value = matcher.group(2);
                gcaCharacter.setBasicValue(key, value);
                continue;
            }
            matcher = idkey.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found idkey. Num: " + matcher.group(1));
                }
                keyHash = GCAFile.parseIDKey(Integer.valueOf(matcher.group(1)), new StringBuilder(matcher.group(2)), input);
                trait = new GCATrait(sectionName, keyHash);
                gcaCharacter.addTrait(trait);
                continue;
            }
            matcher = idkeyChild.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found idkey+parentkey. Num: " + matcher.group(1) + ", parent Num: " + matcher.group(2));
                }
                keyHash = GCAFile.parseIDKey(Integer.valueOf(matcher.group(1)), new StringBuilder(matcher.group(3)), input);
                trait = new GCATrait(sectionName, keyHash);
                if (matcher.group(2).startsWith("k")) {
                    gcaCharacter.addTrait(trait);
                    continue;
                }
                gcaCharacter.addChildTrait(Integer.valueOf(matcher.group(2)), trait);
                continue;
            }
            matcher = idkeyGroup.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found idkey+childkeylist. Num: " + matcher.group(1) + ", childkeylist: '" + matcher.group(2) + "'");
                }
                keyHash = GCAFile.parseIDKey(Integer.valueOf(matcher.group(1)), new StringBuilder(matcher.group(3)), input);
                trait = new GCATrait(sectionName, keyHash);
                gcaCharacter.addTrait(trait);
                continue;
            }
            matcher = idkeyChildGroup.matcher(line);
            if (matcher.matches()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Found idkey+parentkey+childkeylist. Num: " + matcher.group(1) + ", parentkey: '" + matcher.group(2) + ", childkeylist: '" + matcher.group(3) + "'");
                }
                keyHash = GCAFile.parseIDKey(Integer.valueOf(matcher.group(1)), new StringBuilder(matcher.group(4)), input);
                trait = new GCATrait(sectionName, keyHash);
                gcaCharacter.addTrait(trait);
                continue;
            }
            matcher = other.matcher(line);
            if (matcher.matches()) {
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest("Found other: " + matcher.group(1));
                continue;
            }
            matcher = rtfStart.matcher(line);
            if (matcher.lookingAt()) {
                String rtfString = "{" + GCAFile.parseNestedMultiline(new StringBuilder(line), input, "\\{", "\\}") + "}";
                if ("Notes".equals(sectionName) | "Description".equals(sectionName)) {
                    gcaCharacter.setBasicValue("RTF" + sectionName, rtfString);
                    continue;
                }
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unexpectedly found RTF data in section: '" + sectionName + "', line: " + matcher.group(0));
                continue;
            }
            matcher = empty.matcher(line);
            if (matcher.matches() || (matcher = encoding.matcher(line)).matches() || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Cannot parse line: " + line);
        }
    }

    private static HashMap<String, String> parseIDKey(int num, StringBuilder line, BufferedReader input) throws IOException {
        HashMap<String, String> keyHash = new HashMap<String, String>();
        if (num < 1 && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Illegal IDKey number! " + num);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("IDKey " + num + " line: " + line);
        }
        keyHash.put("idkey", String.valueOf(num));
        Pattern idkeySimple = Pattern.compile("^(\\w+)\\(([^\\(\\)]*)\\)(?:,)?");
        Pattern idkeyStart = Pattern.compile("^(\\w+)\\(");
        Pattern idkeyEnd = Pattern.compile("^(?:,)?");
        while (line.length() > 0) {
            String value;
            String key;
            Matcher matcher = idkeySimple.matcher(line);
            if (matcher.lookingAt()) {
                key = matcher.group(1);
                value = matcher.group(2);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Pulled off : " + key + " => " + value);
                }
                keyHash.put(key, value);
                line.delete(0, matcher.end());
                continue;
            }
            matcher = idkeyStart.matcher(line);
            if (matcher.lookingAt()) {
                key = matcher.group(1);
                line.delete(0, matcher.end(1));
                value = GCAFile.parseNestedMultiline(line, input, "\\(", "\\)");
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Pulled off (nested) : " + key + " => " + value);
                }
                keyHash.put(key, value);
                matcher = idkeyEnd.matcher(line);
                if (matcher.lookingAt()) {
                    line.delete(0, matcher.end());
                    continue;
                }
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Got to end of nested parens, but see unexpected result! " + line);
                continue;
            }
            if (!LOG.isLoggable(Level.WARNING)) break;
            LOG.warning("Finished parsing with non-empty line! '" + line + "'");
            break;
        }
        return keyHash;
    }

    /*
     * Unable to fully structure code
     */
    private static String parseNestedMultiline(StringBuilder line, BufferedReader input, String startDelim, String endDelim) throws IOException {
        block12: {
            block13: {
                result = new StringBuilder();
                start = Pattern.compile("^(" + startDelim + ")");
                open = Pattern.compile("^([^" + startDelim + endDelim + "]*" + startDelim + ")");
                close = Pattern.compile("^([^" + startDelim + endDelim + "]*)(" + endDelim + ")");
                newline = Pattern.compile("^([^" + startDelim + endDelim + "]*$)");
                if (GCAFile.LOG.isLoggable(Level.FINEST)) {
                    GCAFile.LOG.finest("Starting parser: startDelim: '" + startDelim + "' endDelim: '" + endDelim + "', line: '" + line + "'");
                }
                if (!(matcher = start.matcher(line)).lookingAt()) break block13;
                parenLevel = 1;
                line.delete(0, matcher.end());
                if (GCAFile.LOG.isLoggable(Level.FINEST)) {
                    GCAFile.LOG.finest("Got expected start delim, line: '" + line + "'");
                }
                while (parenLevel > 0) {
                    matcher = open.matcher(line);
                    if (matcher.lookingAt()) {
                        ++parenLevel;
                        result.append(matcher.group(1));
                        line.delete(0, matcher.end());
                        if (!GCAFile.LOG.isLoggable(Level.FINEST)) continue;
                        GCAFile.LOG.finest("Got start delim, line: '" + line + "'");
                        continue;
                    }
                    matcher = close.matcher(line);
                    if (matcher.lookingAt()) {
                        result.append(matcher.group(1));
                        if (--parenLevel > 0) {
                            result.append(matcher.group(2));
                        }
                        line.delete(0, matcher.end());
                        if (!GCAFile.LOG.isLoggable(Level.FINEST)) continue;
                        GCAFile.LOG.finest("Got end delim, line: '" + line + "'");
                        continue;
                    }
                    matcher = newline.matcher(line);
                    if (!matcher.matches()) ** GOTO lbl53
                    result.append(matcher.group(1));
                    line.delete(0, matcher.end());
                    nextLine = input.readLine();
                    if (nextLine == null) {
                        if (GCAFile.LOG.isLoggable(Level.WARNING)) {
                            GCAFile.LOG.warning("Got null value when reading multi-line value!");
                        }
                    } else {
                        line.append(nextLine);
                        if (!GCAFile.LOG.isLoggable(Level.FINEST)) continue;
                        GCAFile.LOG.finest("Got newline, line: '" + line + "'");
                        continue;
lbl53:
                        // 1 sources

                        if (GCAFile.LOG.isLoggable(Level.WARNING)) {
                            GCAFile.LOG.warning("Can't parse nested parens for line: '" + line + "'");
                        }
                    }
                    break block12;
                }
                break block12;
            }
            if (GCAFile.LOG.isLoggable(Level.WARNING)) {
                GCAFile.LOG.warning("Line does not start with start delim! StartDelim: '" + startDelim + "', line: '" + line + "'");
            }
        }
        if (GCAFile.LOG.isLoggable(Level.FINEST)) {
            GCAFile.LOG.finest("Final Result: '" + result + "'");
        }
        return result.toString();
    }
}

