/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.gca;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Attack;
import gurpsinittool.gca.GCACharacter;
import gurpsinittool.gca.GCAFile;
import gurpsinittool.gca.GCATrait;
import gurpsinittool.util.MiscUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCAImporter {
    private static final Logger LOG = Logger.getLogger(GCAImporter.class.getName());

    public static Actor importActor(File file) throws FileNotFoundException {
        GCACharacter character = GCAFile.loadGCA4File(file);
        return GCAImporter.convertToActor(character);
    }

    public static Actor convertToActor(GCACharacter character) {
        Actor actor = new Actor();
        actor.setType(ActorBase.ActorType.Special);
        GCAImporter.processBasicTraits(actor, character);
        GCAImporter.processOptionalTraits(actor, character);
        GCAImporter.processAttacks(actor, character);
        GCAImporter.processNotes(actor, character);
        return actor;
    }

    private static void processBasicTraits(Actor actor, GCACharacter character) {
        GCAImporter.processSimpleKey(actor, character, "charname", ActorBase.BasicTrait.Name);
        GCAImporter.processStat(actor, character, "ST", ActorBase.BasicTrait.ST);
        GCAImporter.processStat(actor, character, "Hit Points", ActorBase.BasicTrait.HP);
        GCAImporter.processStat(actor, character, "HT", ActorBase.BasicTrait.HT);
        GCAImporter.processStat(actor, character, "Fatigue Points", ActorBase.BasicTrait.FP);
        GCAImporter.processStat(actor, character, "IQ", ActorBase.BasicTrait.IQ);
        GCAImporter.processStat(actor, character, "Will", ActorBase.BasicTrait.Will);
        GCAImporter.processStat(actor, character, "Perception", ActorBase.BasicTrait.Per);
        GCAImporter.processStat(actor, character, "DX", ActorBase.BasicTrait.DX);
        GCAImporter.processStat(actor, character, "Basic Speed", ActorBase.BasicTrait.Speed);
        GCAImporter.processStat(actor, character, "Basic Move", ActorBase.BasicTrait.Move);
        GCAImporter.processStat(actor, character, "Size Modifier", ActorBase.BasicTrait.SM);
        GCAImporter.processStat(actor, character, "Dodge", ActorBase.BasicTrait.Dodge);
        GCAImporter.processSimpleKey(actor, character, "parryscore", ActorBase.BasicTrait.Parry);
        GCAImporter.processSimpleKey(actor, character, "blockscore", ActorBase.BasicTrait.Block);
        GCAImporter.processDR(actor, character);
        GCAImporter.processShield(actor, character);
    }

    private static void processDR(Actor actor, GCACharacter character) {
        Integer drValue;
        GCATrait drTrait;
        String value = "";
        if (character.hasBasicValue("drbody")) {
            value = String.valueOf(value) + character.getBasicValue("drbody");
        }
        if ((drTrait = character.findTraitByName("Stats", "DR")) != null && (drValue = Integer.valueOf(MiscUtil.parseIntSafe(drTrait.getValue("score")))) > 0) {
            value = String.valueOf(value) + (value.length() > 0 ? "+" : "") + drValue;
        }
        actor.setTrait(ActorBase.BasicTrait.DR, value);
    }

    private static void processShield(Actor actor, GCACharacter character) {
        actor.setTrait(ActorBase.BasicTrait.Shield_DB, "0");
        actor.setTrait(ActorBase.BasicTrait.Shield_DR, "0");
        actor.setTrait(ActorBase.BasicTrait.Shield_HP, "0");
        for (GCATrait trait : character.findTraitsInSection("Equipment")) {
            if (!trait.hasValue("shieldarc")) continue;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Using shield arc from trait: " + trait.getName());
            }
            if (trait.hasValue("db")) {
                actor.setTrait(ActorBase.BasicTrait.Shield_DB, trait.getValue("db"));
            }
            if (!trait.hasValue("dr")) continue;
            String dr = trait.getValue("dr");
            Pattern drPattern = Pattern.compile("^(\\d+)/(\\d+)$");
            Matcher matcher = drPattern.matcher(dr);
            if (!matcher.matches()) continue;
            actor.setTrait(ActorBase.BasicTrait.Shield_DR, matcher.group(1));
            actor.setTrait(ActorBase.BasicTrait.Shield_HP, matcher.group(2));
        }
    }

    private static void processOptionalTraits(Actor actor, GCACharacter character) {
        GCAImporter.processBooleanTrait(actor, character, "Advantages", "High Pain Threshold");
        GCAImporter.processBooleanTrait(actor, character, "Disadvantages", "Low Pain Threshold");
        GCAImporter.processBooleanTrait(actor, character, "Advantages", "Combat Reflexes");
        GCAImporter.processIntTrait(actor, character, "Advantages", "Striking ST");
        GCAImporter.processIntTrait(actor, character, "Advantages", "Lifting ST");
        GCAImporter.processModsTrait(actor, character, "Advantages", "Injury Tolerance");
    }

    private static void processAttacks(Actor actor, GCACharacter character) {
        for (GCATrait trait : character.findTraitsInSection("Equipment")) {
            GCAImporter.processTraitAttacks(actor, trait);
        }
        for (GCATrait trait : character.findTraitsInSection("Skills")) {
            GCAImporter.processTraitAttacks(actor, trait);
        }
        for (GCATrait trait : character.findTraitsInSection("Stats")) {
            GCAImporter.processTraitAttacks(actor, trait);
        }
    }

    private static void processNotes(Actor actor, GCACharacter character) {
        String rtfString;
        String decodedString;
        String appearance;
        String notes = "";
        if (character.hasBasicValue("appearance") && !(appearance = character.getBasicValue("appearance")).isEmpty()) {
            notes = "Appearance: " + appearance + "\n\n";
        }
        if (character.hasBasicValue("RTFDescription") && (decodedString = MiscUtil.decodeRTFNotes(rtfString = character.getBasicValue("RTFDescription"))) != null) {
            notes = String.valueOf(notes) + "Description:\n" + decodedString + "\n";
        }
        if (character.hasBasicValue("RTFNotes") && (decodedString = MiscUtil.decodeRTFNotes(rtfString = character.getBasicValue("RTFNotes"))) != null) {
            notes = String.valueOf(notes) + "Notes:\n" + decodedString + "\n";
        }
        actor.setTrait(ActorBase.BasicTrait.Notes, notes);
    }

    private static void processSimpleKey(Actor actor, GCACharacter character, String key, ActorBase.BasicTrait trait) {
        if (character.hasBasicValue(key)) {
            actor.setTrait(trait, character.getBasicValue(key));
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Unable to find key '" + key + "' to set trait " + (Object)((Object)trait));
            }
            actor.setTrait(trait, "");
        }
    }

    private static void processTraitAttacks(Actor actor, GCATrait trait) {
        boolean hasAttacks = false;
        if (trait.hasValue("reach") && !trait.getValue("reach").isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Trait '" + trait.getName() + "' has melee attacks.");
            }
            hasAttacks = true;
        }
        if (trait.hasValue("rangemax") && !trait.getValue("rangemax").isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Trait '" + trait.getName() + "' has ranged attacks.");
            }
            hasAttacks = true;
        }
        if (hasAttacks) {
            List<String> modes = trait.getValueAsList("mode");
            List<String> skills = trait.getValueAsList("charskillscore");
            List<String> damages = trait.getValueAsList("chardamage");
            List<String> damageTypes = trait.getValueAsList("chardamtype");
            List<String> parrys = trait.getValueAsList("parry");
            Integer numAttacks = modes.isEmpty() ? 1 : modes.size();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Trait '" + trait.getName() + " has " + numAttacks + " attacks");
            }
            int i = 0;
            while (i < numAttacks) {
                String name = trait.getName();
                if (numAttacks > 1 && modes.size() > i && !modes.get(i).equals(name)) {
                    name = String.valueOf(name) + ": " + modes.get(i);
                }
                String skill = skills.size() > i ? skills.get(i) : "";
                Integer intSkill = MiscUtil.parseIntSafe(skill);
                String damage = damages.size() > i ? damages.get(i) : "";
                String damageType = damageTypes.size() > i ? damageTypes.get(i) : "";
                Boolean unbalanced = parrys.size() > i ? parrys.get(i).endsWith("U") : false;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding attack '" + name + "'");
                }
                actor.addAttack(new Attack(name, intSkill, String.valueOf(damage) + " " + damageType, unbalanced));
                ++i;
            }
        }
    }

    private static void processModsTrait(Actor actor, GCACharacter character, String sectionName, String traitName) {
        GCATrait trait = character.findTraitByName(sectionName, traitName);
        if (trait == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Found no trait named '" + traitName + "' with section '" + sectionName + "'");
            }
        } else {
            ArrayList<String> values = new ArrayList<String>();
            for (GCATrait child : trait.getChildren()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Processing: child '" + child.getName() + "'");
                }
                values.add(child.getName());
            }
            String value = String.join((CharSequence)";", values);
            actor.addTrait(traitName, value);
        }
    }

    private static boolean processBooleanTrait(Actor actor, GCACharacter character, String sectionName, String traitName) {
        if (character.findTraitByName(sectionName, traitName) != null) {
            actor.addTrait(traitName, "");
            return true;
        }
        return false;
    }

    private static void processIntTrait(Actor actor, GCACharacter character, String sectionName, String traitName) {
        GCATrait trait = character.findTraitByName(sectionName, traitName);
        if (trait == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Found no trait named '" + traitName + "' with section '" + sectionName + "'");
            }
        } else if (trait.hasValue("level")) {
            String value = trait.getValue("level");
            if (value.endsWith(".0")) {
                value = value.substring(0, value.length() - 2);
            }
            actor.addTrait(traitName, value);
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Trait '" + traitName + "' does not have 'level' value");
        }
    }

    private static void processStat(Actor actor, GCACharacter character, String traitName, ActorBase.BasicTrait basicTrait) {
        GCATrait trait = character.findTraitByName("Stats", traitName);
        if (trait == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Unable to find trait named '" + traitName + "' to set trait " + (Object)((Object)basicTrait));
            }
        } else if (trait.hasValue("score")) {
            String value = trait.getValue("score");
            if (value.endsWith(".0")) {
                value = value.substring(0, value.length() - 2);
            }
            actor.setTrait(basicTrait, value);
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Trait '" + traitName + "' does not have 'score' value to set trait " + (Object)((Object)basicTrait));
            }
            actor.setTrait(basicTrait, 0);
        }
    }
}

