/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.app.InitTableModel;
import gurpsinittool.data.ActorBase;
import gurpsinittool.util.MiscUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class ColumnCustomizer
extends JFrame {
    public static final ArrayList<String> DEFAULT_COLUMNS = new ArrayList<String>(Arrays.asList("Act", "Name", "Speed", "Move", "HT", "HP", "Injury", "FP", "Fatigue", "Status"));
    private InitTableModel tableModel;
    private DefaultListModel<String> availableTraitsModel;
    private DefaultListModel<String> displayedTraitsModel;
    private ArrayList<String> visibleColumns;
    private JButton addButton;
    private JList<String> availableTraitsList;
    private JButton cancelButton;
    private JButton customTraitButton;
    private JList<String> displayedTraitsList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton okButton;
    private JButton removeButton;
    private JButton resetButton;

    public ColumnCustomizer(InitTableModel tableModel) {
        this.tableModel = tableModel;
        this.initComponents();
        this.availableTraitsModel = (DefaultListModel)this.availableTraitsList.getModel();
        this.displayedTraitsModel = (DefaultListModel)this.displayedTraitsList.getModel();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            MiscUtil.validateOnScreen(this);
            if (!this.isVisible()) {
                this.getVisibleColumnsFromModel();
                this.initializeColumnLists();
            } else if (this.getState() == 1) {
                this.setState(0);
            }
        }
        super.setVisible(visible);
    }

    private void getVisibleColumnsFromModel() {
        this.visibleColumns = this.tableModel.getColumnNames();
        this.visibleColumns.remove("Act");
    }

    private void initializeColumnLists() {
        ArrayList<String> availableColumns = new ArrayList<String>();
        Enum[] enumArray = ActorBase.BasicTrait.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActorBase.BasicTrait basicTrait = enumArray[n2];
            availableColumns.add(basicTrait.name());
            ++n2;
        }
        enumArray = ActorBase.CalculatedTrait.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum calcTrait = enumArray[n2];
            availableColumns.add(calcTrait.name());
            ++n2;
        }
        availableColumns.add("Type");
        for (String visibleColumn : this.visibleColumns) {
            availableColumns.remove(visibleColumn);
        }
        this.displayedTraitsModel.clear();
        for (String value : this.visibleColumns) {
            this.displayedTraitsModel.addElement(value);
        }
        this.availableTraitsModel.clear();
        for (String value : availableColumns) {
            this.availableTraitsModel.addElement(value);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.availableTraitsList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.displayedTraitsList = new JList();
        this.addButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.resetButton = new JButton();
        this.jLabel2 = new JLabel();
        this.customTraitButton = new JButton();
        this.setTitle("InitTool Column Customizer");
        this.availableTraitsList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.availableTraitsList.setModel(new DefaultListModel());
        this.availableTraitsList.setMinimumSize(new Dimension(50, 80));
        this.jScrollPane1.setViewportView(this.availableTraitsList);
        this.displayedTraitsList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.displayedTraitsList.setModel(new DefaultListModel());
        this.jScrollPane2.setViewportView(this.displayedTraitsList);
        this.addButton.setText("Add >");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.addButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Available Basic Traits");
        this.removeButton.setText("< Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.removeButtonActionPerformed(evt);
            }
        });
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Reset to Default");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.resetButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Displayed Traits Order");
        this.customTraitButton.setText("Add Custom Trait");
        this.customTraitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnCustomizer.this.customTraitButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.moveDownButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.moveUpButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.customTraitButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.resetButton, -2, 115, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.customTraitButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton).addGap(0, 131, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.resetButton))));
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        for (String selected : this.availableTraitsList.getSelectedValuesList()) {
            this.availableTraitsModel.removeElement(selected);
            this.displayedTraitsModel.addElement(selected);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        for (String selected : this.displayedTraitsList.getSelectedValuesList()) {
            this.displayedTraitsModel.removeElement(selected);
            this.availableTraitsModel.addElement(selected);
        }
    }

    private void customTraitButtonActionPerformed(ActionEvent evt) {
        String customTraitName = JOptionPane.showInputDialog(this, "Trait Name:", "Add Custom Trait", -1);
        if (customTraitName != null) {
            this.displayedTraitsModel.addElement(customTraitName);
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.displayedTraitsList.getSelectedIndices();
        int topNonSelIndex = 0;
        int[] selected = this.displayedTraitsList.getSelectedIndices();
        this.displayedTraitsList.getSelectionModel().clearSelection();
        int[] nArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            int selIndex = nArray[n2];
            if (selIndex == topNonSelIndex) {
                ++topNonSelIndex;
                this.displayedTraitsList.getSelectionModel().addSelectionInterval(selIndex, selIndex);
            } else {
                String item = this.displayedTraitsModel.remove(selIndex);
                this.displayedTraitsModel.add(selIndex - 1, item);
                this.displayedTraitsList.getSelectionModel().addSelectionInterval(selIndex - 1, selIndex - 1);
            }
            ++n2;
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.displayedTraitsList.getSelectedIndices();
        int bottomNonSelIndex = this.displayedTraitsModel.getSize() - 1;
        int[] selected = this.displayedTraitsList.getSelectedIndices();
        this.displayedTraitsList.getSelectionModel().clearSelection();
        int i = selected.length - 1;
        while (i >= 0) {
            int selIndex = selected[i];
            if (selIndex == bottomNonSelIndex) {
                --bottomNonSelIndex;
                this.displayedTraitsList.getSelectionModel().addSelectionInterval(selIndex, selIndex);
            } else {
                String item = this.displayedTraitsModel.remove(selIndex);
                this.displayedTraitsModel.add(selIndex + 1, item);
                this.displayedTraitsList.getSelectionModel().addSelectionInterval(selIndex + 1, selIndex + 1);
            }
            --i;
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.visibleColumns.clear();
        this.visibleColumns.addAll(DEFAULT_COLUMNS);
        this.visibleColumns.remove("Act");
        this.initializeColumnLists();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Object[] displayedObjects = this.displayedTraitsModel.toArray();
        String[] displayedStrings = (String[])Arrays.copyOf(displayedObjects, displayedObjects.length, String[].class);
        ArrayList<String> newVisibleColumns = new ArrayList<String>(Arrays.asList(displayedStrings));
        newVisibleColumns.add(0, "Act");
        this.tableModel.setColumnList(newVisibleColumns);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

