/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.DR;
import gurpsinittool.data.Damage;
import gurpsinittool.data.Defense;
import gurpsinittool.data.HitLocations;
import gurpsinittool.util.DieRoller;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DefenseDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(DefenseDialog.class.getName());
    Actor actor;
    public Defense defense;
    public boolean valid = false;
    boolean updating = false;
    public Action cancelAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.cancelButtonActionPerformed(actionEvent);
        }
    };
    public Action okAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.okButtonActionPerformed(actionEvent);
        }
    };
    public Action eeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.eeCheck.doClick();
        }
    };
    public Action retreatAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.retreatCheck.doClick();
        }
    };
    public Action sideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.sideCheck.doClick();
        }
    };
    public Action stunAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.stunnedCheck.doClick();
        }
    };
    public Action shieldAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.shieldCheckBox.doClick();
        }
    };
    public Action deceptiveAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.otherSpinner.setValue(DefenseDialog.this.otherSpinner.getPreviousValue());
        }
    };
    public Action reverseDeceptiveAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.otherSpinner.setValue(DefenseDialog.this.otherSpinner.getNextValue());
        }
    };
    public Action parryDefenseAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.parryButton.doClick();
        }
    };
    public Action blockDefenseAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.blockButton.doClick();
        }
    };
    public Action dodgeDefenseAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.dodgeButton.doClick();
        }
    };
    public Action noDefenseAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefenseDialog.this.noneButton.doClick();
        }
    };
    private JRadioButton blockButton;
    private JLabel blockNote;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    public JTextField damageTextField;
    private JLabel db;
    private JRadioButton dodgeButton;
    private JLabel dodgeNote;
    private JTextField drTextField;
    private JCheckBox eeCheck;
    private JLabel effectiveDefense;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    public JComboBox locationCombo;
    private JTextField name;
    private JRadioButton noneButton;
    private JButton okButton;
    private JSpinner otherSpinner;
    private JRadioButton parryButton;
    private JLabel parryNote;
    private JComboBox postureCombo;
    private JButton rerollButton;
    private JTextField result;
    private JCheckBox retreatCheck;
    private JFormattedTextField rollTextField;
    private JCheckBox shieldCheckBox;
    private JCheckBox sideCheck;
    private JCheckBox stunnedCheck;

    public DefenseDialog(Window parent) {
        super(parent, DEFAULT_MODALITY_TYPE);
        this.setTitle("Defense");
        this.initComponents();
        this.initEnterEsc();
        this.initLocationCombo();
        this.initPositionCombo();
        JFormattedTextField field = (JFormattedTextField)this.otherSpinner.getEditor().getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.rollTextField.getDocument().addDocumentListener(new ValueDocumentListener());
        this.drTextField.getDocument().addDocumentListener(new ValueDocumentListener());
        this.damageTextField.getDocument().addDocumentListener(new ValueDocumentListener());
    }

    private void initLocationCombo() {
        Vector<String> comboItems = new Vector<String>();
        HitLocations.LocationType[] locationTypeArray = HitLocations.LocationType.values();
        int n = locationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HitLocations.LocationType location = locationTypeArray[n2];
            comboItems.add(HitLocations.getLocation((HitLocations.LocationType)location).type.name());
            ++n2;
        }
        this.locationCombo.setModel(new DefaultComboBoxModel(comboItems));
    }

    private void initPositionCombo() {
        Vector<String> comboItems = new Vector<String>();
        comboItems.add("Standing");
        comboItems.add("Kneeling");
        comboItems.add("Prone");
        this.postureCombo.setModel(new DefaultComboBoxModel(comboItems));
    }

    private void initEnterEsc() {
        this.damageTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.damageTextField.getActionMap().put("OK", this.okAction);
        this.damageTextField.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.damageTextField.getActionMap().put("CANCEL", this.cancelAction);
        this.locationCombo.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.locationCombo.getActionMap().put("OK", this.okAction);
        this.locationCombo.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.locationCombo.getActionMap().put("CANCEL", this.cancelAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "OK");
        this.getRootPane().getActionMap().put("OK", this.okAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", this.cancelAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control E"), "ExtraEffort");
        this.getRootPane().getActionMap().put("ExtraEffort", this.eeAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control R"), "Retreat");
        this.getRootPane().getActionMap().put("Retreat", this.retreatAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control S"), "Side");
        this.getRootPane().getActionMap().put("Side", this.sideAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control T"), "Stun");
        this.getRootPane().getActionMap().put("Stun", this.stunAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control D"), "Deceptive");
        this.getRootPane().getActionMap().put("Deceptive", this.deceptiveAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control shift D"), "Reverse Deceptive");
        this.getRootPane().getActionMap().put("Reverse Deceptive", this.reverseDeceptiveAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control I"), "Shield");
        this.getRootPane().getActionMap().put("Shield", this.shieldAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control P"), "Parry");
        this.getRootPane().getActionMap().put("Parry", this.parryDefenseAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control B"), "Block");
        this.getRootPane().getActionMap().put("Block", this.blockDefenseAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control G"), "Dodge");
        this.getRootPane().getActionMap().put("Dodge", this.dodgeDefenseAction);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control N"), "None");
        this.getRootPane().getActionMap().put("None", this.noDefenseAction);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.blockNote = new JLabel();
        this.dodgeNote = new JLabel();
        this.jLabel4 = new JLabel();
        this.parryNote = new JLabel();
        this.jLabel2 = new JLabel();
        this.shieldCheckBox = new JCheckBox();
        this.blockButton = new JRadioButton();
        this.cancelButton = new JButton();
        this.parryButton = new JRadioButton();
        this.rerollButton = new JButton();
        this.retreatCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.dodgeButton = new JRadioButton();
        this.eeCheck = new JCheckBox();
        this.sideCheck = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.effectiveDefense = new JLabel();
        this.name = new JTextField();
        this.result = new JTextField();
        this.db = new JLabel();
        this.jLabel8 = new JLabel();
        this.rollTextField = new JFormattedTextField();
        this.damageTextField = new JTextField();
        this.otherSpinner = new JSpinner();
        this.locationCombo = new JComboBox();
        this.jLabel9 = new JLabel();
        this.noneButton = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.stunnedCheck = new JCheckBox();
        this.postureCombo = new JComboBox();
        this.jLabel10 = new JLabel();
        this.drTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.okButton.setMnemonic('k');
        this.okButton.setText("OK");
        this.okButton.setToolTipText("");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.blockNote.setText("(10-4=12)");
        this.dodgeNote.setText("(10)");
        this.jLabel4.setText("Other");
        this.parryNote.setText("(10-8=12)");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Damage:");
        this.shieldCheckBox.setSelected(true);
        this.shieldCheckBox.setText("Shield");
        this.shieldCheckBox.setToolTipText("Using Shield (Ctrl+I)");
        this.shieldCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.blockButton);
        this.blockButton.setText("Block");
        this.blockButton.setToolTipText("Block (Ctrl+B)");
        this.blockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.parryButton);
        this.parryButton.setSelected(true);
        this.parryButton.setText("Parry");
        this.parryButton.setToolTipText("Parry (Ctrl+P)");
        this.parryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.rerollButton.setText("Reroll");
        this.rerollButton.setMargin(new Insets(2, 4, 2, 4));
        this.rerollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.rerollButtonActionPerformed(evt);
            }
        });
        this.retreatCheck.setText("Retreat");
        this.retreatCheck.setToolTipText("Retreat (Ctrl+R)");
        this.retreatCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Roll:");
        this.buttonGroup1.add(this.dodgeButton);
        this.dodgeButton.setText("Dodge");
        this.dodgeButton.setToolTipText("Dodge (Ctrl+G)");
        this.dodgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.eeCheck.setText("Extra Effort");
        this.eeCheck.setToolTipText("Use Extra Effort (Ctrl+E)");
        this.eeCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.sideCheck.setText("Side Attack");
        this.sideCheck.setToolTipText("Attack is from a side hex (Ctrl+S)");
        this.sideCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("<HTML>Effective<br>Defense</HTML>");
        this.effectiveDefense.setFont(new Font("Tahoma", 1, 24));
        this.effectiveDefense.setText("0");
        this.effectiveDefense.setToolTipText("");
        this.name.setEditable(false);
        this.name.setBackground(new Color(236, 233, 216));
        this.name.setFont(new Font("Tahoma", 1, 20));
        this.name.setText("name");
        this.name.setBorder(null);
        this.name.setFocusable(false);
        this.result.setEditable(false);
        this.result.setBackground(new Color(236, 233, 216));
        this.result.setFont(new Font("Tahoma", 1, 12));
        this.result.setText("result");
        this.result.setBorder(null);
        this.result.setFocusable(false);
        this.db.setFont(new Font("Tahoma", 1, 11));
        this.db.setText("DB: 2");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("DR:");
        this.rollTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.rollTextField.setText("98");
        this.otherSpinner.setToolTipText("Other modifiers, deceptive attack, etc. (Ctrl+D / Ctrl+Shift+D)");
        this.otherSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DefenseDialog.this.otherSpinnerStateChanged(evt);
            }
        });
        this.locationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.locationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.locationCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DefenseDialog.this.locationComboKeyReleased(evt);
            }
        });
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("Location:");
        this.buttonGroup1.add(this.noneButton);
        this.noneButton.setText("None");
        this.noneButton.setToolTipText("No Defense (Ctrl+N)");
        this.noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Defense Type:");
        this.stunnedCheck.setText("Stunned");
        this.stunnedCheck.setToolTipText("Defender is stunned (Ctrl+T)");
        this.stunnedCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DefenseDialog.this.checkItemStateChanged(evt);
            }
        });
        this.postureCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Standing"}));
        this.postureCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefenseDialog.this.radioButtonActionPerformed(evt);
            }
        });
        this.postureCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DefenseDialog.this.locationComboKeyReleased(evt);
            }
        });
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Posture:");
        this.drTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DefenseDialog.this.drTextFieldFocusGained(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name).addComponent(this.result).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addGap(1, 1, 1).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dodgeButton).addComponent(this.parryButton, GroupLayout.Alignment.LEADING)).addComponent(this.blockButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.blockNote).addComponent(this.dodgeNote).addComponent(this.parryNote))).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.postureCombo, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eeCheck).addComponent(this.retreatCheck).addComponent(this.sideCheck).addComponent(this.stunnedCheck).addGroup(layout.createSequentialGroup().addComponent(this.shieldCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.db)).addGroup(layout.createSequentialGroup().addComponent(this.otherSpinner, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(33, 33, 33)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.damageTextField, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.locationCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.drTextField, -2, 46, -2))).addComponent(this.noneButton).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.effectiveDefense).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.rollTextField, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rerollButton))))).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.name, -2, 28, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eeCheck).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.retreatCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sideCheck)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parryButton).addComponent(this.parryNote)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.blockButton).addComponent(this.blockNote)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dodgeButton).addComponent(this.dodgeNote).addComponent(this.stunnedCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noneButton).addComponent(this.shieldCheckBox).addComponent(this.db)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.postureCombo, -2, -1, -2).addComponent(this.otherSpinner, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.effectiveDefense, -2, 28, -2).addComponent(this.jLabel7, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rollTextField, -2, -1, -2).addComponent(this.rerollButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 4, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel8).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationCombo, -2, -1, -2).addComponent(this.damageTextField, -2, -1, -2).addComponent(this.drTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.result, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton))));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("DefenseDialog: OK!");
        }
        this.valid = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("DefenseDialog: CANCEL!");
        }
        this.valid = false;
        this.setVisible(false);
    }

    private void rerollButtonActionPerformed(ActionEvent evt) {
        this.rollDefense();
    }

    private void otherSpinnerStateChanged(ChangeEvent evt) {
        this.updateDefenseResults();
    }

    private void locationComboKeyReleased(KeyEvent evt) {
        this.updateDefenseResults();
    }

    private void checkItemStateChanged(ItemEvent evt) {
        this.updateDefenseResults();
    }

    private void radioButtonActionPerformed(ActionEvent evt) {
        this.updateDefenseResults();
    }

    private void drTextFieldFocusGained(FocusEvent evt) {
        this.drTextField.selectAll();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DefenseDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefenseDialog dialog = new DefenseDialog(new JWindow());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setActor(new Actor());
                dialog.setVisible(true);
            }
        });
    }

    public void setActor(Actor actor) {
        this.updating = true;
        this.actor = actor;
        this.defense = new Defense();
        this.defense.setInitialOptions(actor);
        this.name.setText(actor.getTraitValue(ActorBase.BasicTrait.Name));
        switch (actor.getType()) {
            case PC: {
                this.name.setBackground(new Color(200, 255, 200));
                break;
            }
            case Ally: {
                this.name.setBackground(new Color(200, 200, 255));
                break;
            }
            case Enemy: {
                this.name.setBackground(new Color(255, 200, 200));
                break;
            }
            case Neutral: {
                this.name.setBackground(new Color(200, 200, 200));
                break;
            }
            case Special: {
                this.name.setBackground(new Color(255, 200, 255));
            }
        }
        int effParry = actor.getCurrentDefenseValue(Defense.DefenseType.Parry);
        int effBlock = actor.getCurrentDefenseValue(Defense.DefenseType.Block);
        int effDodge = actor.getCurrentDefenseValue(Defense.DefenseType.Dodge);
        int parry = actor.getTraitValueInt(ActorBase.BasicTrait.Parry);
        int block = actor.getTraitValueInt(ActorBase.BasicTrait.Block);
        int dodge = actor.getTraitValueInt(ActorBase.BasicTrait.Dodge);
        this.parryNote.setText(String.valueOf(effParry) + (effParry != parry ? " (base: " + parry + ")" : ""));
        this.blockNote.setText(String.valueOf(effBlock) + (effBlock != block ? " (base: " + block + ")" : ""));
        this.dodgeNote.setText(String.valueOf(effDodge) + (effDodge != dodge ? " (base: " + dodge + ")" : ""));
        switch (this.defense.type) {
            case Parry: {
                this.parryButton.setSelected(true);
                break;
            }
            case Block: {
                this.blockButton.setSelected(true);
                break;
            }
            case Dodge: {
                this.dodgeButton.setSelected(true);
                break;
            }
            case None: {
                this.noneButton.setSelected(true);
            }
        }
        this.eeCheck.setSelected(this.defense.ee);
        this.retreatCheck.setSelected(this.defense.retreat);
        this.sideCheck.setSelected(this.defense.side);
        this.stunnedCheck.setSelected(this.defense.stunned);
        this.shieldCheckBox.setSelected(this.defense.shield);
        int shieldDB = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DB);
        int shieldDR = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_DR);
        int shieldHP = actor.getTraitValueInt(ActorBase.BasicTrait.Shield_HP);
        String dr = actor.getTraitValue(ActorBase.BasicTrait.DR);
        this.db.setText("DB: " + shieldDB);
        this.db.setToolTipText("DR: " + shieldDR + " HP: " + (shieldHP - actor.getTempInt("shieldDamage")) + "/" + shieldHP);
        this.shieldCheckBox.setToolTipText("DR: " + shieldDR + " HP: " + (shieldHP - actor.getTempInt("shieldDamage")) + "/" + shieldHP);
        this.drTextField.setText(dr);
        this.damageTextField.setText("");
        this.postureCombo.setSelectedIndex(0);
        if (this.defense.position.equals("Kneeling")) {
            this.postureCombo.setSelectedIndex(1);
        }
        if (this.defense.position.equals("Prone")) {
            this.postureCombo.setSelectedIndex(2);
        }
        this.otherSpinner.setValue(0);
        this.locationCombo.setSelectedItem("Torso");
        this.rollDefense();
        this.updating = false;
        this.updateDefenseResults();
        this.damageTextField.selectAll();
        this.damageTextField.requestFocusInWindow();
    }

    private void rollDefense() {
        this.rollTextField.setText(String.valueOf(DieRoller.roll3d6()));
    }

    private void updateDefenseResults() {
        if (this.actor == null || this.updating) {
            return;
        }
        if (!this.parseInputFields()) {
            return;
        }
        this.updateDefenseSettings();
        this.defense.calcDefenseResults(this.actor);
        this.effectiveDefense.setText(String.valueOf(this.defense.effectiveDefense));
        this.setResultMessage();
    }

    private void updateDefenseSettings() {
        if (this.updating) {
            return;
        }
        if (this.parryButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Parry;
        } else if (this.blockButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Block;
        } else if (this.dodgeButton.isSelected()) {
            this.defense.type = Defense.DefenseType.Dodge;
        } else if (this.noneButton.isSelected()) {
            this.defense.type = Defense.DefenseType.None;
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("No defense selected!");
        }
        this.defense.ee = this.eeCheck.isSelected();
        this.defense.retreat = this.retreatCheck.isSelected();
        this.defense.side = this.sideCheck.isSelected();
        this.defense.stunned = this.stunnedCheck.isSelected();
        this.defense.shield = this.shieldCheckBox.isSelected();
        this.defense.position = this.postureCombo.getSelectedItem().toString();
        try {
            this.defense.otherMod = Integer.parseInt(this.otherSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean parseInputFields() {
        boolean parseSuccess = true;
        try {
            this.defense.roll = Integer.parseInt(this.rollTextField.getText());
            this.rollTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.rollTextField.setForeground(Color.RED);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Failed to parse roll field! '" + this.rollTextField.getText() + "': " + e.getMessage());
            }
            parseSuccess = false;
        }
        try {
            this.defense.overrideDR = DR.parseDR(this.drTextField.getText());
            this.drTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.drTextField.setForeground(Color.RED);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Failed to parse dr field! '" + this.drTextField.getText() + "': " + e.getMessage());
            }
            parseSuccess = false;
        }
        try {
            this.defense.damage = Damage.parseDamage(this.damageTextField.getText());
            this.damageTextField.setForeground(Color.BLACK);
        }
        catch (Exception e) {
            this.damageTextField.setForeground(Color.RED);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Failed to parse damage field! '" + this.damageTextField.getText() + "': " + e.getMessage());
            }
            parseSuccess = false;
        }
        this.defense.location = HitLocations.getLocationFromName((String)this.locationCombo.getSelectedItem());
        return parseSuccess;
    }

    private void setResultMessage() {
        String message = "";
        switch (this.defense.result) {
            case CritSuccess: {
                this.result.setText("Critical Defense!");
                this.result.setBackground(new Color(200, 200, 255));
                return;
            }
            case Success: {
                this.result.setText("Defended!");
                this.result.setBackground(new Color(200, 200, 200));
                return;
            }
            case ShieldHit: {
                message = "Shield ";
            }
            case Failure: {
                message = String.valueOf(message) + "Hit";
                break;
            }
            case CritFailure: {
                message = String.valueOf(message) + "Hit (crit fail)";
            }
        }
        if (this.defense.injury != 0) {
            this.result.setBackground(new Color(255, 200, 200));
            message = String.valueOf(message) + ": " + this.defense.injury;
            if (this.defense.cripplingInjury) {
                message = String.valueOf(message) + " crippling";
            } else if (this.defense.majorWound) {
                message = String.valueOf(message) + " major";
            }
            message = String.valueOf(message) + " injury!";
        } else {
            this.result.setBackground(new Color(200, 200, 200));
            message = String.valueOf(message) + ": no injury";
        }
        if (this.defense.result == Defense.DefenseResult.ShieldHit) {
            if (this.defense.shieldDamage != 0 && this.defense.injury == 0) {
                this.result.setBackground(new Color(255, 255, 200));
            }
            message = String.valueOf(message) + " (" + this.defense.shieldDamage + " shld dmg)";
        } else if (this.defense.result == Defense.DefenseResult.CritFailure) {
            this.result.setBackground(new Color(255, 200, 200));
        }
        this.result.setText(message);
    }

    protected class ModDocumentListener
    implements DocumentListener {
        protected ModDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }
    }

    protected class ValueDocumentListener
    implements DocumentListener {
        protected ValueDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DefenseDialog.this.updateDefenseResults();
        }
    }
}

