/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.ui;

import gurpsinittool.data.GameSettings;
import gurpsinittool.util.MiscUtil;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class OptionsWindow
extends JFrame {
    private static final Logger LOG = Logger.getLogger(OptionsWindow.class.getName());
    public GameSettings currentSettings = new GameSettings();
    private Properties propertyBag;
    private JCheckBox allyAutomated;
    private JButton applyButton;
    private JCheckBox autoAttack;
    private JCheckBox autoKnockdown;
    private JCheckBox autoShock;
    private JCheckBox autoStunrecovery;
    private JCheckBox autoUnconsciousness;
    private JButton cancelButton;
    private JPanel combatAutomationPanel;
    private JCheckBox enemyAutomated;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JCheckBox logDefenseDetails;
    private JCheckBox logStatusChanges;
    private JCheckBox neutralAutomated;
    private JButton okButton;
    private JCheckBox pcAutomated;
    private JCheckBox specialAutomated;

    public OptionsWindow(Properties propertyBag) {
        this.propertyBag = propertyBag;
        this.initComponents();
        this.setDefaultProperties();
        this.setLocation(Integer.valueOf(propertyBag.getProperty("Options.location.x")), Integer.valueOf(propertyBag.getProperty("Options.location.y")));
        if (propertyBag.containsKey("Options.game.AUTO_ATTACK")) {
            this.currentSettings.autoAttack = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_ATTACK"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_KNOCKDOWNSTUN")) {
            this.currentSettings.autoKnockdownStun = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_KNOCKDOWNSTUN"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_STUNRECOVERY")) {
            this.currentSettings.autoStunRecovery = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_STUNRECOVERY"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_UNCONSCIOUS")) {
            this.currentSettings.autoUnconscious = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_UNCONSCIOUS"));
        }
        if (propertyBag.containsKey("Options.game.AUTOMATE_PC")) {
            this.currentSettings.automatePC = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTOMATE_PC"));
        }
        if (propertyBag.containsKey("Options.game.AUTOMATE_ENEMY")) {
            this.currentSettings.automateEnemy = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTOMATE_ENEMY"));
        }
        if (propertyBag.containsKey("Options.game.AUTOMATE_ALLY")) {
            this.currentSettings.automateAlly = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTOMATE_ALLY"));
        }
        if (propertyBag.containsKey("Options.game.AUTOMATE_NEUTRAL")) {
            this.currentSettings.automateNeutral = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTOMATE_NEUTRAL"));
        }
        if (propertyBag.containsKey("Options.game.AUTOMATE_SPECIAL")) {
            this.currentSettings.automateSpecial = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTOMATE_SPECIAL"));
        }
        if (propertyBag.containsKey("Options.game.AUTO_SHOCK")) {
            this.currentSettings.autoShock = Boolean.valueOf(propertyBag.getProperty("Options.game.AUTO_SHOCK"));
        }
        if (propertyBag.containsKey("Options.game.LOG_STATUSCHANGES")) {
            this.currentSettings.logStatusChanges = Boolean.valueOf(propertyBag.getProperty("Options.game.LOG_STATUSCHANGES"));
        }
        if (propertyBag.containsKey("Options.game.LOG_DEFENSEDETAILS")) {
            this.currentSettings.logDefenseDetails = Boolean.valueOf(propertyBag.getProperty("Options.game.LOG_DEFENSEDETAILS"));
        }
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("Options.location.x")) {
            this.propertyBag.setProperty("Options.location.x", "500");
        }
        if (!this.propertyBag.containsKey("Options.location.y")) {
            this.propertyBag.setProperty("Options.location.y", "300");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("Options.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("Options.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("Options.game.AUTO_ATTACK", String.valueOf(this.currentSettings.autoAttack));
        this.propertyBag.setProperty("Options.game.AUTO_KNOCKDOWNSTUN", String.valueOf(this.currentSettings.autoKnockdownStun));
        this.propertyBag.setProperty("Options.game.AUTO_STUNRECOVERY", String.valueOf(this.currentSettings.autoStunRecovery));
        this.propertyBag.setProperty("Options.game.AUTO_UNCONSCIOUS", String.valueOf(this.currentSettings.autoUnconscious));
        this.propertyBag.setProperty("Options.game.AUTOMATE_PC", String.valueOf(this.currentSettings.automatePC));
        this.propertyBag.setProperty("Options.game.AUTOMATE_ENEMY", String.valueOf(this.currentSettings.automateEnemy));
        this.propertyBag.setProperty("Options.game.AUTOMATE_ALLY", String.valueOf(this.currentSettings.automateAlly));
        this.propertyBag.setProperty("Options.game.AUTOMATE_NEUTRAL", String.valueOf(this.currentSettings.automateNeutral));
        this.propertyBag.setProperty("Options.game.AUTOMATE_SPECIAL", String.valueOf(this.currentSettings.automateSpecial));
        this.propertyBag.setProperty("Options.game.AUTO_SHOCK", String.valueOf(this.currentSettings.autoShock));
        this.propertyBag.setProperty("Options.game.LOG_STATUSCHANGES", String.valueOf(this.currentSettings.logStatusChanges));
        this.propertyBag.setProperty("Options.game.LOG_DEFENSEDETAILS", String.valueOf(this.currentSettings.logDefenseDetails));
    }

    private void initComponents() {
        this.combatAutomationPanel = new JPanel();
        this.autoAttack = new JCheckBox();
        this.autoUnconsciousness = new JCheckBox();
        this.autoKnockdown = new JCheckBox();
        this.autoStunrecovery = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.pcAutomated = new JCheckBox();
        this.enemyAutomated = new JCheckBox();
        this.allyAutomated = new JCheckBox();
        this.neutralAutomated = new JCheckBox();
        this.specialAutomated = new JCheckBox();
        this.okButton = new JButton();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.logDefenseDetails = new JCheckBox();
        this.logStatusChanges = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.autoShock = new JCheckBox();
        this.setTitle("InitTool Settings");
        this.combatAutomationPanel.setBorder(BorderFactory.createTitledBorder("Automation"));
        this.autoAttack.setText("Attack");
        this.autoAttack.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.autoUnconsciousness.setText("Unconsciousness Checks");
        this.autoUnconsciousness.setToolTipText("NPCs check for unconsciousness at the start of each of their turns.");
        this.autoKnockdown.setText("Knockdown and Stunning");
        this.autoKnockdown.setToolTipText("NPCs check for knockdown and stunning when taking sufficient damage.");
        this.autoStunrecovery.setText("Stun Recovery");
        this.autoStunrecovery.setToolTipText("Stunned NPCs check for stun recovery at the start of their turns.");
        this.jLabel1.setText("Combatant types automated:");
        this.pcAutomated.setText("PC");
        this.pcAutomated.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.enemyAutomated.setText("Enemy");
        this.enemyAutomated.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.allyAutomated.setText("Ally");
        this.allyAutomated.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.neutralAutomated.setText("Neutral");
        this.neutralAutomated.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        this.specialAutomated.setText("Special");
        this.specialAutomated.setToolTipText("NPCs with the 'Attacking' status automatically perform their default attack when it is their turn, as long as they are not Stunned.");
        GroupLayout combatAutomationPanelLayout = new GroupLayout(this.combatAutomationPanel);
        this.combatAutomationPanel.setLayout(combatAutomationPanelLayout);
        combatAutomationPanelLayout.setHorizontalGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combatAutomationPanelLayout.createSequentialGroup().addGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoAttack).addComponent(this.autoUnconsciousness).addComponent(this.autoKnockdown).addComponent(this.autoStunrecovery).addGroup(combatAutomationPanelLayout.createSequentialGroup().addContainerGap().addGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pcAutomated).addComponent(this.enemyAutomated).addComponent(this.allyAutomated).addComponent(this.neutralAutomated).addComponent(this.specialAutomated))).addGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)));
        combatAutomationPanelLayout.setVerticalGroup(combatAutomationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combatAutomationPanelLayout.createSequentialGroup().addComponent(this.autoAttack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoUnconsciousness).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoKnockdown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoStunrecovery).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(1, 1, 1).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcAutomated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enemyAutomated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allyAutomated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.neutralAutomated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.specialAutomated).addGap(0, 7, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.okButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Logging"));
        this.logDefenseDetails.setText("Defense details");
        this.logDefenseDetails.setToolTipText("Log defense details (retreat/EE/side/etc.)");
        this.logStatusChanges.setText("Verbose Status Changes");
        this.logStatusChanges.setToolTipText("Log all status changes");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logStatusChanges).addComponent(this.logDefenseDetails)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.logStatusChanges).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logDefenseDetails)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Game Rules"));
        this.autoShock.setText("Shock");
        this.autoShock.setToolTipText("Track and apply shock to all attack rolls");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.autoShock).addGap(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoShock));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combatAutomationPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 44, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.combatAutomationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.applyButton).addComponent(this.okButton))));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("DefenseDialog: OK!");
        }
        this.copyComponentsToSettings();
        this.setVisible(false);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("OptionsWindow: Apply!");
        }
        this.copyComponentsToSettings();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void copySettingsToComponents() {
        this.autoAttack.setSelected(this.currentSettings.autoAttack);
        this.autoKnockdown.setSelected(this.currentSettings.autoKnockdownStun);
        this.autoStunrecovery.setSelected(this.currentSettings.autoStunRecovery);
        this.autoUnconsciousness.setSelected(this.currentSettings.autoUnconscious);
        this.pcAutomated.setSelected(this.currentSettings.automatePC);
        this.enemyAutomated.setSelected(this.currentSettings.automateEnemy);
        this.allyAutomated.setSelected(this.currentSettings.automateAlly);
        this.neutralAutomated.setSelected(this.currentSettings.automateNeutral);
        this.specialAutomated.setSelected(this.currentSettings.automateSpecial);
        this.autoShock.setSelected(this.currentSettings.autoShock);
        this.logStatusChanges.setSelected(this.currentSettings.logStatusChanges);
        this.logDefenseDetails.setSelected(this.currentSettings.logDefenseDetails);
    }

    public void copyComponentsToSettings() {
        this.currentSettings.autoAttack = this.autoAttack.isSelected();
        this.currentSettings.autoKnockdownStun = this.autoKnockdown.isSelected();
        this.currentSettings.autoStunRecovery = this.autoStunrecovery.isSelected();
        this.currentSettings.autoUnconscious = this.autoUnconsciousness.isSelected();
        this.currentSettings.autoShock = this.autoShock.isSelected();
        this.currentSettings.automatePC = this.pcAutomated.isSelected();
        this.currentSettings.automateEnemy = this.enemyAutomated.isSelected();
        this.currentSettings.automateAlly = this.allyAutomated.isSelected();
        this.currentSettings.automateNeutral = this.neutralAutomated.isSelected();
        this.currentSettings.automateSpecial = this.specialAutomated.isSelected();
        this.currentSettings.logStatusChanges = this.logStatusChanges.isSelected();
        this.currentSettings.logDefenseDetails = this.logDefenseDetails.isSelected();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            MiscUtil.validateOnScreen(this);
            if (!this.isVisible()) {
                this.copySettingsToComponents();
            } else if (this.getState() == 1) {
                this.setState(0);
            }
        }
        super.setVisible(visible);
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(OptionsWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OptionsWindow(new Properties()).setVisible(true);
            }
        });
    }
}

