/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.util;

import gurpsinittool.util.FileChangeEvent;
import gurpsinittool.util.FileChangeEventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class CleanFileChangeEventSource {
    private static final Logger LOG = Logger.getLogger(CleanFileChangeEventSource.class.getName());
    private boolean clean = true;
    private final Object eventSource;
    protected EventListenerList listenerList = new EventListenerList();

    public CleanFileChangeEventSource(Object source) {
        this.eventSource = source;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean() {
        if (!this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this.eventSource, true));
        }
        this.clean = true;
    }

    public void setDirty() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("setDirty");
        }
        if (this.clean) {
            this.fireFileCleanStatusChangedEvent(new FileChangeEvent(this.eventSource, false));
        }
        this.fireFileChangedEvent(new FileChangeEvent(this, false));
        this.clean = false;
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.listenerList.add(FileChangeEventListener.class, listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.listenerList.remove(FileChangeEventListener.class, listener);
    }

    protected void fireFileChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileChangeOccured(evt);
            }
            i += 2;
        }
    }

    protected void fireFileCleanStatusChangedEvent(FileChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == FileChangeEventListener.class) {
                ((FileChangeEventListener)listeners[i + 1]).fileCleanStatusChanged(evt);
            }
            i += 2;
        }
    }
}

