/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.util;

import gurpsinittool.app.GITApp;
import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.util.AbstractGAction;
import gurpsinittool.util.MiscUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SearchSupport {
    private static final Logger LOG = Logger.getLogger(SearchSupport.class.getName());
    private JToolBar searchBar;
    private JTextField searchField;
    private boolean incrementalSearchInProgress = false;
    private JRootPane rootPane;
    private InitTable table;
    private int searchStartingTableIndex;
    private Pattern pattern;
    private SearchMode mode = SearchMode.Table;
    private GroupTree groupTree;
    private GroupTreeNode searchStartingNode;
    private ArrayList<GroupTreeNode> searchNodeList;
    public Action actionNextMatch;
    public Action actionPrevMatch;
    public Action actionSearchFocus;

    public SearchSupport(JRootPane rootPane, InitTable table) {
        this.rootPane = rootPane;
        this.table = table;
        this.initComponents();
    }

    public SearchSupport(JRootPane rootPane, GroupTree tree, InitTable table) {
        this(rootPane, table);
        this.mode = SearchMode.Tree;
        this.groupTree = tree;
    }

    private void initComponents() {
        this.searchBar = new JToolBar();
        JLabel searchLabel = new JLabel("Search: ");
        searchLabel.setToolTipText("Search combatant names (F3)");
        this.searchBar.add(searchLabel);
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Search combatant names (F3)");
        this.searchField.setColumns(20);
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processTextChanges(e);
            }

            private void processTextChanges(DocumentEvent e) {
                SearchSupport.this.incrementalSearch();
            }
        });
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchSupport.this.incrementalSearchInProgress = false;
                SearchSupport.this.searchField.setForeground(Color.gray);
                SearchSupport.this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                MiscUtil.setTextFieldFontStyle(SearchSupport.this.searchField, 2);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchSupport.this.incrementalSearchInProgress = false;
                SearchSupport.this.searchField.setForeground(Color.black);
                MiscUtil.setTextFieldFontStyle(SearchSupport.this.searchField, 0);
                SearchSupport.this.searchField.selectAll();
            }
        });
        this.searchBar.add(this.searchField);
        this.actionPrevMatch = new AbstractGAction("Search Up", "Find previous match (Ctrl+Shift+G)", new ImageIcon(GITApp.class.getResource("/resources/images/bullet_arrow_up.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchSupport.this.searchNext(true);
            }
        };
        this.actionNextMatch = new AbstractGAction("Search Down", "Find next match (Ctrl+G)", new ImageIcon(GITApp.class.getResource("/resources/images/bullet_arrow_down.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchSupport.this.searchNext(false);
            }
        };
        this.actionSearchFocus = new AbstractGAction("Search", "Search (F3)", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchSupport.this.searchField.requestFocusInWindow();
            }
        };
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("control G"), "SearchNext");
        this.rootPane.getActionMap().put("SearchNext", this.actionNextMatch);
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("control shift G"), "SearchPrev");
        this.rootPane.getActionMap().put("SearchPrev", this.actionPrevMatch);
        this.rootPane.getInputMap(1).put(KeyStroke.getKeyStroke("F3"), "SearchFocus");
        this.rootPane.getActionMap().put("SearchFocus", this.actionSearchFocus);
        this.searchBar.add(MiscUtil.noTextButton(this.actionPrevMatch));
        this.searchBar.add(MiscUtil.noTextButton(this.actionNextMatch));
    }

    /*
     * Unable to fully structure code
     */
    private void setStartingLocation() {
        switch (SearchSupport.$SWITCH_TABLE$gurpsinittool$util$SearchSupport$SearchMode()[this.mode.ordinal()]) {
            case 2: {
                if (this.groupTree.getLastSelectedPathComponent() != null) ** GOTO lbl8
                this.searchStartingNode = (GroupTreeNode)this.groupTree.getModel().getRoot();
                if (SearchSupport.LOG.isLoggable(Level.FINE)) {
                    SearchSupport.LOG.fine("Starting at the beginning");
                }
                ** GOTO lbl11
lbl8:
                // 1 sources

                this.searchStartingNode = (GroupTreeNode)this.groupTree.getLastSelectedPathComponent();
                if (SearchSupport.LOG.isLoggable(Level.FINE)) {
                    SearchSupport.LOG.fine("Current group selection: " + this.groupTree.getLastSelectedPathComponent().toString());
                }
            }
lbl11:
            // 5 sources

            case 1: {
                this.searchStartingTableIndex = this.table.getSelectedRow();
            }
        }
    }

    private void generateSearchNodeList() {
        if (this.mode == SearchMode.Tree) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Generating list from enumeration");
            }
            GroupTreeNode rootNode = (GroupTreeNode)this.groupTree.getModel().getRoot();
            Enumeration<TreeNode> en = rootNode.preorderEnumeration();
            this.searchNodeList = new ArrayList();
            while (en.hasMoreElements()) {
                this.searchNodeList.add((GroupTreeNode)en.nextElement());
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Done generating list from enumeration");
            }
        }
    }

    private void searchNext(boolean reverse) {
        if (!this.updatePattern()) {
            return;
        }
        this.setStartingLocation();
        this.generateSearchNodeList();
        if (this.performSearch(true, reverse)) {
            this.setStartingLocation();
            return;
        }
        this.searchField.setBorder(BorderFactory.createLineBorder(Color.red));
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("incrementalSearch: nothing found");
        }
    }

    private void incrementalSearch() {
        if (!this.updatePattern()) {
            return;
        }
        if (!this.incrementalSearchInProgress) {
            this.setStartingLocation();
            this.generateSearchNodeList();
            this.incrementalSearchInProgress = true;
        }
        if (this.performSearch(false, false)) {
            return;
        }
        this.searchField.setBorder(BorderFactory.createLineBorder(Color.red));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Nothing found");
        }
    }

    private boolean updatePattern() {
        String searchText = this.searchField.getText();
        if (searchText.equals("")) {
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Searching for text '" + searchText + "'");
        }
        this.pattern = Pattern.compile(searchText, 18);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean performSearch(boolean next, boolean reverse) {
        switch (this.mode) {
            case Tree: {
                GroupTreeNode currentNode;
                if (this.searchStartingNode == null) {
                    if (!LOG.isLoggable(Level.WARNING)) return false;
                    LOG.warning("currentNode is null!");
                    return false;
                }
                int startingNodeIndex = this.searchNodeList.indexOf(this.searchStartingNode);
                if (startingNodeIndex == -1) {
                    if (!LOG.isLoggable(Level.WARNING)) return false;
                    LOG.warning("startingNodeIndex is invalid!");
                    return false;
                }
                int i = startingNodeIndex;
                if (this.searchStartingNode.isGroup() && this.searchGroupNode(this.searchStartingNode, this.searchStartingTableIndex, -1, next, reverse, this.pattern)) {
                    return true;
                }
                do {
                    if (reverse) {
                        if (--i < 0) {
                            i = this.searchNodeList.size() - 1;
                        }
                    } else if (++i >= this.searchNodeList.size()) {
                        i = 0;
                    }
                    if (i != startingNodeIndex) continue;
                    if (!this.searchStartingNode.isGroup()) return false;
                    if (!this.searchGroupNode(this.searchStartingNode, -1, this.searchStartingTableIndex, false, reverse, this.pattern)) return false;
                    return true;
                } while (!(currentNode = this.searchNodeList.get(i)).isGroup() || !this.searchGroupNode(currentNode, -1, -1, false, reverse, this.pattern));
                return true;
            }
            case Table: {
                if (this.searchTable(this.searchStartingTableIndex, -1, next, reverse, this.pattern)) {
                    return true;
                }
                if (!this.searchTable(-1, this.searchStartingTableIndex, false, reverse, this.pattern)) return false;
                return true;
            }
        }
        return false;
    }

    private boolean searchGroupNode(GroupTreeNode currentNode, int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        int index;
        ArrayList<Actor> actorList = currentNode.getActorList();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("searching node " + currentNode.getUserObject().toString() + " starting at index " + startingIndex);
        }
        if ((index = SearchSupport.searchActorList(actorList, startingIndex, endingIndex, next, reverse, pattern)) != -1) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Found something!");
            }
            TreePath path = new TreePath(currentNode.getPath());
            this.groupTree.setSelectionPath(path);
            this.groupTree.scrollPathToVisible(path);
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return true;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("done searching node");
        }
        return false;
    }

    private boolean searchTable(int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        int index;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("searching initTable starting at index " + startingIndex);
        }
        if ((index = this.table.getActorTableModel().searchActors(startingIndex, endingIndex, next, reverse, pattern)) != -1) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Found something!");
            }
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
            this.searchField.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            return true;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("done searching");
        }
        return false;
    }

    public static int searchActorList(ArrayList<Actor> actorList, int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern searchPattern) {
        int arraySize = actorList.size();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Array size is " + arraySize);
        }
        if (startingIndex == -1) {
            startingIndex = reverse ? arraySize - 1 : 0;
        } else if (next) {
            startingIndex = reverse ? --startingIndex : ++startingIndex;
        }
        endingIndex = endingIndex == -1 ? (reverse ? -1 : arraySize) : (reverse ? --endingIndex : ++endingIndex);
        int index = startingIndex;
        while (index != endingIndex && index < arraySize && index >= 0) {
            String actorName = actorList.get(index).getTraitValue(ActorBase.BasicTrait.Name);
            if (searchPattern.matcher(actorName).find()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Found match at index " + index + ", name=" + actorName);
                }
                return index;
            }
            if (reverse) {
                --index;
                continue;
            }
            ++index;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Reached end of array");
        }
        return -1;
    }

    public JToolBar getSearchToolBar() {
        return this.searchBar;
    }

    public boolean hasFocus() {
        return this.searchField.hasFocus();
    }

    public boolean requestFocus() {
        return this.searchField.requestFocusInWindow();
    }

    private static enum SearchMode {
        Table,
        Tree;

    }
}

