/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.textfield.AbstractParsingFieldParser;
import gurpsinittool.app.textfield.ParsingField;
import gurpsinittool.data.Actor;
import gurpsinittool.data.Attack;
import gurpsinittool.data.DamageExpression;
import gurpsinittool.util.MiscUtil;
import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class AttackTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(AttackTableModel.class.getName());
    private String[] columnNames = new String[]{"Name", "Skill", "Damage", "U"};
    private Class<?>[] columnClasses = new Class[]{String.class, Integer.class, String.class, Boolean.class};
    private static int numColumns = 4;
    private Actor currentActor = null;

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public int getColumnCount() {
        return numColumns;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.currentActor == null) {
            return 0;
        }
        return this.currentActor.getNumAttacks();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentActor == null) {
            return null;
        }
        Attack attack = this.currentActor.getAttack(rowIndex);
        switch (columns.values()[columnIndex]) {
            case Name: {
                return attack.name;
            }
            case Skill: {
                return attack.skill;
            }
            case Damage: {
                return attack.damage;
            }
            case Unbalanced: {
                return attack.unbalanced;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        }
        if (this.getValueAt(row, col).equals(value)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Values are identical. Exiting.");
            }
            return;
        }
        Attack a = this.currentActor.getAttack(row);
        switch (columns.values()[col]) {
            case Name: {
                a.name = (String)value;
                break;
            }
            case Skill: {
                a.skill = (Integer)value;
                break;
            }
            case Damage: {
                a.damage = (String)value;
                break;
            }
            case Unbalanced: {
                a.unbalanced = (Boolean)value;
            }
        }
        this.currentActor.setAttack(a, row);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.currentActor != null;
    }

    public void setActor(Actor actor) {
        this.currentActor = actor;
        this.fireTableDataChanged();
    }

    public void addAttack() {
        if (this.currentActor != null) {
            this.currentActor.addAttack(new Attack());
        }
    }

    public void removeAttacks(int[] rows) {
        if (this.currentActor != null && rows.length > 0) {
            int i = rows.length - 1;
            while (i >= 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Deleting row: " + rows[i]);
                }
                this.currentActor.removeAttack(rows[i]);
                --i;
            }
        }
    }

    public void setDefaultAttack(int row) {
        if (row < 0 || row >= this.currentActor.getNumAttacks()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Row out of range! " + row);
            }
            return;
        }
        this.currentActor.setDefaultAttack(row);
    }

    public class AttackTableCellEditor
    extends DefaultCellEditor {
        public AttackTableCellEditor(AbstractParsingFieldParser parser) {
            super(new ParsingField(parser));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ParsingField c = (ParsingField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (isSelected) {
                c.selectAll();
            }
            return c;
        }
    }

    public class AttackTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getRowSorter().convertRowIndexToModel(row) == AttackTableModel.this.currentActor.getDefaultAttack()) {
                MiscUtil.setLabelBold(c);
            }
            c.setForeground(Color.black);
            c.setToolTipText(null);
            columns col = columns.valueOf(table.getColumnName(column));
            if (col == columns.Damage) {
                try {
                    DamageExpression exp = DamageExpression.parseDamageExpression(c.getText()).convertBasicDamage(AttackTableModel.this.currentActor);
                    String tooltip = exp.toString();
                    c.setToolTipText(tooltip);
                    c.setForeground(Color.black);
                }
                catch (ParseException e) {
                    c.setForeground(Color.red);
                }
            }
            return c;
        }
    }

    public static enum columns {
        Name,
        Skill,
        Damage,
        Unbalanced;

    }
}

