/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugLog
extends JFrame
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DebugLog.class.getName());
    private static final Logger ROOTLOG = Logger.getLogger("gurpsinittool.");
    private Properties propertyBag;
    private JTextArea logArea = new JTextArea();
    private JScrollPane logPane = null;
    private JMenuBar jMenuBar;
    private JMenu jMenu;
    private JFileChooser saveFileChooser;
    private TextAreaHandler textAreaHandler = new TextAreaHandler();

    public DebugLog() {
        super("Debug Log");
        ROOTLOG.addHandler(this.textAreaHandler);
    }

    public void Initialize(Properties propertyBag) {
        this.propertyBag = propertyBag;
        this.setDefaultProperties();
        this.jMenuBar = new JMenuBar();
        this.jMenu = new JMenu("File");
        this.jMenu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem("Save", 83);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.jMenu = new JMenu("Log Level");
        this.jMenu.setMnemonic(76);
        ButtonGroup logLevelGroup = new ButtonGroup();
        menuItem = new JRadioButtonMenuItem("SEVERE");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("WARNING");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("INFO");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("CONFIG");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("FINE");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("FINER");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("FINEST");
        logLevelGroup.add(menuItem);
        menuItem.addActionListener(this);
        this.jMenu.add(menuItem);
        this.jMenuBar.add(this.jMenu);
        this.setJMenuBar(this.jMenuBar);
        this.logArea.setEditable(false);
        this.logArea.setFont(new Font("monospaced", 0, 12));
        this.logPane = new JScrollPane(this.logArea);
        this.getContentPane().add(this.logPane);
        this.saveFileChooser = new JFileChooser();
        this.setLocation(Integer.valueOf(propertyBag.getProperty("DebugLog.location.x")), Integer.valueOf(propertyBag.getProperty("DebugLog.location.y")));
        this.setSize(Integer.valueOf(propertyBag.getProperty("DebugLog.size.width")), Integer.valueOf(propertyBag.getProperty("DebugLog.size.height")));
    }

    public void addText(String text) {
        this.logArea.append(text);
        this.getContentPane().validate();
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("DebugLog.location.x")) {
            this.propertyBag.setProperty("DebugLog.location.x", "400");
        }
        if (!this.propertyBag.containsKey("DebugLog.location.y")) {
            this.propertyBag.setProperty("DebugLog.location.y", "200");
        }
        if (!this.propertyBag.containsKey("DebugLog.size.width")) {
            this.propertyBag.setProperty("DebugLog.size.width", "400");
        }
        if (!this.propertyBag.containsKey("DebugLog.size.height")) {
            this.propertyBag.setProperty("DebugLog.size.height", "400");
        }
    }

    public void updateProperties() {
        this.propertyBag.setProperty("DebugLog.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("DebugLog.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("DebugLog.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("DebugLog.size.height", String.valueOf(this.getSize().height));
    }

    private void userSaveFile() {
        block7: {
            int retVal = this.saveFileChooser.showSaveDialog(this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Displaying file chooser");
            }
            if (retVal == 0) {
                int response;
                File file = this.saveFileChooser.getSelectedFile();
                if (!file.toString().contains(".")) {
                    file = new File(String.valueOf(file.toString()) + ".txt");
                }
                if (file.exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                    return;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Saving log to file: " + file.getName());
                }
                try {
                    FileWriter fstream = new FileWriter(file);
                    BufferedWriter out = new BufferedWriter(fstream);
                    this.logArea.write(out);
                    out.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block7;
                    LOG.log(Level.SEVERE, "Error saving log: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Received info action command " + e.getActionCommand());
        }
        if ("WARNING".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.WARNING);
        } else if ("SEVERE".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.SEVERE);
        } else if ("WARNING".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.WARNING);
        } else if ("INFO".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.INFO);
        } else if ("CONFIG".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.CONFIG);
        } else if ("FINE".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.FINE);
        } else if ("FINER".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.FINER);
        } else if ("FINEST".equals(e.getActionCommand())) {
            ROOTLOG.setLevel(Level.FINEST);
        } else if ("Save".equals(e.getActionCommand())) {
            this.userSaveFile();
        }
    }

    public class TextAreaHandler
    extends Handler {
        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(final LogRecord record) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (record.getSourceClassName().startsWith("gurpsinittool.")) {
                        StringWriter text = new StringWriter();
                        PrintWriter out = new PrintWriter(text);
                        out.printf("[%7s] %s.%s: %s\n", record.getLevel(), record.getSourceClassName(), record.getSourceMethodName(), record.getMessage());
                        DebugLog.this.logArea.append(text.toString());
                    }
                }
            });
        }
    }
}

