/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.CommandMode;
import gurpsinittool.app.DebugLog;
import gurpsinittool.app.GroupManager;
import gurpsinittool.app.InitTable;
import gurpsinittool.data.Actor;
import gurpsinittool.data.GameMaster;
import gurpsinittool.ui.ActorDetailsPanel_v2;
import gurpsinittool.ui.CriticalTablesDialog;
import gurpsinittool.ui.DefenseDialog;
import gurpsinittool.ui.OptionsWindow;
import gurpsinittool.util.AbstractGAction;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogListener;
import gurpsinittool.util.MiscUtil;
import gurpsinittool.util.SearchSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class GITApp
extends JFrame
implements PropertyChangeListener,
EncounterLogListener,
ListSelectionListener,
TableModelListener {
    private static final Logger LOG = Logger.getLogger(GITApp.class.getName());
    private static DebugLog debugLogWindow = new DebugLog();
    public static final String GIT_VERSION = "1.7.0 PRERELEASE";
    private InitTable initTable;
    private JTextPane logTextArea;
    private HTMLDocument logTextDocument;
    private HTMLEditorKit kit;
    private ActorDetailsPanel_v2 detailsPanel;
    private DefenseDialog defenseDialog;
    private GroupManager groupManager;
    private OptionsWindow optionsWindow;
    private CriticalTablesDialog criticalTables;
    private Properties propertyBag = new Properties();
    private JLabel roundCounter;
    private JSplitPane jSplitPaneVertical;
    private JSplitPane jSplitPaneHorizontal;
    private SearchSupport searchSupport;
    private JToggleButton commandModeButton;
    private CommandMode commandMode;
    private GameMaster gameMaster = new GameMaster(true);
    public Action actionOptions;
    public Action actionSizeColumns;
    public Action actionOpenCriticalTables;
    public Action actionOpenGroupManager;
    public Action actionOpenDebugLog;
    public Action actionAbout;
    public Action actionToggleCommandMode;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITApp.initializeLogging();
                GITApp.createAndShowGUI();
            }
        });
    }

    private static void initializeLogging() {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%4$s %2$s: %5$s%6$s%n");
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (h instanceof ConsoleHandler) {
                h.setLevel(Level.ALL);
            }
            ++n2;
        }
    }

    private static void testRig() {
    }

    private static void createAndShowGUI() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Starting GURPS Initiative Tool");
        }
        GITApp mainApp = new GITApp("GURPS Initiative Tool");
        mainApp.setDefaultCloseOperation(0);
        mainApp.loadProperties();
        mainApp.setDefaultProperties();
        mainApp.initializeActions();
        mainApp.setAccelerators();
        mainApp.addComponentsToPane();
        mainApp.groupManager.loadDefaultGroupFile();
        if (Boolean.valueOf(mainApp.propertyBag.getProperty("GITApp.Manager.visible")).booleanValue()) {
            mainApp.groupManager.setVisible(true);
        }
        if (Boolean.valueOf(mainApp.propertyBag.getProperty("GITApp.DebugLog.visible")).booleanValue()) {
            debugLogWindow.setVisible(true);
        }
        mainApp.setVisible(true);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Tool Started");
        }
    }

    private GITApp(String name) {
        super(name);
    }

    private void addComponentsToPane() {
        this.initTable = new InitTable(this.gameMaster, true, this.propertyBag);
        this.searchSupport = new SearchSupport(this.getRootPane(), this.initTable);
        this.defenseDialog = new DefenseDialog((Window)this);
        this.detailsPanel = new ActorDetailsPanel_v2(true);
        this.kit = new HTMLEditorKit();
        this.commandMode = new CommandMode(this, this.defenseDialog, this.searchSupport, this.gameMaster);
        this.commandMode.attachCommandMode(this);
        this.gameMaster.initTable = this.initTable;
        this.gameMaster.detailsPanel = this.detailsPanel;
        this.gameMaster.defenseDialog = this.defenseDialog;
        this.gameMaster.addPropertyChangeListener(this);
        this.initTable.getActorTableModel().addUndoableEditListener(this.gameMaster);
        this.logTextDocument = new HTMLDocument();
        this.logTextArea = new JTextPane();
        this.logTextArea.setEditorKit(this.kit);
        this.logTextArea.setDocument(this.logTextDocument);
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Tahoma", 0, 11));
        this.addLogLine("<i><font color=gray>Encounter Log</color></i>");
        this.logTextDocument.addUndoableEditListener(this.gameMaster);
        this.gameMaster.addEncounterLogEventListener(this);
        this.defenseDialog.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.defense.location.y")));
        this.optionsWindow = new OptionsWindow(this.propertyBag);
        this.optionsWindow.setDefaultCloseOperation(1);
        Actor.settings = this.optionsWindow.currentSettings;
        this.groupManager = new GroupManager(this.propertyBag);
        this.criticalTables = new CriticalTablesDialog((Frame)this, false);
        this.criticalTables.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.location.y")));
        this.criticalTables.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.crittables.size.height")));
        debugLogWindow.Initialize(this.propertyBag);
        this.addMenuBar();
        this.addToolBar();
        this.initTable.getSelectionModel().addListSelectionListener(this);
        this.initTable.getActorTableModel().addTableModelListener(this);
        JScrollPane tableScrollPane = new JScrollPane(this.initTable);
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        JScrollPane actorDetailsPane = new JScrollPane(this.detailsPanel);
        actorDetailsPane.setMinimumSize(new Dimension(this.detailsPanel.getPreferredSize().width + 21, 0));
        this.jSplitPaneVertical = new JSplitPane(0, tableScrollPane, logScrollPane);
        this.jSplitPaneVertical.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitVertical.dividerLocation")));
        this.jSplitPaneVertical.setResizeWeight(0.8);
        this.jSplitPaneHorizontal = new JSplitPane(1, this.jSplitPaneVertical, actorDetailsPane);
        this.jSplitPaneHorizontal.setDividerLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.splitHorizontal.dividerLocation")));
        this.jSplitPaneHorizontal.setResizeWeight(0.95);
        this.getContentPane().add((Component)this.jSplitPaneHorizontal, "Center");
        this.setLocation(Integer.valueOf(this.propertyBag.getProperty("GITApp.location.x")), Integer.valueOf(this.propertyBag.getProperty("GITApp.location.y")));
        this.setSize(Integer.valueOf(this.propertyBag.getProperty("GITApp.size.width")), Integer.valueOf(this.propertyBag.getProperty("GITApp.size.height")));
        MiscUtil.validateOnScreen(this);
        this.addWindowListener(new GITAppWindowListener());
    }

    private void initializeActions() {
        this.actionSizeColumns = new AbstractGAction("Auto-size columns", "Auto re-size the table columns to best fit (Alt+A)", new ImageIcon(GITApp.class.getResource("/resources/images/script_code.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GITApp.this.initTable.autoSizeColumns();
            }
        };
        this.actionOptions = new AbstractGAction("Options", "Open the options dialog (Ctrl+O)", 79, null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GITApp.this.optionsWindow.setVisible(true);
            }
        };
        this.actionAbout = new AbstractGAction("About", "Information about the program", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GITApp.this.showAboutDialog();
            }
        };
        this.actionOpenCriticalTables = new AbstractGAction("Critical Tables", "Open Critical Tables (Alt+C)", new ImageIcon(GITApp.class.getResource("/resources/images/table_error.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MiscUtil.validateOnScreen(GITApp.this.criticalTables);
                GITApp.this.criticalTables.setVisible(true);
            }
        };
        this.actionOpenGroupManager = new AbstractGAction("Groups Manager", "Open Groups Manager (Alt+G)", new ImageIcon(GITApp.class.getResource("/resources/images/group.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MiscUtil.validateOnScreen(GITApp.this.groupManager);
                GITApp.this.groupManager.setVisible(true);
            }
        };
        this.actionOpenDebugLog = new AbstractGAction("Debug Log", "Open Debug Log (Alt+D)", new ImageIcon(GITApp.class.getResource("/resources/images/page_white_text.png"))){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MiscUtil.validateOnScreen(debugLogWindow);
                debugLogWindow.setVisible(true);
            }
        };
        this.actionToggleCommandMode = new AbstractGAction("Command Mode: Off", "Toggle Command Mode (Ctrl+Q)", null){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GITApp.this.commandModeButton.setSelected(!GITApp.this.commandMode.getModeEnabled());
                GITApp.this.commandMode.setModeEnabled(GITApp.this.commandModeButton.isSelected());
                if (GITApp.this.commandModeButton.isSelected()) {
                    GITApp.this.commandModeButton.setText("Command Mode: On");
                } else {
                    GITApp.this.commandModeButton.setText("Command Mode: Off");
                }
            }
        };
    }

    private void setAccelerators() {
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control N"), "actionNextActor");
        this.getRootPane().getActionMap().put("actionNextActor", this.gameMaster.actionNextActor);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control E"), "actionEndRound");
        this.getRootPane().getActionMap().put("actionEndRound", this.gameMaster.actionEndRound);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control R"), "actionNextRound");
        this.getRootPane().getActionMap().put("actionNextRound", this.gameMaster.actionNextRound);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("alt R"), "actionResetRound");
        this.getRootPane().getActionMap().put("actionResetRound", this.gameMaster.actionResetRound);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("alt A"), "actionSizeColumns");
        this.getRootPane().getActionMap().put("actionSizeColumns", this.actionSizeColumns);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control T"), "actionTagActors");
        this.getRootPane().getActionMap().put("actionTagActors", this.gameMaster.actionTagActors);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control K"), "actionAttack");
        this.getRootPane().getActionMap().put("actionAttack", this.gameMaster.actionAttack);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control D"), "actionDefend");
        this.getRootPane().getActionMap().put("actionDefend", this.gameMaster.actionDefend);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("alt C"), "actionOpenCriticalTables");
        this.getRootPane().getActionMap().put("actionOpenCriticalTables", this.actionOpenCriticalTables);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("alt G"), "actionOpenGroupManager");
        this.getRootPane().getActionMap().put("actionOpenGroupManager", this.actionOpenGroupManager);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control Q"), "actionToggleCommandMode");
        this.getRootPane().getActionMap().put("actionToggleCommandMode", this.actionToggleCommandMode);
    }

    private void addMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menuFile = new JMenu("Edit");
        menuFile.setMnemonic(69);
        JMenuItem menuItem = new JMenuItem(this.gameMaster.actionUndo);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(this.gameMaster.actionRedo);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/cut.png"), "Cut"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/page_copy.png"), "Copy"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(86);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.setIcon(new ImageIcon(GITApp.class.getResource("/resources/images/paste_plain.png"), "Paste"));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(this.actionOptions);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuFile.add(menuItem);
        menubar.add(menuFile);
        menuFile = new JMenu("View");
        menuFile.setMnemonic(86);
        menuFile.add(new JMenuItem(this.initTable.actionShowColumnCustomizer));
        menuItem = new JMenuItem(this.initTable.actionIncreaseFontSize);
        menuItem.setText("Increase table font size");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(521, 2));
        menuFile.add(menuItem);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("control EQUALS"), "actionIncreaseFontSize");
        this.getRootPane().getActionMap().put("actionIncreaseFontSize", this.initTable.actionIncreaseFontSize);
        menuItem = new JMenuItem(this.initTable.actionDecreaseFontSize);
        menuItem.setText("Decrease table font size");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        menuFile.add(menuItem);
        menubar.add(menuFile);
        menuFile = new JMenu("Window");
        menuFile.setMnemonic(87);
        menuItem = new JMenuItem(this.actionOpenGroupManager);
        menuItem.setMnemonic(71);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        menuFile.add(menuItem);
        menuFile.setMnemonic(87);
        menuItem = new JMenuItem(this.actionOpenCriticalTables);
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        menuFile.add(menuItem);
        menuItem = new JMenuItem(this.actionOpenDebugLog);
        menuItem.setMnemonic(68);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        menuFile.add(menuItem);
        menubar.add(menuFile);
        menubar.add(Box.createHorizontalGlue());
        JButton menuButton = new JButton(this.actionAbout);
        menuButton.setOpaque(true);
        menuButton.setContentAreaFilled(false);
        menuButton.setBorderPainted(false);
        menuButton.setFocusable(false);
        menubar.add(menuButton);
        this.setJMenuBar(menubar);
    }

    private void addToolBar() {
        JToolBar toolbar = new JToolBar("Encounter Control Toolbar");
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionNextActor));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionEndRound));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionNextRound));
        JLabel label = new JLabel("Round:");
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        toolbar.add(label);
        this.roundCounter = new JLabel("0");
        this.roundCounter.setHorizontalAlignment(0);
        this.roundCounter.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.roundCounter.setPreferredSize(new Dimension(20, 20));
        toolbar.add(this.roundCounter);
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionResetRound));
        toolbar.addSeparator();
        toolbar.add(MiscUtil.noTextButton(this.actionSizeColumns));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionTagActors));
        toolbar.addSeparator();
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionAttack));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionDefend));
        toolbar.addSeparator();
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionPostureStanding));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionPostureKneeling));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionPostureProne));
        toolbar.addSeparator();
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusTogglePhysicalStun));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleMentalStun));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleRecoveringStun));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleAttacking));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleDisarmed));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleUnconscious));
        toolbar.add(MiscUtil.noTextButton(this.gameMaster.actionStatusToggleDead));
        toolbar.addSeparator();
        this.commandModeButton = new JToggleButton(this.actionToggleCommandMode);
        toolbar.add(this.commandModeButton);
        toolbar.addSeparator();
        toolbar.add(this.searchSupport.getSearchToolBar());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.addSeparator();
        toolbar.add(MiscUtil.noTextButton(this.actionOpenCriticalTables));
        toolbar.add(MiscUtil.noTextButton(this.actionOpenGroupManager));
        toolbar.setRollover(true);
        this.getContentPane().add((Component)toolbar, "First");
    }

    private void refreshRoundText() {
        this.roundCounter.setText(String.valueOf(this.gameMaster.getRound()));
        int minimumWidth = this.roundCounter.getMinimumSize().width / 10 * 10;
        if (this.roundCounter.getMinimumSize().width + 1 != 0) {
            minimumWidth += 10;
        }
        this.roundCounter.setPreferredSize(new Dimension(minimumWidth, 20));
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Minimum round counter size = " + this.roundCounter.getMinimumSize().toString());
        }
    }

    private void loadProperties() {
        block8: {
            try {
                File propertyFile = new File("GitApp.props");
                if (propertyFile.exists()) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Loading properties from file " + propertyFile.getAbsolutePath());
                    }
                    FileInputStream propIn = new FileInputStream(propertyFile);
                    this.propertyBag.load(propIn);
                } else if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Properties file does not exist " + propertyFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Caught exception: File not found: " + e.toString());
                }
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block8;
                LOG.log(Level.SEVERE, "Caught exception: Error reading file! " + e.toString(), e);
            }
        }
    }

    private boolean saveProperties() {
        try {
            File propertyFile = new File("GitApp.props");
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Saving properties to file " + propertyFile.getAbsolutePath());
            }
            FileOutputStream propOut = new FileOutputStream(propertyFile);
            this.propertyBag.store(propOut, "GITApp Properties");
        }
        catch (FileNotFoundException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "File not found? " + e.toString(), e);
            }
            return false;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Error writing to file! " + e.toString(), e);
            }
            return false;
        }
        return true;
    }

    private void setDefaultProperties() {
        if (!this.propertyBag.containsKey("GITApp.Manager.visible")) {
            this.propertyBag.setProperty("GITApp.Manager.visible", "false");
        }
        if (!this.propertyBag.containsKey("GITApp.DebugLog.visible")) {
            this.propertyBag.setProperty("GITApp.DebugLog.visible", "false");
        }
        if (!this.propertyBag.containsKey("GITApp.splitHorizontal.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", "580");
        }
        if (!this.propertyBag.containsKey("GITApp.splitVertical.dividerLocation")) {
            this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.location.x")) {
            this.propertyBag.setProperty("GITApp.location.x", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.location.y")) {
            this.propertyBag.setProperty("GITApp.location.y", "400");
        }
        if (!this.propertyBag.containsKey("GITApp.size.width")) {
            this.propertyBag.setProperty("GITApp.size.width", "850");
        }
        if (!this.propertyBag.containsKey("GITApp.size.height")) {
            this.propertyBag.setProperty("GITApp.size.height", "550");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.x")) {
            this.propertyBag.setProperty("GITApp.defense.location.x", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.defense.location.y")) {
            this.propertyBag.setProperty("GITApp.defense.location.y", "200");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.location.x")) {
            this.propertyBag.setProperty("GITApp.crittables.location.x", "175");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.location.y")) {
            this.propertyBag.setProperty("GITApp.crittables.location.y", "175");
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.size.width")) {
            this.propertyBag.setProperty("GITApp.crittables.size.width", String.valueOf(new CriticalTablesDialog((Frame)this, (boolean)false).getPreferredSize().width));
        }
        if (!this.propertyBag.containsKey("GITApp.crittables.size.height")) {
            this.propertyBag.setProperty("GITApp.crittables.size.height", String.valueOf(new CriticalTablesDialog((Frame)this, (boolean)false).getPreferredSize().height));
        }
    }

    private void updateProperties() {
        this.propertyBag.setProperty("GITApp.defense.location.x", String.valueOf(this.defenseDialog.getLocation().x));
        this.propertyBag.setProperty("GITApp.defense.location.y", String.valueOf(this.defenseDialog.getLocation().y));
        this.propertyBag.setProperty("GITApp.Manager.visible", String.valueOf(this.groupManager.isVisible()));
        this.propertyBag.setProperty("GITApp.DebugLog.visible", String.valueOf(debugLogWindow.isVisible()));
        this.propertyBag.setProperty("GITApp.splitHorizontal.dividerLocation", String.valueOf(this.jSplitPaneHorizontal.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.splitVertical.dividerLocation", String.valueOf(this.jSplitPaneVertical.getDividerLocation()));
        this.propertyBag.setProperty("GITApp.location.x", String.valueOf(this.getLocation().x));
        this.propertyBag.setProperty("GITApp.location.y", String.valueOf(this.getLocation().y));
        this.propertyBag.setProperty("GITApp.size.width", String.valueOf(this.getSize().width));
        this.propertyBag.setProperty("GITApp.size.height", String.valueOf(this.getSize().height));
        this.propertyBag.setProperty("GITApp.crittables.location.x", String.valueOf(this.criticalTables.getLocation().x));
        this.propertyBag.setProperty("GITApp.crittables.location.y", String.valueOf(this.criticalTables.getLocation().y));
        this.propertyBag.setProperty("GITApp.crittables.size.width", String.valueOf(this.criticalTables.getSize().width));
        this.propertyBag.setProperty("GITApp.crittables.size.height", String.valueOf(this.criticalTables.getSize().height));
    }

    private void showAboutDialog() {
        String famfamcredit = "<a href=\"http://www.famfamfam.com/lab/icons/silk/\">Silk</a> icons by <a href=\"http://www.famfamfam.com/\">Mark James</a> licensed under <a href=\"http://creativecommons.org/licenses/by/2.5/\">CC BY 2.5</a> / used with minor changes.";
        String policy = "GURPS is a trademark of Steve Jackson Games, and its rules and art are copyrighted by Steve Jackson Games. All rights are reserved by Steve Jackson Games. This game aid is the original creation of Damian Small and is released for free distribution, and not for resale, under the permissions granted in the <a href=\"http://www.sjgames.com/general/online_policy.html\">Steve Jackson Games Online Policy</a>.";
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\"><b>GURPS Initiative Tool</b><br>Version: " + GIT_VERSION + "<br><p style='width: 300px;'>" + policy + "</p><p style='width: 300px;'>" + famfamcredit + "</p><br></body></html>");
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        ep.setEditable(false);
        ep.setBackground(new JLabel().getBackground());
        JOptionPane.showMessageDialog(this, ep, "About GURPS Initiative Tool", 1);
    }

    protected void addLogLine(String line) {
        block4: {
            try {
                this.kit.insertHTML(this.logTextDocument, this.logTextDocument.getLength(), line, 0, 0, null);
            }
            catch (BadLocationException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "BadLocationException trying to add line: " + line, e);
                }
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "IOException trying to add line: " + line, e);
            }
        }
        this.logTextArea.select(this.logTextDocument.getLength(), this.logTextDocument.getLength());
    }

    @Override
    public void encounterLogMessageSent(EncounterLogEvent evt) {
        this.addLogLine(evt.getLogMsg());
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        this.detailsPanel.setActor(this.initTable.getSelectedActor());
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Table list selection event");
            }
            this.detailsPanel.setActor(this.initTable.getSelectedActor());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("Round")) {
            this.refreshRoundText();
        }
    }

    private class GITAppWindowListener
    implements WindowListener {
        private GITAppWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Tool closing");
            }
            GITApp.this.updateProperties();
            GITApp.this.initTable.updateProperties();
            GITApp.this.groupManager.updateProperties();
            GITApp.this.optionsWindow.updateProperties();
            debugLogWindow.updateProperties();
            if (GITApp.this.groupManager.querySaveChanges()) {
                GITApp.this.saveProperties();
                System.exit(0);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }
}

