/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.app.InitTableModel;
import gurpsinittool.app.InitTableTransferHandler;
import gurpsinittool.data.Actor;
import gurpsinittool.data.GameMaster;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class GroupTreeTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(GroupTreeTransferHandler.class.getName());
    private GroupTree parent;
    protected static DataFlavor actorGroupFlavor = new DataFlavor(GroupTreeNode.class, "GURPS Actor Group Object");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{actorGroupFlavor};

    public GroupTreeTransferHandler(GroupTree parent, String property) {
        super(property);
        this.parent = parent;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        if (insertPath == null) {
            return false;
        }
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            this.parent.setDropMode(DropMode.INSERT);
            return true;
        }
        if (support.isDataFlavorSupported(InitTableTransferHandler.initTableActorFlavor) || support.isDataFlavorSupported(InitTableTransferHandler.groupTableActorFlavor)) {
            this.parent.setDropMode(DropMode.ON);
            support.setDropAction(1);
            if (parentNode.isGroup()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        GroupTree tree = (GroupTree)support.getComponent();
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath insertPath = dl.getPath();
        int insertIndex = dl.getChildIndex();
        GroupTreeNode parentNode = (GroupTreeNode)insertPath.getLastPathComponent();
        Transferable t = support.getTransferable();
        int action = support.getDropAction();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting action " + action);
        }
        if (support.isDataFlavorSupported(actorGroupFlavor)) {
            GroupTreeNode transferNode;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Retrieving node data...");
            }
            try {
                transferNode = (GroupTreeNode)t.getTransferData(actorGroupFlavor);
            }
            catch (UnsupportedFlavorException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Unsupported Flavor Exception: " + e.getMessage(), e);
                }
                return false;
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "IOException: " + e.getMessage(), e);
                }
                return false;
            }
            TreePath transferPath = new TreePath(transferNode.getPath());
            if (action == 2 && !tree.isSelectionEmpty()) {
                TreePath selectionPath = tree.getSelectionPath();
                if (transferPath.getPathCount() == selectionPath.getPathCount() && insertPath.getPathCount() >= selectionPath.getPathCount()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Comparing paths: " + insertPath + " vs " + selectionPath + " vs " + transferPath);
                    }
                    int i = 0;
                    while (i < selectionPath.getPathCount()) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.finer("Checking node path: " + insertPath.getPath()[i] + " vs " + selectionPath.getPath()[i]);
                        }
                        if (!transferPath.getPathComponent(i).toString().equals(selectionPath.getPathComponent(i).toString())) {
                            if (!LOG.isLoggable(Level.FINE)) break;
                            LOG.fine("Paths are NOT identical (transfer != selection): allowing move");
                            break;
                        }
                        if (!insertPath.getPathComponent(i).equals(selectionPath.getPathComponent(i))) {
                            if (!LOG.isLoggable(Level.FINE)) break;
                            LOG.fine("Paths are NOT identical (insert != selection): allowing move");
                            break;
                        }
                        if (i == selectionPath.getPathCount() - 1) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Paths are identical: disallowing move");
                            }
                            return false;
                        }
                        ++i;
                    }
                }
                tree.getGroupTable().getGameMaster().startCompoundEdit();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Inserting node " + transferPath.toString() + " @ " + insertIndex);
            }
            if (insertIndex >= 0) {
                tree.insertNode(transferNode, parentNode, insertIndex);
            } else {
                tree.insertNode(transferNode, parentNode, parentNode.getChildCount());
            }
            if (action == 2) {
                tree.setSelectionPath(new TreePath(transferNode.getPath()));
            }
        } else {
            Actor[] actorRows;
            if (!parentNode.isGroup()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Attempting to drop rows on folder!");
                }
                return false;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Retrieving actor data...");
            }
            try {
                actorRows = (Actor[])t.getTransferData(InitTableTransferHandler.initTableActorFlavor);
            }
            catch (UnsupportedFlavorException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Unsupported Flavor Exception: " + e.getMessage(), e);
                }
                return false;
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "IOException: " + e.getMessage(), e);
                }
                return false;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Transferable data retrieved.");
            }
            InitTableModel model = this.parent.getGroupTable().getActorTableModel();
            ArrayList<Actor> actorList = parentNode.getActorList();
            GameMaster gameMaster = this.parent.getGroupTable().getGameMaster();
            gameMaster.startCompoundEdit();
            int i = 0;
            while (i < actorRows.length) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Adding actor # " + i);
                }
                model.addActorToList(actorList, actorRows[i], actorList.size() - 1);
                ++i;
            }
            gameMaster.endCompoundEdit("Copy");
            tree.setDirty();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Done");
        }
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        GroupTree tree = (GroupTree)c;
        TreePath transferPath = tree.getSelectionPath();
        if (transferPath == null) {
            return null;
        }
        return new TransferableActorGroup((GroupTreeNode)transferPath.getLastPathComponent());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        GroupTreeNode transferNode;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting action " + action);
        }
        GroupTree tree = (GroupTree)source;
        try {
            transferNode = (GroupTreeNode)data.getTransferData(actorGroupFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "UnsupportedFlavorException: " + e.getMessage(), e);
            }
            return;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "IOException: " + e.getMessage(), e);
            }
            return;
        }
        TreePath transferPath = new TreePath(transferNode.getPath());
        if (action == 2) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Removing path that was transfered: " + transferPath.toString());
            }
            tree.removeNode(transferNode);
            tree.getGroupTable().getGameMaster().endCompoundEdit("Move");
        } else if (action == 1) {
            tree.setSelectionPath(transferPath);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Done");
        }
    }

    class TransferableActorGroup
    implements Transferable {
        GroupTreeNode transferNode;

        public TransferableActorGroup(GroupTreeNode transferNode) {
            this.transferNode = transferNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(actorGroupFlavor)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Exporting data to " + flavor + " flavor, path: " + new TreePath(this.transferNode.getPath()).toString());
                }
                return this.transferNode;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(actorGroupFlavor);
        }
    }
}

