/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app;

import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.GameMaster;
import gurpsinittool.util.CleanFileChangeEventSource;
import gurpsinittool.util.FileChangeEventListener;
import gurpsinittool.util.SearchSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class InitTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(InitTableModel.class.getName());
    private UndoableEditSupport mUes = new UndoableEditSupport();
    protected transient boolean undoRedoInProgress = false;
    private ArrayList<String> columnNames = new ArrayList();
    Actor newActor = new Actor();
    private ArrayList<Actor> actorList = new ArrayList();
    private GameMaster gameMaster;
    protected CleanFileChangeEventSource cleanFileChangeEventSource = new CleanFileChangeEventSource(this);

    public InitTableModel(GameMaster gameMaster) {
        this.gameMaster = gameMaster;
        this.addNewActor();
    }

    public void addActor(Actor actor, int destRow) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Start: " + actor.getTraitValue(ActorBase.BasicTrait.Name));
        }
        if (destRow > this.actorList.size() - 1) {
            destRow = this.actorList.size() - 1;
        } else if (destRow < 0) {
            destRow = 0;
        }
        this.addActorToList(this.actorList, actor, destRow);
    }

    public void addActorToList(ArrayList<Actor> list, Actor actor, int position) {
        list.add(position, actor);
        actor.setGameLogicEnabled(this.gameMaster.isGameLogicEnabled());
        if (list.equals(this.actorList)) {
            actor.addPropertyChangeListener(this);
            actor.addEncounterLogEventListener(this.gameMaster);
            actor.addUndoableEditListener(this.gameMaster);
            this.fireTableRowsInserted(position, position);
        }
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new AddActorToListEdit(list, actor, position));
        }
        this.setDirty();
    }

    private void addNewActor() {
        this.addActorToList(this.actorList, new Actor(this.newActor), this.actorList.size());
    }

    public void removeActor(int row) {
        Actor actor = this.getActor(row);
        this.removeActorFromList(this.actorList, actor, row);
    }

    private void removeActorFromList(ArrayList<Actor> list, Actor actor, int position) {
        list.remove(position);
        if (list.equals(this.actorList)) {
            actor.removePropertyChangeListener(this);
            actor.removeUndoableEditListener(this.gameMaster);
            actor.removeEncounterLogEventListener(this.gameMaster);
            this.setDirty();
            this.fireTableRowsDeleted(position, position);
        }
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new RemoveActorFromListEdit(list, actor, position));
        }
        this.setDirty();
    }

    public Actor getActor(int row) {
        return this.actorList.get(row);
    }

    public int[] getActorRows(Actor actor) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.actorList.size()) {
            if (this.actorList.get(i).equals(actor)) {
                rows.add(i);
            }
            ++i;
        }
        int[] intRows = new int[rows.size()];
        int i2 = 0;
        while (i2 < intRows.length) {
            intRows[i2] = (Integer)rows.get(i2);
            ++i2;
        }
        return intRows;
    }

    public Actor[] getActors(int[] rows) {
        Actor[] actors = new Actor[rows.length];
        int i = 0;
        while (i < rows.length) {
            actors[i] = this.actorList.get(rows[i]);
            ++i;
        }
        return actors;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    public ArrayList<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames);
    }

    @Override
    public int getRowCount() {
        return this.actorList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Actor actor = this.actorList.get(rowIndex);
        String traitName = this.columnNames.get(columnIndex);
        if (traitName.equals("Act")) {
            return null;
        }
        if (traitName.equals("Status")) {
            return actor.getAllStatuses();
        }
        if (traitName.equals("Type")) {
            return actor.getType();
        }
        if (!actor.hasTrait(traitName)) {
            return null;
        }
        return actor.getTraitValue(traitName);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        }
        Actor a = this.actorList.get(row);
        String traitName = this.columnNames.get(col);
        if (!traitName.equals("Act")) {
            if (traitName.equals("Status")) {
                a.setAllStatuses((HashSet)value);
            } else if (traitName.equals("Type")) {
                a.setType((ActorBase.ActorType)((Object)value));
            } else {
                a.setTrait(traitName, (String)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        String columnName = this.columnNames.get(col);
        if ("Status".equals(columnName) || "Type".equals(columnName)) {
            return true;
        }
        return !columnName.equals("Act") && !columnName.equals("Notes") && Actor.isBasicTrait(columnName);
    }

    public void setColumnList(ArrayList<String> columnList) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Setting list to " + columnList);
        }
        this.columnNames.clear();
        this.columnNames.addAll(columnList);
        super.fireTableStructureChanged();
    }

    public void setActorList(ArrayList<Actor> actorList) {
        for (Actor a : this.actorList) {
            a.removePropertyChangeListener(this);
            a.removeUndoableEditListener(this.gameMaster);
            a.removeEncounterLogEventListener(this.gameMaster);
        }
        this.fireTableRowsDeleted(0, this.getRowCount());
        if (actorList == null) {
            this.actorList = new ArrayList();
        } else {
            this.actorList = actorList;
            int i = 0;
            while (i < this.actorList.size()) {
                Actor a = this.actorList.get(i);
                a.addPropertyChangeListener(this);
                a.addUndoableEditListener(this.gameMaster);
                a.addEncounterLogEventListener(this.gameMaster);
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public int searchActors(int startingIndex, int endingIndex, boolean next, boolean reverse, Pattern pattern) {
        return SearchSupport.searchActorList(this.actorList, startingIndex, endingIndex, next, reverse, pattern);
    }

    public boolean isClean() {
        return this.cleanFileChangeEventSource.isClean();
    }

    public void setClean() {
        this.cleanFileChangeEventSource.setClean();
    }

    public void setDirty() {
        this.cleanFileChangeEventSource.setDirty();
    }

    public void addFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.addFileChangeEventListener(listener);
    }

    public void removeFileChangeEventListener(FileChangeEventListener listener) {
        this.cleanFileChangeEventSource.removeFileChangeEventListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (Actor.class.isInstance(e.getSource())) {
            this.setDirty();
            Actor actor = (Actor)e.getSource();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Got notification from actor " + actor.getTraitValue(ActorBase.BasicTrait.Name));
            }
            int[] rows = this.getActorRows(actor);
            int i = 0;
            while (i < rows.length) {
                if (rows[i] == this.getRowCount() - 1) {
                    this.addNewActor();
                }
                this.fireTableRowsUpdated(rows[i], rows[i]);
                ++i;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Done with actor " + actor.getTraitValue(ActorBase.BasicTrait.Name));
            }
        } else if (e.getPropertyName().equals("ActiveActor")) {
            int oldValue = (Integer)e.getOldValue();
            int newValue = (Integer)e.getNewValue();
            if (oldValue != -1) {
                this.fireTableRowsUpdated(oldValue, oldValue);
            }
            if (newValue != -1) {
                this.fireTableRowsUpdated(newValue, newValue);
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.mUes.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.mUes.removeUndoableEditListener(listener);
    }

    private class AddActorToListEdit
    extends AbstractUndoableEdit {
        private Actor actor;
        private int index;
        private ArrayList<Actor> list;

        public AddActorToListEdit(ArrayList<Actor> list, Actor actor, int index) {
            this.actor = actor;
            this.index = index;
            this.list = list;
        }

        @Override
        public String getPresentationName() {
            return "Add";
        }

        @Override
        public void undo() {
            super.undo();
            InitTableModel.this.undoRedoInProgress = true;
            InitTableModel.this.removeActorFromList(this.list, this.actor, this.index);
            InitTableModel.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            InitTableModel.this.undoRedoInProgress = true;
            InitTableModel.this.addActorToList(this.list, this.actor, this.index);
            InitTableModel.this.undoRedoInProgress = false;
        }
    }

    private class RemoveActorFromListEdit
    extends AbstractUndoableEdit {
        private Actor actor;
        private int index;
        private ArrayList<Actor> list;

        public RemoveActorFromListEdit(ArrayList<Actor> list, Actor actor, int index) {
            this.actor = actor;
            this.index = index;
            this.list = list;
        }

        @Override
        public String getPresentationName() {
            return "Delete";
        }

        @Override
        public void undo() {
            super.undo();
            InitTableModel.this.undoRedoInProgress = true;
            InitTableModel.this.addActorToList(this.list, this.actor, this.index);
            InitTableModel.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            InitTableModel.this.undoRedoInProgress = true;
            InitTableModel.this.removeActorFromList(this.list, this.actor, this.index);
            InitTableModel.this.undoRedoInProgress = false;
        }
    }
}

