/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.app.textfield;

import gurpsinittool.app.textfield.AbstractParsingFieldParser;
import gurpsinittool.data.DR;
import gurpsinittool.data.DamageExpression;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ParsingFieldParserFactory {
    private static final Logger LOG = Logger.getLogger(ParsingFieldParserFactory.class.getName());

    private ParsingFieldParserFactory() {
    }

    public static AbstractParsingFieldParser IntegerParser() {
        return new AbstractParsingFieldParser(){

            @Override
            public boolean parseIsValid(String text) {
                try {
                    Integer.parseInt(text);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }

            @Override
            public Object parseText(String text) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
    }

    public static AbstractParsingFieldParser FloatParser() {
        return new AbstractParsingFieldParser(){

            @Override
            public boolean parseIsValid(String text) {
                try {
                    Float.parseFloat(text);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }

            @Override
            public Object parseText(String text) {
                try {
                    return Float.valueOf(Float.parseFloat(text));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
    }

    public static AbstractParsingFieldParser DRParser() {
        return new AbstractParsingFieldParser(){

            @Override
            public boolean parseIsValid(String text) {
                try {
                    DR.parseDR(text);
                    return true;
                }
                catch (ParseException ex) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(ex.getMessage());
                    }
                    return false;
                }
            }

            @Override
            public Object parseText(String text) {
                try {
                    return DR.parseDR(text);
                }
                catch (ParseException ex) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(ex.getMessage());
                    }
                    return null;
                }
            }
        };
    }

    public static AbstractParsingFieldParser DamageExpressionParser() {
        return new AbstractParsingFieldParser(){

            @Override
            public boolean parseIsValid(String text) {
                try {
                    DamageExpression.parseDamageExpression(text);
                    return true;
                }
                catch (ParseException ex) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(ex.getMessage());
                    }
                    return false;
                }
            }

            @Override
            public Object parseText(String text) {
                try {
                    return DamageExpression.parseDamageExpression(text);
                }
                catch (ParseException ex) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(ex.getMessage());
                    }
                    return null;
                }
            }
        };
    }
}

