/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.Attack;
import gurpsinittool.data.GameSettings;
import gurpsinittool.util.EncounterLogEvent;
import gurpsinittool.util.EncounterLogListener;
import gurpsinittool.util.EncounterLogSupport;
import gurpsinittool.util.MiscUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class ActorBase
implements Serializable {
    private static final Logger LOG = Logger.getLogger(ActorBase.class.getName());
    public static GameSettings settings;
    private transient EncounterLogSupport mEls = new EncounterLogSupport(this);
    private transient PropertyChangeSupport mPcs = new PropertyChangeSupport(this);
    protected transient UndoableEditSupport mUes = new UndoableEditSupport();
    protected transient boolean undoRedoInProgress = false;
    private HashSet<ActorStatus> statuses;
    protected ActorType type;
    protected HashMap<String, Trait> traits = new HashMap();
    protected int defaultAttack = 0;
    protected ArrayList<Attack> attacks;
    protected HashMap<String, Trait> temps = new HashMap();
    protected static final Map<String, ArrayList<String>> TRAIT_ALIASES;

    static {
        ArrayList<ArrayList<String>> aliases = new ArrayList<ArrayList<String>>();
        aliases.add(new ArrayList<String>(Arrays.asList("Combat Reflexes", "CR")));
        aliases.add(new ArrayList<String>(Arrays.asList("High Pain Threshold", "HPT")));
        aliases.add(new ArrayList<String>(Arrays.asList("Hard To Kill", "HtK")));
        aliases.add(new ArrayList<String>(Arrays.asList("Hard To Subdue", "HtS")));
        aliases.add(new ArrayList<String>(Arrays.asList("Low Pain Threshold", "LPT")));
        aliases.add(new ArrayList<String>(Arrays.asList("Injury Tolerance", "IT")));
        aliases.add(new ArrayList<String>(Arrays.asList("Immunity to Metabolic Hazards", "IMH")));
        aliases.add(new ArrayList<String>(Arrays.asList("Supernatural Durability", "SD")));
        aliases.add(new ArrayList<String>(Arrays.asList("Vulnerability", "Vuln")));
        HashMap<String, ArrayList> aMap = new HashMap<String, ArrayList>();
        for (ArrayList arrayList : aliases) {
            for (String alias : arrayList) {
                if (aMap.containsKey(alias)) {
                    if (!LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.severe("static initialization of traitAliases: alias already exists! '" + alias + "'");
                    continue;
                }
                aMap.put(alias, arrayList);
            }
        }
        TRAIT_ALIASES = Collections.unmodifiableMap(aMap);
    }

    public ActorBase() {
        this("", ActorType.Enemy);
    }

    public ActorBase(String name, ActorType type) {
        this.statuses = new HashSet();
        this.type = type;
        this.attacks = new ArrayList();
        this.initializeBasicTraits(name);
    }

    public ActorBase(ActorBase anActor) {
        this(anActor.getTrait((BasicTrait)BasicTrait.Name).value, anActor.type);
        this.statuses.addAll(anActor.statuses);
        this.traits.clear();
        for (Trait value : anActor.traits.values()) {
            Trait trait = new Trait(value);
            this.traits.put(trait.name, trait);
        }
        int i = 0;
        while (i < anActor.attacks.size()) {
            this.attacks.add(anActor.attacks.get(i));
            ++i;
        }
    }

    private void initializeBasicTraits(String name) {
        String[] defaultBasicTraitValues = new String[]{name, "10", "10", "5.00", "10", "10", "5", "10", "10", "10", "10", "0", "0", "0", "8", "9", "9", "0", "2", "4", "20", ""};
        BasicTrait[] traitNames = BasicTrait.values();
        int i = 0;
        while (i < traitNames.length) {
            String traitValue = defaultBasicTraitValues[i];
            String traitName = traitNames[i].toString();
            this.internalAddTrait(traitName, traitValue);
            ++i;
        }
        this.setTemp("numParry", 0);
        this.setTemp("numBlock", 0);
        this.setTemp("shieldDamage", 0);
        this.setTemp("shock", 0);
        this.setTemp("shock.next", 0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mEls = new EncounterLogSupport(this);
        this.mPcs = new PropertyChangeSupport(this);
        this.mUes = new UndoableEditSupport(this);
        this.undoRedoInProgress = false;
    }

    public boolean hasStatus(ActorStatus status) {
        return this.statuses.contains((Object)status);
    }

    public void addStatus(ActorStatus status) {
        if (!this.statuses.contains((Object)status)) {
            HashSet<ActorStatus> oldValue = new HashSet<ActorStatus>(this.statuses);
            this.statuses.add(status);
            this.mPcs.firePropertyChange("Status", null, (Object)status);
            if (!this.undoRedoInProgress) {
                this.startCompoundEdit();
                if (ActorBase.settings.logStatusChanges.isSet()) {
                    this.logEventTypeName("added status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
                }
                this.mUes.postEdit(new StatusEdit(oldValue, new HashSet<ActorStatus>(this.statuses)));
                this.endCompoundEdit("Status");
            }
        }
    }

    public Set<ActorStatus> getAllStatuses() {
        return new HashSet<ActorStatus>(this.statuses);
    }

    public void setAllStatuses(Set<ActorStatus> newStatuses) {
        if (!this.statuses.containsAll(newStatuses) || !newStatuses.containsAll(this.statuses)) {
            HashSet<ActorStatus> oldValue = new HashSet<ActorStatus>(this.statuses);
            String oldStatuses = this.getStatusesString();
            this.statuses.clear();
            this.statuses.addAll(newStatuses);
            this.mPcs.firePropertyChange("Statuses", oldStatuses, this.getStatusesString());
            if (!this.undoRedoInProgress) {
                this.startCompoundEdit();
                if (ActorBase.settings.logStatusChanges.isSet()) {
                    this.logEventTypeName("status set to <b>[" + this.getStatusesString() + "]</b>");
                }
                this.mUes.postEdit(new StatusEdit(oldValue, new HashSet<ActorStatus>(this.statuses)));
                this.endCompoundEdit("Status");
            }
        }
    }

    public void removeStatus(ActorStatus status) {
        if (this.statuses.contains((Object)status)) {
            HashSet<ActorStatus> oldValue = new HashSet<ActorStatus>(this.statuses);
            this.statuses.remove((Object)status);
            this.mPcs.firePropertyChange("Status", (Object)status, null);
            if (!this.undoRedoInProgress) {
                this.startCompoundEdit();
                if (ActorBase.settings.logStatusChanges.isSet()) {
                    this.logEventTypeName("removed status <b>" + (Object)((Object)status) + "</b>, now has [" + this.getStatusesString() + "]");
                }
                this.mUes.postEdit(new StatusEdit(oldValue, new HashSet<ActorStatus>(this.statuses)));
                this.endCompoundEdit("Status");
            }
        }
    }

    protected void clearStatuses() {
        this.setAllStatuses(new HashSet<ActorStatus>());
    }

    public String getStatusesString() {
        int[] scodes = new int[this.statuses.size()];
        int index = 0;
        for (ActorStatus as : this.statuses) {
            scodes[index++] = as.ordinal();
        }
        Arrays.sort(scodes);
        String text = "";
        int j = 0;
        while (j < scodes.length) {
            if (j != 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ActorStatus.values()[scodes[j]].toString();
            ++j;
        }
        return text;
    }

    public void setPosture(ActorStatus posture) {
        if (posture == ActorStatus.Kneeling) {
            this.removeStatus(ActorStatus.Prone);
            this.addStatus(posture);
        } else if (posture == ActorStatus.Prone) {
            this.removeStatus(ActorStatus.Kneeling);
            this.addStatus(posture);
        } else if (posture == null) {
            this.removeStatus(ActorStatus.Kneeling);
            this.removeStatus(ActorStatus.Prone);
        }
    }

    public ActorType getType() {
        return this.type;
    }

    public void setType(ActorType type) {
        if (this.type != type) {
            ActorType oldType = this.type;
            this.type = type;
            if (!this.undoRedoInProgress) {
                this.startCompoundEdit();
                this.logEvent("<b>" + this.getTraitValue(BasicTrait.Name) + "</b> type changed to <b>" + (Object)((Object)type) + "</b>");
                this.mUes.postEdit(new TypeEdit(oldType, type));
                this.endCompoundEdit("Type");
            }
            this.mPcs.firePropertyChange("Type", (Object)oldType, (Object)type);
        }
    }

    public boolean isTypeAutomated() {
        switch (this.type) {
            case Ally: {
                return ActorBase.settings.automateAlly.isSet();
            }
            case Enemy: {
                return ActorBase.settings.automateEnemy.isSet();
            }
            case Neutral: {
                return ActorBase.settings.automateNeutral.isSet();
            }
            case PC: {
                return ActorBase.settings.automatePC.isSet();
            }
            case Special: {
                return ActorBase.settings.automateSpecial.isSet();
            }
        }
        return false;
    }

    public int getDefaultAttack() {
        return this.defaultAttack;
    }

    public void setDefaultAttack(int index) {
        if (this.defaultAttack != index && index < this.attacks.size() && index >= 0) {
            int oldDefault = this.defaultAttack;
            this.defaultAttack = index;
            this.mPcs.firePropertyChange("DefaultAttack", oldDefault, this.defaultAttack);
            if (!this.undoRedoInProgress) {
                this.mUes.postEdit(new DefaultAttackEdit(oldDefault, index));
            }
        } else if (this.defaultAttack != index && LOG.isLoggable(Level.INFO)) {
            LOG.info("Actor '" + this.getTraitValue(BasicTrait.Name) + "': Attempted to set invalid attack id # " + index);
        }
    }

    public int getNumAttacks() {
        return this.attacks.size();
    }

    public Attack getAttack(int index) {
        return new Attack(this.attacks.get(index));
    }

    public void setAttack(Attack attack, int index) {
        if (index < this.attacks.size()) {
            Attack oldAttack = this.attacks.get(index);
            this.attacks.set(index, attack);
            this.mPcs.firePropertyChange("Attacks", index, index);
            if (!this.undoRedoInProgress) {
                this.mUes.postEdit(new AttackEdit(oldAttack, attack, index));
            }
        }
    }

    public void addAttack(Attack attack) {
        this.attacks.add(attack);
        this.mPcs.firePropertyChange("Attacks", this.attacks.size() - 1, this.attacks.size());
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new AttackEdit(null, attack, this.attacks.size() - 1));
        }
    }

    public void removeAttack(int index) {
        if (index < this.attacks.size()) {
            this.startCompoundEdit();
            if (index < this.defaultAttack) {
                this.setDefaultAttack(this.defaultAttack - 1);
            } else if (index == this.defaultAttack) {
                this.setDefaultAttack(0);
            }
            Attack attack = this.attacks.get(index);
            this.attacks.remove(index);
            this.mPcs.firePropertyChange("Attacks", this.attacks.size() + 1, this.attacks.size());
            if (!this.undoRedoInProgress) {
                this.mUes.postEdit(new AttackEdit(attack, null, index));
            }
            this.endCompoundEdit("Edit");
        }
    }

    public boolean hasTrait(String name) {
        if (!this.traits.containsKey(name)) {
            if (ActorBase.isCalculatedTrait(name)) {
                return true;
            }
            if (TRAIT_ALIASES.containsKey(name)) {
                for (String alias : TRAIT_ALIASES.get(name)) {
                    if (!this.traits.containsKey(alias)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isBasicTrait(String name) {
        try {
            BasicTrait.valueOf(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCalculatedTrait(String name) {
        try {
            CalculatedTrait.valueOf(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCustomTrait(String name) {
        return !ActorBase.isCalculatedTrait(name) && !ActorBase.isBasicTrait(name);
    }

    protected String calculateTrait(CalculatedTrait calcTrait) {
        return "0";
    }

    private Trait getTrait(String name) {
        if (!this.traits.containsKey(name)) {
            if (ActorBase.isCalculatedTrait(name)) {
                return this.getTrait(CalculatedTrait.valueOf(name));
            }
            if (TRAIT_ALIASES.containsKey(name)) {
                for (String alias : TRAIT_ALIASES.get(name)) {
                    if (!this.traits.containsKey(alias)) continue;
                    return this.traits.get(alias);
                }
            }
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Trait does not exist: '" + name + "'");
            }
            return null;
        }
        return this.traits.get(name);
    }

    private Trait getTrait(BasicTrait trait) {
        return this.traits.get(trait.toString());
    }

    private Trait getTrait(CalculatedTrait trait) {
        return new Trait(trait.name(), this.calculateTrait(trait));
    }

    public String getTraitValue(String name) {
        return this.getTrait((String)name).value;
    }

    public String getTraitValue(BasicTrait trait) {
        return this.getTrait((BasicTrait)trait).value;
    }

    public int getTraitValueInt(String trait) {
        return MiscUtil.parseIntSafe(this.getTrait((String)trait).value);
    }

    public int getTraitValueInt(BasicTrait trait) {
        return MiscUtil.parseIntSafe(this.getTrait((BasicTrait)trait).value);
    }

    public ArrayList<String> getTraitValueArray(String name) {
        if (this.hasTrait(name)) {
            return new ArrayList<String>(Arrays.asList(this.getTrait((String)name).value.toLowerCase().split("\\s*;\\s*")));
        }
        return new ArrayList<String>();
    }

    public Collection<String> getAllTraitNames() {
        return this.traits.keySet();
    }

    public void setTrait(String name, String value) {
        if (!this.hasTrait(name)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Trait does not exist: " + name);
            }
            return;
        }
        if (ActorBase.isCalculatedTrait(name)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot set calculated trait: " + name);
            }
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Setting trait: '" + name + "' to '" + value + "'");
        }
        Trait trait = this.getTrait(name);
        if (!trait.value.equals(value)) {
            this.internalSetTrait(trait, value);
        }
    }

    protected void internalSetTrait(Trait trait, String value) {
        String oldValue = trait.value;
        trait.value = value;
        this.mPcs.firePropertyChange("trait." + trait.name, oldValue, value);
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new TraitEdit(trait.name, oldValue, value));
        }
    }

    public void setTrait(BasicTrait trait, String value) {
        this.setTrait(trait.toString(), value);
    }

    public void setTrait(BasicTrait trait, int value) {
        this.setTrait(trait, String.valueOf(value));
    }

    public void setTrait(String name, int value) {
        this.setTrait(name, String.valueOf(value));
    }

    public boolean addTrait(String name, String value) {
        if (this.hasTrait(name)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Trait already exists! " + name);
            }
            return false;
        }
        this.internalAddTrait(name, value);
        this.mPcs.firePropertyChange("trait." + name, null, value);
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new TraitEdit(name, null, value));
        }
        return true;
    }

    private void internalAddTrait(String name, String value) {
        Trait newTrait = new Trait(name, value);
        this.traits.put(name, newTrait);
    }

    public boolean removeTrait(String name) {
        if (ActorBase.isBasicTrait(name)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot remove basic traits! => " + name);
            }
            return false;
        }
        if (ActorBase.isCalculatedTrait(name)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot remove calculated traits! => " + name);
            }
            return false;
        }
        if (!this.hasTrait(name)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot remove non-existant trait! => " + name);
            }
            return false;
        }
        Trait trait = this.getTrait(name);
        this.traits.remove(trait.name);
        this.mPcs.firePropertyChange("trait." + trait.name, trait.value, null);
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new TraitEdit(trait.name, trait.value, null));
        }
        return true;
    }

    public boolean renameTrait(String oldName, String newName) {
        if (ActorBase.isBasicTrait(oldName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot rename BasicTrait! oldName: " + oldName + ", newName: " + newName);
            }
            return false;
        }
        if (ActorBase.isCalculatedTrait(oldName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot rename CalculatedTrait! oldName: " + oldName + ", newName: " + newName);
            }
            return false;
        }
        if (this.traits.containsKey(newName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("New trait name already exists! oldName: " + oldName + ", newName: " + newName);
            }
            return false;
        }
        if (!this.traits.containsKey(oldName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Old name does not exist! oldName: " + oldName + ", newName: " + newName);
            }
            return false;
        }
        if (this.hasTrait(newName) && this.getTrait(newName) != this.getTrait(oldName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Trait alias exists for new name! oldName: " + oldName + ", newName: " + newName);
            }
            return false;
        }
        Trait trait = this.getTrait(oldName);
        trait.name = newName;
        this.traits.remove(oldName);
        this.traits.put(newName, trait);
        this.mPcs.firePropertyChange("traitName", oldName, newName);
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new TraitRenameEdit(oldName, newName));
        }
        return true;
    }

    public boolean hasTemp(String name) {
        return this.temps.containsKey(name);
    }

    private Trait getTemp(String name) {
        return this.temps.get(name);
    }

    public String getTempValue(String name) {
        return this.temps.get((Object)name).value;
    }

    public int getTempInt(String name) {
        return Integer.parseInt(this.getTemp((String)name).value);
    }

    public void setTemp(String name, String value) {
        if (this.hasTemp(name)) {
            Trait temp = this.getTemp(name);
            if (!temp.value.equals(value)) {
                String oldValue = temp.value;
                temp.value = value;
                if (!this.undoRedoInProgress) {
                    this.mUes.postEdit(new TempEdit(name, oldValue, value));
                }
            }
        } else {
            Trait newTrait = new Trait(name, value);
            this.temps.put(name, newTrait);
            if (!this.undoRedoInProgress) {
                this.mUes.postEdit(new TempEdit(name, "0", value));
            }
        }
    }

    public void setTemp(String name, int value) {
        this.setTemp(name, String.valueOf(value));
    }

    public Collection<String> getAllTempNames() {
        return this.temps.keySet();
    }

    public void addEncounterLogEventListener(EncounterLogListener listener) {
        this.mEls.addEncounterLogEventListener(listener);
    }

    public void removeEncounterLogEventListener(EncounterLogListener listener) {
        this.mEls.removeEncounterLogEventListener(listener);
    }

    protected void logEvent(String text) {
        this.mEls.fireEncounterLogEvent(new EncounterLogEvent(this, text));
    }

    protected void logEventTypeName(String text) {
        String prepend = "";
        String color = "";
        switch (this.type) {
            case Enemy: {
                color = "red";
                break;
            }
            case Ally: {
                color = "blue";
                break;
            }
            case Neutral: {
                color = "grey";
                break;
            }
            case PC: {
                color = "green";
                break;
            }
            case Special: {
                color = "purple";
            }
        }
        prepend = String.valueOf(prepend) + "[<b><font color=" + color + ">" + this.type.toString() + "</font></b>] ";
        prepend = String.valueOf(prepend) + "<b>" + this.getTraitValue(BasicTrait.Name) + "</b> ";
        this.logEvent(String.valueOf(prepend) + text);
    }

    protected void logEventError(String text) {
        this.logEventTypeName("<i><b><font color=red>-E-: " + text + "</font></b></i>");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPcs.removePropertyChangeListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.mUes.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.mUes.removeUndoableEditListener(listener);
    }

    protected void startCompoundEdit() {
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new HackStartCompound());
        }
    }

    protected void endCompoundEdit(String name) {
        if (!this.undoRedoInProgress) {
            this.mUes.postEdit(new HackEndCompound(name));
        }
    }

    public static enum ActorStatus {
        Attacking,
        Disarmed,
        StunPhys,
        StunMental,
        StunRecovr,
        Kneeling,
        Prone,
        Waiting,
        Disabled,
        Unconscious,
        Dead;

    }

    public static enum ActorType {
        PC,
        Enemy,
        Ally,
        Neutral,
        Special;

    }

    private class AttackEdit
    extends AbstractUndoableEdit {
        private Attack oldAttack;
        private Attack newAttack;
        private int position;

        public AttackEdit(Attack oldAttack, Attack newAttack, int position) {
            this.oldAttack = oldAttack;
            this.newAttack = newAttack;
            this.position = position;
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            if (this.oldAttack == null) {
                ActorBase.this.attacks.remove(this.position);
                ActorBase.this.mPcs.firePropertyChange("Attacks", ActorBase.this.attacks.size() + 1, ActorBase.this.attacks.size());
            } else if (this.newAttack == null) {
                ActorBase.this.attacks.add(this.position, this.oldAttack);
                ActorBase.this.mPcs.firePropertyChange("Attacks", ActorBase.this.attacks.size() - 1, ActorBase.this.attacks.size());
            } else {
                ActorBase.this.attacks.set(this.position, this.oldAttack);
                ActorBase.this.mPcs.firePropertyChange("Attacks", (Object)this.position, null);
            }
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            if (this.oldAttack == null) {
                ActorBase.this.attacks.add(this.position, this.newAttack);
                ActorBase.this.mPcs.firePropertyChange("Attacks", ActorBase.this.attacks.size() - 1, ActorBase.this.attacks.size());
            } else if (this.newAttack == null) {
                ActorBase.this.attacks.remove(this.position);
                ActorBase.this.mPcs.firePropertyChange("Attacks", ActorBase.this.attacks.size() + 1, ActorBase.this.attacks.size());
            } else {
                ActorBase.this.attacks.set(this.position, this.newAttack);
                ActorBase.this.mPcs.firePropertyChange("Attacks", (Object)this.position, null);
            }
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    public static enum BasicTrait {
        Name,
        ST,
        HP,
        Speed,
        DX,
        Will,
        Move,
        IQ,
        Per,
        HT,
        FP,
        SM,
        Fatigue,
        Injury,
        Dodge,
        Parry,
        Block,
        DR,
        Shield_DB,
        Shield_DR,
        Shield_HP,
        Notes;

    }

    public static enum CalculatedTrait {
        CurrHP,
        CurrFP,
        BasicThrust,
        BasicSwing,
        BasicLift;

    }

    private class DefaultAttackEdit
    extends AbstractUndoableEdit {
        private int oldValue;
        private int newValue;

        public DefaultAttackEdit(int oldValue, int newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setDefaultAttack(this.oldValue);
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setDefaultAttack(this.newValue);
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    public class HackEndCompound
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        String display;

        public HackEndCompound(String display) {
            this.display = display;
        }

        @Override
        public String getPresentationName() {
            return this.display;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    public class HackStartCompound
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    private class StatusEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private HashSet<ActorStatus> oldValue;
        private HashSet<ActorStatus> newValue;

        public StatusEdit(HashSet<ActorStatus> oldValue, HashSet<ActorStatus> newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Status";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setAllStatuses(this.oldValue);
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setAllStatuses(this.newValue);
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    private class TempEdit
    extends AbstractUndoableEdit {
        private String tempName;
        private String oldValue;
        private String newValue;

        public TempEdit(String tempName, String oldValue, String newValue) {
            this.tempName = tempName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "TEMP";
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setTemp(this.tempName, this.oldValue);
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setTemp(this.tempName, this.newValue);
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    protected class Trait
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public String value;

        public Trait(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Trait(Trait aTrait) {
            this.name = aTrait.name;
            this.value = aTrait.value;
        }
    }

    private class TraitEdit
    extends AbstractUndoableEdit {
        private final String traitName;
        private final String oldValue;
        private final String newValue;

        public TraitEdit(String traitName, String oldValue, String newValue) {
            this.traitName = traitName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            if (this.oldValue == null) {
                ActorBase.this.removeTrait(this.traitName);
            } else if (this.newValue == null) {
                ActorBase.this.addTrait(this.traitName, this.oldValue);
            } else {
                ActorBase.this.setTrait(this.traitName, this.oldValue);
            }
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            if (this.oldValue == null) {
                ActorBase.this.addTrait(this.traitName, this.newValue);
            } else if (this.newValue == null) {
                ActorBase.this.removeTrait(this.traitName);
            } else {
                ActorBase.this.setTrait(this.traitName, this.newValue);
            }
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    private class TraitRenameEdit
    extends AbstractUndoableEdit {
        private String traitOldName;
        private String traitNewName;

        public TraitRenameEdit(String traitOldName, String traitNewName) {
            this.traitOldName = traitOldName;
            this.traitNewName = traitNewName;
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.renameTrait(this.traitNewName, this.traitOldName);
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.renameTrait(this.traitOldName, this.traitNewName);
            ActorBase.this.undoRedoInProgress = false;
        }
    }

    private class TypeEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private ActorType oldValue;
        private ActorType newValue;

        public TypeEdit(ActorType oldValue, ActorType newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getPresentationName() {
            return "Type";
        }

        @Override
        public void undo() {
            super.undo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setType(this.oldValue);
            ActorBase.this.undoRedoInProgress = false;
        }

        @Override
        public void redo() {
            super.redo();
            ActorBase.this.undoRedoInProgress = true;
            ActorBase.this.setType(this.newValue);
            ActorBase.this.undoRedoInProgress = false;
        }
    }
}

