/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.app.GroupTree;
import gurpsinittool.app.GroupTreeNode;
import gurpsinittool.data.Actor;
import gurpsinittool.data.ActorBase;
import gurpsinittool.data.Attack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ActorGroupFile {
    private static final Logger LOG = Logger.getLogger(ActorGroupFile.class.getName());
    public static int currentSchemaVer = 5;

    public static void openActorGroupTree(GroupTree groupTree, File openFile) {
        BufferedReader input;
        FileReader file;
        try {
            file = new FileReader(openFile);
            input = new BufferedReader(file);
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Error: " + e.getMessage(), e);
            }
            return;
        }
        GroupTree.GroupTreeModel treeModel = groupTree.setNewModel();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Reading input file: " + openFile.getPath());
        }
        try {
            Pattern startFile = Pattern.compile("^<GURPSActorGroupList schemaVer=\"(\\d+)\">$");
            String line = input.readLine();
            Matcher matcher = startFile.matcher(line);
            if (!matcher.matches()) {
                input.close();
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("First line does not specify start of ActorGroupList!");
                }
                return;
            }
            int schemaVer = Integer.parseInt(matcher.group(1));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found start of Group List, schema version: " + schemaVer);
            }
            switch (schemaVer) {
                case 0: {
                    ActorGroupFile.readSchema0(input, treeModel);
                    break;
                }
                case 1: {
                    ActorGroupFile.readSchema1(input, treeModel);
                    break;
                }
                case 2: {
                    ActorGroupFile.readSchema2(input, treeModel);
                    break;
                }
                case 3: {
                    ActorGroupFile.readSchema3(input, treeModel);
                    break;
                }
                case 4: {
                    ActorGroupFile.readSchema4(input, treeModel);
                    break;
                }
                case 5: {
                    ActorGroupFile.readSchema5(input, treeModel);
                    break;
                }
                default: {
                    if (!LOG.isLoggable(Level.WARNING)) break;
                    LOG.warning("Unknown schema version: " + schemaVer + "!");
                }
            }
            input.close();
            file.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        treeModel.nodeStructureChanged((TreeNode)treeModel.getRoot());
    }

    public static void saveActorGroupTree(GroupTree groupTree, File saveFile) {
        block6: {
            StringBuffer buffer = new StringBuffer();
            GroupTreeNode rootNode = (GroupTreeNode)groupTree.getModel().getRoot();
            ArrayList<GroupTreeNode> currentNodes = new ArrayList<GroupTreeNode>(Arrays.asList(rootNode));
            ArrayList<Integer> currentPositions = new ArrayList<Integer>(Arrays.asList(0));
            buffer.append("<GURPSActorGroupList schemaVer=\"" + currentSchemaVer + "\">\n");
            buffer.append("<GroupFolder name=\"" + rootNode.toString() + "\">\n");
            while (currentNodes.size() > 0) {
                if (currentPositions.get(0) >= currentNodes.get(0).getChildCount()) {
                    currentNodes.remove(0);
                    currentPositions.remove(0);
                    buffer.append("</GroupFolder>\n");
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.finer("End of folder");
                    continue;
                }
                GroupTreeNode node = (GroupTreeNode)currentNodes.get(0).getChildAt(currentPositions.get(0));
                currentPositions.set(0, currentPositions.get(0) + 1);
                if (!node.isGroup()) {
                    buffer.append("<GroupFolder name=\"" + node.toString() + "\">\n");
                    currentNodes.add(0, node);
                    currentPositions.add(0, 0);
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.finer("Start of folder: " + node.toString());
                    continue;
                }
                buffer.append("<ActorGroup name=\"" + node.toString() + "\">\n");
                ArrayList<Actor> actorList = node.getActorList();
                int i = 0;
                while (i < actorList.size() - 1) {
                    buffer.append(ActorGroupFile.serializeActor(actorList.get(i)));
                    ++i;
                }
                buffer.append("</ActorGroup>\n");
            }
            buffer.append("</GURPSActorGroupList>");
            String filename = saveFile.getPath();
            try {
                FileWriter fstream = new FileWriter(filename);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(buffer.toString());
                out.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block6;
                LOG.log(Level.SEVERE, "Error: " + e.getMessage(), e);
            }
        }
    }

    public static String serializeActor(Actor actor) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<Actor name=\"" + actor.getTraitValue(ActorBase.BasicTrait.Name) + "\"" + " default_attack=\"" + actor.getDefaultAttack() + "\"" + " state=\"[" + actor.getStatusesString() + "]\"" + " type=\"" + actor.getType().toString() + "\"" + ">\n");
        for (String traitName : actor.getAllTraitNames()) {
            stringWriter.append(ActorGroupFile.serializeTrait(traitName, actor.getTraitValue(traitName)));
        }
        int i = 0;
        while (i < actor.getNumAttacks()) {
            stringWriter.append(ActorGroupFile.serializeAttack(actor.getAttack(i)));
            ++i;
        }
        stringWriter.append("</Actor>\n");
        return stringWriter.toString();
    }

    public static String serializeTrait(String traitName, String value) {
        return "<" + traitName + ">" + value + "</" + traitName + ">\n";
    }

    public static String serializeAttack(Attack attack) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<Attack name=\"" + attack.name + "\" skill=\"" + attack.skill + "\" damage=\"" + attack.damage + "\" unbalanced=\"" + attack.unbalanced + "\" />\n");
        return stringWriter.toString();
    }

    public static HashSet<ActorBase.ActorStatus> parseOldState(String state) {
        HashSet<ActorBase.ActorStatus> status = new HashSet<ActorBase.ActorStatus>();
        if (!state.equals("Active")) {
            status.add(ActorBase.ActorStatus.valueOf(state));
        }
        return status;
    }

    public static HashSet<ActorBase.ActorStatus> parseState(String stateString) {
        HashSet<ActorBase.ActorStatus> status = new HashSet<ActorBase.ActorStatus>();
        Pattern states = Pattern.compile("^\\[(.*)\\]$");
        Matcher matcher = states.matcher(stateString);
        if (!matcher.matches()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("stateString does not conform to pattern! " + stateString);
            }
        } else {
            String[] stringArray = matcher.group(1).split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.length() > 0) {
                    status.add(ActorBase.ActorStatus.valueOf(part));
                }
                ++n2;
            }
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema5(BufferedReader input, DefaultTreeModel treeModel) {
        block26: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                trait = Pattern.compile("^<([^\"]+)>(.*)</([^\"]+)>$");
                startTrait = Pattern.compile("^<([^\"]+)>(.*)$");
                endTrait = Pattern.compile("^(.*)</([^\"]+)>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl114
                if (ActorGroupFile.LOG.isLoggable(Level.WARNING)) {
                    ActorGroupFile.LOG.warning("Second line does not specify start of base folder!");
                }
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found start of folder. Name: " + name);
                        }
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found start of group. Name: " + name);
                        }
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = new Actor();
                        currentActor.setType(ActorBase.ActorType.valueOf(matcher.group(4)));
                        currentActor.setTrait(ActorBase.BasicTrait.Name, matcher.group(1));
                        currentActor.setAllStatuses(ActorGroupFile.parseState(matcher.group(3)));
                        defaultAttack = Integer.parseInt(matcher.group(2));
                        aName = currentActor.getTraitValue(ActorBase.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) break;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found attack for actor. Name: " + aName);
                                continue;
                            }
                            matcher = trait.matcher(line);
                            if (matcher.matches()) {
                                if (matcher.group(1).equals(matcher.group(3))) {
                                    if (!currentActor.hasTrait(matcher.group(1))) {
                                        currentActor.addTrait(matcher.group(1), matcher.group(2));
                                    } else {
                                        currentActor.setTrait(matcher.group(1), matcher.group(2));
                                    }
                                    if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                    ActorGroupFile.LOG.finer("Found trait for actor. Actor: " + aName + ", Trait: " + matcher.group(1) + ", Value: " + matcher.group(2));
                                    continue;
                                }
                                if (!ActorGroupFile.LOG.isLoggable(Level.WARNING)) continue;
                                ActorGroupFile.LOG.warning("Start/end tags do not match! " + line);
                                continue;
                            }
                            matcher = startTrait.matcher(line);
                            if (matcher.matches()) {
                                traitName = matcher.group(1);
                                traitValue = new StringBuilder(String.valueOf(matcher.group(2)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endTrait.matcher(line);
                                    if (matcher.matches()) {
                                        traitValue.append(matcher.group(1));
                                        if (!traitName.equals(matcher.group(2)) && ActorGroupFile.LOG.isLoggable(Level.INFO)) {
                                            ActorGroupFile.LOG.info("Multiline start/end tags do not match! Start: " + traitName + ", End: " + matcher.group(2));
                                        }
                                        if (!currentActor.hasTrait(traitName)) {
                                            currentActor.addTrait(traitName, traitValue.toString());
                                        } else {
                                            currentActor.setTrait(traitName, traitValue.toString());
                                        }
                                        if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue block3;
                                        ActorGroupFile.LOG.finer("Found multiline trait for actor. Actor: " + aName + ", Trait: " + traitName + ", Value: " + traitValue);
                                        continue block3;
                                    }
                                    traitValue.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                            ActorGroupFile.LOG.info("Cannot parse line inside Actor: " + line);
                        }
                        currentActor.setDefaultAttack(defaultAttack);
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) {
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found end of Group List");
                        }
                        break block26;
                    }
                    if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                    ActorGroupFile.LOG.info("Cannot parse line: " + line);
lbl114:
                    // 8 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl115:
                // 1 sources

            }
            catch (IOException ex) {
                if (ActorGroupFile.LOG.isLoggable(Level.SEVERE)) {
                    ActorGroupFile.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema4(BufferedReader input, DefaultTreeModel treeModel) {
        block17: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" parry=\"([^\"]+)\" block=\"([^\"]+)\" dodge=\"([^\"]+)\" dr=\"([^\"]+)\" db=\"([^\"]+)\" shield_dr=\"([^\"]+)\" shield_hp=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl90
                if (ActorGroupFile.LOG.isLoggable(Level.WARNING)) {
                    ActorGroupFile.LOG.warning("Second line does not specify start of base folder!");
                }
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseState(matcher.group(16)), ActorBase.ActorType.valueOf(matcher.group(17)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10)), Integer.parseInt(matcher.group(11)), Integer.parseInt(matcher.group(12)), Integer.parseInt(matcher.group(13)), Integer.parseInt(matcher.group(14)), Integer.parseInt(matcher.group(15)));
                        aName = currentActor.getTraitValue(ActorBase.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found attack for actor. Name: " + aName);
                                continue;
                            }
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(ActorBase.BasicTrait.Notes, matcher.group(1));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(ActorBase.BasicTrait.Notes, actorNotes.toString());
                                        if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue block3;
                                        ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                            ActorGroupFile.LOG.info("Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) {
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found end of Group List");
                        }
                        break block17;
                    }
                    if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                    ActorGroupFile.LOG.info("Cannot parse line: " + line);
lbl90:
                    // 9 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl91:
                // 1 sources

            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema3(BufferedReader input, DefaultTreeModel treeModel) {
        block18: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" parry=\"([^\"]+)\" block=\"([^\"]+)\" dodge=\"([^\"]+)\" dr=\"([^\"]+)\" db=\"([^\"]+)\" shield_dr=\"([^\"]+)\" shield_hp=\"([^\"]+)\" default_attack=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                attack = Pattern.compile("^<Attack name=\"([^\"]+)\" skill=\"([^\"]+)\" damage=\"([^\"]+)\" unbalanced=\"([^\"]+)\" />$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl90
                if (ActorGroupFile.LOG.isLoggable(Level.WARNING)) {
                    ActorGroupFile.LOG.warning("Second line does not specify start of base folder!");
                }
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(16)), ActorBase.ActorType.valueOf(matcher.group(17)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10)), Integer.parseInt(matcher.group(11)), Integer.parseInt(matcher.group(12)), Integer.parseInt(matcher.group(13)), Integer.parseInt(matcher.group(14)), Integer.parseInt(matcher.group(15)));
                        aName = currentActor.getTraitValue(ActorBase.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = attack.matcher(line);
                            if (matcher.matches()) {
                                currentActor.addAttack(new Attack(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), Boolean.parseBoolean(matcher.group(4))));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found attack for actor. Name: " + aName);
                                continue;
                            }
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(ActorBase.BasicTrait.Notes, matcher.group(1));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(ActorBase.BasicTrait.Notes, actorNotes.toString());
                                        if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue block3;
                                        ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                            ActorGroupFile.LOG.info("Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) {
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found end of Group List");
                        }
                        break block18;
                    }
                    if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                    ActorGroupFile.LOG.info("Cannot parse line: " + line);
lbl90:
                    // 9 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl91:
                // 1 sources

            }
            catch (IOException ex) {
                if (ActorGroupFile.LOG.isLoggable(Level.SEVERE)) {
                    ActorGroupFile.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema2(BufferedReader input, DefaultTreeModel treeModel) {
        block17: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" ht=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" fp=\"([^\"]+)\" fatigue=\"([^\"]+)\" move=\"([^\"]+)\" dodge=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl83
                if (ActorGroupFile.LOG.isLoggable(Level.WARNING)) {
                    ActorGroupFile.LOG.warning("Second line does not specify start of base folder!");
                }
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(9)), ActorBase.ActorType.valueOf(matcher.group(10)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), 9, 9, Integer.parseInt(matcher.group(8)), 0, 0, 4, 20, 0);
                        aName = currentActor.getTraitValue(ActorBase.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(ActorBase.BasicTrait.Notes, matcher.group(1));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(ActorBase.BasicTrait.Notes, actorNotes.toString());
                                        if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue block3;
                                        ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                            ActorGroupFile.LOG.info("Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) {
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found end of Group List");
                        }
                        break block17;
                    }
                    if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                    ActorGroupFile.LOG.info("Cannot parse line: " + line);
lbl83:
                    // 9 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl84:
                // 1 sources

            }
            catch (IOException ex) {
                if (ActorGroupFile.LOG.isLoggable(Level.SEVERE)) {
                    ActorGroupFile.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void readSchema1(BufferedReader input, DefaultTreeModel treeModel) {
        block17: {
            currentNode = (GroupTreeNode)treeModel.getRoot();
            try {
                endFile = Pattern.compile("^</GURPSActorGroupList>$");
                startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
                endFolder = Pattern.compile("^</GroupFolder>$");
                startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
                endGroup = Pattern.compile("^</ActorGroup>$");
                startActor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\">$");
                endActor = Pattern.compile("^</Actor>$");
                notes = Pattern.compile("^<notes>(.*)</notes>$");
                startNotes = Pattern.compile("^<notes>(.*)$");
                endNotes = Pattern.compile("^(.*)</notes>$");
                line = input.readLine();
                matcher = startFolder.matcher(line);
                if (matcher.matches()) ** GOTO lbl83
                if (ActorGroupFile.LOG.isLoggable(Level.WARNING)) {
                    ActorGroupFile.LOG.warning("Second line does not specify start of base folder!");
                }
                return;
lbl-1000:
                // 1 sources

                {
                    matcher = startFolder.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, false);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startGroup.matcher(line);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        newNode = new GroupTreeNode(name, true);
                        currentNode.add(newNode);
                        currentNode = newNode;
                        continue;
                    }
                    matcher = startActor.matcher(line);
                    if (matcher.matches()) {
                        currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(5)), ActorBase.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 9, 9, 8, 0, 0, 4, 20, 0);
                        aName = currentActor.getTraitValue(ActorBase.BasicTrait.Name);
                        actorList = currentNode.getActorList();
                        actorList.add(actorList.size() - 1, currentActor);
                        block3: while ((line = input.readLine()) != null) {
                            matcher = endActor.matcher(line);
                            if (matcher.matches()) continue block2;
                            matcher = notes.matcher(line);
                            if (matcher.matches()) {
                                currentActor.setTrait(ActorBase.BasicTrait.Notes, matcher.group(1));
                                if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue;
                                ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                continue;
                            }
                            matcher = startNotes.matcher(line);
                            if (matcher.matches()) {
                                actorNotes = new StringBuilder(String.valueOf(matcher.group(1)) + "\n");
                                while ((line = input.readLine()) != null) {
                                    matcher = endNotes.matcher(line);
                                    if (matcher.matches()) {
                                        actorNotes.append(matcher.group(1));
                                        currentActor.setTrait(ActorBase.BasicTrait.Notes, actorNotes.toString());
                                        if (!ActorGroupFile.LOG.isLoggable(Level.FINER)) continue block3;
                                        ActorGroupFile.LOG.finer("Found notes for actor. Name: " + aName + ", Notes: " + currentActor.getTraitValue(ActorBase.BasicTrait.Notes));
                                        continue block3;
                                    }
                                    actorNotes.append(String.valueOf(line) + "\n");
                                }
                                continue;
                            }
                            if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                            ActorGroupFile.LOG.info("Cannot parse line inside Actor: " + line);
                        }
                        continue;
                    }
                    matcher = endFolder.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endGroup.matcher(line);
                    if (matcher.matches()) {
                        currentNode = (GroupTreeNode)currentNode.getParent();
                        continue;
                    }
                    matcher = endFile.matcher(line);
                    if (matcher.matches()) {
                        if (ActorGroupFile.LOG.isLoggable(Level.FINER)) {
                            ActorGroupFile.LOG.finer("Found end of Group List");
                        }
                        break block17;
                    }
                    if (!ActorGroupFile.LOG.isLoggable(Level.INFO)) continue;
                    ActorGroupFile.LOG.info("Cannot parse line: " + line);
lbl83:
                    // 9 sources

                    ** while ((line = input.readLine()) != null)
                }
lbl84:
                // 1 sources

            }
            catch (IOException ex) {
                if (ActorGroupFile.LOG.isLoggable(Level.SEVERE)) {
                    ActorGroupFile.LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readSchema0(BufferedReader input, DefaultTreeModel treeModel) {
        GroupTreeNode currentNode = (GroupTreeNode)treeModel.getRoot();
        try {
            Pattern endFile = Pattern.compile("^</GURPSActorGroupList>$");
            Pattern startFolder = Pattern.compile("^<GroupFolder name=\"([^\"]+)\">$");
            Pattern endFolder = Pattern.compile("^</GroupFolder>$");
            Pattern startGroup = Pattern.compile("^<ActorGroup name=\"([^\"]+)\">$");
            Pattern endGroup = Pattern.compile("^</ActorGroup>$");
            Pattern actor = Pattern.compile("^<Actor name=\"([^\"]+)\" hp=\"([^\"]+)\" damage=\"([^\"]+)\" health=\"([^\"]+)\" state=\"([^\"]+)\" type=\"([^\"]+)\"></Actor>$");
            String line = input.readLine();
            Matcher matcher = startFolder.matcher(line);
            if (!matcher.matches()) {
                if (!LOG.isLoggable(Level.WARNING)) return;
                LOG.warning("Second line does not specify start of base folder!");
                return;
            }
            while (true) {
                GroupTreeNode newNode;
                String name;
                if ((line = input.readLine()) == null) {
                    return;
                }
                matcher = startFolder.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, false);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = startGroup.matcher(line);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    newNode = new GroupTreeNode(name, true);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                matcher = actor.matcher(line);
                if (matcher.matches()) {
                    Actor currentActor = ActorGroupFile.createLegacyActor(matcher.group(1), ActorGroupFile.parseOldState(matcher.group(5)), ActorBase.ActorType.valueOf(matcher.group(6)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 10, 0, 5, 9, 9, 8, 0, 0, 4, 20, 0);
                    ArrayList<Actor> actorList = currentNode.getActorList();
                    actorList.add(actorList.size() - 1, currentActor);
                    continue;
                }
                matcher = endFolder.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endGroup.matcher(line);
                if (matcher.matches()) {
                    currentNode = (GroupTreeNode)currentNode.getParent();
                    continue;
                }
                matcher = endFile.matcher(line);
                if (matcher.matches()) {
                    if (!LOG.isLoggable(Level.FINER)) return;
                    LOG.finer("Found end of Group List");
                    return;
                }
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("Cannot parse line: " + line);
            }
        }
        catch (IOException ex) {
            if (!LOG.isLoggable(Level.SEVERE)) return;
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return;
        }
    }

    public static Actor createLegacyActor(String name, HashSet<ActorBase.ActorStatus> status, ActorBase.ActorType type, int ht, int hp, int damage, int fp, int fatigue, int move, int parry, int block, int dodge, int dr, int db, int shieldDR, int shieldHP, int defaultAttack) {
        Actor a = new Actor();
        a.setType(type);
        a.setTrait(ActorBase.BasicTrait.Name, name);
        a.setAllStatuses(status);
        a.setDefaultAttack(defaultAttack);
        a.setTrait(ActorBase.BasicTrait.HT, ht);
        a.setTrait(ActorBase.BasicTrait.HP, hp);
        a.setTrait(ActorBase.BasicTrait.Injury, damage);
        a.setTrait(ActorBase.BasicTrait.FP, fp);
        a.setTrait(ActorBase.BasicTrait.Fatigue, fatigue);
        a.setTrait(ActorBase.BasicTrait.Move, move);
        a.setTrait(ActorBase.BasicTrait.Parry, parry);
        a.setTrait(ActorBase.BasicTrait.Block, block);
        a.setTrait(ActorBase.BasicTrait.Dodge, dodge);
        a.setTrait(ActorBase.BasicTrait.DR, dr);
        a.setTrait(ActorBase.BasicTrait.Shield_DB, db);
        a.setTrait(ActorBase.BasicTrait.Shield_DR, shieldDR);
        a.setTrait(ActorBase.BasicTrait.Shield_HP, shieldHP);
        return a;
    }
}

