/*
 * Decompiled with CFR 0.152.
 */
package gurpsinittool.data;

import gurpsinittool.data.DamageExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Damage {
    private static final Logger LOG = Logger.getLogger(Damage.class.getName());
    public int basicDamage;
    public double armorDivisor;
    public boolean explosive;
    public DamageExpression.DamageType type;
    public static ArrayList<Integer> armorDivisorLevels = new ArrayList<Integer>(Arrays.asList(2, 3, 5, 10, 100));

    public Damage(int basic, DamageExpression.DamageType type) {
        this(basic, 1.0, type, false);
    }

    public Damage(int basic, double divisor, DamageExpression.DamageType type, boolean explosive) {
        this.basicDamage = basic;
        this.armorDivisor = divisor;
        this.type = type;
        this.explosive = explosive;
        int minDamage = type == DamageExpression.DamageType.cr ? 0 : 1;
        this.basicDamage = this.basicDamage < minDamage ? minDamage : this.basicDamage;
    }

    public double getWoundingModifier() {
        return Damage.getWoundingModifier(this.type);
    }

    public static double getWoundingModifier(DamageExpression.DamageType type) {
        switch (type) {
            case pi_: {
                return 0.5;
            }
            case burn: 
            case cor: 
            case cr: 
            case pi: 
            case tbb: 
            case tox: {
                return 1.0;
            }
            case cut: 
            case pi4: {
                return 1.5;
            }
            case imp: 
            case pi44: {
                return 2.0;
            }
            case aff: 
            case fat: 
            case spec: {
                return 0.0;
            }
        }
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("getWoundingModifier: Unhandled type! " + type.toString());
        }
        return 0.0;
    }
}

